/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.partask.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.task.partask.ParTaskMessage;
import kd.ssc.task.partask.enums.CurNodeEnum;
import kd.ssc.task.partask.enums.FlowInstEnum;
import kd.ssc.task.partask.enums.InstNodeEnum;
import kd.ssc.task.partask.service.impl.ParTaskFlowInstServiceImpl;
import kd.ssc.task.partask.service.impl.ParTaskNodeServiceImpl;
import kd.ssc.task.partask.util.CreateNewPartask;

public class FixCheckTask {
    private static final String TARGET_NODE_ID = "target_node_id";
    private static final String TARGET_TYPE_ID = "target_type_id";

    public static long fixNextCheckTask(long hisTaskId) {
        DynamicObject hisTask = QueryServiceHelper.queryOne((String)"task_taskhistory", (String)"sscid,billtype,billid,assignid,sourcetaskid,tasktypeid,state", (QFilter[])new QFilter("id", "=", (Object)hisTaskId).toArray());
        long assignid = hisTask.getLong("assignid");
        if (assignid == 0L) {
            ErrorCode code = new ErrorCode("-1", ResManager.loadKDString((String)"\u7531\u4e8e\u5386\u53f2\u539f\u56e0\uff0c\u8be5\u4efb\u52a1\u65e0\u6cd5\u4e0b\u63a8\u751f\u6210\u590d\u6838\u4efb\u52a1\uff0c\u8bf7\u901a\u8fc7\u5de5\u4f5c\u6d41\u8df3\u8f6c\uff0c\u91cd\u65b0\u5ba1\u6279\u3002", (String)"FixCheckTask_0", (String)"ssc-task-common", (Object[])new Object[0]));
            throw new KDException(code, new Object[0]);
        }
        if (!TaskStateEnum.AUDIT_PASSED.getValue().equals(hisTask.getString("state"))) {
            ErrorCode code = new ErrorCode("-1", ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5ba1\u6838\u672a\u901a\u8fc7\uff0c\u65e0\u6cd5\u4e0b\u63a8\u751f\u6210\u590d\u6838\u4efb\u52a1\u3002", (String)"FixCheckTask_1", (String)"ssc-task-common", (Object[])new Object[0]));
            throw new KDException(code, new Object[0]);
        }
        long sscid = hisTask.getLong("sscid");
        long billTypeId = hisTask.getLong("billtype");
        String billId = hisTask.getString("billid");
        ParTaskNodeServiceImpl nodeService = new ParTaskNodeServiceImpl();
        long sourceTaskId = hisTask.getLong("sourcetaskid");
        long instanceId = nodeService.getInstIdByTaskId(sourceTaskId);
        if (instanceId == 0L) {
            ErrorCode code = new ErrorCode("-1", ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u4e0d\u5c5e\u4e8e\u591a\u7ea7\u4efb\u52a1\uff0c\u65e0\u6cd5\u751f\u6210\u590d\u6838\u4efb\u52a1\u3002", (String)"FixCheckTask_2", (String)"ssc-task-common", (Object[])new Object[0]));
            throw new KDException(code, new Object[0]);
        }
        ParTaskFlowInstServiceImpl instService = new ParTaskFlowInstServiceImpl();
        long defId = instService.getFlowIdWithInsId(instanceId);
        long taskTypeId = hisTask.getLong("tasktypeid");
        Map<String, Object> targetNode = FixCheckTask.getTargetNode(defId, taskTypeId);
        String targetNodeId = (String)targetNode.get(TARGET_NODE_ID);
        Long targetNodeType = (Long)targetNode.get(TARGET_TYPE_ID);
        FixCheckTask.validParam(sscid, billTypeId, billId, defId, targetNodeType, targetNodeId);
        FixCheckTask.validTask(sscid, billTypeId, billId, targetNodeType, assignid, instanceId);
        FixCheckTask.validJump(assignid);
        FixCheckTask.recoverData(instanceId, sourceTaskId, taskTypeId, targetNodeId);
        ParTaskMessage message = new ParTaskMessage(sscid, billTypeId, billId, defId, instanceId, targetNodeType, targetNodeId, assignid);
        long taskId = CreateNewPartask.createNewTask(message);
        if (taskId == 0L) {
            ErrorCode code = new ErrorCode("-1", ResManager.loadKDString((String)"\u590d\u6838\u4efb\u52a1\u4e0b\u63a8\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u4e1a\u52a1\u5355\u636e\u914d\u7f6e\u3002", (String)"FixCheckTask_3", (String)"ssc-task-common", (Object[])new Object[0]));
            throw new KDException(code, new Object[0]);
        }
        return taskId;
    }

    private static void validJump(long assignid) {
        if (!QueryServiceHelper.exists((String)"wf_task", (QFilter[])new QFilter("id", "=", (Object)assignid).toArray())) {
            ErrorCode code = new ErrorCode("-1", ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u6b63\u5728\u5de5\u4f5c\u6d41\u8df3\u8f6c\uff0c\u65e0\u6cd5\u751f\u6210\u590d\u6838\u4efb\u52a1\u3002", (String)"FixCheckTask_4", (String)"ssc-task-common", (Object[])new Object[0]));
            throw new KDException(code, new Object[0]);
        }
    }

    private static void recoverData(long instanceId, long sourceTaskId, long taskTypeId, String targetNodeId) {
        try (TXHandle h = TX.requiresNew((String)"ssc_task_FixCheckTask");){
            try {
                DynamicObject instDyo = BusinessDataServiceHelper.loadSingle((String)"task_partaskinst", (String)"ptstatus", (QFilter[])new QFilter("id", "=", (Object)instanceId).toArray());
                instDyo.set("ptstatus", (Object)FlowInstEnum.PROCESSING.getValue());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{instDyo});
                DynamicObject insNodeDyo = BusinessDataServiceHelper.loadSingle((String)"task_partaskinstnode", (String)"state", (QFilter[])new QFilter[]{new QFilter("instantid", "=", (Object)instanceId), new QFilter("type", "=", (Object)taskTypeId), new QFilter("taskid", "=", (Object)sourceTaskId)});
                insNodeDyo.set("state", (Object)InstNodeEnum.COMPLETED.getValue());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{insNodeDyo});
                QFilter[] filters = new QFilter[]{new QFilter("instid", "=", (Object)instanceId), new QFilter("curtaskid", "=", (Object)sourceTaskId), new QFilter("nextnodedefid", "=", (Object)targetNodeId)};
                if (QueryServiceHelper.exists((String)"task_partaskcurnode", (QFilter[])filters)) {
                    DynamicObject curNodeDyo = BusinessDataServiceHelper.loadSingle((String)"task_partaskcurnode", (String)"status", (QFilter[])filters);
                    if (!curNodeDyo.get("status").equals(CurNodeEnum.COMPLETED.getValue())) {
                        curNodeDyo.set("status", (Object)CurNodeEnum.COMPLETED.getValue());
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{curNodeDyo});
                } else {
                    DynamicObject taskType = QueryServiceHelper.queryOne((String)"task_tasktype", (String)"name", (QFilter[])new QFilter("id", "=", (Object)taskTypeId).toArray());
                    String soureNodeDefId = taskType.get("name") + "__" + taskTypeId;
                    DynamicObject curNodeDyo = BusinessDataServiceHelper.newDynamicObject((String)"task_partaskcurnode");
                    curNodeDyo.set("instid", (Object)instanceId);
                    curNodeDyo.set("curtaskid", (Object)sourceTaskId);
                    curNodeDyo.set("curnodedefid", (Object)soureNodeDefId);
                    curNodeDyo.set("status", (Object)CurNodeEnum.COMPLETED.getValue());
                    curNodeDyo.set("nextnodedefid", (Object)targetNodeId);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{curNodeDyo});
                }
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private static void validTask(long sscid, long billTypeId, String billId, long targetNodeType, long assignid, long instanceId) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(5);
        filterList.add(new QFilter("sscid", "=", (Object)sscid));
        filterList.add(new QFilter("billtype", "=", (Object)billTypeId));
        filterList.add(new QFilter("billid", "=", (Object)billId));
        filterList.add(new QFilter("assignid", "=", (Object)(assignid + "")));
        filterList.add(new QFilter("tasktypeid", "=", (Object)targetNodeType));
        QFilter[] filters = filterList.toArray(new QFilter[0]);
        if (QueryServiceHelper.exists((String)"task_task", (QFilter[])filters)) {
            ErrorCode code = new ErrorCode("-1", ResManager.loadKDString((String)"\u5df2\u751f\u6210\u590d\u6838\u4efb\u52a1\uff0c\u8bf7\u52ff\u91cd\u590d\u751f\u6210\u3002", (String)"FixCheckTask_5", (String)"ssc-task-common", (Object[])new Object[0]));
            throw new KDException(code, new Object[0]);
        }
        if (QueryServiceHelper.exists((String)"task_taskhistory", (QFilter[])filters)) {
            QFilter[] parNodeFilters = new QFilter[]{new QFilter("instantid", "=", (Object)instanceId), new QFilter("type", "=", (Object)targetNodeType)};
            if (QueryServiceHelper.exists((String)"task_partaskinstnode", (QFilter[])parNodeFilters)) {
                ErrorCode code = new ErrorCode("-1", ResManager.loadKDString((String)"\u5df2\u751f\u6210\u590d\u6838\u4efb\u52a1\uff0c\u8bf7\u52ff\u91cd\u590d\u751f\u6210\u3002", (String)"FixCheckTask_5", (String)"ssc-task-common", (Object[])new Object[0]));
                throw new KDException(code, new Object[0]);
            }
        } else {
            QFilter[] parNodeFilters = new QFilter[]{new QFilter("instantid", "=", (Object)instanceId), new QFilter("type", "=", (Object)targetNodeType)};
            if (QueryServiceHelper.exists((String)"task_partaskinstnode", (QFilter[])parNodeFilters)) {
                ErrorCode code = new ErrorCode("-1", ResManager.loadKDString((String)"\u751f\u6210\u7684\u590d\u6838\u4efb\u52a1\u88ab\u5220\u9664\uff0c\u4e0d\u80fd\u91cd\u590d\u751f\u6210\u3002", (String)"FixCheckTask_8", (String)"ssc-task-common", (Object[])new Object[0]));
                throw new KDException(code, new Object[0]);
            }
        }
    }

    private static void validParam(long sscid, long billTypeId, String billId, long defId, long targetNodeType, String targetNodeId) {
        boolean legal = true;
        if (sscid <= 0L || billTypeId <= 0L || defId <= 0L || targetNodeType <= 0L) {
            legal = false;
        }
        if (StringUtils.isBlank((CharSequence)billId) || StringUtils.isBlank((CharSequence)targetNodeId)) {
            legal = false;
        }
        if (!legal) {
            ErrorCode code = new ErrorCode("-1", ResManager.loadKDString((String)"\u4efb\u52a1\u76f8\u5173\u4fe1\u606f\u7f3a\u5931\uff0c\u65e0\u6cd5\u4e0b\u63a8\u751f\u6210\u590d\u6838\u4efb\u52a1\uff0c\u8bf7\u901a\u8fc7\u5de5\u4f5c\u6d41\u8df3\u8f6c\uff0c\u91cd\u65b0\u5ba1\u6279\u3002", (String)"FixCheckTask_6", (String)"ssc-task-common", (Object[])new Object[0]));
            throw new KDException(code, new Object[0]);
        }
    }

    private static Map<String, Object> getTargetNode(long defId, long billTypeId) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)defId), new QFilter("entryentity.ptsourcetype", "=", (Object)billTypeId), new QFilter("entryentity.pttargettype", "!=", (Object)0L)};
        String selectField = "entryentity.pttargettype.name, entryentity.pttargettype.id, entryentity.pttargetnode";
        DynamicObject targetNode = QueryServiceHelper.queryOne((String)"task_partaskflowdef", (String)selectField, (QFilter[])filters);
        if (targetNode == null) {
            ErrorCode errorCode = new ErrorCode("-1", ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u4e3a\u590d\u6838\u4efb\u52a1\uff0c\u65e0\u6cd5\u4e0b\u63a8\u3002", (String)"FixCheckTask_7", (String)"ssc-task-common", (Object[])new Object[0]));
            throw new KDException(errorCode, new Object[0]);
        }
        Long targetTypeId = targetNode.getLong("entryentity.pttargettype.id");
        String targetTypeName = targetNode.getString("entryentity.pttargettype.name");
        String target = targetNode.getString("entryentity.pttargetnode");
        String targetNodeId = targetTypeName + "_" + target + "_" + targetTypeId;
        HashMap<String, Object> rtnMap = new HashMap<String, Object>(2);
        rtnMap.put(TARGET_NODE_ID, targetNodeId);
        rtnMap.put(TARGET_TYPE_ID, targetTypeId);
        return rtnMap;
    }
}

