/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.util;

import java.util.ArrayList;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.license.LicenseServiceHelper;

public class SscLicenseUtil {
    public static final String PRO_SSC_IAA = "PRO_SSC_IAA";
    private static final Log logger = LogFactory.getLog(SscLicenseUtil.class);

    public static void checkFeatureLicense(String featureLicNum, PreOpenFormEventArgs e) {
        String version = LicenseServiceHelper.getProductVersion();
        logger.info("\u8bb8\u53ef\u7f16\u7801\uff1a" + featureLicNum + "\uff1b\u8bb8\u53ef\u7248\u672c\uff1a" + version);
        if ("3.0".compareTo(version) >= 0) {
            return;
        }
        LicenseCheckResult checkResult = LicenseServiceHelper.checkPerformGroup((String)featureLicNum);
        boolean hasLicenseRight = checkResult.getHasLicense();
        if (!hasLicenseRight) {
            String licParameter = checkResult.getCancelFormShowParameter();
            switch (featureLicNum) {
                case "PRO_SSC_SCS": {
                    if ("4.0".equalsIgnoreCase(version)) {
                        e.setCancelMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u8d2d\u4e70\u667a\u80fd\u5ba2\u670d\u7684\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"SscLicenseUtil_1", (String)"ssc-task-common", (Object[])new Object[0]));
                        e.setCancel(true);
                    } else {
                        e.setCancelMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u8d2d\u4e70\u5171\u4eab\u5ba2\u670d\u673a\u5668\u4eba\u7684\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"SscLicenseUtil_5", (String)"ssc-task-common", (Object[])new Object[0]));
                        e.setCancel(true);
                    }
                    e.setCancelFormShowParameter(licParameter);
                    break;
                }
                case "PRO_SSC_IAA": {
                    e.setCancelMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u8d2d\u4e70\u5171\u4eab\u667a\u80fd\u5ba1\u6838\u52a9\u624b\u7684\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"SscLicenseUtil_6", (String)"ssc-task-common", (Object[])new Object[0]));
                    e.setCancel(true);
                    e.setCancelFormShowParameter(licParameter);
                    break;
                }
                default: {
                    e.setCancelMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u8d2d\u4e70\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"SscLicenseUtil_3", (String)"ssc-task-common", (Object[])new Object[0]));
                    e.setCancel(true);
                }
            }
        }
    }

    public static boolean checkGroupLicense5_0(PreOpenFormEventArgs e, String metaNumber) {
        String version;
        switch (version = LicenseServiceHelper.getProductVersion()) {
            case "1.0": 
            case "2.0": 
            case "3.0": {
                return true;
            }
        }
        return SscLicenseUtil.checkLicense(e, metaNumber);
    }

    private static boolean checkLicense(PreOpenFormEventArgs e, String metaNumber) {
        Long userId = RequestContext.get().getCurrUserId();
        String appId = e.getFormShowParameter().getCheckRightAppId();
        if ("ssc".equalsIgnoreCase(appId) || "som".equalsIgnoreCase(appId)) {
            return SscLicenseUtil.checkFiLicense(401L, userId, appId, e);
        }
        return SscLicenseUtil.checkHrLicense(517L, userId, appId, e);
    }

    private static boolean checkFiLicense(Long licNum, Long userId, String appId, PreOpenFormEventArgs e) {
        LicenseCheckResult checkResult = LicenseServiceHelper.checkUserInGroup((Long)userId, (Long)licNum);
        Set modules = LicenseServiceHelper.getLicenseModules();
        if (checkResult == null || modules == null) {
            e.setCancelMessage(String.format("License Exception: userId = %s, checkResult = %s, modules = %s", userId, checkResult, modules));
            e.setCancel(true);
            return false;
        }
        boolean moduleContains = modules.stream().anyMatch(m -> m.equalsIgnoreCase(appId));
        if (!checkResult.getHasLicense().booleanValue() || !moduleContains) {
            String title = "";
            if ("ssc".equalsIgnoreCase(appId)) {
                e.setCancelMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u8d22\u52a1+\u4f9b\u5e94\u94fe+\u5236\u9020\u5206\u7ec4\u4e2d\u5171\u4eab\u4efb\u52a1\u4e2d\u5fc3\u5e94\u7528\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SscLicenseUtil_7", (String)"ssc-task-common", (Object[])new Object[0]));
                title = ResManager.loadKDString((String)"\u6ca1\u6709\"\u8d22\u52a1+\u4f9b\u5e94\u94fe+\u5236\u9020\u5206\u7ec4\"\u4e2d\"\u5171\u4eab\u4efb\u52a1\u4e2d\u5fc3\"\u6a21\u5757\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SscLicenseUtil_12", (String)"ssc-task-common", (Object[])new Object[0]);
            } else {
                e.setCancelMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u8d22\u52a1+\u4f9b\u5e94\u94fe+\u5236\u9020\u5206\u7ec4\u4e2d\u5171\u4eab\u8fd0\u8425\u7ba1\u7406\u5e94\u7528\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SscLicenseUtil_4", (String)"ssc-task-common", (Object[])new Object[0]));
                title = ResManager.loadKDString((String)"\u6ca1\u6709\"\u8d22\u52a1+\u4f9b\u5e94\u94fe+\u5236\u9020\u5206\u7ec4\"\u4e2d\"\u5171\u4eab\u8fd0\u8425\u7ba1\u7406\"\u6a21\u5757\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SscLicenseUtil_13", (String)"ssc-task-common", (Object[])new Object[0]);
            }
            String detail = ResManager.loadKDString((String)"\u7528\u6237\u9700\u8981\u5206\u914d\"\u8d22\u52a1+\u4f9b\u5e94\u94fe+\u5236\u9020\u5206\u7ec4\"\u8bb8\u53ef\u5206\u7ec4\u3002", (String)"SscLicenseUtil_14", (String)"ssc-task-common", (Object[])new Object[0]);
            ArrayList<String> details = new ArrayList<String>(1);
            details.add(detail);
            FormShowParameter licParameter = LicenseServiceHelper.buildNoticeFormShowParameter((String)title, details);
            e.setCancelFormShowParameter(licParameter.toString());
            e.setCancel(true);
            return false;
        }
        return true;
    }

    private static boolean checkHrLicense(long licNum, Long userId, String appId, PreOpenFormEventArgs e) {
        LicenseCheckResult checkResult = LicenseServiceHelper.checkUserInGroup((Long)userId, (Long)licNum);
        if (checkResult == null) {
            e.setCancelMessage(String.format("License Exception: userId = %s, checkResult = %s, modules = %s", userId, checkResult));
            e.setCancel(true);
            return false;
        }
        if (!checkResult.getHasLicense().booleanValue()) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u6ca1\u6709HR\u6838\u5fc3\u4eba\u529b\u5206\u7ec4\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SscLicenseUtil_11", (String)"ssc-task-common", (Object[])new Object[0]));
            String title = ResManager.loadKDString((String)"\u6ca1\u6709\"\u6838\u5fc3\u4eba\u529b\u5e94\u7528\u5206\u7ec4\"\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SscLicenseUtil_15", (String)"ssc-task-common", (Object[])new Object[0]);
            String detail = ResManager.loadKDString((String)"\u79df\u6237\u672a\u8d2d\u4e70\"\u6838\u5fc3\u4eba\u529b\u5e94\u7528\u5206\u7ec4\"\u8bb8\u53ef\u3002", (String)"SscLicenseUtil_16", (String)"ssc-task-common", (Object[])new Object[0]);
            ArrayList<String> details = new ArrayList<String>(1);
            details.add(detail);
            FormShowParameter licParameter = LicenseServiceHelper.buildNoticeFormShowParameter((String)title, details);
            e.setCancelFormShowParameter(licParameter.toString());
            e.setCancel(true);
            return false;
        }
        return true;
    }
}

