/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.workbill.field;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.ssc.workbill.field.AbstractFieldPropService;

public class AmountPropService
extends AbstractFieldPropService {
    public AmountPropService() {
    }

    public AmountPropService(String formId, String closeCallBackKey) {
        super(formId, closeCallBackKey);
    }

    @Override
    public String getFieldPropertyJSON(Object returnData) {
        if (returnData == null) {
            return null;
        }
        Map map = (Map)returnData;
        Object number = map.get("number");
        if (number != null && !number.toString().isEmpty()) {
            HashMap<String, String> baseMap = new HashMap<String, String>(1);
            baseMap.put("currencyFieldId", number.toString());
            return JSONObject.toJSONString(baseMap);
        }
        return null;
    }

    @Override
    public String getFieldProperty(Object returnData) {
        if (returnData == null) {
            return null;
        }
        Map map = (Map)returnData;
        Object name = map.get("name");
        if (name != null && !name.toString().isEmpty()) {
            return name.toString();
        }
        return null;
    }

    @Override
    public String convertJSONToFieldProperty(String fieldPropJSON) {
        return null;
    }

    @Override
    public void showFieldPropChooseView(IFormView billView, IDataModel dataModel, String pluginName) {
        List<DynamicObject> items = this.getCurrencyField(dataModel);
        if (items.size() < 1) {
            billView.showTipNotification(ResManager.loadKDString((String)"\u672a\u5b9a\u4e49\u5e01\u79cd\u5b57\u6bb5\u3002", (String)"AmountPropService_0", (String)"ssc-task-common", (Object[])new Object[0]));
        } else {
            FormShowParameter showParameter = this.createFormShowParameter(pluginName);
            ArrayList fieldValue = new ArrayList();
            for (DynamicObject item : items) {
                String fieldnumber = item.getString("fieldnumber");
                if (fieldnumber.isEmpty()) continue;
                HashMap<String, String> v = new HashMap<String, String>(3);
                v.put("fieldnumber", item.getString("fieldnumber"));
                v.put("fieldname", item.getString("fieldname"));
                v.put("ispreset", item.getString("ispreset"));
                fieldValue.add(v);
            }
            if (fieldValue.size() > 0) {
                showParameter.setCustomParam("fieldValue", fieldValue);
                billView.showForm(showParameter);
            } else {
                billView.showTipNotification(ResManager.loadKDString((String)"\u672a\u5b9a\u4e49\u5e01\u79cd\u5b57\u6bb5\u3002", (String)"AmountPropService_0", (String)"ssc-task-common", (Object[])new Object[0]));
            }
        }
    }

    private List<DynamicObject> getCurrencyField(IDataModel model) {
        DynamicObjectCollection cPanel;
        List currencyF;
        DynamicObjectCollection entry = model.getEntryEntity("entryentity");
        List basePanels = entry.stream().filter(e -> "0".equals(e.getString("ptype"))).collect(Collectors.toList());
        ArrayList<DynamicObject> items = new ArrayList<DynamicObject>();
        for (DynamicObject bp : basePanels) {
            DynamicObjectCollection fieldEntry = bp.getDynamicObjectCollection("subentryentity");
            currencyF = fieldEntry.stream().filter(item -> "Currency".equals(item.getString("fieldtype"))).collect(Collectors.toList());
            items.addAll(currencyF);
        }
        int panelIndex = model.getEntryCurrentRowIndex("entryentity");
        String panelType = (String)model.getValue("ptype", panelIndex);
        if ("1".equals(panelType) && (cPanel = (DynamicObjectCollection)model.getValue("subentryentity", panelIndex)) != null) {
            currencyF = cPanel.stream().filter(item -> "Currency".equals(item.getString("fieldtype"))).collect(Collectors.toList());
            items.addAll(currencyF);
        }
        return items;
    }
}

