/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.workbill.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import org.apache.commons.io.IOUtils;

public class EntityJsonTransferUtil {
    public static String entity2Json(DynamicObject cacheObject) {
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeDataEntityState(true);
        option.setIncludeComplexProperty(true);
        option.setIncludeCollectionProperty(true);
        option.setIncludeType(false);
        return DataEntitySerializer.serializerToString((Object)cacheObject, (DataEntitySerializerOption)option);
    }

    public static DynamicObject json2Entity(String jsonStr, String entityType) {
        MainEntityType subMainType = EntityMetadataCache.getDataEntityType((String)entityType);
        return (DynamicObject)DataEntitySerializer.deSerializerFromString((String)jsonStr, (IDataEntityType)subMainType);
    }

    public static String exportEntityFile(String fileName, DynamicObject dynObj) {
        String jsonStr = EntityJsonTransferUtil.entity2Json(dynObj);
        InputStream in = IOUtils.toInputStream((String)jsonStr, (Charset)StandardCharsets.UTF_8);
        return CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName + ".dts", in, 5000);
    }

    public static DynamicObject importEntityFile(InputStream inputStream, String entityType) throws IOException {
        String result = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
        return EntityJsonTransferUtil.json2Entity(result, entityType);
    }
}

