/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.service;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.ssc.mircoservice.exception.BizExceptionUtils;
import kd.ssc.mircoservice.result.BaseErrorCode;
import kd.ssc.mircoservice.result.ServiceResult;
import kd.ssc.task.business.handler.KnowledgeServiceHandler;
import kd.ssc.task.service.KnowledgeService;

public class KnowledgeServiceImpl
implements KnowledgeService {
    private static Log logger = LogFactory.getLog(KnowledgeServiceImpl.class);

    public String deleteById(Long knowledgeId) {
        this.logInfo("deleteById accept request,knowledgeId:" + knowledgeId);
        ServiceResult result = new ServiceResult();
        try {
            if (KnowledgeServiceImpl.isNullOrZero(knowledgeId)) {
                ErrorCode code = new ErrorCode(BaseErrorCode.FAILURE.getCode(), ResManager.loadKDString((String)"\u77e5\u8bc6\u95ee\u7b54id\u4e0d\u80fd\u4e3a\u7a7a\u6216\u80050\u3002", (String)"KnowledgeServiceImpl_0", (String)"ssc-task-mservice", (Object[])new Object[0]));
                throw new KDException(code, new Object[0]);
            }
            KnowledgeServiceHandler.deleteById((Long)knowledgeId);
        }
        catch (Exception e) {
            BizExceptionUtils.handle((Exception)e, (ServiceResult)result);
        }
        String jsonResult = result.toJSONString();
        this.logInfo("deleteById service result:" + jsonResult);
        return jsonResult;
    }

    private void logInfo(String infoLog) {
        if (logger.isInfoEnabled()) {
            logger.info(infoLog);
        }
    }

    public static boolean isNullOrZero(Long longValue) {
        return longValue == null || longValue == 0L;
    }
}

