/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.ssc.mircoservice.exception.BizExceptionUtils;
import kd.ssc.mircoservice.exception.FISSCBizException;
import kd.ssc.mircoservice.pojo.SmartcsCustomerServiceVO;
import kd.ssc.mircoservice.pojo.SmartcsGetGroupsVO;
import kd.ssc.mircoservice.result.ServiceResult;
import kd.ssc.mircoservice.validator.SmartCustomerServiceValidator;
import kd.ssc.mircoservice.validator.SmartGetGroupValidator;
import kd.ssc.task.service.SmartCustomerService;
import kd.ssc.task.util.RandomUtil;

public class SmartCustomerServiceImpl
implements SmartCustomerService {
    private static final Log logger = LogFactory.getLog(SmartCustomerServiceImpl.class);

    public String getGroups(String jsonString) {
        logger.info(String.format("getGroups accept a request, params:%s", jsonString));
        ServiceResult result = new ServiceResult();
        try {
            SmartcsGetGroupsVO input = SmartGetGroupValidator.validateAndTransferCallDTO((String)jsonString);
            Long orgId = input.getCosmicOrg();
            List<SmartcsCustomerServiceVO> data = this.doGetGroups(orgId);
            result.setData(data);
        }
        catch (Exception e) {
            BizExceptionUtils.handle((Exception)e, (ServiceResult)result);
        }
        String jsonResult = result.toJSONString();
        logger.info("queryQuestionTypes service result:" + jsonResult);
        return jsonResult;
    }

    public String callCustomerService(String jsonString) {
        logger.info(String.format("callCustomerService accept a request, params:%s", jsonString));
        ServiceResult result = new ServiceResult();
        try {
            SmartcsCustomerServiceVO dto = SmartCustomerServiceValidator.validateAndTransferCallDTO((String)jsonString);
            String data = this.doCallCustomerService(dto);
            result.setData((Object)data);
        }
        catch (Exception e) {
            BizExceptionUtils.handle((Exception)e, (ServiceResult)result);
        }
        String jsonResult = result.toJSONString();
        logger.info("callCustomerService service result:" + jsonResult);
        return jsonResult;
    }

    private List<SmartcsCustomerServiceVO> doGetGroups(long orgId) {
        Map accountOrgInfo = OrgUnitServiceHelper.getCompanyByAdminOrg((Long)orgId);
        Long accountOrgId = (Long)accountOrgInfo.get("id");
        long currUserId = RequestContext.get().getCurrUserId();
        logger.info(String.format("OrgUnitServiceHelper.getCompanyByAdminOrg(orgId)\uff1a \u5f53\u524d\u7528\u6237id=%s, \u884c\u653f\u7ec4\u7ec7id=%s, \u6838\u7b97\u7ec4\u7ec7\uff08\u968f\u673a\uff09=%s", currUserId, orgId, accountOrgInfo));
        if (accountOrgId == null || accountOrgId == 0L) {
            throw new FISSCBizException(new ErrorCode("400004", ResManager.loadKDString((String)"\u60a8\u6240\u5728\u7684\u7ec4\u7ec7\u6682\u4e0d\u652f\u6301\u4eba\u5de5\u5ba2\u670d\u54a8\u8be2\u670d\u52a1\u3002", (String)"SmartcsServiceErrorHint_4", (String)"ssc-task-mservice", (Object[])new Object[0])), new Object[0]);
        }
        List sscIds = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"12", (Long)accountOrgId, (boolean)true);
        if (sscIds.isEmpty()) {
            logger.error(String.format("doGetGroups--\u884c\u653f\u7ec4\u7ec7\uff1a%s\u5173\u8054\u7684\u6838\u7b97\u4e3b\u4f53\uff1a%s\u6ca1\u6709\u59d4\u6258\u5171\u4eab\u4e2d\u5fc3", orgId, accountOrgId));
            throw new FISSCBizException(new ErrorCode("400004", ResManager.loadKDString((String)"\u60a8\u6240\u5728\u7684\u7ec4\u7ec7\u672a\u59d4\u6258\u8d22\u52a1\u5171\u4eab\u4e2d\u5fc3\uff0c\u6682\u4e0d\u652f\u6301\u4eba\u5de5\u5ba2\u670d\u54a8\u8be2\u670d\u52a1\u3002", (String)"SmartcsServiceErrorHint_1", (String)"ssc-task-mservice", (Object[])new Object[0])), new Object[0]);
        }
        QFilter ssc = new QFilter("createorg", "in", (Object)sscIds);
        QFilter enable = new QFilter("entryentity.isenable", "=", (Object)"1");
        DynamicObject[] staffs = BusinessDataServiceHelper.load((String)"som_smartcs_staff", (String)"createorg,entryentity.groupid,entryentity.isenable", (QFilter[])new QFilter[]{ssc, enable});
        HashMap<Long, Map> sscMapGroup = new HashMap<Long, Map>();
        for (DynamicObject staff : staffs) {
            Long sscPK = (Long)staff.getDynamicObject("createorg").getPkValue();
            DynamicObjectCollection entryentity = staff.getDynamicObjectCollection("entryentity");
            if (sscPK == null || sscPK == 0L || entryentity == null) continue;
            for (DynamicObject entry : entryentity) {
                DynamicObject group = entry.getDynamicObject("groupid");
                String subgroup = group.getString("subgroup");
                boolean isEnable = entry.getBoolean("isenable");
                if (!"A".equals(subgroup) || !isEnable) continue;
                String groupName = group.getString("name");
                long groupPk = (Long)group.getPkValue();
                if (groupName == null || "".equals(groupName.trim()) || groupPk == 0L) continue;
                Map groupMap = sscMapGroup.computeIfAbsent(sscPK, key -> new HashMap());
                Set staffIds = groupMap.computeIfAbsent(groupName, key -> new HashSet(4));
                staffIds.add(groupPk);
            }
        }
        Set sscWithGroups = sscMapGroup.keySet();
        if (sscWithGroups.isEmpty()) {
            logger.error(String.format("doGetGroups--\u884c\u653f\u7ec4\u7ec7\uff1a%s\u5173\u8054\u7684\u6838\u7b97\u4e3b\u4f53\uff1a%s\u59d4\u6258\u7684\u5171\u4eab\u4e2d\u5fc3\u90fd\u6ca1\u6709\u8bbe\u7f6e\u5ba2\u670d", orgId, accountOrgId));
            throw new FISSCBizException(new ErrorCode("400003", ResManager.loadKDString((String)"\u60a8\u6240\u5728\u7ec4\u7ec7\u59d4\u6258\u7684\u8d22\u52a1\u5171\u4eab\u4e2d\u5fc3\uff0c\u6682\u4e0d\u652f\u6301\u4eba\u5de5\u5ba2\u670d\u54a8\u8be2\u670d\u52a1\u3002", (String)"SmartcsServiceErrorHint_0", (String)"ssc-task-mservice", (Object[])new Object[0])), new Object[0]);
        }
        int randIndex = RandomUtil.nextInt((int)sscWithGroups.size());
        Iterator iterator = sscWithGroups.iterator();
        Long randSscPK = 0L;
        while (iterator.hasNext()) {
            if (randIndex == 0) {
                randSscPK = (Long)iterator.next();
                break;
            }
            --randIndex;
            iterator.next();
        }
        logger.info(String.format("doGetGroups--\u5171\u4eab\u4e2d\u5fc3\uff1a%s, \u914d\u7f6e\u4e86\u4ee5\u4e0b\u5206\u7ec4:%s", randSscPK, sscMapGroup.get(randSscPK)));
        return ((Map)sscMapGroup.get(randSscPK)).entrySet().stream().map(e -> new SmartcsCustomerServiceVO((String)e.getKey(), (Set)e.getValue())).collect(Collectors.toList());
    }

    private String doCallCustomerService(SmartcsCustomerServiceVO dto) throws FISSCBizException {
        ArrayList staffIds = new ArrayList(dto.getStaffIds());
        long groupId = (Long)staffIds.get(0);
        QFilter enable = new QFilter("entryentity.isenable", "=", (Object)"1");
        QFilter groups = new QFilter("entryentity.groupid", "=", (Object)groupId);
        DynamicObject[] staffs = BusinessDataServiceHelper.load((String)"som_smartcs_staff", (String)"userid", (QFilter[])new QFilter[]{groups, enable});
        QFilter fGroup = new QFilter("id", "=", (Object)groupId);
        QFilter fSubGroup = new QFilter("subgroup", "=", (Object)"A");
        boolean isCustomGroup = QueryServiceHelper.exists((String)"som_smartcs_group", (QFilter[])new QFilter[]{fGroup, fSubGroup});
        if (staffs.length == 0 || !isCustomGroup) {
            logger.error(String.format("doCallCustomerService--\u5206\u7ec4:%s-%s\u6ca1\u6709\u53ef\u7528\u5ba2\u670d\uff0c\u53ef\u80fd\u662f\u5728\u54a8\u8be2\u671f\u95f4\u88ab\u5220\u9664\u6216\u8005\u7981\u7528\u6216\u8005\u5206\u7ec4\u88ab\u6539\u4e3a\u4e0d\u662f\u5ba2\u670d\u7ec4\u3002", groupId, isCustomGroup));
            throw new FISSCBizException(new ErrorCode("400005", ResManager.loadKDString((String)"\u8d22\u52a1\u5171\u4eab\u4e2d\u5fc3\u6682\u4e0d\u652f\u6301\u6b64\u7c7b\u95ee\u9898\u4eba\u5de5\u54a8\u8be2\u3002", (String)"SmartcsServiceErrorHint_2", (String)"ssc-task-mservice", (Object[])new Object[0])), new Object[0]);
        }
        List userIds = Arrays.stream(staffs).map(staff -> (Long)((DynamicObject)staff.get("userId")).getPkValue()).collect(Collectors.toList());
        List userOpenIdList = UserServiceHelper.get(userIds, (String[])new String[]{"useropenid"}, null).stream().filter(m -> StringUtils.isNotBlank(m.get("useropenid"))).map(m -> m.get("useropenid")).collect(Collectors.toList());
        if (userOpenIdList.isEmpty()) {
            logger.error(String.format("doCallCustomerService--\u5206\u7ec4:%s\u91cc\u7684\u5ba2\u670d:%s\u5747\u6ca1\u6709\u540c\u6b65\u4e91\u4e4b\u5bb6\u8d26\u53f7\u3002", groupId, userIds));
            throw new FISSCBizException(new ErrorCode("400006", ResManager.loadKDString((String)"\u8be5\u5ba2\u670d\u7ec4\u672a\u540c\u6b65\u4e91\u4e4b\u5bb6\u8d26\u53f7\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SmartcsServiceErrorHint_3", (String)"ssc-task-mservice", (Object[])new Object[0])), new Object[0]);
        }
        String userOpenId = (String)userOpenIdList.get(RandomUtil.nextInt((int)userOpenIdList.size()));
        logger.info(String.format("doCallCustomerService--\u53ef\u7528\u5ba2\u670d\uff1a%s,\u4e91\u4e4b\u5bb6id:%s,\u4e0e\u5ba2\u6237\u4ea4\u6d41\u7684\u5ba2\u670d\u4e91\u4e4b\u5bb6id:%s", userIds, userOpenIdList, userOpenId));
        return userOpenId;
    }
}

