/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.opplugin;

import java.util.Map;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.validate.AbstractValidator;

public class TaskQuerylistpoolDisableValidatorPlugin
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            Object id = dataEntity.getPkValue();
            IDataEntityType dataEntityType = dataEntity.getDataEntityType();
            Map<Object, BaseDataCheckRefrenceResult> checkResult = this.isRefrenced(dataEntityType, id);
            if (checkResult.isEmpty()) continue;
            for (Map.Entry<Object, BaseDataCheckRefrenceResult> entry : checkResult.entrySet()) {
                BaseDataCheckRefrenceResult refrenceResult = entry.getValue();
                if (!entry.getValue().isRefence()) continue;
                String msg = this.buildRefMessage(refrenceResult);
                this.addErrorMessage(extendedDataEntity, msg);
            }
        }
    }

    private Map<Object, BaseDataCheckRefrenceResult> isRefrenced(IDataEntityType dataEntityType, Object id) {
        BaseDataCheckRefrence checker = new BaseDataCheckRefrence();
        checker.setDraftValidReference(true);
        Object[] ids = new Object[]{id};
        return checker.checkRef((BasedataEntityType)dataEntityType, ids);
    }

    private String buildRefMessage(BaseDataCheckRefrenceResult refrenceResult) {
        MainEntityType refMainType = EntityMetadataCache.getDataEntityType((String)refrenceResult.getRefenceKey().getRefEntityKey());
        String billName = refMainType.getDisplayName().toString();
        String tableName = refrenceResult.getRefenceKey().getRefTable();
        String fieldName = refrenceResult.getRefenceKey().getRefCol();
        for (IDataEntityProperty property : refMainType.getAllFields().values()) {
            if (this.equalsFieldname(property, tableName, fieldName)) {
                fieldName = property.getDisplayName().toString();
                break;
            }
            if (!this.equalsMulBasedataFieldname(property, tableName, fieldName)) continue;
            fieldName = property.getDisplayName().toString();
            break;
        }
        return String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7684\u5b57\u6bb5\u201c%2$s\u201d\u5f15\u7528\u4e86\u6b64\u6570\u636e\uff0c\u4e0d\u80fd\u88ab\u7981\u7528\u3002", (String)"TaskQuerylistpoolDisableValidatorPlugin_0", (String)"ssc-task-opplugin", (Object[])new Object[0]), billName, fieldName);
    }

    private boolean equalsFieldname(IDataEntityProperty property, String tableName, String fieldName) {
        if (property instanceof IFieldHandle && property.getParent() != null && property.getParent().getAlias() != null) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)property.getAlias(), (CharSequence)fieldName)) {
                return false;
            }
            String propTableName = property.getParent().getAlias();
            if (StringUtils.isNotBlank((CharSequence)property.getTableGroup())) {
                propTableName = propTableName + "_" + property.getTableGroup();
            }
            return StringUtils.equalsIgnoreCase((CharSequence)propTableName, (CharSequence)tableName);
        }
        return false;
    }

    private boolean equalsMulBasedataFieldname(IDataEntityProperty property, String tableName, String fieldName) {
        if (!(property instanceof MulBasedataProp)) {
            return false;
        }
        MulBasedataProp mulBasedataProp = (MulBasedataProp)property;
        if (mulBasedataProp.getItemType() != null && mulBasedataProp.getItemType().getAlias() != null) {
            return StringUtils.equalsIgnoreCase((CharSequence)fieldName, (CharSequence)"fbasedataid") && StringUtils.equalsIgnoreCase((CharSequence)tableName, (CharSequence)mulBasedataProp.getItemType().getAlias());
        }
        return false;
    }
}

