/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.opplugin;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.validate.BaseDataDeleteValidator;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.ssc.cache.SscDistributeCache;
import kd.ssc.task.opplugin.TaskRuleDeleteValidatorPlugin;

public class TaskRuleDeletePlugin
extends AbstractOperationServicePlugIn {
    private List<Object> taskBillIds;
    private List<Long> childPkIds;
    private List<Long> subjectIds;

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().removeIf(v -> v instanceof BaseDataDeleteValidator);
        e.addValidator((AbstractValidator)new TaskRuleDeleteValidatorPlugin());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        this.taskBillIds = Arrays.stream(e.getDataEntities()).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        QFilter filter = new QFilter("id", "in", this.taskBillIds);
        DynamicObjectCollection taskBills = QueryServiceHelper.query((String)"task_taskbill", (String)"id,entryentity.childpkid", (QFilter[])filter.toArray());
        this.childPkIds = taskBills.stream().map(bill -> bill.getLong("entryentity.childpkid")).collect(Collectors.toList());
        DynamicObjectCollection subject = QueryServiceHelper.query((String)"task_taskbill_child", (String)"id,tasksubjectid", (QFilter[])new QFilter("id", "in", this.childPkIds).and(new QFilter("tasksubjectid", "!=", (Object)0L)).toArray());
        this.subjectIds = subject.stream().map(child -> child.getLong("tasksubjectid")).collect(Collectors.toList());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        SscDistributeCache.remove((String)"ssc-task-billtype");
        SscDistributeCache.remove((String)"ssc-task-operation");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DeleteServiceHelper.delete((String)"task_taskbill_child", (QFilter[])new QFilter("id", "in", this.childPkIds).toArray());
        DeleteServiceHelper.delete((String)"task_tasksubject", (QFilter[])new QFilter("id", "in", this.subjectIds).toArray());
        QFilter billIdFilter = new QFilter("basetype", "in", this.taskBillIds);
        DeleteServiceHelper.delete((String)"task_taskquantcoefficient", (QFilter[])new QFilter[]{billIdFilter});
        DeleteServiceHelper.delete((String)"task_dealopinionsopen", (QFilter[])new QFilter[]{billIdFilter});
    }
}

