/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.opplugin.achieve;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.ssc.achieve.AchieveExtScoreHelper;
import kd.ssc.enums.achieve.ScoreComputeTypeEnum;
import kd.ssc.task.business.achieve.factory.ScoreComputeFactory;
import kd.ssc.task.business.achieve.score.IScoreComputeEngine;

public class AchieveEvaluteSubmitPlugin
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(AchieveEvaluteSubmitPlugin.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fields = e.getFieldKeys();
        fields.addAll(this.billEntityType.getAllFields().keySet());
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities;
        super.beforeExecuteOperationTransaction(e);
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            Date endDate;
            Date startDate;
            long sscId;
            long userId;
            BigDecimal userExtScore;
            DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection("entryentity_po");
            BigDecimal totalWeightScore = BigDecimal.ZERO;
            for (DynamicObject indicator : entry) {
                indicator.set("poapproved", indicator.get("poactual"));
                Long indicatorId = indicator.getLong("poachieveid_id");
                DynamicObject achieveTarget = indicator.getDynamicObject("poachieveid");
                BigDecimal standScore = indicator.getBigDecimal("postandard");
                BigDecimal targetScore = indicator.getBigDecimal("potarget");
                BigDecimal actualValue = indicator.getBigDecimal("poactual");
                IScoreComputeEngine scoreComputeInstance = ScoreComputeFactory.getScoreComputeInstance((ScoreComputeTypeEnum)ScoreComputeTypeEnum.getScoreComputeTypeByValue((String)achieveTarget.getString("scoringmethod")));
                if (scoreComputeInstance == null) {
                    ErrorCode code = new ErrorCode("fi.ssc.achieve.evaluateSubmit", "the score compute type don't have service.");
                    throw new KDException(code, new Object[0]);
                }
                BigDecimal indicatorScore = scoreComputeInstance.computeIndicatorScore(indicatorId, standScore, targetScore, actualValue, actualValue);
                log.info(achieveTarget.getString("number") + "\u5b9e\u9645\u8ba1\u7b97\u5f97\u5206\u4e3a\uff1a" + indicatorScore);
                if (indicatorScore == null) continue;
                BigDecimal maxScore = achieveTarget.getBigDecimal("maxScore");
                BigDecimal minScore = achieveTarget.getBigDecimal("minScore");
                boolean isSetUp = achieveTarget.getBoolean("setup");
                boolean isSetDown = achieveTarget.getBoolean("setdown");
                if (isSetUp && maxScore.compareTo(indicatorScore) < 0) {
                    indicatorScore = maxScore;
                } else if (isSetDown && minScore.compareTo(indicatorScore) > 0) {
                    indicatorScore = minScore;
                }
                indicator.set("poscore", (Object)indicatorScore);
                int weight = indicator.getInt("poweight");
                BigDecimal weightP = new BigDecimal(weight).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP);
                totalWeightScore = totalWeightScore.add(indicatorScore.multiply(weightP)).setScale(2, RoundingMode.HALF_UP);
            }
            BigDecimal extraScore = BigDecimal.ZERO;
            if ("2".equals(dataEntity.getString("assessdimension")) && (userExtScore = AchieveExtScoreHelper.getUserExtScoreNew((long)(userId = dataEntity.getLong("assessuserid.id")), (long)(sscId = dataEntity.getLong("sscid.id")), (Date)(startDate = dataEntity.getDate("periodstart")), (Date)(endDate = dataEntity.getDate("periodend")))) != null) {
                extraScore = userExtScore;
            }
            dataEntity.set("extrapoint", (Object)extraScore);
            dataEntity.set("totalscore", (Object)totalWeightScore);
            dataEntity.set("score", (Object)totalWeightScore.add(extraScore).setScale(2, RoundingMode.HALF_UP));
        }
    }
}

