/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.opplugin.achieve;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.util.StringUtils;

public class AchieveTargetSaveValidator
extends AbstractValidator {
    private static final BigDecimal zero = new BigDecimal(0);

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject achieveTarget = dataEntity.getDataEntity();
            String targetType = achieveTarget.getString("targetType");
            BigDecimal minScore = achieveTarget.getBigDecimal("minScore");
            BigDecimal maxScore = achieveTarget.getBigDecimal("maxScore");
            boolean setUp = achieveTarget.getBoolean("setup");
            boolean setDown = achieveTarget.getBoolean("setdown");
            if (setDown && minScore == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672a\u586b\u5199\u6307\u6807\u5206\u503c\u6700\u5c0f\u503c\u3002", (String)"AchieveTargetSaveValidator_4", (String)"ssc-task-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (setUp && maxScore == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672a\u586b\u5199\u6307\u6807\u5206\u503c\u6700\u5927\u503c\u3002", (String)"AchieveTargetSaveValidator_5", (String)"ssc-task-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (!"2".equals(targetType)) {
                String scoringmethod = achieveTarget.getString("scoringmethod");
                if (StringUtils.isBlank((String)scoringmethod)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672a\u586b\u5199\u8bc4\u5206\u65b9\u5f0f\u3002", (String)"AchieveTargetSaveValidator_0", (String)"ssc-task-opplugin", (Object[])new Object[0]));
                    continue;
                }
                if (setDown && minScore.compareTo(zero) < 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u975e\u989d\u5916\u52a0\u51cf\u5206\u6307\u6807\u7684\u6307\u6807\u6700\u5c0f\u503c\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"AchieveTargetSaveValidator_1", (String)"ssc-task-opplugin", (Object[])new Object[0]));
                    continue;
                }
                if (setUp && maxScore.compareTo(zero) < 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u975e\u989d\u5916\u52a0\u51cf\u5206\u6307\u6807\u7684\u6307\u6807\u6700\u5927\u503c\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"AchieveTargetSaveValidator_2", (String)"ssc-task-opplugin", (Object[])new Object[0]));
                    continue;
                }
            }
            if (!setUp || !setDown || minScore.compareTo(maxScore) < 0) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6307\u6807\u5206\u503c\u6700\u5927\u503c\u4e0d\u80fd\u5c0f\u4e8e\u6216\u7b49\u4e8e\u6307\u6807\u5206\u503c\u6700\u5c0f\u503c\u3002", (String)"AchieveTargetSaveValidator_3", (String)"ssc-task-opplugin", (Object[])new Object[0]));
        }
    }
}

