/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.opplugin.condition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;

public class ConditionFieldReferenceValidator
extends AbstractValidator {
    public void validate() {
        String operateType = this.getOperateType();
        if (!"delete".equals(operateType)) {
            Map<Object, ExtendedDataEntity> dataMap = Arrays.stream(this.dataEntities).collect(Collectors.toMap(ExtendedDataEntity::getBillPkId, d -> d));
            ArrayList<String> needCheckEntity = new ArrayList<String>(2);
            needCheckEntity.add("ssc_confield_mapping");
            needCheckEntity.add("ssc_apply_condition");
            Map checkResult = BaseDataRefrenceHelper.checkRefrenced((String)"ssc_condition_field", (Object[])dataMap.keySet().toArray(new Object[0]), null, needCheckEntity, null);
            for (Map.Entry entry : checkResult.entrySet()) {
                ExtendedDataEntity dataObj = dataMap.get(entry.getKey());
                if (dataObj == null) continue;
                BaseDataCheckRefrenceResult refrenceResult = (BaseDataCheckRefrenceResult)entry.getValue();
                if (!((BaseDataCheckRefrenceResult)entry.getValue()).isRefence()) continue;
                String msg = this.buildRefMessage(refrenceResult);
                this.addErrorMessage(dataObj, msg);
            }
        }
        for (ExtendedDataEntity entity : this.dataEntities) {
            DynamicObject dataEntity = entity.getDataEntity();
            String number = dataEntity.getString("number");
            QFilter qFilter = new QFilter("conditionjson_tag", "like", (Object)("%" + number + "%"));
            DynamicObjectCollection query = QueryServiceHelper.query((String)"ssc_apply_condition", (String)"id,name", (QFilter[])new QFilter[]{qFilter});
            if (query == null || query.size() <= 0) continue;
            Set names = query.stream().map(q -> q.getString("name")).collect(Collectors.toSet());
            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u201c\u9002\u7528\u6761\u4ef6\u201d\u4e2d\u540d\u79f0\u4e3a\u201c%1$s\u201d\u7684\u6570\u636e\u7684\u6761\u4ef6\u5f15\u7528\u4e86\u6b64\u6570\u636e\uff0c\u4e0d\u80fd\u88ab%2$s\u3002", (String)"ConditionFieldReferenceValidator_1", (String)"ssc-task-opplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3001", names), this.getOperationName()));
        }
    }

    private String buildRefMessage(BaseDataCheckRefrenceResult referenceResult) {
        MainEntityType refMainType = EntityMetadataCache.getDataEntityType((String)referenceResult.getRefenceKey().getRefEntityKey());
        String billName = refMainType.getDisplayName().toString();
        String tableName = referenceResult.getRefenceKey().getRefTable();
        String fieldName = referenceResult.getRefenceKey().getRefCol();
        for (IDataEntityProperty property : refMainType.getAllFields().values()) {
            if (this.equalsFieldName(property, tableName, fieldName)) {
                fieldName = property.getDisplayName().toString();
                break;
            }
            if (!this.equalsMulBasedataFieldname(property, tableName, fieldName)) continue;
            fieldName = property.getDisplayName().toString();
            break;
        }
        return String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7684\u5b57\u6bb5\u201c%2$s\u201d\u5f15\u7528\u4e86\u6b64\u6570\u636e\uff0c\u4e0d\u80fd\u88ab%3$s\u3002", (String)"ConditionFieldReferenceValidator_0", (String)"ssc-task-opplugin", (Object[])new Object[0]), billName, fieldName, this.getOperationName());
    }

    private boolean equalsFieldName(IDataEntityProperty property, String tableName, String fieldName) {
        if (!(property instanceof IFieldHandle) || property.getParent() == null || property.getParent().getAlias() == null) {
            return false;
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)property.getAlias(), (CharSequence)fieldName)) {
            return false;
        }
        String propTableName = property.getParent().getAlias();
        if (StringUtils.isNotBlank((CharSequence)property.getTableGroup())) {
            propTableName = propTableName + "_" + property.getTableGroup();
        }
        return StringUtils.equalsIgnoreCase((CharSequence)propTableName, (CharSequence)tableName);
    }

    private boolean equalsMulBasedataFieldname(IDataEntityProperty property, String tableName, String fieldName) {
        if (!(property instanceof MulBasedataProp)) {
            return false;
        }
        MulBasedataProp mulBasedataProp = (MulBasedataProp)property;
        if (mulBasedataProp.getItemType() == null || mulBasedataProp.getItemType().getAlias() == null) {
            return false;
        }
        return StringUtils.equalsIgnoreCase((CharSequence)fieldName, (CharSequence)"fbasedataid") && StringUtils.equalsIgnoreCase((CharSequence)tableName, (CharSequence)mulBasedataProp.getItemType().getAlias());
    }
}

