/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.opplugin.monitor;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.monitor.ExceptionHandlingResultEnum;
import kd.ssc.monitor.ExceptionStatusEnum;
import kd.ssc.task.create.CreateTaskByWorkflow;
import kd.ssc.task.disRebuild.engine.Distribution;
import kd.ssc.task.opplugin.monitor.ExceptionRetryValidator;

public class ExceptionRetryPlugin
extends AbstractOperationServicePlugIn {
    private ExceptionRetryValidator exceptionRetryValidator;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fields = e.getFieldKeys();
        fields.addAll(this.billEntityType.getAllFields().keySet());
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        this.exceptionRetryValidator = new ExceptionRetryValidator();
        e.addValidator((AbstractValidator)this.exceptionRetryValidator);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        int length = this.exceptionRetryValidator.getDataEntities().length;
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<DynamicObject> successList = new ArrayList<DynamicObject>();
        block8: for (DynamicObject dataEntity : dataEntities) {
            String scenarioNumber;
            switch (scenarioNumber = dataEntity.getString("scenario.number")) {
                case "SYS_SCENARIO_1": {
                    this.createTaskRetry(dataEntity, successList, length);
                    continue block8;
                }
                case "SYS_SCENARIO_3": {
                    this.disTaskRetry(dataEntity, successList, length);
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
        e.setDataEntities(successList.toArray(new DynamicObject[0]));
    }

    private void disTaskRetry(DynamicObject dataEntity, List<DynamicObject> successList, int length) {
        long taskId = dataEntity.getLong("taskid");
        String retryParam = dataEntity.getString("retryparam");
        Map map = (Map)SerializationUtils.fromJsonString((String)retryParam, Map.class);
        Integer disType = (Integer)map.get("disType");
        boolean result = Distribution.retryDistribution((long)taskId, (int)disType);
        this.updateExceptionHandle(dataEntity, successList, length, result);
    }

    private void createTaskRetry(DynamicObject dataEntity, List<DynamicObject> successList, int length) {
        CreateTaskByWorkflow createTaskByWorkflow = new CreateTaskByWorkflow();
        String retryParam = dataEntity.getString("retryparam");
        Map map = (Map)SerializationUtils.fromJsonString((String)retryParam, Map.class);
        long taskId = 0L;
        try {
            taskId = createTaskByWorkflow.createTask(((Long)map.get("taskTypeID")).longValue(), ((Long)map.get("billTypeID")).longValue(), (String)map.get("billID"), 0L, "", "", 0L, (String)map.get("assignID"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean result = taskId == 0L;
        this.updateExceptionHandle(dataEntity, successList, length, result);
    }

    private void updateExceptionHandle(DynamicObject dataEntity, List<DynamicObject> successList, int length, boolean result) {
        DynamicObjectCollection handleEntry = dataEntity.getDynamicObjectCollection("handle_entry");
        DynamicObject handleRecord = handleEntry.addNew();
        Date handleTime = new Date();
        handleRecord.set("handling_time", (Object)handleTime);
        handleRecord.set("handler", (Object)RequestContext.get().getCurrUserId());
        handleRecord.set("traceid_h", (Object)RequestContext.get().getTraceId());
        if (result) {
            successList.add(dataEntity);
            handleRecord.set("handling_result", (Object)ExceptionHandlingResultEnum.SUCCESS.getValue());
            dataEntity.set("status", (Object)ExceptionStatusEnum.PROCESSED.getValue());
            dataEntity.set("final_handle_time", (Object)handleTime);
            dataEntity.set("final_handler", (Object)RequestContext.get().getCurrUserId());
        } else {
            OperateErrorInfo errorInfo = new OperateErrorInfo("", ErrorLevel.Error, dataEntity.getPkValue());
            if (length == 1) {
                errorInfo.setMessage(ResManager.loadKDString((String)"\u91cd\u8bd5\u5931\u8d25\u3002", (String)"ExceptionRetryPlugin_3", (String)"ssc-task-opplugin", (Object[])new Object[0]));
            } else {
                errorInfo.setMessage(String.format(ResManager.loadKDString((String)"%s\uff1a \u91cd\u8bd5\u5931\u8d25\u3002", (String)"ExceptionRetryPlugin_4", (String)"ssc-task-opplugin", (Object[])new Object[0]), dataEntity.getString("billno")));
            }
            this.operationResult.addErrorInfo(errorInfo);
            handleRecord.set("handling_result", (Object)ExceptionHandlingResultEnum.FAILURE.getValue());
        }
    }
}

