/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.opplugin.monitor;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.sdk.fi.ssc.extpoint.disRebuild.disenum.DisTypeEnum;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.monitor.ExceptionStatusEnum;

public class ExceptionRetryValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject dyo = dataEntity.getDataEntity();
            String scenarioNumber = dyo.getString("scenario.number");
            if (StringUtils.isNotEmpty((String)scenarioNumber)) {
                switch (scenarioNumber) {
                    case "SYS_SCENARIO_1": {
                        this.createTaskValidate(dataEntity);
                        break;
                    }
                    case "SYS_SCENARIO_3": {
                        this.disTaskValidate(dataEntity, dyo);
                        break;
                    }
                    default: {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u5f02\u5e38\u65e0\u9700\u91cd\u8bd5\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"ExceptionRetryPlugin_5", (String)"ssc-task-opplugin", (Object[])new Object[0]));
                        break;
                    }
                }
                continue;
            }
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u5f02\u5e38\u573a\u666f\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"ExceptionRetryPlugin_6", (String)"ssc-task-opplugin", (Object[])new Object[0]));
        }
    }

    private void disTaskValidate(ExtendedDataEntity dataEntity, DynamicObject dyo) {
        String retryParam = dyo.getString("retryparam");
        Map map = (Map)SerializationUtils.fromJsonString((String)retryParam, Map.class);
        Integer disType = (Integer)map.get("disType");
        long taskId = dyo.getLong("taskid");
        if (DisTypeEnum.AUTO_DIS.getValue() == disType.intValue()) {
            this.autoDisValidate(dataEntity, taskId);
        } else if (DisTypeEnum.NOPASS_DIS.getValue() == disType.intValue()) {
            this.noPassDisValidate(dataEntity, taskId);
        } else {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u4e1a\u52a1\u5c5e\u6027\u4e3a\u201c\u81ea\u52a8\u5206\u914d\u201c\u548c\u201c\u667a\u80fd\u5ba1\u6838\u4e0d\u901a\u8fc7\u8f6c\u4eba\u5de5\u201c\u65f6\uff0c\u652f\u6301\u91cd\u8bd5\uff0c\u5bf9\u4efb\u52a1\u8fdb\u884c\u91cd\u65b0\u5206\u914d\u3002", (String)"ExceptionRetryPlugin_8", (String)"ssc-task-opplugin", (Object[])new Object[0]));
        }
    }

    private void autoDisValidate(ExtendedDataEntity dataEntity, long taskId) {
        QFilter idFilter = new QFilter("id", "=", (Object)taskId);
        DynamicObject taskDo = BusinessDataServiceHelper.loadSingle((String)"task_task", (String)"id,personid,pooltype,state,autoprocess", (QFilter[])new QFilter[]{idFilter});
        if (taskDo == null) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u5f02\u5e38\u5171\u4eab\u4efb\u52a1\u5df2\u4e0d\u5b58\u5728\u3002", (String)"ExceptionRetryPlugin_7", (String)"ssc-task-opplugin", (Object[])new Object[0]));
            return;
        }
        String poolType = taskDo.getString("pooltype");
        String taskState = taskDo.getString("state");
        if (TaskPoolTypeEnum.TO_BE_DIS.getValue().equals(poolType)) {
            if (!(TaskStateEnum.TO_BE_DIS.getValue().equals(taskState) || TaskStateEnum.TO_BE_MANUAL_DIS.getValue().equals(taskState) || TaskStateEnum.DIS_EXCEPTION.getValue().equals(taskState))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ec5\u201c\u5f85\u5206\u914d\u201d\u72b6\u6001\u7684\u81ea\u52a8\u5206\u914d\u4efb\u52a1\u6216\u201c\u5904\u7406\u4e2d\u201d\u7684\u667a\u80fd\u5ba1\u6838\u8f6c\u4eba\u5de5\u4efb\u52a1\u652f\u6301\u91cd\u8bd5\uff0c\u5f53\u524d\u4efb\u52a1\u65e0\u9700\u91cd\u8bd5\u3002", (String)"ExceptionRetryPlugin_9", (String)"ssc-task-opplugin", (Object[])new Object[0]));
            }
        } else {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ec5\u201c\u5f85\u5206\u914d\u201d\u72b6\u6001\u7684\u81ea\u52a8\u5206\u914d\u4efb\u52a1\u6216\u201c\u5904\u7406\u4e2d\u201d\u7684\u667a\u80fd\u5ba1\u6838\u8f6c\u4eba\u5de5\u4efb\u52a1\u652f\u6301\u91cd\u8bd5\uff0c\u5f53\u524d\u4efb\u52a1\u65e0\u9700\u91cd\u8bd5\u3002", (String)"ExceptionRetryPlugin_9", (String)"ssc-task-opplugin", (Object[])new Object[0]));
        }
    }

    private void noPassDisValidate(ExtendedDataEntity dataEntity, long taskId) {
        QFilter idFilter = new QFilter("id", "=", (Object)taskId);
        DynamicObject taskDo = BusinessDataServiceHelper.loadSingle((String)"task_task", (String)"id,personid,pooltype,state,autoprocess", (QFilter[])new QFilter[]{idFilter});
        if (taskDo == null) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u5f02\u5e38\u5171\u4eab\u4efb\u52a1\u5df2\u4e0d\u5b58\u5728\u3002", (String)"ExceptionRetryPlugin_7", (String)"ssc-task-opplugin", (Object[])new Object[0]));
            return;
        }
        String poolType = taskDo.getString("pooltype");
        String taskState = taskDo.getString("state");
        if (TaskPoolTypeEnum.PROCESSING.getValue().equals(poolType)) {
            if (!TaskStateEnum.TO_BE_AUDIT.getValue().equals(taskState) && !TaskStateEnum.REUPLOAD_IMAGE.getValue().equals(taskState)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ec5\u201c\u5f85\u5206\u914d\u201d\u72b6\u6001\u7684\u81ea\u52a8\u5206\u914d\u4efb\u52a1\u6216\u201c\u5904\u7406\u4e2d\u201d\u7684\u667a\u80fd\u5ba1\u6838\u8f6c\u4eba\u5de5\u4efb\u52a1\u652f\u6301\u91cd\u8bd5\uff0c\u5f53\u524d\u4efb\u52a1\u65e0\u9700\u91cd\u8bd5\u3002", (String)"ExceptionRetryPlugin_9", (String)"ssc-task-opplugin", (Object[])new Object[0]));
                return;
            }
            boolean autoprocess = taskDo.getBoolean("autoprocess");
            if (!autoprocess) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ec5\u201c\u5f85\u5206\u914d\u201d\u72b6\u6001\u7684\u81ea\u52a8\u5206\u914d\u4efb\u52a1\u6216\u201c\u5904\u7406\u4e2d\u201d\u7684\u667a\u80fd\u5ba1\u6838\u8f6c\u4eba\u5de5\u4efb\u52a1\u652f\u6301\u91cd\u8bd5\uff0c\u5f53\u524d\u4efb\u52a1\u65e0\u9700\u91cd\u8bd5\u3002", (String)"ExceptionRetryPlugin_9", (String)"ssc-task-opplugin", (Object[])new Object[0]));
            }
        } else {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ec5\u201c\u5f85\u5206\u914d\u201d\u72b6\u6001\u7684\u81ea\u52a8\u5206\u914d\u4efb\u52a1\u6216\u201c\u5904\u7406\u4e2d\u201d\u7684\u667a\u80fd\u5ba1\u6838\u8f6c\u4eba\u5de5\u4efb\u52a1\u652f\u6301\u91cd\u8bd5\uff0c\u5f53\u524d\u4efb\u52a1\u65e0\u9700\u91cd\u8bd5\u3002", (String)"ExceptionRetryPlugin_9", (String)"ssc-task-opplugin", (Object[])new Object[0]));
        }
    }

    private void createTaskValidate(ExtendedDataEntity dataEntity) {
        DynamicObject dyo = dataEntity.getDataEntity();
        String status = dyo.getString("status");
        if (!ExceptionStatusEnum.UN_PROCESSED.getValue().equals(status)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u672a\u5904\u7406\u72b6\u6001\u7684\u5f02\u5e38\u624d\u53ef\u4ee5\u91cd\u8bd5\u3002", (String)"ExceptionRetryPlugin_2", (String)"ssc-task-opplugin", (Object[])new Object[0]));
            return;
        }
        String retryParam = dyo.getString("retryparam");
        if (StringUtils.isEmpty((String)retryParam)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u5f02\u5e38\u4fe1\u606f\u4e0d\u652f\u6301\u91cd\u8bd5\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"ExceptionRetryPlugin_0", (String)"ssc-task-opplugin", (Object[])new Object[0]));
            return;
        }
        Map map = (Map)SerializationUtils.fromJsonString((String)retryParam, Map.class);
        Long taskTypeID = (Long)map.get("taskTypeID");
        Long billTypeID = (Long)map.get("billTypeID");
        String billID = (String)map.get("billID");
        QFilter[] qFilters = new QFilter[]{new QFilter("billid", "=", (Object)billID), new QFilter("tasktypeid", "=", (Object)taskTypeID), new QFilter("billtype", "=", (Object)billTypeID)};
        if (QueryServiceHelper.exists((String)"task_task", (QFilter[])qFilters)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u5355\u636e\u5df2\u521b\u5efa\u4efb\u52a1\uff0c\u4e0d\u80fd\u91cd\u590d\u521b\u5efa\u3002", (String)"ExceptionRetryPlugin_1", (String)"ssc-task-opplugin", (Object[])new Object[0]));
            return;
        }
    }
}

