/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.opplugin.sla;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.constant.EntityField;
import kd.ssc.sla.SlaUtil;
import kd.ssc.task.opplugin.sla.SlaServiceBillSynNorAmtValidator;

public class SlaServiceBillSynNorAmtPlugin
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(SlaServiceBillSynNorAmtPlugin.class);
    private static final String BILLING_QTY = "qty";
    private static final String BILLING_FIXED = "fixed";
    private static final String ENTRY_BILLDETAIL = "billdetails";
    private static final String ENTRY_STERIDETAILS = "steridetails";

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new SlaServiceBillSynNorAmtValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fields = e.getFieldKeys();
        fields.addAll(this.billEntityType.getAllFields().keySet());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        OperationResult operationResult = this.getOperationResult();
        ValidateResultCollection collection = operationResult.getValidateResult();
        List validateResults = collection.getValidateErrors();
        List successPkIds = operationResult.getSuccessPkIds();
        Map<String, Object> resultMap = this.synNorAmount(args.getDataEntities());
        String opMsg = (String)resultMap.get("opMsg");
        List failIds = (List)resultMap.get("failIds");
        successPkIds.remove(failIds);
        if (StringUtils.isNotEmpty((String)opMsg)) {
            ValidationErrorInfo info = new ValidationErrorInfo("", null, 0, 0, "errorcode_001", "", opMsg, ErrorLevel.Error);
            ValidateResult validateResult = new ValidateResult();
            validateResult.addErrorInfo((OperateErrorInfo)info);
            validateResults.add(validateResult);
        }
    }

    private Map<String, Object> synNorAmount(DynamicObject[] bills) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        StringBuilder opMsg = new StringBuilder();
        ArrayList<Object> failIds = new ArrayList<Object>(8);
        StringBuilder billNoStr = new StringBuilder();
        for (DynamicObject bill : bills) {
            try {
                Long cdpk = SlaUtil.getCdpkBySbillId((Long)bill.getLong("id"));
                if (cdpk == null) continue;
                DynamicObject cdBasedata = BusinessDataServiceHelper.loadSingleFromCache((Object)cdpk, (String)"sla_contractdetails", (String)EntityField.buildSelectField((String[])new String[]{"id", "norprice", "norfixedamount"}));
                DynamicObjectCollection detailsEntry = cdBasedata.getDynamicObjectCollection("detailsentry");
                DynamicObjectCollection billDetailsEntry = bill.getDynamicObjectCollection(ENTRY_BILLDETAIL);
                BigDecimal exrate = bill.getBigDecimal("exrate");
                BigDecimal taxRate = BigDecimal.ZERO;
                Object taxRateDyo = bill.get("taxrate");
                if (taxRateDyo != null) {
                    taxRate = ((DynamicObject)taxRateDyo).getBigDecimal("taxrate").divide(new BigDecimal("100"));
                }
                for (DynamicObject rowSB : billDetailsEntry) {
                    Long sourceEntryId = rowSB.getLong("sourceentryid");
                    for (DynamicObject rowCD : detailsEntry) {
                        Long entryId = rowCD.getLong("id");
                        if (!entryId.equals(sourceEntryId)) continue;
                        rowSB.set("price", (Object)rowCD.getBigDecimal("norprice"));
                        rowSB.set("fixedamount", (Object)rowCD.getBigDecimal("norfixedamount"));
                        BigDecimal bdAmount = BigDecimal.ZERO;
                        String billing = rowSB.getString("billing");
                        if (BILLING_QTY.equals(billing)) {
                            bdAmount = rowCD.getBigDecimal("norprice").multiply(rowSB.getBigDecimal(BILLING_QTY));
                        } else if (BILLING_FIXED.equals(billing)) {
                            bdAmount = rowCD.getBigDecimal("norfixedamount");
                        }
                        rowSB.set("bdamount", (Object)bdAmount);
                        rowSB.set("bdamountstd", (Object)bdAmount.multiply(exrate));
                        BigDecimal deducAmt = rowSB.getBigDecimal("deducamt");
                        BigDecimal vouchAmt = bdAmount.subtract(deducAmt);
                        rowSB.set("vouchamt", (Object)vouchAmt);
                        rowSB.set("vouchamtstd", (Object)vouchAmt.multiply(exrate));
                        BigDecimal taxAmt = vouchAmt.multiply(taxRate);
                        rowSB.set("taxamount", (Object)taxAmt);
                        rowSB.set("taxamountstd", (Object)taxAmt.multiply(exrate));
                        rowSB.set("vouchnotaxamt", (Object)vouchAmt.subtract(taxAmt));
                        rowSB.set("vouchnotaxamtstd", (Object)vouchAmt.subtract(taxAmt).multiply(exrate));
                    }
                }
                BigDecimal vouchAmtSum = this.getVouchAmtSum(bill.getDynamicObjectCollection(ENTRY_BILLDETAIL));
                BigDecimal vouchAmtSumStd = this.getVouchAmtStdSum(bill.getDynamicObjectCollection(ENTRY_BILLDETAIL));
                BigDecimal sdsteriAmtSum = this.getSdSteriamtSum(bill.getDynamicObjectCollection(ENTRY_STERIDETAILS));
                BigDecimal sdsteriAmtSumStd = this.getSdSteriamtStdSum(bill.getDynamicObjectCollection(ENTRY_STERIDETAILS));
                bill.set("billamt", (Object)vouchAmtSum);
                bill.set("billamtstd", (Object)vouchAmtSumStd);
                BigDecimal billrecAmt = vouchAmtSum.subtract(sdsteriAmtSum);
                bill.set("billrecamt", (Object)billrecAmt);
                bill.set("billrecamtstd", (Object)vouchAmtSumStd.subtract(sdsteriAmtSumStd));
                bill.set("taxamt", (Object)billrecAmt.multiply(taxRate));
            }
            catch (Exception ex) {
                String billNo = bill.getString("billno");
                billNoStr.append((CharSequence)billNoStr).append(",");
                failIds.add(bill.getPkValue());
                log.error("\u5171\u4eab\u670d\u52a1\u8d26\u5355" + billNo + "\uff0c\u540c\u6b65\u7ed3\u7b97\u4ef7\u683c\u5f02\u5e38 ", (Throwable)ex);
            }
        }
        if (StringUtils.isBlank((String)billNoStr.toString())) {
            resultMap.put("opMsg", billNoStr.toString());
        } else {
            opMsg.append("[");
            opMsg.append(billNoStr.substring(0, billNoStr.length() - 1));
            opMsg.append("]");
            opMsg.append(ResManager.loadKDString((String)"\u540c\u6b65\u7ed3\u7b97\u4ef7\u683c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7\u3002", (String)"SlaServiceContractSynNorAmtPlugin_0", (String)"ssc-task-opplugin", (Object[])new Object[0]));
            resultMap.put("opMsg", opMsg.toString());
        }
        resultMap.put("failIds", failIds);
        SaveServiceHelper.update((DynamicObject[])bills);
        return resultMap;
    }

    private BigDecimal getVouchAmtSum(DynamicObjectCollection billDetailsEntry) {
        BigDecimal vouchAmtSum = billDetailsEntry.stream().map(v -> v.getBigDecimal("vouchamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        return vouchAmtSum;
    }

    private BigDecimal getVouchAmtStdSum(DynamicObjectCollection billDetailsEntry) {
        BigDecimal vouchAmtStdSum = billDetailsEntry.stream().map(v -> v.getBigDecimal("vouchamtstd")).reduce(BigDecimal.ZERO, BigDecimal::add);
        return vouchAmtStdSum;
    }

    private BigDecimal getSdSteriamtSum(DynamicObjectCollection steriDetailsEntry) {
        BigDecimal sdSteriamtSum = steriDetailsEntry.stream().map(v -> v.getBigDecimal("sdsteriamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        return sdSteriamtSum;
    }

    private BigDecimal getSdSteriamtStdSum(DynamicObjectCollection steriDetailsEntry) {
        BigDecimal sdSteriamtStdSum = steriDetailsEntry.stream().map(v -> v.getBigDecimal("sdsteriamtstd")).reduce(BigDecimal.ZERO, BigDecimal::add);
        return sdSteriamtStdSum;
    }
}

