/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.opplugin.sla;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ssc.constant.EntityField;
import kd.ssc.sla.SlaUtil;

public class SlaServiceBillSynNorAmtValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            StringBuilder errorMsg = new StringBuilder();
            this.verifyDataVariable(errorMsg, dataEntity);
            this.verifyNorAmtModify(errorMsg, dataEntity);
            if (errorMsg.length() <= 0) continue;
            this.addMessage(dataEntity, errorMsg.toString(), ErrorLevel.Error);
        }
    }

    private void verifyDataVariable(StringBuilder errorMsg, ExtendedDataEntity dataEntity) {
        String billStatus = (String)dataEntity.getValue("billstatus");
        DynamicObject billType = (DynamicObject)dataEntity.getValue("billtype");
        if (!"A".equals(billStatus) || !"sla_servicebill_settle_BT_S".equals(billType.getString("number"))) {
            errorMsg.append(ResManager.loadKDString((String)"\u53ea\u6709\u201c\u6682\u5b58\u201d\u72b6\u6001\u7684\u670d\u52a1\u7ed3\u7b97\u8d26\u5355\u53ef\u4ee5\u540c\u6b65\u7ed3\u7b97\u4ef7\u683c\u3002", (String)"SlaServiceBillSynNorAmtValidator_0", (String)"ssc-task-opplugin", (Object[])new Object[0]));
        }
    }

    private void verifyNorAmtModify(StringBuilder errorMsg, ExtendedDataEntity dataEntity) {
        if (errorMsg.length() > 0) {
            return;
        }
        Long cdpk = SlaUtil.getCdpkBySbillId((Long)((Long)dataEntity.getValue("id")));
        if (cdpk == null) {
            return;
        }
        DynamicObject cdBasedata = BusinessDataServiceHelper.loadSingle((Object)cdpk, (String)"sla_contractdetails", (String)EntityField.buildSelectField((String[])new String[]{"id", "norprice", "norfixedamount"}));
        DynamicObjectCollection detailsEntry = cdBasedata.getDynamicObjectCollection("detailsentry");
        DynamicObjectCollection billDetailsEntry = (DynamicObjectCollection)dataEntity.getValue("billdetails");
        boolean modify = false;
        for (DynamicObject rowSB : billDetailsEntry) {
            Long sourceEntryId = rowSB.getLong("sourceentryid");
            for (DynamicObject rowCD : detailsEntry) {
                Long entryId = rowCD.getLong("id");
                if (!entryId.equals(sourceEntryId)) continue;
                BigDecimal norPriceCD = rowCD.getBigDecimal("norprice");
                BigDecimal norFixedAmountCD = rowCD.getBigDecimal("norfixedamount");
                BigDecimal norPriceSB = rowSB.getBigDecimal("price");
                BigDecimal norFixedAmountSB = rowSB.getBigDecimal("fixedamount");
                if (norPriceCD.compareTo(norPriceSB) == 0 && norFixedAmountCD.compareTo(norFixedAmountSB) == 0) continue;
                modify = true;
            }
        }
        if (!modify) {
            errorMsg.append(ResManager.loadKDString((String)"\u7ed3\u7b97\u4ef7\u683c\u65e0\u53d8\u66f4\u3002", (String)"SlaServiceContractSynNorAmtValidator_0", (String)"ssc-task-opplugin", (Object[])new Object[0]));
        }
    }
}

