/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.opplugin.sla;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ssc.constant.EntityField;

public class SlaServiceContractSynNorAmtValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            StringBuilder errorMsg = new StringBuilder();
            this.verifyNorAmtModify(errorMsg, dataEntity);
            if (errorMsg.length() <= 0) continue;
            this.addMessage(dataEntity, errorMsg.toString(), ErrorLevel.Error);
        }
    }

    private void verifyNorAmtModify(StringBuilder errorMsg, ExtendedDataEntity dataEntity) {
        DynamicObject contractDetail = (DynamicObject)dataEntity.getValue("contractdetails");
        if (contractDetail != null) {
            Long cdpk = contractDetail.getLong("id");
            DynamicObject cdBasedata = BusinessDataServiceHelper.loadSingle((Object)cdpk, (String)"sla_contractdetails", (String)EntityField.buildSelectField((String[])new String[]{"id", "norprice", "norfixedamount"}));
            DynamicObjectCollection detailsEntry = cdBasedata.getDynamicObjectCollection("detailsentry");
            DynamicObjectCollection conDetailsEntry = (DynamicObjectCollection)dataEntity.getValue("condetails");
            boolean modify = false;
            for (DynamicObject rowSC : conDetailsEntry) {
                Long sourceEntryId = rowSC.getLong("sourceentryid");
                for (DynamicObject rowCD : detailsEntry) {
                    Long entryId = rowCD.getLong("id");
                    if (!entryId.equals(sourceEntryId)) continue;
                    BigDecimal norPriceCD = rowCD.getBigDecimal("norprice");
                    BigDecimal norFixedAmountCD = rowCD.getBigDecimal("norfixedamount");
                    BigDecimal norPriceSC = rowSC.getBigDecimal("norprice");
                    BigDecimal norFixedAmountSC = rowSC.getBigDecimal("norfixedamount");
                    if (norPriceCD.compareTo(norPriceSC) == 0 && norFixedAmountCD.compareTo(norFixedAmountSC) == 0) continue;
                    modify = true;
                }
            }
            if (!modify) {
                errorMsg.append(ResManager.loadKDString((String)"\u7ed3\u7b97\u4ef7\u683c\u65e0\u53d8\u66f4\u3002", (String)"SlaServiceContractSynNorAmtValidator_0", (String)"ssc-task-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

