/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.opplugin.smartcs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.ssc.smartcs.enums.ExcpStateEnum;
import kd.ssc.smartcs.util.AIMetaDataSynchrnizedUtil;
import kd.ssc.smartcs.util.ExceptionHandler;
import kd.ssc.task.opplugin.smartcs.util.ErrorMsgBuilder;

public class InfoDeletePlugin
extends AbstractOperationServicePlugIn {
    private static final String AREA = "area";
    private static final String SUBJECT = "group";
    private static final String IS_SUBJECT = "subject";
    private static final String AI_SUBJECT_ID = "aisubjectid";
    private static final String AI_QUESTION_ID = "aiquestionid";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fields = e.getFieldKeys();
        fields.add(AREA);
        fields.add(SUBJECT);
        fields.add(IS_SUBJECT);
        fields.add(AI_SUBJECT_ID);
        fields.add(AI_QUESTION_ID);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] deleteSuccessDyn = e.getDataEntities();
        if (deleteSuccessDyn == null || deleteSuccessDyn.length == 0) {
            return;
        }
        ArrayList<DynamicObject> continueDelDynList = new ArrayList<DynamicObject>(Arrays.asList(deleteSuccessDyn));
        for (DynamicObject dyo : deleteSuccessDyn) {
            if (this.isSubject(dyo)) continue;
            try {
                Long knowledgePkId = dyo.getLong("id");
                Long areaId = this.getAIAreaId(this.getAreaId(dyo));
                Long subjectId = this.getAISubjectId(dyo);
                Long questionId = this.getAIQuestionId(dyo);
                AIMetaDataSynchrnizedUtil.deleteQuestionForBatching((Long)areaId, (Long)subjectId, Collections.singletonList(questionId));
                this.deleteKnowledgeBySql(knowledgePkId);
            }
            catch (KDException ex) {
                continueDelDynList.remove(dyo);
                this.operationResult.addErrorInfo((OperateErrorInfo)ErrorMsgBuilder.buildErrMessage(dyo, (Exception)((Object)ex), ResManager.loadKDString((String)"\u77e5\u8bc6\u9886\u57df\u5220\u9664", (String)"", (String)"", (Object[])new Object[0])));
                ExceptionHandler.saveErrLog((String)dyo.getDataEntityType().getName(), (Object)dyo.getPkValue(), (Throwable)ex);
            }
        }
        e.setDataEntities(continueDelDynList.toArray(new DynamicObject[0]));
    }

    private Long getAIAreaId(Long areaId) {
        QFilter qFilter = new QFilter("id", "=", (Object)areaId);
        DynamicObject area = QueryServiceHelper.queryOne((String)"som_knowledge_area", (String)"aiareaid", (QFilter[])new QFilter[]{qFilter});
        if (area == null || area.getLong("aiareaid") == 0L) {
            ErrorCode code = new ErrorCode(ExcpStateEnum.DataOutOfSync.getValue(), String.format(ResManager.loadKDString((String)"\u5220\u9664\u95ee\u7b54\u672a\u83b7\u5f97\u6240\u5c5e\u9886\u57dfid\uff08AI\uff09\uff0c\u6240\u5c5e\u82cd\u7a79\u9886\u57dfid\u4e3a\uff1a%s", (String)"InfoDeletePlugin_0", (String)"ssc-task-opplugin", (Object[])new Object[0]), areaId));
            throw new KDException(code, new Object[0]);
        }
        return area.getLong("aiareaid");
    }

    private Long getAISubjectId(DynamicObject dyo) {
        long subjectId = this.getSubjectId(dyo);
        DynamicObject subject = QueryServiceHelper.queryOne((String)"som_knowledge_info", (String)AI_SUBJECT_ID, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)subjectId)});
        if (subject == null || subject.getLong(AI_SUBJECT_ID) == 0L) {
            ErrorCode code = new ErrorCode(ExcpStateEnum.DataOutOfSync.getValue(), String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u95ee\u7b54\u672a\u83b7\u5f97\u6240\u5c5e\u7c7b\u76eeid\uff08AI\uff09\uff0c\u6240\u5c5e\u82cd\u7a79\u7c7b\u76eeid\u4e3a\uff1a%s", (String)"InfoSavePlugin_1", (String)"ssc-task-opplugin", (Object[])new Object[0]), dyo.getPkValue()));
            throw new KDException(code, new Object[0]);
        }
        return subject.getLong(AI_SUBJECT_ID);
    }

    private Long getAIQuestionId(DynamicObject dyo) {
        return this.getBaseId(dyo, AI_QUESTION_ID);
    }

    private Long getSubjectId(DynamicObject dyo) {
        return this.getBaseId(dyo, SUBJECT);
    }

    private Long getAreaId(DynamicObject dyo) {
        return this.getBaseId(dyo, AREA);
    }

    private Long getBaseId(DynamicObject dyo, String field) {
        Object value = dyo.get(field);
        if (value instanceof DynamicObject) {
            return (Long)((DynamicObject)value).getPkValue();
        }
        return (Long)value;
    }

    private void deleteStatisticsReport(DynamicObject[] deleteSuccessDyn) {
        ArrayList<Long> deleteIds = new ArrayList<Long>(deleteSuccessDyn.length);
        for (DynamicObject dyo : deleteSuccessDyn) {
            Object id = dyo.getPkValue();
            if (!(id instanceof Long)) continue;
            deleteIds.add((Long)id);
        }
        QFilter delFilter = new QFilter("knowledge", "in", deleteIds);
        DeleteServiceHelper.delete((String)"som_knowledge_qa_detail", (QFilter[])new QFilter[]{delFilter});
    }

    private boolean isSubject(DynamicObject dyo) {
        return dyo.getBoolean(IS_SUBJECT);
    }

    private void deleteKnowledgeBySql(Long knowledgeId) {
        if (knowledgeId == null || knowledgeId == 0L) {
            return;
        }
        String sql = "DELETE FROM t_tk_scs_detail WHERE fid = ?";
        String sql_l = "DELETE FROM t_tk_scs_detail_l WHERE fid = ?";
        Object[] params = new Object[]{knowledgeId};
        DB.execute((DBRoute)DBRoute.of((String)"ssc"), (String)sql, (Object[])params);
        DB.execute((DBRoute)DBRoute.of((String)"ssc"), (String)sql_l, (Object[])params);
    }
}

