/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.opplugin.smartcs;

import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.task.opplugin.smartcs.constant.Constant;

public class InfoSaveValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            StringBuilder builder = new StringBuilder();
            Boolean isSubject = (Boolean)dataEntity.getValue("subject");
            if (!isSubject.booleanValue()) {
                this.numberValidator(dataEntity, builder);
                this.nameValidator(dataEntity, builder);
                this.answerLengthValidator(dataEntity, builder);
                this.repetitionValidator(dataEntity, builder);
            }
            if (builder.length() <= 0) continue;
            this.addMessage(dataEntity, builder.toString(), ErrorLevel.Error);
        }
    }

    private void repetitionValidator(ExtendedDataEntity dataEntity, StringBuilder builder) {
        HashSet<String> questionSet = new HashSet<String>(6);
        DynamicObjectCollection simques = (DynamicObjectCollection)dataEntity.getValue("quesentry");
        String question = dataEntity.getValue("question") + "";
        questionSet.add(question);
        for (DynamicObject dyo : simques) {
            String eachSimQues = dyo.getString("similarques") + "";
            if (!StringUtils.isNotBlank((CharSequence)eachSimQues)) continue;
            if (questionSet.contains(eachSimQues)) {
                if (builder.length() > 0) {
                    builder.append(';');
                }
                builder.append(ResManager.loadKDString((String)"\u5305\u62ec\u76f8\u4f3c\u95ee\u6cd5\u5728\u5185\u7684\u95ee\u9898\u63cf\u8ff0\u6709\u91cd\u590d\uff0c\u8bf7\u5220\u9664\u91cd\u590d\u63cf\u8ff0\u3002", (String)"InfoSaveValidator_3", (String)"ssc-task-opplugin", (Object[])new Object[0]));
                break;
            }
            questionSet.add(eachSimQues);
        }
    }

    private void answerLengthValidator(ExtendedDataEntity dataEntity, StringBuilder builder) {
        String answer = dataEntity.getValue("answer").toString();
        Boolean isUsedRebort = (Boolean)dataEntity.getValue("rebortuse");
        if (isUsedRebort != null && isUsedRebort.booleanValue() && answer.length() > Constant.MAX_ANSWER_LENGTH) {
            if (builder.length() > 0) {
                builder.append(';');
            }
            builder.append(ResManager.loadKDString((String)"\u7b54\u6848\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7300\u4e2a\u5b57\u3002", (String)"InfoSaveValidator_4", (String)"ssc-task-opplugin", (Object[])new Object[0]));
        }
    }

    private void nameValidator(ExtendedDataEntity dataEntity, StringBuilder builder) {
        Long pkId = this.getPkId(dataEntity);
        String question = dataEntity.getValue("question") + "";
        QFilter qFilter1 = new QFilter("question", "=", (Object)question);
        QFilter qFilter2 = new QFilter("id", "!=", (Object)pkId);
        String entity = dataEntity.getDataEntity().getDataEntityType().getName();
        if (QueryServiceHelper.exists((String)entity, (QFilter[])new QFilter[]{qFilter1, qFilter2})) {
            if (builder.length() > 0) {
                builder.append(';');
            }
            builder.append(ResManager.loadKDString((String)"\u95ee\u9898\u5df2\u5b58\u5728\u3002", (String)"InfoSaveValidator_2", (String)"ssc-task-opplugin", (Object[])new Object[0]));
        }
    }

    private void numberValidator(ExtendedDataEntity dataEntity, StringBuilder builder) {
        Long pkId = this.getPkId(dataEntity);
        Object number = dataEntity.getValue("number");
        QFilter qFilter1 = new QFilter("number", "=", number);
        QFilter qFilter2 = new QFilter("id", "!=", (Object)pkId);
        String entity = dataEntity.getDataEntity().getDataEntityType().getName();
        if (QueryServiceHelper.exists((String)entity, (QFilter[])new QFilter[]{qFilter1, qFilter2})) {
            builder.append(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728", (String)"InfoSaveValidator_0", (String)"ssc-task-opplugin", (Object[])new Object[0]));
        }
    }

    private Long getPkId(ExtendedDataEntity dataEntity) {
        Object pkId = dataEntity.getBillPkId();
        if (pkId instanceof Long) {
            return (Long)pkId;
        }
        return 0L;
    }
}

