/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.opplugin.sscbillmanger;

import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.metadata.dao.MetadataDao;

public class WorkBillDeleteValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject workBill = dataEntity.getDataEntity();
            String entityName = workBill.getString("number");
            boolean existMetadata = MetadataDao.checkNumber((String)entityName);
            if (!existMetadata) continue;
            DBRoute dbRoute = DBRoute.of((String)"ssc");
            String algoKey = ((Object)((Object)this)).getClass() + ".existBillBizData";
            DynamicObjectCollection entryEntity = workBill.getDynamicObjectCollection("entryentity");
            HashSet<String> tables = new HashSet<String>(entryEntity.size() + 1);
            tables.add("t_" + entityName);
            for (DynamicObject entry : entryEntity) {
                String panelType = entry.getString("ptype");
                String pCheckMeta = entry.getString("pcheckmeta");
                if (!"1".equals(pCheckMeta) || !"1".equals(panelType)) continue;
                String panelNumber = entry.getString("pnumber");
                String tableName = "t_" + panelNumber + "_e";
                tables.add(tableName);
            }
            String querySql = "select 1 from %s";
            boolean hasBizData = false;
            for (String table : tables) {
                if (!DB.exitsTable((DBRoute)dbRoute, (String)table)) continue;
                DataSet ds = DB.queryDataSet((String)algoKey, (DBRoute)dbRoute, (String)String.format(querySql, table));
                Throwable throwable = null;
                try {
                    if (ds.isEmpty()) continue;
                    hasBizData = true;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ds == null) continue;
                    if (throwable != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ds.close();
                }
            }
            if (!hasBizData) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5de5\u5355\u5df2\u4ea7\u751f\u4e1a\u52a1\u6570\u636e\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"WorkBillDeleteValidator_1", (String)"ssc-task-opplugin", (Object[])new Object[0]));
        }
    }
}

