/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.image.api;

import java.util.HashMap;
import kd.bos.api.ApiRequestContext;
import kd.bos.service.DispatchService;
import kd.bos.service.lookup.ServiceLookup;

public class ImageAPI {
    private static <T> T invokeBizService(String cloudId, String appId, String serviceName, String methodName, Object ... paras) {
        DispatchService service = (DispatchService)ServiceLookup.lookup(DispatchService.class, (String)appId);
        String factory = String.format("kd.%s.%s.servicehelper.ServiceFactory", cloudId, appId);
        return (T)service.invoke(factory, serviceName, methodName, paras);
    }

    private static <T> T invokeTaskImageService(String methodName, Object ... paras) {
        return ImageAPI.invokeBizService("ssc", "task", "ImageService", methodName, paras);
    }

    public void getImageInfo() {
        ApiRequestContext ctx = ApiRequestContext.get();
        String inputXml = ctx.getPostData();
        String outputXml = (String)ImageAPI.invokeTaskImageService("getImageInfo", inputXml);
        ctx.writeSuccess((Object)outputXml);
    }

    public void imageReady() {
        ApiRequestContext ctx = ApiRequestContext.get();
        String inputXml = ctx.getPostData();
        String imageNo = (String)ImageAPI.invokeTaskImageService("imageReady", inputXml);
        ctx.writeSuccess((Object)imageNo);
    }

    public void updateImageState() {
        ApiRequestContext ctx = ApiRequestContext.get();
        String inputXml = ctx.getPostData();
        String outputXml = (String)ImageAPI.invokeTaskImageService("updateImageState", inputXml);
        ctx.writeSuccess((Object)outputXml);
    }

    public void synchronizeBillImageMap() {
        ApiRequestContext ctx = ApiRequestContext.get();
        HashMap inputXmlMap = (HashMap)ctx.getPostData(HashMap.class);
        boolean flag = (Boolean)ImageAPI.invokeTaskImageService("invokeSynBillImageMap", inputXmlMap);
        ctx.writeSuccess((Object)flag);
    }
}

