/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.api.smartcs;

import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractBillWebApiPlugin;
import kd.bos.bill.events.AICommandEvent;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.AICommand;
import kd.bos.entity.api.ApiResult;
import kd.ssc.smartcs.enums.TerminalAppEnum;
import kd.ssc.smartcs.util.SmartcsUserAccessPermHelper;

public class SmartCsUserAccessPermApiService
extends AbstractBillWebApiPlugin {
    private static final String CMD_CODE = "getSmartCSPermission";
    private static final String[] errCodes = new String[]{"01", "02", "03", "04"};
    private static final String AI_DEVICE = "AI_DEVICE";
    private static final String OPENID = "openId";

    public void doAICommand(AICommandEvent e) {
        super.doAICommand(e);
        AICommand cmd = e.getCommand();
        ApiResult result = e.getResult();
        if (!CMD_CODE.equals(cmd.getCommand())) {
            result.setSuccess(false);
            result.setErrorCode(errCodes[0]);
            result.setMessage(ResManager.loadKDString((String)"AI\u547d\u4ee4\u64cd\u4f5c\u7801\u9519\u8bef", (String)"SmartCsUserAccessPermApiService_3", (String)"ssc-task-webapi", (Object[])new Object[0]));
            return;
        }
        Map params = cmd.getParameter();
        if (!this.validateParams(result, params)) {
            return;
        }
        String appId = (String)params.get(AI_DEVICE);
        String userId = (String)params.get(OPENID);
        Map userPermMap = SmartcsUserAccessPermHelper.getPermSSCAndRole((String)TerminalAppEnum.valueOf((String)appId).getAppId(), (String)userId);
        if (userPermMap == null) {
            result.setSuccess(false);
            result.setErrorCode(errCodes[2]);
            result.setMessage(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u8be5\u7528\u6237\u7684\u6743\u9650\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2\u662f\u5426\u6b63\u786e\u3002", (String)"SmartCsUserAccessPermApiService_1", (String)"ssc-task-webapi", (Object[])new Object[0]));
            return;
        }
        result.setSuccess(true);
        HashMap<String, Map> data = new HashMap<String, Map>(1);
        data.put("permissions", userPermMap);
        result.setData(data);
    }

    private boolean validateParams(ApiResult result, Map<String, Object> params) {
        String appId = (String)params.get(AI_DEVICE);
        String userId = (String)params.get(OPENID);
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isEmpty((CharSequence)appId)) {
            sb.append(AI_DEVICE);
        } else if ((TerminalAppEnum.YZJ_CHATBOT.name().equals(appId) || TerminalAppEnum.NATIVE_CHATBOT.name().equals(appId)) && StringUtils.isEmpty((CharSequence)userId)) {
            if (sb.length() > 0) {
                sb.append("\u3001 ");
            }
            sb.append(OPENID);
        }
        if (sb.length() > 0) {
            result.setSuccess(false);
            result.setErrorCode(errCodes[1]);
            result.setMessage(String.format(ResManager.loadKDString((String)"\u5165\u53c2\u201c%s\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SmartCsUserAccessPermApiService_0", (String)"ssc-task-webapi", (Object[])new Object[0]), sb.toString()));
            return false;
        }
        if (!(TerminalAppEnum.YZJ_CHATBOT.name().equals(appId) || TerminalAppEnum.NATIVE_CHATBOT.name().equals(appId) || TerminalAppEnum.APP_CHATBOT.name().equals(appId))) {
            result.setSuccess(false);
            result.setErrorCode(errCodes[3]);
            result.setMessage(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u4e91\u4e4b\u5bb6\u539f\u751f\u5c0fK\u548c\u4e91\u4e4b\u5bb6\u8f7b\u5e94\u7528\u5c0fK\u3002", (String)"SmartCsUserAccessPermApiService_2", (String)"ssc-task-webapi", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

