/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.achieve.factor;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.sdk.fi.ssc.extpoint.achieve.ICustomAchieveFactorPlugin;
import kd.ssc.task.business.achieve.factor.IFactorComputeEngine;

public class PluginFactorCompute
implements IFactorComputeEngine {
    private static final String DATA_ERROR = "fi.ssc.factorDataError";
    private static final Log LOGGER = LogFactory.getLog(PluginFactorCompute.class);
    private static final String LOG_PREFIX = "-- ssc achieve EntityFactorCompute --";

    private PluginFactorCompute() {
    }

    public static IFactorComputeEngine getInstance() {
        return PluginFactorComputeInstance.INSTANCE;
    }

    @Override
    public Object computeFactorValue(Long mainOrgId, Long factorId, String assessType, Long assessObjectId, Date startDate, Date endDate) {
        ICustomAchieveFactorPlugin customPlugin = this.getCustomPlugin(factorId);
        return customPlugin.getCustomAchieveFactor(mainOrgId, assessType, assessObjectId, startDate, endDate);
    }

    @Override
    public Map<Long, Object> batchComputeFactor(Long mainOrgId, Long factorId, String assessType, Set<Long> assessObjectIds, Date startDate, Date endDate) {
        Map values;
        ICustomAchieveFactorPlugin customPlugin = this.getCustomPlugin(factorId);
        try {
            values = customPlugin.getCustomAchieveFactorBatch(mainOrgId, assessType, assessObjectIds, startDate, endDate);
        }
        catch (Exception e) {
            LOGGER.error("-- ssc achieve EntityFactorCompute --call custom factor compute plugin's method error,method name is getCustomAchieveFactorBatch.", (Throwable)e);
            ErrorCode code = new ErrorCode(DATA_ERROR, ResManager.loadKDString((String)"\u8c03\u7528\u81ea\u5b9a\u4e49\u56e0\u5b50\u8ba1\u7b97\u63d2\u4ef6%s\u7684\u6279\u5904\u7406\u65b9\u6cd5\u53d1\u751f\u5f02\u5e38\u3002", (String)"PluginFactorCompute_2", (String)"ssc-task-business", (Object[])new Object[0]));
            throw new KDException(code, customPlugin.getClass().getName(), (Throwable)e);
        }
        if (values != null) {
            return values;
        }
        HashMap<Long, Object> result = new HashMap<Long, Object>();
        for (Long assessObj : assessObjectIds) {
            try {
                Object value = customPlugin.getCustomAchieveFactor(mainOrgId, assessType, assessObj, startDate, endDate);
                result.put(assessObj, value);
            }
            catch (Exception ex) {
                LOGGER.error("-- ssc achieve EntityFactorCompute --call custom factor compute plugin's method error,method name is getCustomAchieveFactor.", (Throwable)ex);
                ErrorCode code = new ErrorCode(DATA_ERROR, ResManager.loadKDString((String)"\u8c03\u7528\u81ea\u5b9a\u4e49\u56e0\u5b50\u8ba1\u7b97\u63d2\u4ef6%s\u7684\u56e0\u5b50\u8ba1\u7b97\u65b9\u6cd5\u53d1\u751f\u5f02\u5e38\u3002", (String)"PluginFactorCompute_3", (String)"ssc-task-business", (Object[])new Object[0]));
                throw new KDException(code, customPlugin.getClass().getName(), (Throwable)ex);
            }
        }
        return result;
    }

    private ICustomAchieveFactorPlugin getCustomPlugin(Long factorId) {
        String factorSelectFields = "id,javaplugin";
        DynamicObject factorDetailInfo = BusinessDataServiceHelper.loadSingle((Object)factorId, (String)"ssc_calculationfactor", (String)factorSelectFields);
        if (factorDetailInfo == null) {
            ErrorCode code = new ErrorCode(DATA_ERROR, ResManager.loadKDString((String)"\u8ba1\u7b97\u56e0\u5b50\u4e0d\u5b58\u5728\u3002", (String)"EntityFactorCompute_0", (String)"ssc-task-business", (Object[])new Object[0]));
            throw new KDException(code, new Object[0]);
        }
        String javaPlugin = factorDetailInfo.getString("javaplugin");
        if (StringUtils.isEmpty((String)javaPlugin)) {
            ErrorCode code = new ErrorCode(DATA_ERROR, ResManager.loadKDString((String)"\u8be5\u8ba1\u7b97\u56e0\u5b50\u63d2\u4ef6\u5b9e\u73b0\u7c7b\u4e0d\u5b58\u5728\u3002", (String)"PluginFactorCompute_0", (String)"ssc-task-business", (Object[])new Object[0]));
            throw new KDException(code, new Object[0]);
        }
        try {
            Class<?> aClass = Class.forName(javaPlugin.trim());
            return (ICustomAchieveFactorPlugin)aClass.newInstance();
        }
        catch (Throwable th) {
            LOGGER.error("-- ssc achieve EntityFactorCompute --call achieve factor custom compute error.", th);
            ErrorCode code = new ErrorCode(DATA_ERROR, String.format(ResManager.loadKDString((String)"\u8c03\u7528\u8be5\u8ba1\u7b97\u56e0\u5b50\u63d2\u4ef6\u5b9e\u73b0\u7c7b\u5931\u8d25\uff1a%s", (String)"PluginFactorCompute_1", (String)"ssc-task-business", (Object[])new Object[0]), th.getMessage()));
            throw new KDException(code, new Object[0]);
        }
    }

    private static class PluginFactorComputeInstance {
        private static final IFactorComputeEngine INSTANCE = new PluginFactorCompute();

        private PluginFactorComputeInstance() {
        }
    }
}

