/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.board.credit;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.task.business.board.credit.Bill;
import kd.ssc.task.business.board.credit.BoardData;

public class CreditBoardConfigUtil {
    private static final Log log = LogFactory.getLog(CreditBoardConfigUtil.class);

    public static void updateCreditBoardData(DynamicObject[] datas) {
        if (datas.length > 0) {
            CreditBoardConfigUtil.updateCreditBoardDatas(datas);
        }
    }

    private static void updateCreditBoardDatas(DynamicObject[] dyBoardDatas) {
        HashMap bizBills = new HashMap(16);
        HashMap<String, Bill> bizBillIds = new HashMap<String, Bill>(16);
        HashSet sscIds = new HashSet(16);
        HashSet billEntityNums = new HashSet(16);
        Arrays.stream(dyBoardDatas).forEach(dyBoardData -> {
            Long sscId = dyBoardData.getLong("sscid");
            DynamicObjectCollection boardEntryData = dyBoardData.getDynamicObjectCollection("entry");
            boardEntryData.forEach(data -> {
                Bill bill;
                Object billEntityNum = data.get("bizbill");
                Object billId = data.get("billid");
                if (billEntityNum == null || StringUtils.isEmpty((CharSequence)(billEntityNum + "")) || billId == null || billId.equals(0L)) {
                    return;
                }
                String key = sscId + "#" + billEntityNum + "#" + billId;
                if (bizBills.get(key) == null) {
                    bizBills.put(key, new BoardData());
                }
                if ((bill = (Bill)bizBillIds.get(sscId + "#" + billEntityNum)) == null) {
                    bill = new Bill();
                    bizBillIds.put(sscId + "#" + billEntityNum, bill);
                }
                bill.getBillIds().add(billId);
                sscIds.add(sscId);
                billEntityNums.add(billEntityNum + "");
            });
        });
        log.info("sscid.size = " + sscIds.size());
        if (billEntityNums.isEmpty()) {
            log.warn("billEntityNums is empty");
            return;
        }
        QFilter qFilter = new QFilter("createorg", "in", sscIds);
        qFilter.and(new QFilter("billtype.number", "in", billEntityNums));
        DynamicObject[] configs = BusinessDataServiceHelper.load((String)"task_creditboardconfig_", (String)"id,createorg,billtype,fieldname,fieldnumber,fieldentitynumber", (QFilter[])new QFilter[]{qFilter});
        if (configs.length == 0) {
            log.info("configs.length == 0, qFilter = " + qFilter);
            return;
        }
        Arrays.stream(configs).forEach(config -> {
            Object createOrg = config.get("createorg.id");
            Object billNumber = config.get("billtype.number");
            String keyLike = createOrg + "#" + billNumber;
            Bill bill = (Bill)bizBillIds.get(keyLike);
            if (bill != null) {
                bill.setFiledNumber(config.get("fieldnumber") + "");
            }
            bizBills.forEach((key, boardData) -> {
                if (key.indexOf(keyLike) > -1) {
                    boardData.setFieldEntityNumber(config.get("fieldentitynumber"));
                    boardData.setFieldNumber(config.get("fieldnumber") + "");
                }
            });
        });
        bizBillIds.forEach((key, bill) -> {
            String sscId = key.split("#")[0];
            String billNumber = key.split("#")[1];
            String fieldNumber = bill.getFiledNumber();
            if (StringUtils.isEmpty((CharSequence)fieldNumber)) {
                return;
            }
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)(billNumber + ""), (String)("id," + fieldNumber), (QFilter[])new QFilter[]{new QFilter("id", "in", bill.getBillIds())});
            Arrays.stream(bills).forEach(value -> {
                Object billId = value.getPkValue();
                String key2 = sscId + "#" + billNumber + "#" + billId;
                BoardData boardData = (BoardData)bizBills.get(key2);
                DynamicObject field = null;
                if (fieldNumber.contains(".")) {
                    String entryEntity = fieldNumber.split("\\.")[0];
                    String entryEntityFiled = fieldNumber.split("\\.")[1];
                    DynamicObjectCollection collection = value.getDynamicObjectCollection(entryEntity);
                    if (collection != null && collection.size() > 0) {
                        field = ((DynamicObject)collection.get(0)).getDynamicObject(entryEntityFiled);
                    }
                } else {
                    field = value.getDynamicObject(fieldNumber);
                }
                if (field != null) {
                    boardData.setBizTypeId(field.get("id"));
                    try {
                        boardData.setFieldName((OrmLocaleValue)field.get("name"));
                    }
                    catch (Exception e) {
                        log.info(billNumber + "(" + value.getPkValue() + "),\u8be5\u5355\u636e\u7684\u5f15\u7528\u7684\u57fa\u7840\u8d44\u6599\u5c5e\u6027" + boardData.getFieldEntityNumber() + "(" + field.get("id") + "),\u672a\u5f15\u7528name\u5b57\u6bb5");
                    }
                }
            });
        });
        Arrays.stream(dyBoardDatas).forEach(dyBoardData -> {
            Long sscId = dyBoardData.getLong("sscid");
            DynamicObjectCollection boardEntryData = dyBoardData.getDynamicObjectCollection("entry");
            boardEntryData.forEach(data -> {
                Object billId = data.get("billid");
                Object billNumber = data.get("bizbill");
                String key = sscId + "#" + billNumber + "#" + billId;
                BoardData boardData = (BoardData)bizBills.get(key);
                if (boardData != null) {
                    Object fieldEntityNumber;
                    OrmLocaleValue fieldName;
                    Object bizTypeId = boardData.getBizTypeId();
                    if (bizTypeId != null) {
                        data.set("biztypeid", bizTypeId);
                    }
                    if ((fieldName = boardData.getFieldName()) != null) {
                        data.set("biztypename", (Object)fieldName);
                    }
                    if ((fieldEntityNumber = boardData.getFieldEntityNumber()) != null) {
                        data.set("biztypeentity", fieldEntityNumber);
                    }
                }
            });
        });
        SaveServiceHelper.save((DynamicObject[])dyBoardDatas);
    }
}

