/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.boardv2.pojo;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.ssc.task.business.boardv2.pojo.MulSeriesData;

public class ChartData {
    private String title;
    private List<String> xAxis = new ArrayList<String>(2);
    private List<MulSeriesData> series = new ArrayList<MulSeriesData>(2);

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<String> getxAxis() {
        return this.xAxis;
    }

    public void setxAxis(List<String> xAxis) {
        this.xAxis = xAxis;
    }

    public void addxAxis(String xAxis) {
        this.xAxis = this.xAxis == null ? new ArrayList() : this.xAxis;
        this.xAxis.add(xAxis);
    }

    public List<MulSeriesData> getSeries() {
        return this.series;
    }

    public void setSeries(List<MulSeriesData> series) {
        this.series = series;
    }

    public void addSeries(MulSeriesData series) {
        this.series = this.series == null ? new ArrayList() : this.series;
        this.series.add(series);
    }

    public static ChartData newEmpty(String title, List<String> xList, List<String> seriesName, Object defaultSeriesValue) {
        ChartData chartData = new ChartData();
        if (StringUtils.isBlank((CharSequence)title)) {
            chartData.setTitle("");
        } else {
            chartData.setTitle(title);
        }
        if (xList != null && !xList.isEmpty()) {
            chartData.setxAxis(xList);
        } else {
            chartData.setxAxis(new ArrayList<String>());
        }
        int dataSize = chartData.getxAxis().size();
        if (seriesName != null && !seriesName.isEmpty()) {
            chartData.setSeries(new ArrayList<MulSeriesData>(seriesName.size()));
            for (String s : seriesName) {
                MulSeriesData mulSeriesData = new MulSeriesData();
                mulSeriesData.setName(s);
                for (int i = 0; i < dataSize; ++i) {
                    mulSeriesData.addData(defaultSeriesValue);
                }
                chartData.addSeries(mulSeriesData);
            }
        } else {
            MulSeriesData mulSeriesData = new MulSeriesData();
            for (int i = 0; i < dataSize; ++i) {
                mulSeriesData.addData(defaultSeriesValue);
            }
            if (dataSize == 0) {
                mulSeriesData.setData(new ArrayList<Object>());
            }
            chartData.addSeries(mulSeriesData);
        }
        return chartData;
    }
}

