/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.boardv2.query;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.task.business.boardv2.helper.DataHelper;
import kd.ssc.task.business.boardv2.helper.DateHelper;
import kd.ssc.task.business.boardv2.helper.TimingLogger;

public class TaskStateProcessor {
    private static final Log logger = LogFactory.getLog(TaskStateProcessor.class);
    private static final int DB_BATCH = 5000;
    private final Date[] curMonthRange;
    private final Map<Long, Integer> sscRescan = new HashMap<Long, Integer>(1024);

    public TaskStateProcessor() {
        this.curMonthRange = DateHelper.getCurMonthRange();
    }

    public void processData() {
        TimingLogger timeLog = new TimingLogger();
        this.countRescan("task_statechange", "task_task");
        timeLog.info("TaskStateProcessor.processData#task_statechange", logger);
        this.countRescan("task_statechangehis", "task_taskhistory");
        timeLog.info("TaskStateProcessor.processData#task_statechangehis", logger);
        if (!this.sscRescan.isEmpty()) {
            this.saveDynamicObject();
        }
    }

    private void countRescan(String stateChangeEntity, String taskEntity) {
        QFilter[] timeFilter = new QFilter[]{new QFilter("changetime", ">=", (Object)this.curMonthRange[0]), new QFilter("changetime", "<", (Object)this.curMonthRange[1]), new QFilter("operation", "in", (Object)new String[]{"5", "20"})};
        String algoKey = "TaskStateProcessor.processTask#" + stateChangeEntity;
        HashSet<Long> taskIds = new HashSet<Long>(1024);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)stateChangeEntity, (String)"jobid,operation,changetime", (QFilter[])timeFilter, null).groupBy(new String[]{"operation", "jobid"}).max("changetime").finish().orderBy(new String[]{"jobid", "changetime desc"});){
            long cancelRescanId = 0L;
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long jobId = row.getLong("jobid");
                String operation = row.getString("operation");
                Date changeTime = row.getDate("changetime");
                if (jobId == null || jobId == 0L || StringUtils.isBlank((CharSequence)operation) || changeTime == null) continue;
                if ("5".equals(operation) && cancelRescanId != jobId) {
                    taskIds.add(jobId);
                } else if ("20".equals(operation)) {
                    cancelRescanId = jobId;
                }
                if (taskIds.size() != 5000) continue;
                this.setRescanCount(taskIds, taskEntity);
                taskIds.clear();
            }
        }
        if (!taskIds.isEmpty()) {
            this.setRescanCount(taskIds, taskEntity);
        }
    }

    private void setRescanCount(Set<Long> taskIds, String taskEntity) {
        String algoKey = "TaskStateProcessor.processTask#" + taskEntity;
        QFilter idsFilter = new QFilter("id", "in", taskIds);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)taskEntity, (String)"sscid", (QFilter[])idsFilter.toArray(), null).groupBy(new String[]{"sscid"}).count("count").finish();){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long sscId = row.getLong("sscid");
                Integer count = row.getInteger("count");
                if (sscId == null || sscId == 0L || count == null) continue;
                this.sscRescan.compute(sscId, (k, v) -> {
                    v = v == null ? Integer.valueOf(0) : v;
                    return v + count;
                });
            }
        }
    }

    private void saveDynamicObject() {
        ArrayList<DynamicObject> objects = new ArrayList<DynamicObject>(5000);
        for (Map.Entry<Long, Integer> entry : this.sscRescan.entrySet()) {
            Long sscId = entry.getKey();
            Integer value = entry.getValue();
            DynamicObject sscCurDyo = DataHelper.getSscCurDyo(sscId, "2");
            sscCurDyo.set("rescancnt", (Object)value);
            objects.add(sscCurDyo);
            if (objects.size() != 5000) continue;
            SaveServiceHelper.save((DynamicObject[])objects.toArray(new DynamicObject[0]));
            objects.clear();
        }
        if (!objects.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])objects.toArray(new DynamicObject[0]));
            objects.clear();
        }
    }
}

