/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.boardv2.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.task.business.boardv2.helper.DateHelper;
import kd.ssc.task.util.AlgUtil;
import kd.ssc.task.util.DateUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class WFDataProcessor {
    private static final String WORKFLOW_DATA = "som_task_ssc";
    private static final String SSC = "sscid";
    private static final String SELECT_FILTER = "selectfilter";
    private static final String TIME_DIM = "timedim";
    private static final String QUERY_DATE = "querydate";
    private static final String AUDIT_COUNT = "auditcount";
    private static final String AUDIT_TIME = "audittime";
    private static final String IMAGE_COUNT = "imagecount";
    private static final String IMAGE_TIME = "imagetime";

    public static long[] loadData(long sscId) {
        Date start = DateUtil.getCurMonthStartTime();
        String monthFilter = DateHelper.getMonthFilter(sscId, start);
        QFilter[] qFilters = new QFilter[]{new QFilter(SSC, "=", (Object)sscId), new QFilter(SELECT_FILTER, "=", (Object)monthFilter)};
        DynamicObject data = QueryServiceHelper.queryOne((String)WORKFLOW_DATA, (String)"auditcount,audittime,imagecount,imagetime", (QFilter[])qFilters);
        if (data == null) {
            return new long[]{0L, 0L, 0L, 0L};
        }
        return new long[]{NumberUtils.toLong((String)(data.getLong(AUDIT_COUNT) + ""), (long)0L), NumberUtils.toLong((String)(data.getLong(AUDIT_TIME) + ""), (long)0L), NumberUtils.toLong((String)(data.getLong(IMAGE_COUNT) + ""), (long)0L), NumberUtils.toLong((String)(data.getLong(IMAGE_TIME) + ""), (long)0L)};
    }

    public void query(Date date) {
        Long sscId;
        Date start = DateUtil.getFirstDayOfMonth((Date)date);
        Date endExclude = DateUtil.addMonth((Date)start, (int)1);
        QFilter[] qFilters = new QFilter[]{new QFilter("completetime", ">=", (Object)start), new QFilter("completetime", "<", (Object)endExclude), new QFilter("qualitysamplelibrary", "=", (Object)0L)};
        HashMap<Long, Set> sscBills = new HashMap<Long, Set>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"WFDataProcessor#query#task_taskhistory", (String)"task_taskhistory", (String)"sscid,billid", (QFilter[])qFilters, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                sscId = row.getLong(SSC);
                String billId = row.getString("billid");
                if (sscId == null || sscId == 0L || StringUtils.isBlank((CharSequence)billId)) continue;
                Set billIds = sscBills.computeIfAbsent(sscId, k -> new HashSet());
                billIds.add(billId);
            }
        }
        for (Map.Entry entry : sscBills.entrySet()) {
            Set billList = (Set)entry.getValue();
            sscId = (Long)entry.getKey();
            long[] workflow = new long[4];
            int index = 0;
            for (List bills : AlgUtil.splitList(new ArrayList(billList), (int)5000)) {
                QFilter[] qfs = new QFilter[]{new QFilter("category", "in", Arrays.asList("AuditTask", "SSCImageUploadNew")), new QFilter("businesskey", "in", (Object)bills)};
                DataSet data = QueryServiceHelper.queryDataSet((String)"WFDataProcessor#query#wf_hitaskinst", (String)"wf_hitaskinst", (String)"realdurationinmillis,category", (QFilter[])qfs, null);
                Throwable throwable = null;
                try {
                    DataSet sums = data.groupBy(new String[]{"category"}).count("count").sum("realdurationinmillis", "time").finish();
                    Throwable throwable2 = null;
                    try {
                        while (sums.hasNext()) {
                            Row row = sums.next();
                            String category = row.getString("category");
                            Integer count = row.getInteger("count");
                            Long t = row.getLong("time");
                            if (StringUtils.isBlank((CharSequence)category) || count == null || count == 0 || t == null || t == 0L) continue;
                            if ("AuditTask".equalsIgnoreCase(category)) {
                                int n = index;
                                workflow[n] = workflow[n] + (long)count.intValue();
                                int n2 = index + 1;
                                workflow[n2] = workflow[n2] + t;
                                continue;
                            }
                            if (!"SSCImageUploadNew".equalsIgnoreCase(category)) continue;
                            int n = index + 2;
                            workflow[n] = workflow[n] + (long)count.intValue();
                            int n3 = index + 3;
                            workflow[n3] = workflow[n3] + t;
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (sums == null) continue;
                        if (throwable2 != null) {
                            try {
                                sums.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        sums.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (data == null) continue;
                    if (throwable != null) {
                        try {
                            data.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    data.close();
                }
            }
            String monthFilter = DateHelper.getMonthFilter(sscId, start);
            QFilter[] loadFilter = new QFilter[]{new QFilter(SSC, "=", (Object)sscId), new QFilter(SELECT_FILTER, "=", (Object)monthFilter)};
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)WORKFLOW_DATA, (String)"imagecount,imagetime,auditcount,audittime", (QFilter[])loadFilter);
            if (dynamicObject == null) {
                dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)WORKFLOW_DATA);
                dynamicObject.set(SSC, (Object)sscId);
                dynamicObject.set(QUERY_DATE, (Object)start);
                dynamicObject.set(SELECT_FILTER, (Object)monthFilter);
                dynamicObject.set(TIME_DIM, (Object)"2");
            }
            dynamicObject.set(AUDIT_COUNT, (Object)workflow[index]);
            dynamicObject.set(AUDIT_TIME, (Object)workflow[index + 1]);
            dynamicObject.set(IMAGE_COUNT, (Object)workflow[index + 2]);
            dynamicObject.set(IMAGE_TIME, (Object)workflow[index + 3]);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }
}

