/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.condition;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.UserProp;
import kd.bos.util.StringUtils;

public enum ConFieldTypeEnum {
    BASE_DATA("1", (Class)BasedataProp.class){

        @Override
        public DynamicProperty buildProp(String number, String name, String refEntityNumber) {
            BasedataProp bsProp = new BasedataProp();
            ConFieldTypeEnum.setPropBaseInfo((DynamicProperty)bsProp, number, name);
            bsProp.setBaseEntityId(refEntityNumber);
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)refEntityNumber);
            BasedataEntityType basedataEntityType = (BasedataEntityType)dt;
            ArrayList<String> refProps = new ArrayList<String>(2);
            refProps.add(basedataEntityType.getNameProperty());
            refProps.add(basedataEntityType.getNumberProperty());
            EntityType refEntityType = basedataEntityType.getSubEntityType(refProps);
            bsProp.setBaseEntityId(dt.getName());
            bsProp.setComplexType((IDataEntityType)refEntityType);
            ConFieldTypeEnum.buildRefIdProp(bsProp);
            return bsProp;
        }
    }
    ,
    TEXT("2", (Class)TextProp.class){

        @Override
        public DynamicProperty buildProp(String number, String name, String extInfo) {
            TextProp textProp = new TextProp();
            ConFieldTypeEnum.setPropBaseInfo((DynamicProperty)textProp, number, name);
            return textProp;
        }
    }
    ,
    BOOLE("3", (Class)BooleanProp.class){

        @Override
        public DynamicProperty buildProp(String number, String name, String extInfo) {
            BooleanProp booleanProp = new BooleanProp();
            ConFieldTypeEnum.setPropBaseInfo((DynamicProperty)booleanProp, number, name);
            return booleanProp;
        }
    }
    ,
    COMBO("4", (Class)ComboProp.class){

        @Override
        public DynamicProperty buildProp(String number, String name, String itemsJson) {
            ComboProp comboProp = new ComboProp();
            ConFieldTypeEnum.setPropBaseInfo((DynamicProperty)comboProp, number, name);
            this.buildComboItems(comboProp, itemsJson);
            return comboProp;
        }

        private void buildComboItems(ComboProp combo, String itemsJson) {
            if (StringUtils.isEmpty((String)itemsJson)) {
                return;
            }
            List comboItems = combo.getComboItems();
            JSONObject extraInfo = JSON.parseObject((String)itemsJson);
            JSONArray items = extraInfo.getJSONArray("items");
            for (Object item : items) {
                JSONObject item_ = (JSONObject)item;
                ValueMapItem vmItem = new ValueMapItem();
                vmItem.setValue(item_.getString("Value"));
                vmItem.setName(new LocaleString(item_.getString("Caption")));
                comboItems.add(vmItem);
            }
        }
    }
    ,
    DATE("5", (Class)DateProp.class){

        @Override
        public DynamicProperty buildProp(String number, String name, String extInfo) {
            DateProp dateProp = new DateProp();
            ConFieldTypeEnum.setPropBaseInfo((DynamicProperty)dateProp, number, name);
            return dateProp;
        }
    }
    ,
    NUMERIC("6", (Class)DecimalProp.class){

        @Override
        public DynamicProperty buildProp(String number, String name, String extInfo) {
            DecimalProp decimalProp = new DecimalProp();
            ConFieldTypeEnum.setPropBaseInfo((DynamicProperty)decimalProp, number, name);
            return decimalProp;
        }
    }
    ,
    ORG("7", (Class)OrgProp.class){

        @Override
        public DynamicProperty buildProp(String number, String name, String extInfo) {
            OrgProp orgProp = new OrgProp();
            ConFieldTypeEnum.setPropBaseInfo((DynamicProperty)orgProp, number, name);
            ArrayList<String> refProps = new ArrayList<String>(2);
            refProps.add("name");
            refProps.add("number");
            DynamicObjectType refPropType = EntityMetadataCache.getSubDataEntityType((String)"bos_org", refProps);
            orgProp.setComplexType((IDataEntityType)refPropType);
            ConFieldTypeEnum.buildRefIdProp((BasedataProp)orgProp);
            return orgProp;
        }
    }
    ,
    USER("8", (Class)UserProp.class){

        @Override
        public DynamicProperty buildProp(String number, String name, String extInfo) {
            UserProp userProp = new UserProp();
            ConFieldTypeEnum.setPropBaseInfo((DynamicProperty)userProp, number, name);
            ArrayList<String> refProps = new ArrayList<String>(2);
            refProps.add("name");
            refProps.add("number");
            DynamicObjectType refPropType = EntityMetadataCache.getSubDataEntityType((String)"bos_user", refProps);
            userProp.setComplexType((IDataEntityType)refPropType);
            ConFieldTypeEnum.buildRefIdProp((BasedataProp)userProp);
            return userProp;
        }
    };

    private final String value;
    private final Class<?> propType;

    private ConFieldTypeEnum(String value, Class<?> propType) {
        this.value = value;
        this.propType = propType;
    }

    public String getValue() {
        return this.value;
    }

    public static ConFieldTypeEnum getTypeEnum(String value) {
        for (ConFieldTypeEnum type : ConFieldTypeEnum.values()) {
            if (!type.getValue().equals(value)) continue;
            return type;
        }
        return null;
    }

    public Class<?> getPropType() {
        return this.propType;
    }

    public abstract DynamicProperty buildProp(String var1, String var2, String var3);

    private static void setPropBaseInfo(DynamicProperty prop, String number, String name) {
        prop.setDisplayName(new LocaleString(name));
        prop.setName(number);
        prop.setAlias("f" + number);
    }

    private static void buildRefIdProp(BasedataProp bs) {
        DynamicSimpleProperty refIdProp = bs.createRefIDProp();
        refIdProp.setName(bs.getName() + "_id");
        bs.setRefIdProp((IDataEntityProperty)refIdProp);
        bs.setRefIdPropName(refIdProp.getName());
    }
}

