/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.condition;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.util.StringUtils;
import kd.ssc.task.business.condition.ConFieldTypeEnum;
import kd.ssc.task.business.condition.ConditionDataQueryHelper;

public class ConditionFilterHelper {
    public static Set<String> getFieldsOfCondition(Long conditionId) {
        FilterBuilder filterBuilder = ConditionFilterHelper.getFilterBuilderByConditionId(conditionId);
        if (filterBuilder == null) {
            return null;
        }
        return filterBuilder.getFilterObject().getAllFilterFields().keySet().stream().map(f -> f.split("\\.")[0]).collect(Collectors.toSet());
    }

    public static Map<Long, Set<String>> getFieldsOfConditions(Long[] conditionIds) {
        DynamicObjectCollection conditionCol = ConditionDataQueryHelper.queryConditionInfoById(conditionIds);
        if (conditionCol == null) {
            return null;
        }
        HashMap<Long, Set<String>> result = new HashMap<Long, Set<String>>(conditionIds.length);
        MainEntityType mainEntityType = ConditionFilterHelper.buildConFieldEntityType();
        for (DynamicObject condition : conditionCol) {
            String conditionJson = condition.getString("conditionjson_tag");
            FilterBuilder filterBuilder = ConditionFilterHelper.getFilterBuilder(mainEntityType, conditionJson);
            if (filterBuilder == null) continue;
            result.put(condition.getLong("id"), filterBuilder.getFilterObject().getAllFilterFields().keySet());
        }
        return result;
    }

    public static Set<String> getFieldsOfCondition(String conditionJson) {
        FilterBuilder filterBuilder = ConditionFilterHelper.getFilterBuilder(conditionJson);
        if (filterBuilder == null) {
            return null;
        }
        return filterBuilder.getFilterObject().getAllFilterFields().keySet();
    }

    public static FilterBuilder getFilterBuilderByConditionId(Long conditionId) {
        DynamicObject condition = ConditionDataQueryHelper.queryConditionInfoById(conditionId);
        if (condition == null) {
            return null;
        }
        return ConditionFilterHelper.getFilterBuilder(condition.getString("conditionjson_tag"));
    }

    public static FilterBuilder getFilterBuilder(String conditionJson) {
        if (StringUtils.isEmpty((String)conditionJson)) {
            return null;
        }
        MainEntityType mainEntityType = ConditionFilterHelper.buildConFieldEntityType();
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)conditionJson, FilterCondition.class);
        FilterBuilder filterBuilder = new FilterBuilder(mainEntityType, filterCondition, false);
        filterBuilder.buildFilter(false);
        return filterBuilder;
    }

    public static FilterBuilder getFilterBuilder(MainEntityType mainEntityType, String conditionJson) {
        if (mainEntityType == null || StringUtils.isEmpty((String)conditionJson)) {
            return null;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)conditionJson, FilterCondition.class);
        FilterBuilder filterBuilder = new FilterBuilder(mainEntityType, filterCondition, false);
        filterBuilder.buildFilter(false);
        return filterBuilder;
    }

    public static MainEntityType buildConFieldEntityType() {
        MainEntityType mainEntityType = new MainEntityType();
        mainEntityType.setDbIgnore(true);
        mainEntityType.setName("condition_field_data");
        for (DynamicObject conField : ConditionDataQueryHelper.queryConFields()) {
            String fieldType = conField.getString("fieldtype");
            ConFieldTypeEnum typeEnum = ConFieldTypeEnum.getTypeEnum(fieldType);
            if (typeEnum == null) continue;
            String propNumber = conField.getString("number");
            String propName = conField.getString("name");
            String extraInfo = null;
            switch (typeEnum) {
                case BASE_DATA: {
                    extraInfo = conField.getString("basedatatype");
                    break;
                }
                case COMBO: {
                    extraInfo = conField.getString("comboitemjson_tag");
                }
            }
            DynamicProperty dynamicProperty = typeEnum.buildProp(propNumber, propName, extraInfo);
            mainEntityType.addProperty(dynamicProperty);
        }
        return mainEntityType;
    }
}

