/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.handler;

import java.util.Collections;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.ssc.mircoservice.result.BaseErrorCode;
import kd.ssc.smartcs.util.AIMetaDataSynchrnizedUtil;

public class KnowledgeServiceHandler {
    private static Log logger = LogFactory.getLog(KnowledgeServiceHandler.class);

    public static void deleteById(Long knowledgeId) {
        DynamicObject knowledge = KnowledgeServiceHandler.queryKnowledgeById(knowledgeId);
        KnowledgeServiceHandler.canNotBeSubjectValidation(knowledge);
        Long aiAreaId = 0L;
        Long aiSubjectId = 0L;
        Long aiQuestionId = 0L;
        Boolean isRebortUse = knowledge.getBoolean("rebortuse");
        if (isRebortUse.booleanValue()) {
            aiAreaId = KnowledgeServiceHandler.getAIAreaId(knowledge);
            aiSubjectId = KnowledgeServiceHandler.getAISubjectId(knowledge.getLong("group"));
            aiQuestionId = KnowledgeServiceHandler.getAIQuestionId(knowledge);
        }
        try {
            if (isRebortUse.booleanValue()) {
                AIMetaDataSynchrnizedUtil.deleteQuestionForBatching((Long)aiAreaId, (Long)aiSubjectId, Collections.singletonList(aiQuestionId));
            }
            KnowledgeServiceHandler.deleteKnowledgeBySql(knowledgeId);
        }
        catch (KDException e) {
            KnowledgeServiceHandler.logError("deleteById occur exception, knowledgeId:" + knowledgeId + ",exception:" + ExceptionUtils.getExceptionStackTraceMessage((Exception)((Object)e)));
            ErrorCode code = new ErrorCode(BaseErrorCode.FAILURE.getCode(), ResManager.loadKDString((String)"\u77e5\u8bc6\u95ee\u7b54\u5220\u9664\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"KnowledgeServiceHandler_1", (String)"ssc-task-business", (Object[])new Object[0]));
            throw new KDException(code, new Object[0]);
        }
    }

    private static Long getAIAreaId(DynamicObject knowledge) {
        Long aiAreaId = knowledge.getLong("area.aiareaid");
        if (KnowledgeServiceHandler.isNullOrZero(aiAreaId)) {
            ErrorCode code = new ErrorCode(BaseErrorCode.FAILURE.getCode(), ResManager.loadKDString((String)"\u77e5\u8bc6\u9886\u57dfid(AI)\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"KnowledgeServiceHandler_2", (String)"ssc-task-business", (Object[])new Object[0]));
            throw new KDException(code, new Object[0]);
        }
        return aiAreaId;
    }

    private static Long getAIQuestionId(DynamicObject knowledge) {
        Long aiQuestionId = knowledge.getLong("aiquestionid");
        if (KnowledgeServiceHandler.isNullOrZero(aiQuestionId)) {
            ErrorCode code = new ErrorCode(BaseErrorCode.FAILURE.getCode(), ResManager.loadKDString((String)"\u77e5\u8bc6\u95ee\u7b54id(AI)\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"KnowledgeServiceHandler_4", (String)"ssc-task-business", (Object[])new Object[0]));
            throw new KDException(code, new Object[0]);
        }
        return aiQuestionId;
    }

    private static void canNotBeSubjectValidation(DynamicObject knowledge) {
        Boolean isSubject = knowledge.getBoolean("subject");
        if (isSubject.booleanValue()) {
            ErrorCode code = new ErrorCode(BaseErrorCode.FAILURE.getCode(), ResManager.loadKDString((String)"\u4e0d\u80fd\u5220\u9664\u77e5\u8bc6\u7c7b\u76ee\u3002", (String)"KnowledgeServiceHandler_5", (String)"ssc-task-business", (Object[])new Object[0]));
            throw new KDException(code, new Object[0]);
        }
    }

    private static DynamicObject queryKnowledgeById(Long knowledgeId) {
        String queryFields = "area.aiareaid, rebortuse, group, subject, aisubjectid, aiquestionid";
        QFilter qFilter = new QFilter("id", "=", (Object)knowledgeId);
        DynamicObject knowledge = QueryServiceHelper.queryOne((String)"som_knowledge_info", (String)queryFields, (QFilter[])new QFilter[]{qFilter});
        if (knowledge == null) {
            ErrorCode code = new ErrorCode(BaseErrorCode.FAILURE.getCode(), ResManager.loadKDString((String)"\u77e5\u8bc6\u95ee\u7b54\u4e0d\u5b58\u5728\u6216\u8005\u88ab\u5220\u9664\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"KnowledgeServiceHandler_0", (String)"ssc-task-business", (Object[])new Object[0]));
            throw new KDException(code, new Object[0]);
        }
        return knowledge;
    }

    private static Long getAISubjectId(Long subjectId) {
        DynamicObject subject = QueryServiceHelper.queryOne((String)"som_knowledge_info", (String)"aisubjectid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)subjectId)});
        if (subject == null || subject.getLong("aisubjectid") == 0L) {
            ErrorCode code = new ErrorCode(BaseErrorCode.FAILURE.getCode(), ResManager.loadKDString((String)"\u77e5\u8bc6\u7c7b\u76eeid(AI)\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"KnowledgeServiceHandler_3", (String)"ssc-task-business", (Object[])new Object[0]));
            throw new KDException(code, new Object[0]);
        }
        return subject.getLong("aisubjectid");
    }

    private static void deleteKnowledgeBySql(Long knowledgeId) {
        if (knowledgeId == null || knowledgeId == 0L) {
            return;
        }
        String sql = "DELETE FROM t_tk_scs_detail WHERE fid = ?";
        Object[] params = new Object[]{knowledgeId};
        DB.execute((DBRoute)DBRoute.of((String)"ssc"), (String)sql, (Object[])params);
    }

    public static boolean isNullOrZero(Long longValue) {
        return longValue == null || longValue == 0L;
    }

    private static void logError(String errorLog) {
        if (logger.isErrorEnabled()) {
            logger.error(errorLog);
        }
    }
}

