/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.fs.util.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.ssc.enums.CreditModifySourceEnum;
import kd.ssc.enums.TaskFieldConfigEnum;
import kd.ssc.task.business.board.credit.pojo.BarChart;
import kd.ssc.task.business.board.credit.pojo.CreditBoardDataResult;
import kd.ssc.task.business.board.credit.pojo.EmpoyeeCreditSubScore;
import kd.ssc.task.business.board.credit.pojo.MLABSeriesDataItem;
import kd.ssc.task.business.board.credit.pojo.MixedLineAndBar;
import kd.ssc.task.business.board.credit.pojo.NestedPies;
import kd.ssc.task.business.board.credit.pojo.NestedPiesChildData;
import kd.ssc.task.business.board.credit.pojo.NestedPiesData;
import kd.ssc.task.business.board.credit.pojo.OrgAvgCredit;
import kd.ssc.task.business.board.credit.pojo.SscCombobox;
import kd.ssc.task.business.helper.OrgRelationQueryHelper;
import kd.ssc.task.util.DateUtil;

public class CreditServiceHelper {
    protected static ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"CreditServiceHelper", (int)4);
    private static final Log log = LogFactory.getLog(CreditServiceHelper.class);
    private static final String SSC_CREDITBOARDDATA = "ssc_creditboarddata";
    private static final String SSC_CREDITBOARDAVGSCORE = "ssc_creditboardavgscore";
    private static final String SSC_CREDITBOARD = "ssc_creditboard";

    private static DynamicObject getBillOrgByFieldMap(DynamicObjectCollection fieldMapCol, DynamicObject billEntity) {
        Object orgObj = null;
        for (DynamicObject fieldMap : fieldMapCol) {
            String fieldNumber;
            String fieldName = (String)fieldMap.get("fieldconfiguration");
            if (!TaskFieldConfigEnum.ORG.getFieldKey().equals(fieldName) || !StringUtils.isNotEmpty((String)(fieldNumber = (String)fieldMap.get("sourcefieldnumber")))) continue;
            orgObj = billEntity.get(fieldNumber);
            break;
        }
        if (orgObj instanceof DynamicObject) {
            return (DynamicObject)orgObj;
        }
        return null;
    }

    private static boolean matchSscBillOrgPar(DynamicObject org, DynamicObjectCollection sscBillOrgParColl) {
        for (DynamicObject sscBillOrgPar : sscBillOrgParColl) {
            Long orgId = org.getLong("id");
            if (orgId.longValue() != sscBillOrgPar.getLong("fbasedataid_id")) continue;
            return true;
        }
        return false;
    }

    public static CreditBoardDataResult queryCreditBoardData(Map<String, Object> params) {
        long t0;
        Date endTime;
        Date startTime;
        CreditBoardDataResult dataResult = new CreditBoardDataResult();
        Long sscid = Long.parseLong((String)params.get("sscid"));
        String startTimeStr = (String)params.get("starttime");
        String endTimeStr = (String)params.get("endtime");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            startTime = dateFormat.parse(startTimeStr);
            endTime = dateFormat.parse(endTimeStr);
            endTime = DateUtil.getCurDateForm((Date)endTime, (boolean)false);
        }
        catch (ParseException e) {
            log.error(CreditServiceHelper.class + ".queryCreditBoardData()", (Throwable)e);
            return dataResult;
        }
        StringBuilder sb = new StringBuilder("queryCreditBoardData() cost time statistics:");
        long t1 = t0 = System.currentTimeMillis();
        if (sscid == 0L) {
            String userId = RequestContext.get().getUserId();
            List<SscCombobox> allPermSSC = CreditServiceHelper.getAllPermSSC(Long.parseLong(userId));
            dataResult.setSscid(allPermSSC);
            if (allPermSSC.isEmpty()) {
                return dataResult;
            }
            SscCombobox sscObj = allPermSSC.get(0);
            sscid = Long.parseLong(sscObj.getValue());
            t1 = System.currentTimeMillis();
            sb.append(" getSscid = ").append(t1 - t0).append(',');
        }
        int start = DateUtil.convertIntFormate((Date)startTime);
        int end = DateUtil.convertIntFormate((Date)endTime);
        CreditServiceHelper.setBoardTopData(dataResult, sscid, start, end);
        long t2 = System.currentTimeMillis();
        sb.append(" setBoardTopData() = ").append(t2 - t1).append(',');
        CreditServiceHelper.setSubScoreOrgTop10(dataResult, sscid, start, end);
        long t3 = System.currentTimeMillis();
        sb.append(" setSubScoreOrgTop10() = ").append(t3 - t2).append(',');
        CreditServiceHelper.setSubScoreTendency(dataResult, sscid, end);
        long t4 = System.currentTimeMillis();
        sb.append(" setSubScoreTendency() = ").append(t4 - t3).append(',');
        CreditServiceHelper.setSubScoreCauseAnalyze(dataResult, sscid, start, end);
        long t5 = System.currentTimeMillis();
        sb.append(" setSubScoreCauseAnalyze() = ").append(t5 - t4).append(',');
        CreditServiceHelper.setEmpoyeeScoreWarn(dataResult, sscid, start, end);
        long t6 = System.currentTimeMillis();
        sb.append(" setEmpoyeeScoreWarn() = ").append(t6 - t5).append(',');
        CreditServiceHelper.setOrgAvgScore(dataResult, sscid);
        long t7 = System.currentTimeMillis();
        sb.append(" setOrgAvgScore() = ").append(t7 - t6).append(',');
        CreditServiceHelper.setSubScoreBillTypeTop10(dataResult, sscid, start, end);
        long t8 = System.currentTimeMillis();
        sb.append(" setSubScoreBillTypeTop10() = ").append(t8 - t7);
        log.info(sb.toString());
        return dataResult;
    }

    private static List<SscCombobox> getAllPermSSC(Long userId) {
        QFilter filter;
        ArrayList<SscCombobox> sscList = new ArrayList<SscCombobox>(16);
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"12", (String)"som", (String)SSC_CREDITBOARD, (String)"47150e89000000ac");
        if (allPermOrgs.hasAllOrgPerm() || PermissionServiceHelper.isSuperUser((long)userId)) {
            filter = new QFilter("fisscc", "=", (Object)Character.valueOf('1'));
        } else {
            List hasPermOrgs = allPermOrgs.getHasPermOrgs();
            if (CollectionUtils.isEmpty((Collection)hasPermOrgs)) {
                return sscList;
            }
            filter = new QFilter("id", "in", (Object)hasPermOrgs);
        }
        String algoKey = CreditServiceHelper.class + ".getAllPermSSC()";
        QFilter[] filters = new QFilter[]{filter};
        try (DataSet orgDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"bos_org", (String)"id,name", (QFilter[])filters, null);){
            for (Row row : orgDataSet) {
                SscCombobox combobox = new SscCombobox();
                combobox.setValue(row.getString(0));
                combobox.setTitle(row.getString(1));
                sscList.add(combobox);
            }
        }
        log.info(algoKey + sscList.size());
        return sscList;
    }

    private static void setBoardTopData(CreditBoardDataResult dataResult, Long sscid, int start, int end) {
        Throwable throwable;
        String algoKey = CreditServiceHelper.class + ".setBoardTopData()";
        String selFields = "taskcompletednum";
        QFilter sscidFil = new QFilter("sscid", "=", (Object)sscid);
        QFilter bizDateFil = QFilter.of((String)"bizdate >= ? and bizdate <= ?", (Object[])new Object[]{start, end});
        QFilter entryIdFil = QFilter.isNotNull((String)"entry.id");
        try (DataSet completedTasks = QueryServiceHelper.queryDataSet((String)algoKey, (String)SSC_CREDITBOARDDATA, (String)selFields, (QFilter[])new QFilter[]{sscidFil, bizDateFil}, null);){
            throwable = null;
            try (DataSet resultSet = completedTasks.groupBy(null).sum("taskcompletednum").finish();){
                if (resultSet.hasNext()) {
                    Row row = resultSet.next();
                    dataResult.setCompletedTaskNum(row.getInteger("taskcompletednum"));
                }
            }
            catch (Throwable row) {
                throwable = row;
                throw row;
            }
        }
        selFields = "entry.taskid taskid";
        var10_10 = null;
        try (DataSet taskIds = QueryServiceHelper.queryDataSet((String)(algoKey + "_1"), (String)SSC_CREDITBOARDDATA, (String)selFields, (QFilter[])new QFilter[]{sscidFil, bizDateFil, entryIdFil}, null);){
            throwable = null;
            try (DataSet tempDSet = taskIds.groupBy(new String[]{"taskid"}).count("repeat").finish();
                 DataSet resultSet1 = tempDSet.groupBy(null).count("tasksubscorenum").sum("repeat", "taskdetailnum").finish();){
                int tssn = 0;
                int tssd = 0;
                int percent = 0;
                if (resultSet1.hasNext()) {
                    Row row = resultSet1.next();
                    tssn = row.getInteger("tasksubscorenum");
                    tssd = row.getInteger("taskdetailnum");
                    int ctn = dataResult.getCompletedTaskNum();
                    percent = ctn == 0 ? 0 : BigDecimal.valueOf(tssn).divide(BigDecimal.valueOf(ctn), 2, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L)).intValue();
                }
                dataResult.setCreditSubScoreTaskNum(tssn);
                dataResult.setCreditSubScoreDetail(tssd);
                dataResult.setPercentOfScoreTaskNum(percent);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            var10_10 = throwable3;
            throw throwable3;
        }
    }

    private static void setSubScoreOrgTop10(CreditBoardDataResult dataResult, Long sscid, int start, int end) {
        BarChart bar = new BarChart();
        ArrayList<Integer> data = new ArrayList<Integer>(10);
        ArrayList<String> xAxisData = new ArrayList<String>(10);
        String algoKey = CreditServiceHelper.class + ".setSubScoreOrgTop10()";
        String selFields = "entry.company company,entry.company.name companyname,entry.subscore subscore";
        QFilter sscidFil = new QFilter("sscid", "=", (Object)sscid);
        QFilter bizDateFil = QFilter.of((String)"bizdate >= ? and bizdate <= ?", (Object[])new Object[]{start, end});
        QFilter entryIdFil = QFilter.isNotNull((String)"entry.id");
        QFilter orgIdFil = new QFilter("entry.company", ">", (Object)0);
        try (DataSet subScoreSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)SSC_CREDITBOARDDATA, (String)selFields, (QFilter[])new QFilter[]{sscidFil, bizDateFil, entryIdFil, orgIdFil}, null);
             DataSet resultSet = subScoreSet.groupBy(new String[]{"company", "companyname"}).sum("subscore").finish().orderBy(new String[]{"subscore desc"}).top(10);){
            for (Row row : resultSet) {
                BigDecimal subscore = row.getBigDecimal("subscore");
                data.add(subscore.setScale(0, RoundingMode.HALF_UP).intValue());
                xAxisData.add(row.getString("companyname"));
                if (data.size() != 10) continue;
                break;
            }
            bar.setData(data);
            bar.setxAxisData(xAxisData);
        }
        dataResult.setSubScoreOrg(bar);
    }

    private static void setSubScoreBillTypeTop10(CreditBoardDataResult dataResult, Long sscid, int start, int end) {
        NestedPies subScoreBillType = new NestedPies();
        ArrayList<NestedPiesData> npList = new ArrayList<NestedPiesData>(11);
        try (DataSet resultData = CreditServiceHelper.calSubScoreBillTypeDataSet(sscid, start, end);){
            BigDecimal totalSubScore = dataResult.getTotalSubScore();
            HashMap<String, BigDecimal> tempMap = new HashMap<String, BigDecimal>(10);
            for (Row row : resultData) {
                NestedPiesChildData npChildData;
                List<NestedPiesChildData> npChildList;
                NestedPiesData npData;
                BigDecimal billPercent;
                String bizbill = row.getString("bizbill");
                BigDecimal billSubScore = row.getBigDecimal("billsubscore");
                List existsNpData = npList.stream().filter(p -> p.getNumber().equals(bizbill)).limit(1L).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(existsNpData)) {
                    billPercent = billSubScore.divide(totalSubScore, 4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L)).stripTrailingZeros();
                    if (billPercent.compareTo(BigDecimal.ZERO) == 0) continue;
                    npData = new NestedPiesData();
                    npChildList = new ArrayList<NestedPiesChildData>(4);
                    npData.setNumber(bizbill);
                    npData.setValue(billPercent);
                    npData.setChild(npChildList);
                    npList.add(npData);
                } else {
                    npData = (NestedPiesData)existsNpData.get(0);
                    billPercent = npData.getValue();
                    npChildList = ((NestedPiesData)existsNpData.get(0)).getChild();
                }
                int size = npChildList.size();
                BigDecimal addUpPercent = (BigDecimal)tempMap.get(bizbill);
                if (size < 3) {
                    npChildData = new NestedPiesChildData();
                    npChildData.setName(row.getString("biztypename"));
                    BigDecimal bizTypeSubScore = row.getBigDecimal("biztypesubscore");
                    BigDecimal bizTypePercent = bizTypeSubScore.divide(totalSubScore, 4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L)).stripTrailingZeros();
                    if (bizTypePercent.compareTo(BigDecimal.ZERO) == 0) continue;
                    if (addUpPercent == null) {
                        tempMap.put(bizbill, bizTypePercent);
                    } else {
                        tempMap.put(bizbill, addUpPercent.add(bizTypePercent));
                    }
                    npChildData.setValue(bizTypePercent);
                    npChildList.add(npChildData);
                    continue;
                }
                if (size != 3 || addUpPercent == null || addUpPercent.compareTo(billPercent) >= 0) continue;
                npChildData = new NestedPiesChildData();
                npChildData.setName(ResManager.loadKDString((String)"\u5176\u5b83", (String)"CreditServiceHelper_0", (String)"ssc-task-business", (Object[])new Object[0]));
                npChildData.setValue(billPercent.subtract(addUpPercent));
                npChildList.add(npChildData);
            }
        }
        CreditServiceHelper.setNameByBizBillNumber(npList);
        CreditServiceHelper.buildTop10AndOtherStructure(npList);
        CreditServiceHelper.repairNestedPiesChildData(npList);
        subScoreBillType.setInner(npList);
        dataResult.setSubScoreBillType(subScoreBillType);
    }

    private static DataSet calSubScoreBillTypeDataSet(Long sscid, int start, int end) {
        String algoKey = CreditServiceHelper.class + ".calSubScoreBillTypeDataSet()";
        String selFields0 = "entry.bizbill bizbill,entry.subscore subscore";
        String selFields1 = "entry.bizbill bizbill,entry.biztypename biztypename,entry.subscore subscore";
        QFilter sscidFil = new QFilter("sscid", "=", (Object)sscid);
        QFilter bizDateFil = QFilter.of((String)"bizdate >= ? and bizdate <= ?", (Object[])new Object[]{start, end});
        QFilter entryIdFil = QFilter.isNotNull((String)"entry.id");
        DataSet dataSet0_0 = QueryServiceHelper.queryDataSet((String)(algoKey + "_0"), (String)SSC_CREDITBOARDDATA, (String)selFields0, (QFilter[])new QFilter[]{sscidFil, bizDateFil, entryIdFil}, null);
        DataSet dataSet0_1 = dataSet0_0.groupBy(new String[]{"bizbill"}).sum("subscore", "billsubscore").finish().orderBy(new String[]{"billsubscore desc"}).top(11);
        DataSet dataSet1_0 = QueryServiceHelper.queryDataSet((String)(algoKey + "_1"), (String)SSC_CREDITBOARDDATA, (String)selFields1, (QFilter[])new QFilter[]{sscidFil, bizDateFil, entryIdFil}, null);
        DataSet dataSet1_1 = dataSet1_0.groupBy(new String[]{"bizbill", "biztypename"}).sum("subscore", "biztypesubscore").finish();
        DataSet joinData = dataSet1_1.leftJoin(dataSet0_1).on("bizbill", "bizbill").select(new String[]{"bizbill", "biztypename", "biztypesubscore"}, new String[]{"billsubscore"}).finish().filter("billsubscore is not null and billsubscore > 0");
        DataSet resultData = joinData.orderBy(new String[]{"billsubscore desc", "bizbill desc", "biztypesubscore desc"});
        return resultData;
    }

    private static void setNameByBizBillNumber(List<NestedPiesData> innerList) {
        HashSet billNumSet = new HashSet(10);
        innerList.forEach(p -> billNumSet.add(p.getNumber()));
        HashMap<String, String> bizObjectMap = new HashMap<String, String>(10);
        if (billNumSet.size() > 0) {
            DynamicObject[] bizObjects;
            QFilter numFil = new QFilter("number", "in", billNumSet);
            for (DynamicObject dynObj : bizObjects = BusinessDataServiceHelper.load((String)"bos_objecttype", (String)"number,name", (QFilter[])new QFilter[]{numFil})) {
                bizObjectMap.put(dynObj.getString("number"), dynObj.getString("name"));
            }
        }
        innerList.forEach(p -> {
            String name = (String)bizObjectMap.get(p.getNumber());
            if (StringUtils.isNotEmpty((String)name)) {
                p.setName(name);
            }
        });
    }

    private static void buildTop10AndOtherStructure(List<NestedPiesData> innerList) {
        if (innerList.size() <= 10) {
            return;
        }
        BigDecimal addUpPercent = BigDecimal.ZERO;
        for (int i = 0; i < 10; ++i) {
            addUpPercent = addUpPercent.add(innerList.get(i).getValue());
        }
        BigDecimal bd100 = BigDecimal.valueOf(100L);
        if (addUpPercent.compareTo(bd100) < 0) {
            NestedPiesData npData = innerList.get(10);
            npData.setValue(bd100.subtract(addUpPercent));
            npData.setName(ResManager.loadKDString((String)"\u5176\u5b83", (String)"CreditServiceHelper_0", (String)"ssc-task-business", (Object[])new Object[0]));
            List<NestedPiesChildData> npChildList = npData.getChild();
            npChildList.clear();
            NestedPiesChildData npChildData = new NestedPiesChildData();
            npChildData.setName(ResManager.loadKDString((String)"\u5176\u5b83", (String)"CreditServiceHelper_0", (String)"ssc-task-business", (Object[])new Object[0]));
            npChildData.setValue(bd100.subtract(addUpPercent));
            npChildList.add(npChildData);
        }
    }

    private static void repairNestedPiesChildData(List<NestedPiesData> innerList) {
        String elseStr = ResManager.loadKDString((String)"\u5176\u5b83", (String)"CreditServiceHelper_0", (String)"ssc-task-business", (Object[])new Object[0]);
        for (NestedPiesData npData : innerList) {
            List<NestedPiesChildData> npChildList = npData.getChild();
            if (CollectionUtils.isEmpty(npChildList)) {
                NestedPiesChildData npChildData = new NestedPiesChildData();
                npChildData.setName(elseStr);
                npChildData.setValue(npData.getValue());
                npChildList.add(npChildData);
                continue;
            }
            if (npChildList.size() != 4) continue;
            NestedPiesChildData npChildData_3 = npChildList.get(3);
            Iterator<NestedPiesChildData> it = npChildList.iterator();
            int i = 0;
            while (it.hasNext()) {
                NestedPiesChildData temp = it.next();
                if (i < 3 && temp.getName().equals(npChildData_3.getName())) {
                    npChildData_3.setValue(npChildData_3.getValue().add(temp.getValue()));
                    it.remove();
                }
                ++i;
            }
        }
    }

    private static void setSubScoreTendency(CreditBoardDataResult dataResult, Long sscid, int end) {
        Throwable throwable;
        MixedLineAndBar lineBar = new MixedLineAndBar();
        List<String> xAxisData = CreditServiceHelper.getMixedLineAndBarXAxis(end);
        lineBar.setxAxisData(xAxisData);
        ArrayList<MLABSeriesDataItem> dataItems = new ArrayList<MLABSeriesDataItem>(3);
        List<Integer> initData = Arrays.asList(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
        MLABSeriesDataItem item0 = new MLABSeriesDataItem();
        item0.setName(ResManager.loadKDString((String)"\u4fe1\u7528\u6263\u5206\u4efb\u52a1\u91cf\u5360\u6bd4", (String)"CreditServiceHelper_1", (String)"ssc-task-business", (Object[])new Object[0]));
        ArrayList<Integer> data0 = new ArrayList<Integer>(initData);
        ArrayList<Integer> data0_1 = new ArrayList<Integer>(initData);
        ArrayList<Integer> data0_2 = new ArrayList<Integer>(initData);
        item0.setData(data0);
        dataItems.add(item0);
        MLABSeriesDataItem item1 = new MLABSeriesDataItem();
        item1.setName(ResManager.loadKDString((String)"\u524d\u4e00\u5e74\u540c\u6bd4\u6570\u636e", (String)"CreditServiceHelper_2", (String)"ssc-task-business", (Object[])new Object[0]));
        dataItems.add(item1);
        ArrayList<Integer> data1 = new ArrayList<Integer>(initData);
        ArrayList<Integer> data1_1 = new ArrayList<Integer>(initData);
        ArrayList<Integer> data1_2 = new ArrayList<Integer>(initData);
        item1.setData(data1);
        MLABSeriesDataItem item2 = new MLABSeriesDataItem();
        item2.setName(ResManager.loadKDString((String)"\u4fe1\u7528\u6263\u5206\u7387\u8d8b\u52bf", (String)"CreditServiceHelper_3", (String)"ssc-task-business", (Object[])new Object[0]));
        dataItems.add(item2);
        item2.setData(data0);
        int endMonthBegin = end / 100 * 100 + 1;
        int twoYearsAgoStart = endMonthBegin - 20000 + 100;
        String algoKey = CreditServiceHelper.class + ".getSubScoreTendency()";
        String selFields1 = "taskcompletednum,bizdate";
        QFilter sscidFil = new QFilter("sscid", "=", (Object)sscid);
        QFilter bizDateFil = QFilter.of((String)"bizdate >= ? and bizdate <= ?", (Object[])new Object[]{twoYearsAgoStart, end});
        try (DataSet dataSet1 = QueryServiceHelper.queryDataSet((String)algoKey, (String)SSC_CREDITBOARDDATA, (String)selFields1, (QFilter[])new QFilter[]{sscidFil, bizDateFil}, null);){
            throwable = null;
            try (DataSet dataSet1_1 = dataSet1.select(new String[]{"taskcompletednum", "bizdate-bizdate%100 monthofyear"}).groupBy(new String[]{"monthofyear"}).sum("taskcompletednum").finish().orderBy(new String[]{"monthofyear desc"}).top(24);){
                for (Row row : dataSet1_1) {
                    Integer monthofyear = row.getInteger("monthofyear");
                    int year = monthofyear / 10000;
                    int month = monthofyear % 10000 / 100;
                    String separator = month / 10 == 0 ? "-0" : "-";
                    int idx = xAxisData.indexOf(year + separator + month);
                    int idx_ = xAxisData.indexOf(year + 1 + separator + month);
                    if (idx >= 0) {
                        data0_1.set(idx, row.getInteger("taskcompletednum"));
                        continue;
                    }
                    if (idx_ < 0) continue;
                    data1_1.set(idx_, row.getInteger("taskcompletednum"));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        String selFields2 = "bizdate,entry.taskid taskid";
        QFilter entryIdFil = QFilter.isNotNull((String)"entry.id");
        throwable = null;
        try (DataSet dataSet2 = QueryServiceHelper.queryDataSet((String)algoKey, (String)SSC_CREDITBOARDDATA, (String)selFields2, (QFilter[])new QFilter[]{sscidFil, bizDateFil, entryIdFil}, null);
             DataSet dataSet2_2 = dataSet2.select(new String[]{"bizdate-bizdate%100 monthofyear", "taskid"}).groupBy(new String[]{"monthofyear", "taskid"}).finish();
             DataSet dataSet2_3 = dataSet2_2.groupBy(new String[]{"monthofyear"}).count("tasksubscorenum").finish().orderBy(new String[]{"monthofyear desc"}).top(24);){
            for (Row row : dataSet2_3) {
                Integer monthofyear = row.getInteger("monthofyear");
                int year = monthofyear / 10000;
                int month = monthofyear % 10000 / 100;
                String separator = month / 10 == 0 ? "-0" : "-";
                int idx = xAxisData.indexOf(year + separator + month);
                int idx_ = xAxisData.indexOf(year + 1 + separator + month);
                if (idx >= 0) {
                    data0_2.set(idx, row.getInteger("tasksubscorenum"));
                    continue;
                }
                if (idx_ < 0) continue;
                data1_2.set(idx_, row.getInteger("tasksubscorenum"));
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        CreditServiceHelper.calPercent(data0, data0_1, data0_2);
        CreditServiceHelper.calPercent(data1, data1_1, data1_2);
        lineBar.setSeriesData(dataItems);
        dataResult.setSubScoreTendency(lineBar);
    }

    private static List<String> getMixedLineAndBarXAxis(int end) {
        String[] xAxisData = new String[12];
        int year = end / 10000;
        int month = end % 10000 / 100;
        for (int i = 11; i >= 0; --i) {
            xAxisData[i] = month / 10 == 0 ? year + "-0" + month : year + "-" + month;
            if (--month >= 1) continue;
            --year;
            month = 12;
        }
        return new ArrayList<String>(Arrays.asList(xAxisData));
    }

    private static void calPercent(List<Integer> data0, List<Integer> data1, List<Integer> data2) {
        int size = data0.size();
        for (int i = 0; i < size; ++i) {
            BigDecimal tcn = BigDecimal.valueOf(data1.get(i).longValue());
            BigDecimal tssn = BigDecimal.valueOf(data2.get(i).longValue());
            BigDecimal percent = tcn.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : tssn.divide(tcn, 2, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L));
            data0.set(i, percent.intValue());
        }
    }

    private static void setSubScoreCauseAnalyze(CreditBoardDataResult dataResult, Long sscid, int start, int end) {
        NestedPies np = new NestedPies();
        ArrayList<NestedPiesData> inner = new ArrayList<NestedPiesData>(4);
        String algoKey = CreditServiceHelper.class + ".setSubScoreCauseAnalyze()";
        String selFields = "entry.subscore subscore,entry.subscoretype subscoretype";
        QFilter sscidFil = new QFilter("sscid", "=", (Object)sscid);
        QFilter bizDateFil = QFilter.of((String)"bizdate >= ? and bizdate <= ?", (Object[])new Object[]{start, end});
        QFilter entryIdFil = QFilter.isNotNull((String)"entry.id");
        try (DataSet subScoreSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)SSC_CREDITBOARDDATA, (String)selFields, (QFilter[])new QFilter[]{sscidFil, bizDateFil, entryIdFil}, null);
             DataSet dataSet1 = subScoreSet.groupBy(new String[]{"subscoretype"}).sum("subscore").finish();
             DataSet dataSet2 = dataSet1.copy();){
            BigDecimal subScore;
            BigDecimal totalScore = BigDecimal.ZERO;
            for (Row row : dataSet1) {
                subScore = row.getBigDecimal("subscore");
                if (subScore == null) continue;
                totalScore = totalScore.add(subScore);
            }
            dataResult.setTotalSubScore(totalScore);
            for (Row row : dataSet2) {
                subScore = row.getBigDecimal("subscore");
                if (subScore == null) continue;
                BigDecimal percent = totalScore.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : subScore.divide(totalScore, 2, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L)).stripTrailingZeros();
                NestedPiesData npData = new NestedPiesData();
                CreditModifySourceEnum source = CreditModifySourceEnum.getSource((String)row.getString("subscoretype"));
                if (source != null) {
                    npData.setName(source.getName());
                    npData.setValue(percent);
                }
                inner.add(npData);
            }
        }
        np.setInner(inner);
        dataResult.setCreditSubCauseAnalyze(np);
    }

    private static void setEmpoyeeScoreWarn(CreditBoardDataResult dataResult, Long sscid, int start, int end) {
        ArrayList<EmpoyeeCreditSubScore> empoyeeScoreWarn = new ArrayList<EmpoyeeCreditSubScore>(10);
        String algoKey = CreditServiceHelper.class + ".setEmpoyeeScoreWarn()";
        String selFields = "entry.user.number usernum,entry.user.name username,entry.company.name company,entry.subscore subscore";
        QFilter sscidFil = new QFilter("sscid", "=", (Object)sscid);
        QFilter bizDateFil = QFilter.of((String)"bizdate >= ? and bizdate <= ?", (Object[])new Object[]{start, end});
        QFilter entryIdFil = QFilter.isNotNull((String)"entry.id");
        try (DataSet userSubScore = QueryServiceHelper.queryDataSet((String)algoKey, (String)SSC_CREDITBOARDDATA, (String)selFields, (QFilter[])new QFilter[]{sscidFil, bizDateFil, entryIdFil}, null);
             DataSet resultSet = userSubScore.groupBy(new String[]{"usernum", "username", "company"}).sum("subscore").finish().orderBy(new String[]{"subscore desc"}).top(10);){
            int i = 1;
            for (Row row : resultSet) {
                EmpoyeeCreditSubScore empoyee = new EmpoyeeCreditSubScore();
                empoyee.setRank(i);
                empoyee.setNumber(row.getString("usernum"));
                empoyee.setName(row.getString("username"));
                empoyee.setCompany(row.getString("company"));
                empoyee.setTotalSubScore(row.getInteger("subscore"));
                empoyee.setTotalSubScore(row.getInteger("subscore"));
                empoyeeScoreWarn.add(empoyee);
                ++i;
            }
            dataResult.setEmpoyeeScoreWarn(empoyeeScoreWarn);
        }
    }

    private static void setOrgAvgScore(CreditBoardDataResult dataResult, Long sscid) {
        ArrayList<OrgAvgCredit> orgAvgCreditList = new ArrayList<OrgAvgCredit>(10);
        String algoKey = CreditServiceHelper.class + ".setOrgAvgScore()";
        String selFields = "company.name company,avgscore";
        HashSet<Long> showOrg = new HashSet<Long>(OrgRelationQueryHelper.getFromOrgList(sscid, false));
        if (showOrg.isEmpty()) {
            dataResult.setCompanyScoreWarn(orgAvgCreditList);
            return;
        }
        QFilter[] filter = new QFilter[]{new QFilter("company", "in", showOrg)};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)SSC_CREDITBOARDAVGSCORE, (String)selFields, (QFilter[])filter, (String)"avgscore asc", (int)10);){
            int i = 1;
            for (Row row : dataSet) {
                OrgAvgCredit instance = new OrgAvgCredit();
                instance.setRank(i);
                instance.setCompany(row.getString("company"));
                BigDecimal avgScore = row.getBigDecimal("avgscore");
                instance.setAvgScore(avgScore.setScale(0, RoundingMode.HALF_UP).intValue());
                orgAvgCreditList.add(instance);
                ++i;
            }
        }
        dataResult.setCompanyScoreWarn(orgAvgCreditList);
    }

    public static void collectAllShowOrg(Long sscId, Set<Long> showOrg) {
        long start = System.currentTimeMillis();
        OrgRelationParam param = new OrgRelationParam();
        param.setOrgId(sscId.longValue());
        param.setToViewType("12");
        param.setFromViewType("10");
        param.setDirectViewType("fromorg");
        param.setIncludeSelf(false);
        List fromAccountOrgIds = OrgUnitServiceHelper.getBizRelationOrgIds((OrgRelationParam)param);
        long process1 = System.currentTimeMillis();
        log.info("1\u4fe1\u7528\u770b\u677f\u516c\u53f8\u5e73\u5747\u4fe1\u7528\u5206\u6307\u6807\u67e5\u8be2\u59d4\u6258\u5171\u4eab\u4e2d\u5fc3\u7684\u6838\u7b97\u7ec4\u7ec7\u8017\u65f6\uff1a" + (process1 - start) + "\u3002");
        if (fromAccountOrgIds != null && fromAccountOrgIds.size() > 0) {
            log.info("\u4fe1\u7528\u770b\u677f\u59d4\u6258\u5230\u5171\u4eab\u4e2d\u5fc3\uff1a[" + sscId + "]\u7684\u6838\u7b97\u7ec4\u7ec7ID\u96c6\u5408\uff1a" + fromAccountOrgIds);
            HashSet<Long> adminOrgIds = new HashSet<Long>(16);
            List allotAdminOrgList = OrgUnitServiceHelper.getAdminOrgRelation((List)fromAccountOrgIds, (boolean)true);
            long process2 = System.currentTimeMillis();
            log.info("2\u4fe1\u7528\u770b\u677f\u516c\u53f8\u5e73\u5747\u4fe1\u7528\u5206\u6307\u6807\u67e5\u8be2\u6838\u7b97\u7ec4\u7ec7\u5206\u914d\u7684\u884c\u653f\u7ec4\u7ec7\u8017\u65f6\uff1a" + (process2 - process1) + "\u3002");
            log.info("\u4fe1\u7528\u770b\u677f\u6838\u7b97\u7ec4\u7ec7\u5206\u914d\u7684\u884c\u653f\u7ec4\u7ec7\uff1a" + allotAdminOrgList);
            adminOrgIds.addAll(allotAdminOrgList);
            List hasAdminOrgIdList = OrgUnitServiceHelper.filterOrgDuty((List)fromAccountOrgIds, (String)"01");
            process1 = System.currentTimeMillis();
            log.info("3\u4fe1\u7528\u770b\u677f\u516c\u53f8\u5e73\u5747\u4fe1\u7528\u5206\u6307\u6807\u8fc7\u6ee4\u6838\u7b97\u7ec4\u7ec7\u62e5\u6709\u884c\u653f\u7ec4\u7ec7\u804c\u80fd\u8017\u65f6\uff1a" + (process1 - process2) + "\u3002");
            if (!hasAdminOrgIdList.isEmpty()) {
                final List allSubAdminOrgList = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"01", (List)hasAdminOrgIdList, (boolean)false);
                process2 = System.currentTimeMillis();
                log.info("4\u4fe1\u7528\u770b\u677f\u516c\u53f8\u5e73\u5747\u4fe1\u7528\u5206\u6307\u6807\u67e5\u8be2\u884c\u653f\u7ec4\u7ec7\u804c\u80fd\u7684\u6838\u7b97\u7ec4\u7ec7\u6240\u6709\u4e0b\u7ea7\u884c\u653f\u7ec4\u7ec7\u8017\u65f6\uff1a" + (process2 - process1) + "\u3002");
                Future orgStructureMapFuture = threadPool.submit((Callable)new Callable<Map<Long, List<Long>>>(){

                    @Override
                    public Map<Long, List<Long>> call() {
                        return CreditServiceHelper.getOrgStructure("01", allSubAdminOrgList);
                    }
                });
                Map orgMap = OrgUnitServiceHelper.getAdminOrgRelationMap((List)allSubAdminOrgList, (boolean)false);
                process1 = System.currentTimeMillis();
                log.info("5\u4fe1\u7528\u770b\u677f\u516c\u53f8\u5e73\u5747\u4fe1\u7528\u5206\u6307\u6807\u67e5\u8be2\u884c\u653f\u7ec4\u7ec7\u5bf9\u5e94\u7684\u5206\u914d\u4e1a\u52a1\u5355\u5143\u8017\u65f6\uff1a" + (process1 - process2) + "\u3002");
                HashSet orgSet = new HashSet(16);
                for (Map.Entry entry : orgMap.entrySet()) {
                    orgSet.addAll((Collection)entry.getValue());
                }
                List accountingList = OrgUnitServiceHelper.filterOrgDuty(new ArrayList(orgSet), (String)"10");
                process2 = System.currentTimeMillis();
                log.info("6\u4fe1\u7528\u770b\u677f\u516c\u53f8\u5e73\u5747\u4fe1\u7528\u5206\u6307\u6807\u5206\u914d\u4e1a\u52a1\u5355\u5143\u8fc7\u6ee4\u6838\u7b97\u7ec4\u7ec7\u804c\u80fd\u8017\u65f6\uff1a" + (process2 - process1) + "\u3002");
                block3: for (Map.Entry entry : orgMap.entrySet()) {
                    for (Long id : (Set)entry.getValue()) {
                        if (!accountingList.contains(id)) continue;
                        allSubAdminOrgList.remove(entry.getKey());
                        continue block3;
                    }
                }
                accountingList = OrgUnitServiceHelper.filterOrgDuty((List)allSubAdminOrgList, (String)"10");
                process1 = System.currentTimeMillis();
                log.info("7\u4fe1\u7528\u770b\u677f\u516c\u53f8\u5e73\u5747\u4fe1\u7528\u5206\u6307\u6807\u8fc7\u6ee4\u884c\u653f\u7ec4\u7ec7\u62e5\u6709\u6838\u7b97\u7ec4\u7ec7\u804c\u80fd\u8017\u65f6\uff1a" + (process1 - process2) + "\u3002");
                if (accountingList != null && !accountingList.isEmpty()) {
                    try {
                        Map map = (Map)orgStructureMapFuture.get();
                        process2 = System.currentTimeMillis();
                        log.info("7.5\u4fe1\u7528\u770b\u677f\u516c\u53f8\u5e73\u5747\u4fe1\u7528\u5206\u6307\u6807\u67e5\u627e\u7ec4\u7ec7\u7ed3\u6784\u518d\u7b49\u5f85\u65f6\u95f4\uff1a" + (process2 - process1) + "\u3002");
                        process1 = System.currentTimeMillis();
                        for (Long id : accountingList) {
                            List idList = (List)map.get(id);
                            if (idList == null) continue;
                            allSubAdminOrgList.removeAll(idList);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    allSubAdminOrgList.removeAll(accountingList);
                }
                adminOrgIds.addAll(allSubAdminOrgList);
                adminOrgIds.addAll(hasAdminOrgIdList);
            }
            if (!adminOrgIds.isEmpty()) {
                CreditServiceHelper.addCompany(adminOrgIds, showOrg);
                process2 = System.currentTimeMillis();
                log.info("8\u4fe1\u7528\u770b\u677f\u516c\u53f8\u5e73\u5747\u4fe1\u7528\u5206\u6307\u6807\u67e5\u8be2\u884c\u653f\u7ec4\u7ec7\u4e3a\u516c\u53f8\u5f62\u6001\u7684\u884c\u653f\u7ec4\u7ec7\u8017\u65f6\uff1a" + (process2 - process1) + "\u3002");
            }
        }
        long end = System.currentTimeMillis();
        log.info("9\u4fe1\u7528\u770b\u677f\u516c\u53f8\u5e73\u5747\u4fe1\u7528\u5206\u6307\u6807\u603b\u8017\u65f6\uff1a" + (end - start) + "\u3002");
    }

    private static Map<Long, List<Long>> getOrgStructure(String viewSchemaNumber, Collection<Long> orgIds) {
        long start = System.currentTimeMillis();
        if (orgIds == null || orgIds.isEmpty()) {
            return new HashMap<Long, List<Long>>(0);
        }
        QFilter numberFilter = new QFilter("number", "=", (Object)viewSchemaNumber);
        QFilter[] filters = new QFilter[]{numberFilter};
        DynamicObject viewObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_viewschema", (String)"id", (QFilter[])filters);
        if (viewObj == null) {
            return new HashMap<Long, List<Long>>(0);
        }
        QFilter filter = new QFilter("view", "=", (Object)viewObj.getLong("id")).and("org", "in", orgIds).and("isfreeze", "=", (Object)Boolean.FALSE).and("org.enable", "=", (Object)Boolean.TRUE);
        Map orgStructureMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_structure", (String)"id,org,longnumber", (QFilter[])filter.toArray());
        HashMap<Long, List<Long>> resultMap = new HashMap<Long, List<Long>>(orgStructureMap.size());
        HashMap orgStructureNumMap = new HashMap(orgStructureMap.size());
        orgStructureMap.forEach((key, value) -> orgStructureNumMap.put(value.getDynamicObject("org").getString("number"), value));
        for (Map.Entry entry : orgStructureMap.entrySet()) {
            long orgId = ((DynamicObject)entry.getValue()).getLong("org_id");
            String longNumber = ((DynamicObject)entry.getValue()).getString("longnumber");
            String[] numberArr = longNumber.split("!");
            for (int i = 0; i < numberArr.length - 1; ++i) {
                DynamicObject orgStructureDyo = (DynamicObject)orgStructureNumMap.get(numberArr[i]);
                if (orgStructureDyo == null) continue;
                resultMap.computeIfAbsent(orgStructureDyo.getLong("org_id"), p -> new ArrayList(10)).add(orgId);
            }
        }
        long end = System.currentTimeMillis();
        log.info("4.5\u4fe1\u7528\u770b\u677f\u516c\u53f8\u5e73\u5747\u4fe1\u7528\u5206\u6307\u6807\u67e5\u627e\u5bf9\u5e94\u7ec4\u7ec7\u7ed3\u6784\u8017\u65f6\uff1a" + (end - start) + "\u3002");
        return resultMap;
    }

    private static void adminOrgShow(Collection<Long> adminOrgList, Set<Long> showOrg, List<Long> fromAccountOrgIds) {
        CreditServiceHelper.addCompany(adminOrgList, showOrg);
        List<Long> deptOrgList = CreditServiceHelper.getDeptOrgList(adminOrgList);
        Map directSuperiorOrgMap = OrgUnitServiceHelper.getDirectSuperiorOrg((String)"01", deptOrgList);
        if (directSuperiorOrgMap != null && !directSuperiorOrgMap.isEmpty()) {
            ArrayList supAdminOrgList = new ArrayList(directSuperiorOrgMap.values());
            OrgRelationParam param1 = new OrgRelationParam();
            param1.setOrgIds(supAdminOrgList);
            param1.setToViewType("10");
            param1.setFromViewType("01");
            param1.setDirectViewType("toorg");
            param1.setIncludeSelf(false);
            List accountOrgIds = OrgUnitServiceHelper.getBizRelationOrgIds((OrgRelationParam)param1);
            Map allSubordinateOrgMap = OrgUnitServiceHelper.getAllSubordinateOrgMap((String)"01", (List)accountOrgIds, (boolean)false);
            block0: for (Map.Entry entry : allSubordinateOrgMap.entrySet()) {
                if (!fromAccountOrgIds.contains(entry.getKey())) continue;
                for (Long id : (List)entry.getValue()) {
                    if (!supAdminOrgList.contains(id)) continue;
                    showOrg.add(id);
                    continue block0;
                }
            }
        }
    }

    private static void addCompany(Collection<Long> ids, Set<Long> showOrg) {
        QFilter filter = new QFilter("id", "in", ids).and("orgpattern", "in", (Object)new Long[]{1L, 2L, 6L, 7L, 8L});
        List orgCompanyTypeList = QueryServiceHelper.queryPrimaryKeys((String)"bos_adminorg", (QFilter[])filter.toArray(), null, (int)-1);
        orgCompanyTypeList.stream().map(id -> Long.parseLong(String.valueOf(id))).forEach(showOrg::add);
    }

    private static List<Long> getDeptOrgList(Collection<Long> ids) {
        QFilter filter = new QFilter("id", "in", ids).and("orgpattern", "in", (Object)new Long[]{1733414559324166144L, 3L, 4L});
        List orgDeptTypeList = QueryServiceHelper.queryPrimaryKeys((String)"bos_adminorg", (QFilter[])filter.toArray(), null, (int)-1);
        return orgDeptTypeList.stream().map(id -> Long.parseLong(String.valueOf(id))).collect(Collectors.toCollection(() -> new ArrayList(orgDeptTypeList.size())));
    }

    public static Set<String> queryEnableFircmCreditArg() {
        QFilter enableFilter;
        QFilter commonFilter = new QFilter("status", "!=", (Object)Character.valueOf('D'));
        QFilter[] filters = new QFilter[]{commonFilter, enableFilter = new QFilter("enable", "=", (Object)Character.valueOf('1'))};
        DynamicObject[] creditArgDyns = BusinessDataServiceHelper.load((String)"fircm_creditarg", (String)"bizbill", (QFilter[])filters);
        if (creditArgDyns == null || creditArgDyns.length == 0) {
            return new HashSet<String>();
        }
        return Arrays.stream(creditArgDyns).map(crfeditArg -> crfeditArg.getString("bizbill.number")).collect(Collectors.toSet());
    }

    public static Map<String, String> queryAllEnableCreditAppObj() {
        QFilter enableFilter;
        QFilter commonFilter = new QFilter("status", "!=", (Object)Character.valueOf('D'));
        QFilter[] filters = new QFilter[]{commonFilter, enableFilter = new QFilter("enable", "=", (Object)Character.valueOf('1'))};
        DynamicObject[] creditArgDyns = BusinessDataServiceHelper.load((String)"fircm_creditarg", (String)"bizbill,appobj", (QFilter[])filters);
        if (creditArgDyns == null || creditArgDyns.length == 0) {
            return new HashMap<String, String>();
        }
        return Arrays.stream(creditArgDyns).collect(Collectors.toMap(crfeditArg -> crfeditArg.getString("bizbill.number"), crfeditArg -> crfeditArg.getString("appobj")));
    }

    public static Map<Long, Long> batchQueryAppObjIds(String billType, Set<String> billIds, String appObj) {
        String selectProperties = appObj + ",id";
        HashMap<Long, Long> userIdMap = new HashMap<Long, Long>();
        Set<Long> billIdSet = CreditServiceHelper.transferBillIds(billIds);
        DynamicObject[] bizObjs = BusinessDataServiceHelper.load((String)billType, (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("id", "in", billIdSet)});
        if (bizObjs == null || bizObjs.length == 0) {
            return new HashMap<Long, Long>();
        }
        for (DynamicObject obj : bizObjs) {
            Long billId = obj.getLong("id");
            DynamicObject userObj = obj.getDynamicObject(appObj);
            if (userObj == null) {
                userIdMap.put(billId, -1L);
                continue;
            }
            Long userId = userObj.getLong("id");
            userIdMap.put(billId, userId);
        }
        return userIdMap;
    }

    private static Set<Long> transferBillIds(Set<String> billIds) {
        HashSet<Long> billIdSet = new HashSet<Long>();
        for (String billId : billIds) {
            try {
                Long billIdL = Long.parseLong(billId);
                billIdSet.add(billIdL);
            }
            catch (NumberFormatException e) {
                log.error("transfer billId error,only support long type billId:" + billId);
            }
        }
        return billIdSet;
    }
}

