/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.filter.FilterField;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.util.StringUtils;

public class TaskMultiLangHelper {
    public static String getStringByMultiLangJsonOrDefault(String multiLangJson) {
        return TaskMultiLangHelper.getStringByMultiLangJsonOrDefault(multiLangJson, RequestContext.get().getLang().name());
    }

    public static String getStringByMultiLangJsonOrDefault(String multiLangJson, Long userId) {
        return TaskMultiLangHelper.getStringByMultiLangJsonOrDefault(multiLangJson, InteServiceHelper.getUserLang((Long)userId).getNumber());
    }

    public static String getStringByMultiLangJsonOrDefault(String multiLangJson, String lang) {
        String result = multiLangJson;
        if (StringUtils.isNotEmpty((String)multiLangJson)) {
            JSONObject jsonObject;
            try {
                jsonObject = JSON.parseObject((String)multiLangJson);
            }
            catch (JSONException e) {
                return multiLangJson;
            }
            if (jsonObject != null && !jsonObject.isEmpty() && StringUtils.isEmpty((String)(result = jsonObject.getString(lang)))) {
                result = jsonObject.containsKey((Object)"GLang") ? jsonObject.getString("GLang") : jsonObject.values().stream().filter(obj -> obj != null && StringUtils.isNotEmpty((String)obj.toString())).findFirst().map(Object::toString).orElse(result);
            }
        }
        return result == null ? "" : result;
    }

    public static OrmLocaleValue setLocaleValueByMultiLangJson(String multiLangJson, OrmLocaleValue value) {
        if (StringUtils.isNotEmpty((String)multiLangJson) && value != null) {
            JSONObject jsonObject;
            try {
                jsonObject = JSON.parseObject((String)multiLangJson);
            }
            catch (JSONException e) {
                value.setItem(RequestContext.get().getLang().name(), multiLangJson);
                return value;
            }
            if (jsonObject != null && !jsonObject.isEmpty()) {
                jsonObject.forEach((k, v) -> value.setItem(k, v == null ? null : v.toString()));
            }
        }
        return value;
    }

    public static OrmLocaleValue setLocaleValueDefault(OrmLocaleValue value) {
        String lang = RequestContext.get().getLang().name();
        if (value != null && StringUtils.isEmpty((String)value.get((Object)lang))) {
            value.setItem(lang, value.toString());
        }
        return value;
    }

    public static String getTaskSubjectRemarkByMulLang(Long taskSubjectId, String entityNumber) {
        if (taskSubjectId != null && taskSubjectId != 0L && StringUtils.isNotEmpty((String)entityNumber)) {
            List filterFields = new EntityTypeUtil().getFilterFields((IDataEntityType)EntityMetadataCache.getDataEntityType((String)entityNumber), false);
            HashMap<String, String> comboItemsMap = new HashMap<String, String>(filterFields.size());
            for (FilterField filterField : filterFields) {
                String fullFieldName = filterField.getFullFieldName();
                LocaleString caption = new LocaleString();
                caption.setLocaleValue(filterField.getFullFieldCaption());
                comboItemsMap.put(fullFieldName, caption.getLocaleValue());
            }
            DynamicObject taskSubjectDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)taskSubjectId, (String)"task_tasksubject");
            if (taskSubjectDyo != null) {
                DynamicObjectCollection rules = taskSubjectDyo.getDynamicObjectCollection("entryentity");
                StringBuilder appendNumber = new StringBuilder();
                for (int i = 0; i < rules.size(); ++i) {
                    String fieldNumber;
                    String fieldName;
                    DynamicObject ruleDyo = (DynamicObject)rules.get(i);
                    if (i != 0) {
                        appendNumber.append('-');
                    }
                    String pretext = ruleDyo.getString("pretext");
                    String postText = ruleDyo.getString("posttext");
                    if (StringUtils.isNotEmpty((String)pretext)) {
                        appendNumber.append(pretext);
                    }
                    if (StringUtils.isNotEmpty((String)(fieldName = (String)comboItemsMap.get(fieldNumber = ruleDyo.getString("billfield"))))) {
                        appendNumber.append(fieldName);
                    }
                    if (!StringUtils.isNotEmpty((String)postText)) continue;
                    appendNumber.append(postText);
                }
                String taskSubjectStr = appendNumber.toString();
                if (taskSubjectStr.endsWith("-")) {
                    taskSubjectStr = taskSubjectStr.substring(0, taskSubjectStr.length() - 1);
                }
                return taskSubjectStr.length() > 255 ? taskSubjectStr.substring(0, 255) : taskSubjectStr;
            }
        }
        return null;
    }
}

