/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.indicators;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.exception.KDBizException;
import kd.bos.formula.platform.engine.FormulaEngine;
import kd.bos.formula.platform.engine.RunFormulaException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ssc.enums.indicators.DateRangeEnum;
import kd.ssc.enums.indicators.IndicatorsTypeEnum;
import kd.ssc.task.business.indicators.DateRangeUtil;

public class CalFormulaUtil {
    private static final Log logger = LogFactory.getLog(CalFormulaUtil.class);
    private static final String SELECT_PROPERTIES = "bizobject.number,indicatorstype.id,monitortype,datemapping,datetype,daterange,calformulajson,dimensionmapping,datebegin,dateend";

    public static Map<Long, String> calculateIndicators(List<Long> indicatorsIds, List<Long> indicatorsObjectIds) {
        QFilter idFilter = new QFilter("id", "in", indicatorsIds);
        DynamicObject[] indicatorsArray = BusinessDataServiceHelper.load((String)"som_indicators_lib", (String)SELECT_PROPERTIES, (QFilter[])new QFilter[]{idFilter});
        if (indicatorsArray == null || indicatorsArray.length == 0) {
            logger.error("\u6307\u6807\u4e0d\u5b58\u5728");
            return null;
        }
        HashMap<Long, Map<Long, Object>> result = new HashMap<Long, Map<Long, Object>>(indicatorsIds.size());
        for (DynamicObject dynamicObject : indicatorsArray) {
            String indicatorsType = dynamicObject.getString("indicatorstype");
            Map<Long, Object> value = null;
            if (IndicatorsTypeEnum.BASE.getType().equals(indicatorsType)) {
                value = CalFormulaUtil.calBaseIndicatorsValue(dynamicObject, indicatorsObjectIds);
            } else if (IndicatorsTypeEnum.COMPOSITE.getType().equals(indicatorsType)) {
                value = CalFormulaUtil.calCompositeValue(dynamicObject, indicatorsObjectIds);
            } else {
                value = new HashMap<Long, Object>(indicatorsObjectIds.size());
                for (Long indicatorsObjectId : indicatorsObjectIds) {
                    value.put(indicatorsObjectId, null);
                }
            }
            result.put((Long)dynamicObject.getPkValue(), value);
        }
        return CalFormulaUtil.parse(result, indicatorsObjectIds);
    }

    private static void setDateRange(DynamicObject dynamicObject) {
        String dateRangeType = dynamicObject.getString("datetype");
        if (!dateRangeType.equals(DateRangeEnum.CUSTOM.getType())) {
            Map<String, Date> dateRange = DateRangeUtil.getDateRange(dateRangeType);
            dynamicObject.set("datebegin", (Object)dateRange.get("start"));
            dynamicObject.set("dateend", (Object)dateRange.get("end"));
        }
    }

    private static Map<Long, Object> calBaseIndicatorsValue(DynamicObject indicators, List<Long> indicatorsObjectIds) {
        String bizNumber = indicators.getDynamicObject("bizobject").getString("number");
        CalFormulaUtil.setDateRange(indicators);
        String dimensionMappingField = indicators.getString("dimensionmapping");
        String dateMappingField = indicators.getString("datemapping");
        CRFormula crFormula = (CRFormula)SerializationUtils.fromJsonString((String)indicators.getString("calformulajson"), CRFormula.class);
        BOSExpression bosExpression = new BOSExpression(crFormula.getExpression());
        Set vars = bosExpression.getVars();
        String selectField = String.join((CharSequence)",", vars) + "," + dimensionMappingField;
        QFilter monitorObjectFilter = new QFilter(dimensionMappingField, "in", indicatorsObjectIds);
        QFilter dateBeginFilter = new QFilter(dateMappingField, ">", (Object)indicators.getDate("datebegin"));
        QFilter dateEndFilter = new QFilter(dateMappingField, "<", (Object)indicators.getDate("dateend"));
        DynamicObject[] load = BusinessDataServiceHelper.load((String)bizNumber, (String)selectField, (QFilter[])new QFilter[]{monitorObjectFilter, dateBeginFilter, dateEndFilter});
        HashMap<Long, Object> result = new HashMap<Long, Object>(indicatorsObjectIds.size());
        for (Long indicatorsObject : indicatorsObjectIds) {
            HashMap calParam = new HashMap(16);
            List list = Arrays.stream(load).filter(dynamicObject -> {
                Object o = dynamicObject.get(dimensionMappingField);
                if (o instanceof DynamicObject) {
                    return ((DynamicObject)o).getLong("id") == indicatorsObject.longValue();
                }
                return o.equals(indicatorsObject);
            }).collect(Collectors.toList());
            for (String var : vars) {
                List collect = list.stream().map(dynamicObject -> dynamicObject.get(var)).collect(Collectors.toList());
                calParam.put(var, new HashSet(collect));
            }
            Object calResult = null;
            try {
                calResult = FormulaEngine.runFormula((String)crFormula.getExpression(), calParam);
            }
            catch (RunFormulaException e) {
                logger.error("\u76d1\u63a7\u5bf9\u8c61id\uff1a" + indicatorsObject + "\u6307\u6807\uff1a" + indicators.getString("number") + "\u8ba1\u7b97\u5931\u8d25");
            }
            result.put(indicatorsObject, calResult);
        }
        return result;
    }

    private static Map<Long, Object> calCompositeValue(DynamicObject indicators, List<Long> indicatorsObjectIds) {
        CRFormula crFormula = (CRFormula)SerializationUtils.fromJsonString((String)indicators.getString("calformulajson"), CRFormula.class);
        BOSExpression bosExpression = new BOSExpression(crFormula.getExpression());
        Set vars = bosExpression.getVars();
        HashMap<String, Map<Long, Object>> indicatorsValueMap = new HashMap<String, Map<Long, Object>>(indicatorsObjectIds.size());
        for (String var : vars) {
            QFilter numberFilter = new QFilter("number", "=", (Object)var);
            Map<Long, Object> value = null;
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"som_indicators_lib", (String)SELECT_PROPERTIES, (QFilter[])new QFilter[]{numberFilter});
            if (dynamicObject == null) {
                logger.info("\u590d\u5408\u6307\u6807\u4e2d\u7684\u6307\u6807\uff1a" + var + "\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u8ba1\u7b97");
                value = new HashMap<Long, Object>(indicatorsObjectIds.size());
                for (Long indicatorsObjectId : indicatorsObjectIds) {
                    value.put(indicatorsObjectId, null);
                }
                continue;
            }
            String indicatorsType = dynamicObject.getString("indicatorstype");
            if (IndicatorsTypeEnum.BASE.getType().equals(indicatorsType)) {
                value = CalFormulaUtil.calBaseIndicatorsValue(dynamicObject, indicatorsObjectIds);
            } else if (IndicatorsTypeEnum.COMPOSITE.getType().equals(indicatorsType)) {
                value = CalFormulaUtil.calCompositeValue(dynamicObject, indicatorsObjectIds);
            }
            indicatorsValueMap.put(var, value);
        }
        HashMap<Long, Object> result = new HashMap<Long, Object>(indicatorsObjectIds.size());
        for (Long indicatorsObjectId : indicatorsObjectIds) {
            HashMap calParam = new HashMap(vars.size());
            for (String var : vars) {
                calParam.put(var, ((Map)indicatorsValueMap.get(var)).get(indicatorsObjectId));
            }
            Object value = null;
            try {
                value = FormulaEngine.runFormula((String)crFormula.getExpression(), calParam);
            }
            catch (Exception e) {
                logger.error("\u76d1\u63a7\u5bf9\u8c61id\uff1a" + indicatorsObjectId + "\u6307\u6807\uff1a" + indicators.getString("number") + "\u8ba1\u7b97\u5931\u8d25");
            }
            result.put(indicatorsObjectId, value);
        }
        return result;
    }

    private static Map<Long, String> parse(Map<Long, Map<Long, Object>> indicatorsObjectValueMap, List<Long> indicatorsObjectIds) {
        HashMap<Long, String> result = new HashMap<Long, String>(indicatorsObjectIds.size());
        for (Long indicatorsObjectId : indicatorsObjectIds) {
            HashMap<Long, Object> indicatorsObjectValue = new HashMap<Long, Object>(indicatorsObjectValueMap.size());
            for (Map.Entry<Long, Map<Long, Object>> entry : indicatorsObjectValueMap.entrySet()) {
                Long indicatorsId = entry.getKey();
                Object value = entry.getValue().get(indicatorsObjectId);
                indicatorsObjectValue.put(indicatorsId, value);
            }
            result.put(indicatorsObjectId, SerializationUtils.toJsonString(indicatorsObjectValue));
        }
        return result;
    }

    public static Object tryCalBaseIndicators(String bizNumber, CRFormula crFormula) throws Exception {
        BOSExpression bosExpression = new BOSExpression(crFormula.getExpression());
        Set vars = bosExpression.getVars();
        String selectField = String.join((CharSequence)",", vars);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)bizNumber, (String)selectField, (QFilter[])new QFilter[0]);
        if (dynamicObject != null) {
            HashMap<String, String> calParam = new HashMap<String, String>(vars.size());
            for (String var : vars) {
                calParam.put(var, dynamicObject.getString(var));
            }
            return FormulaEngine.runFormula((String)crFormula.getExpression(), calParam);
        }
        return null;
    }

    public static Object tryCompositeIndicators(CRFormula crFormula) throws Exception {
        BOSExpression bosExpression = new BOSExpression(crFormula.getExpression());
        Set vars = bosExpression.getVars();
        HashMap<String, Object> calParams = new HashMap<String, Object>(vars.size());
        for (String var : vars) {
            QFilter numberFilter = new QFilter("number", "=", (Object)var);
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"som_indicators_lib", (String)"number,bizobject.number,calformulajson,indicatorstype.id", (QFilter[])new QFilter[]{numberFilter});
            if (dynamicObject == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6307\u6807%s\u4e0d\u5b58\u5728", (String)"CalFormulaUtil_0", (String)"ssc-task-business", (Object[])new Object[0]), var));
            }
            String indicatorsType = dynamicObject.getString("indicatorstype");
            CRFormula formula = (CRFormula)SerializationUtils.fromJsonString((String)dynamicObject.getString("calformulajson"), CRFormula.class);
            Object result = null;
            if (indicatorsType.equals(IndicatorsTypeEnum.BASE.getType())) {
                String bizNumber = dynamicObject.getDynamicObject("bizobject").getString("number");
                result = CalFormulaUtil.tryCalBaseIndicators(bizNumber, formula);
            } else {
                result = CalFormulaUtil.tryCompositeIndicators(formula);
            }
            calParams.put(var, result);
        }
        return FormulaEngine.runFormula((String)crFormula.getExpression(), calParams);
    }
}

