/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.indicators;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.ssc.enums.indicators.DateRangeEnum;

public class DateRangeUtil {
    private static final Log log = LogFactory.getLog(DateRangeUtil.class);

    public static Map<String, Date> getDateRange(String dateRangeType) {
        HashMap<String, Date> result = new HashMap<String, Date>(2);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        if (dateRangeType.equals(DateRangeEnum.TODAY.getType())) {
            String begin = simpleDateFormat.format(calendar.getTime()).substring(0, 10) + " 00:00:00";
            calendar.add(5, 1);
            String end = simpleDateFormat.format(calendar.getTime()).substring(0, 10) + " 00:00:00";
            try {
                result.put("start", simpleDateFormat.parse(begin));
                result.put("end", simpleDateFormat.parse(end));
            }
            catch (ParseException e) {
                log.error("\u83b7\u53d6\u4eca\u65e5\u65e5\u671f\u533a\u95f4\u5f02\u5e38", (Throwable)e);
            }
        } else if (dateRangeType.equals(DateRangeEnum.LAST_THIRTY_DAY.getType())) {
            calendar.add(5, -29);
            String begin = simpleDateFormat.format(calendar.getTime()).substring(0, 10) + " 00:00:00";
            calendar.add(5, 30);
            String end = simpleDateFormat.format(calendar.getTime()).substring(0, 10) + " 00:00:00";
            try {
                result.put("start", simpleDateFormat.parse(begin));
                result.put("end", simpleDateFormat.parse(end));
            }
            catch (ParseException e) {
                log.error("\u83b7\u53d6\u8fd1\u4e09\u5341\u5929\u533a\u95f4\u5f02\u5e38", (Throwable)e);
            }
        }
        return result;
    }
}

