/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.quality.credit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterObject;
import kd.bos.entity.filter.FilterScriptBuilder;
import kd.bos.entity.property.UserProp;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.FormulaException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.task.business.quality.credit.QualityCreditPojo;

public class QualityCheckCreditHelper {
    private static final Log log = LogFactory.getLog(QualityCheckCreditHelper.class);

    public static String queryAppObjNum(String bizBill) {
        QFilter qFilter = new QFilter("bizbill", "=", (Object)bizBill);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        DynamicObject dynObj = QueryServiceHelper.queryOne((String)"fircm_creditarg", (String)"appobj", (QFilter[])new QFilter[]{qFilter, enableFilter});
        if (dynObj == null) {
            return "";
        }
        return dynObj.getString("appobj");
    }

    public static String queryAppObjName(String bizBill, String appObj) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)bizBill);
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        for (IDataEntityProperty prop : properties) {
            if (!(prop instanceof UserProp)) continue;
            LocaleString displayName = prop.getDisplayName();
            String propName = prop.getName();
            if (!appObj.equals(propName)) continue;
            return displayName.toString();
        }
        return "";
    }

    public static List<DynamicObject> getNextValidTaskSet(List<DynamicObject> taskSet, String creditFilterJson, String formNumber, String appObj) {
        if (CollectionUtils.isEmpty(taskSet) || StringUtils.isEmpty((Object)creditFilterJson) || StringUtils.isEmpty((Object)formNumber) || StringUtils.isEmpty((Object)appObj)) {
            return taskSet;
        }
        List<QualityCreditPojo> pojoList = QualityCheckCreditHelper.initQualityCreditPojoList(taskSet);
        QualityCheckCreditHelper.queryAppObjCreditInfo(pojoList, formNumber, appObj);
        return QualityCheckCreditHelper.checkValidTask(pojoList, creditFilterJson);
    }

    private static List<QualityCreditPojo> initQualityCreditPojoList(List<DynamicObject> taskSet) {
        ArrayList<QualityCreditPojo> pojoList = new ArrayList<QualityCreditPojo>(16);
        for (DynamicObject taskDynObj : taskSet) {
            String billId = taskDynObj.getString("billid");
            long taskId = taskDynObj.getLong("id");
            QualityCreditPojo pojo = new QualityCreditPojo();
            pojo.setTaskId(taskId);
            pojo.setBillIdStr(billId);
            pojo.setTaskDynObj(taskDynObj);
            pojoList.add(pojo);
        }
        return pojoList;
    }

    private static List<DynamicObject> checkValidTask(List<QualityCreditPojo> pojoList, String creditFilterJson) {
        if (CollectionUtils.isEmpty(pojoList)) {
            return new ArrayList<DynamicObject>();
        }
        ArrayList<DynamicObject> validTaskDynObjs = new ArrayList<DynamicObject>();
        for (QualityCreditPojo pojo : pojoList) {
            String creditLevelName = pojo.getCreditLevelName();
            Integer creditValue = pojo.getCreditValue();
            if (StringUtils.isEmpty((Object)creditLevelName)) {
                log.error("\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u7528\u4fe1\u606f,userId:" + pojo.getUserId() + ",taskId:" + pojo.getTaskId());
                continue;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("creditlevel.name", creditLevelName);
            map.put("creditvalue", creditValue);
            String creFormula = QualityCheckCreditHelper.getCreExpFormular(creditFilterJson);
            Object result = "false";
            try {
                result = FormulaEngine.execExcelFormula((String)creFormula, map);
            }
            catch (FormulaException e) {
                log.error("\u62a5\u8d26\u4fe1\u7528\u5355\u636e\u89c4\u5219\u89e3\u6790\u5931\u8d25:" + creFormula, (Throwable)e);
            }
            if (!"true".equals(result.toString())) continue;
            validTaskDynObjs.add(pojo.getTaskDynObj());
        }
        return validTaskDynObjs;
    }

    private static String getCreExpFormular(String creditFilterJson) {
        FilterCondition fc = (FilterCondition)SerializationUtils.fromJsonString((String)creditFilterJson, FilterCondition.class);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"task_qualityscalef7credit");
        FilterBuilder filterBuilder = new FilterBuilder(entityType, fc);
        filterBuilder.buildFilter(false);
        FilterObject filterObject = filterBuilder.getFilterObject();
        if (filterObject == null) {
            return "1 = 2";
        }
        FilterScriptBuilder scriptBuilder = new FilterScriptBuilder();
        String[] filterScript = scriptBuilder.buildFilterScript(filterObject);
        return filterScript[0];
    }

    private static void queryAppObjCreditInfo(List<QualityCreditPojo> pojoList, String formNum, String appObj) {
        if (CollectionUtils.isEmpty(pojoList)) {
            return;
        }
        Set<Long> billIds = QualityCheckCreditHelper.getBillIds(pojoList);
        DynamicObject[] bizBillDynObjs = QualityCheckCreditHelper.queryBizBillInfo(formNum, appObj, billIds);
        if (bizBillDynObjs == null || bizBillDynObjs.length == 0) {
            log.warn("\u67e5\u8be2\u4e0d\u5230\u539f\u5355\u4fe1\u606f\uff1a" + billIds);
            return;
        }
        Set<Long> userIds = QualityCheckCreditHelper.getUserIds(pojoList, appObj, bizBillDynObjs);
        DynamicObject[] creditFiles = QualityCheckCreditHelper.getCreditFile(userIds);
        if (creditFiles == null || creditFiles.length == 0) {
            log.warn("\u67e5\u8be2\u4e0d\u5230\u4fe1\u7528\u6863\u6848\u4fe1\u606f\uff1a" + userIds);
            return;
        }
        QualityCheckCreditHelper.buildAppObjCreditInfo(pojoList, creditFiles);
    }

    private static void buildAppObjCreditInfo(List<QualityCreditPojo> pojoList, DynamicObject[] creditFiles) {
        for (QualityCreditPojo pojo : pojoList) {
            for (DynamicObject creditFile : creditFiles) {
                boolean isSameUser;
                boolean bl = isSameUser = creditFile.getLong("user.id") == pojo.getUserId().longValue();
                if (!isSameUser) continue;
                pojo.setCreditValue(creditFile.getInt("creditvalue"));
                pojo.setCreditLevelName(creditFile.getString("creditlevel.name"));
            }
        }
    }

    private static Set<Long> getUserIds(List<QualityCreditPojo> pojoList, String appObj, DynamicObject[] bizBillDynObjs) {
        HashSet<Long> userIds = new HashSet<Long>();
        for (QualityCreditPojo pojo : pojoList) {
            for (DynamicObject bizBillDynObj : bizBillDynObjs) {
                boolean isSameBill;
                boolean bl = isSameBill = bizBillDynObj.getLong("id") == pojo.getBillIdLong().longValue();
                if (!isSameBill) continue;
                long userId = bizBillDynObj.getDynamicObject(appObj).getLong("id");
                pojo.setUserId(userId);
                userIds.add(userId);
            }
        }
        return userIds;
    }

    private static DynamicObject[] queryBizBillInfo(String formNum, String appObj, Set<Long> billIds) {
        String selectFields = "id," + appObj;
        DynamicObject[] bizBillDynObjs = BusinessDataServiceHelper.load((String)formNum, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
        return bizBillDynObjs;
    }

    private static Set<Long> getBillIds(List<QualityCreditPojo> pojoList) {
        HashSet<Long> billIds = new HashSet<Long>(16);
        for (QualityCreditPojo pojo : pojoList) {
            long billIdL;
            try {
                billIdL = Long.parseLong(pojo.getBillIdStr());
            }
            catch (NumberFormatException e) {
                log.error("transfer billId error,only support long type billId:" + pojo.getBillIdStr() + ",taskId:" + pojo.getTaskId());
                continue;
            }
            pojo.setBillIdLong(billIdL);
            billIds.add(billIdL);
        }
        return billIds;
    }

    private static DynamicObject[] getCreditFile(Set<Long> userIds) {
        QFilter userFil = new QFilter("user", "in", userIds);
        QFilter statusFilter = new QFilter("status", "!=", (Object)Character.valueOf('D'));
        String selectFileds = "id,user.id,creditlevel.name,creditvalue";
        return BusinessDataServiceHelper.load((String)"task_creditfiles", (String)selectFileds, (QFilter[])new QFilter[]{userFil, statusFilter});
    }
}

