/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.task;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.enums.TaskFieldConfigEnum;
import kd.ssc.task.business.helper.OrgRelationQueryHelper;
import kd.ssc.task.util.BizBillValidateUtil;

public class TaskRule4ImptEditHelper {
    private static final Log log = LogFactory.getLog(TaskRule4ImptEditHelper.class);

    public static void checkOrg4Ssc(long sscId, BeforeImportDataEventArgs e, IFormView view, Map<String, Set<Long>> bindBill2TaskBillOrgsMap, Map<String, DynamicObject> bindBillMap) {
        Map.Entry validateResult;
        List<Long> orgList;
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Object orgListObj = formShowParameter.getCustomParam("orgList");
        if (orgListObj == null) {
            orgList = OrgRelationQueryHelper.getFromOrgListFilterDutyScope(sscId, true);
            formShowParameter.setCustomParam("orgList", orgList);
        } else {
            orgList = (List<Long>)orgListObj;
        }
        JSONObject row = (JSONObject)e.getSourceData();
        String orgNumbers = row.getJSONObject("sscbillorgpar").getString("number");
        if (StringUtils.isEmpty((CharSequence)orgNumbers)) {
            e.setCancel(true);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u9002\u7528\u7ec4\u7ec7", (String)"TaskRule4ImptEditHelper_0", (String)"ssc-task-business", (Object[])new Object[0]));
            return;
        }
        String[] orgNumberArr = orgNumbers.split(",");
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bos_org", (String)"id,number,name", (QFilter[])new QFilter("number", "in", (Object)orgNumberArr).toArray());
        Map<String, DynamicObject> number2Org = orgs.stream().collect(Collectors.toMap(k -> k.getString("number"), v -> v));
        ArrayList<Long> collection = new ArrayList<Long>();
        String bindBillNum = row.getJSONObject("bindbill").getString("number");
        DynamicObject bindBillDyo = bindBillMap.get(bindBillNum);
        String bindBillId = null;
        if (bindBillDyo != null) {
            bindBillId = bindBillDyo.getString("id");
        }
        for (String orgNumber : orgNumberArr) {
            DynamicObject org = number2Org.get(orgNumber);
            if (org == null) {
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u8303\u56f4\u4e2d\u7f16\u53f7\u4e3a%s\u7684\u7ec4\u7ec7\u4e0d\u5b58\u5728", (String)"TaskRule4ImptEditHelper_32", (String)"ssc-task-business", (Object[])new Object[0]), orgNumber));
                return;
            }
            if (!orgList.contains(org.getLong("id"))) {
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u8303\u56f4\u4e2d\u7f16\u53f7\u4e3a%s\u7684\u7ec4\u7ec7\u672a\u59d4\u6258\u8be5\u5171\u4eab\u4e2d\u5fc3\u6216\u59d4\u6258\u72b6\u6001\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u5171\u4eab\u804c\u8d23\u7ba1\u7406\u59d4\u6258\u5173\u7cfb", (String)"TaskRule4ImptEditHelper_1", (String)"ssc-task-business", (Object[])new Object[0]), org.getString("number")));
                return;
            }
            collection.add(org.getLong("id"));
        }
        JSONObject applyCondJson = row.getJSONObject("applycond");
        Long applyCondId = 0L;
        if (applyCondJson != null && applyCondJson.getLong("id") != null) {
            applyCondId = applyCondJson.getLong("id");
        }
        List orgIds = orgs.stream().map(p -> p.getLong("id")).collect(Collectors.toList());
        if (StringUtils.isNotEmpty((CharSequence)bindBillId) && !((Boolean)(validateResult = BizBillValidateUtil.validateOrgUsed(orgIds, (long)0L, (String)bindBillId, (long)applyCondId)).getKey()).booleanValue()) {
            e.setCancel(true);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), (String)validateResult.getValue());
        }
        row.put("orgCollection", collection);
    }

    public static void checkTaskBill(long sscId, BeforeImportDataEventArgs e, IFormView view, Map<String, DynamicObject> number2BindBillMap) {
        JSONObject row;
        String bindBill;
        DynamicObject bindBillObj;
        FormShowParameter formShowParameter = view.getFormShowParameter();
        DynamicObjectCollection taskBills = (DynamicObjectCollection)formShowParameter.getCustomParam("taskBillList");
        if (taskBills == null) {
            taskBills = QueryServiceHelper.query((String)"task_taskbill", (String)"id,number,name,effective,bindbill.number,bindbill.name", (QFilter[])new QFilter("ssccenter", "=", (Object)sscId).toArray());
            formShowParameter.setCustomParam("taskBillList", (Object)taskBills);
        }
        if ((bindBillObj = number2BindBillMap.get(bindBill = (row = (JSONObject)e.getSourceData()).getJSONObject("bindbill").getString("number"))) == null) {
            e.setCancel(true);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), String.format(ResManager.loadKDString((String)"%s\uff1a\u6765\u6e90\u5355\u636e\u4e0d\u5b58\u5728", (String)"TaskRule4ImptEditHelper_2", (String)"ssc-task-business", (Object[])new Object[0]), bindBill));
            return;
        }
        row.getJSONObject("bindbill").put("id", (Object)bindBillObj.getString("id"));
        for (DynamicObject taskBill : taskBills) {
            if (taskBill.getString("number").equals(row.getString("number"))) {
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), String.format(ResManager.loadKDString((String)"%s\uff1a\u8be5\u7f16\u53f7\u5df2\u5b58\u5728", (String)"TaskRule4ImptEditHelper_3", (String)"ssc-task-business", (Object[])new Object[0]), row.getString("number")));
                continue;
            }
            if (!taskBill.getString("name").equals(row.getJSONObject("name").getString(RequestContext.get().getLang().toString()))) continue;
            e.setCancel(true);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), String.format(ResManager.loadKDString((String)"%s\uff1a\u8be5\u540d\u79f0\u5df2\u5b58\u5728", (String)"TaskRule4ImptEditHelper_4", (String)"ssc-task-business", (Object[])new Object[0]), row.getJSONObject("name").getString(RequestContext.get().getLang().toString())));
        }
    }

    public static void checkTaskType(long sscId, BeforeImportDataEventArgs e, IFormView view) {
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Map<String, DynamicObject> number2TaskType = (Map<String, DynamicObject>)formShowParameter.getCustomParam("taskTypeMap");
        if (number2TaskType == null) {
            DynamicObject[] dataInsight = BusinessDataServiceHelper.load((String)"task_tasktype", (String)"id,number,enable,name,qualityjudge,tasklevel", (QFilter[])new QFilter("orgfield", "=", (Object)sscId).toArray());
            number2TaskType = Arrays.stream(dataInsight).collect(Collectors.toMap(k -> k.getString("number"), v -> v));
            formShowParameter.setCustomParam("taskTypeMap", number2TaskType);
        }
        JSONObject row = (JSONObject)e.getSourceData();
        String createTaskModel = row.getString("createtaskmodel");
        boolean WFCreateTaskModel = "1".equals(createTaskModel);
        JSONArray childBillEntity = row.getJSONArray("childbillentryentity");
        HashMap<String, JSONObject> taskNumber2Entry = new HashMap<String, JSONObject>();
        boolean oneFromWorkFlow = false;
        for (int i = 0; i < childBillEntity.size(); ++i) {
            JSONObject taskEntry = childBillEntity.getJSONObject(i);
            JSONObject taskType = taskEntry.getJSONObject("tasktype");
            if (taskType == null || StringUtils.isEmpty((CharSequence)taskType.getString("number"))) {
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(-1), ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4efb\u52a1\u7c7b\u578b", (String)"TaskRule4ImptEditHelper_6", (String)"ssc-task-business", (Object[])new Object[0]));
                return;
            }
            DynamicObject taskTypeObj = number2TaskType.get(taskType.getString("number"));
            if (taskTypeObj == null) {
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(-1), String.format(ResManager.loadKDString((String)"%s\uff1a\u4efb\u52a1\u7c7b\u578b\u4e0d\u5b58\u5728", (String)"TaskRule4ImptEditHelper_7", (String)"ssc-task-business", (Object[])new Object[0]), taskType.getString("number")));
                return;
            }
            if (!taskTypeObj.getBoolean("enable")) {
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(-1), String.format(ResManager.loadKDString((String)"%s\uff1a\u4efb\u52a1\u7c7b\u578b\u5df2\u7981\u7528", (String)"TaskRule4ImptEditHelper_8", (String)"ssc-task-business", (Object[])new Object[0]), taskType.getString("number")));
                return;
            }
            if (1 == taskTypeObj.getInt("qualityjudge")) {
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(-1), String.format(ResManager.loadKDString((String)"%s\uff1a\u4efb\u52a1\u5c5e\u6027\u4e0d\u80fd\u662f\u8d28\u68c0\u4efb\u52a1", (String)"TaskRule4ImptEditHelper_30", (String)"ssc-task-business", (Object[])new Object[0]), taskType.getString("number")));
                return;
            }
            taskType.put("id", (Object)taskTypeObj.getLong("id"));
            taskType.put("taskName", (Object)taskTypeObj.getString("name"));
            if (taskNumber2Entry.containsKey(taskType.getString("number"))) {
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(-1), String.format(ResManager.loadKDString((String)"%s\uff1a\u4e0d\u5141\u8bb8\u586b\u5199\u91cd\u590d\u7684\u4efb\u52a1\u7c7b\u578b", (String)"TaskRule4ImptEditHelper_9", (String)"ssc-task-business", (Object[])new Object[0]), taskType.getString("number")));
                return;
            }
            if ("0".equals(taskEntry.getString("taskoriginal")) && !StringUtils.isEmpty((CharSequence)taskEntry.getString("pretasks"))) {
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(-1), ResManager.loadKDString((String)"\u4efb\u52a1\u6765\u6e90\u4e3a\u5de5\u4f5c\u6d41\u7684\u5355\u636e\u4efb\u52a1\u5206\u5f55\u4e0d\u80fd\u5b58\u5728\u524d\u7f6e\u4efb\u52a1", (String)"TaskRule4ImptEditHelper_10", (String)"ssc-task-business", (Object[])new Object[0]));
                return;
            }
            taskNumber2Entry.put(taskType.getString("number"), taskEntry);
            if ("0".equals(taskEntry.getString("taskoriginal"))) {
                oneFromWorkFlow = true;
            }
            if (!WFCreateTaskModel) continue;
            String taskLevel = taskTypeObj.getString("tasklevel");
            if (StringUtils.isEmpty((CharSequence)taskLevel)) {
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(-1), String.format(ResManager.loadKDString((String)"%s\uff1a\u591a\u7ea7\u4efb\u52a1\u521b\u5efa\u6a21\u5f0f\u4e3a\u5de5\u4f5c\u6d41\u521b\u5efa\u4efb\u52a1\u65f6\uff0c\u9700\u8981\u586b\u5199\u6709\u4efb\u52a1\u7ea7\u6b21\u7684\u4efb\u52a1\u7c7b\u578b", (String)"TaskRule4ImptEditHelper_33", (String)"ssc-task-business", (Object[])new Object[0]), taskType.getString("number")));
                return;
            }
            String taskOriginal = taskEntry.getString("taskoriginal");
            if ("0".equals(taskOriginal) || "3".equals(taskOriginal)) continue;
            e.setCancel(true);
            e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(-1), String.format(ResManager.loadKDString((String)"\u591a\u7ea7\u4efb\u52a1\u521b\u5efa\u6a21\u5f0f\u4e3a\u5de5\u4f5c\u6d41\u521b\u5efa\u4efb\u52a1\u65f6\uff0c\u4efb\u52a1\u6765\u6e90\u53ea\u80fd\u662f\u5de5\u4f5c\u6d41\u6216\u5fae\u670d\u52a1", (String)"TaskRule4ImptEditHelper_34", (String)"ssc-task-business", (Object[])new Object[0]), taskOriginal));
            return;
        }
        if (!WFCreateTaskModel && !oneFromWorkFlow) {
            e.setCancel(true);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), ResManager.loadKDString((String)"\u591a\u7ea7\u4efb\u52a1\u521b\u5efa\u6a21\u5f0f\u4e3a\u5171\u4eab\u4e2d\u5fc3\u521b\u5efa\u4efb\u52a1\u65f6\uff0c\u81f3\u5c11\u586b\u5199\u4e00\u4e2a\u4efb\u52a1\u6765\u6e90\u4e3a\u5de5\u4f5c\u6d41\u7684\u5355\u636e\u4efb\u52a1", (String)"TaskRule4ImptEditHelper_11", (String)"ssc-task-business", (Object[])new Object[0]));
            return;
        }
        TaskRule4ImptEditHelper.checkPreTask(row, taskNumber2Entry, e);
    }

    public static void checkPreTask(JSONObject row, HashMap<String, JSONObject> taskNumber2Entry, BeforeImportDataEventArgs e) {
        JSONArray childBillEntity = row.getJSONArray("childbillentryentity");
        for (int i = 0; i < childBillEntity.size(); ++i) {
            JSONObject taskEntry = childBillEntity.getJSONObject(i);
            JSONObject taskType = taskEntry.getJSONObject("tasktype");
            if (!"2".equals(taskEntry.getString("taskoriginal"))) continue;
            row.put("isParTaskBill", (Object)true);
            JSONObject preTasks = taskEntry.getJSONObject("pretasks");
            if (preTasks == null || StringUtils.isEmpty((CharSequence)preTasks.getString("number"))) {
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(-1), ResManager.loadKDString((String)"\u5f53\u524d\u5206\u5f55\u7684\u4efb\u52a1\u6765\u6e90\u4e3a\u591a\u7ea7\u4efb\u52a1\uff0c\u8bf7\u586b\u5199\u524d\u7f6e\u4efb\u52a1", (String)"TaskRule4ImptEditHelper_12", (String)"ssc-task-business", (Object[])new Object[0]));
                return;
            }
            ArrayList<Long> collection = new ArrayList<Long>();
            StringBuilder idString = new StringBuilder();
            for (String number : preTasks.getString("number").split(",")) {
                String nextTasks;
                JSONObject preTaskEntry = taskNumber2Entry.get(number);
                if (preTaskEntry == null) {
                    e.setCancel(true);
                    e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(-1), String.format(ResManager.loadKDString((String)"%s\uff1a\u5f53\u524d\u5355\u636e\u7684\u5206\u5f55\u4e2d\u4e0d\u5b58\u5728\u6b64\u524d\u7f6e\u4efb\u52a1", (String)"TaskRule4ImptEditHelper_13", (String)"ssc-task-business", (Object[])new Object[0]), number));
                    return;
                }
                if (number.equals(taskType.getString("number"))) {
                    e.setCancel(true);
                    e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(-1), String.format(ResManager.loadKDString((String)"%s\uff1a\u524d\u7f6e\u4efb\u52a1\u4e0d\u5141\u8bb8\u586b\u5199\u5f53\u524d\u4efb\u52a1", (String)"TaskRule4ImptEditHelper_14", (String)"ssc-task-business", (Object[])new Object[0]), number));
                    return;
                }
                if ("2".equals(taskEntry.getString("taskoriginal")) && !StringUtils.isEmpty((CharSequence)preTaskEntry.getString("pretasks"))) {
                    for (String num : preTaskEntry.getString("pretasks").split(",")) {
                        if (!num.equals(taskType.getString("number"))) continue;
                        e.setCancel(true);
                        e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(-1), String.format(ResManager.loadKDString((String)"%s\uff1a\u524d\u7f6e\u4efb\u52a1\u5b58\u5728\u5faa\u73af\u4f9d\u8d56", (String)"TaskRule4ImptEditHelper_15", (String)"ssc-task-business", (Object[])new Object[0]), number));
                        return;
                    }
                }
                nextTasks = StringUtils.isEmpty((CharSequence)(nextTasks = preTaskEntry.getString("nexttasks"))) ? taskEntry.getJSONObject("tasktype").getString("taskName") : nextTasks + "," + taskEntry.getJSONObject("tasktype").getString("taskName");
                preTaskEntry.put("nexttasks", (Object)nextTasks);
                Long preTaskId = preTaskEntry.getJSONObject("tasktype").getLong("id");
                idString.append(preTaskId).append(",");
                collection.add(preTaskId);
            }
            preTasks.put("importprop", (Object)"id");
            preTasks.put("id", (Object)idString.deleteCharAt(idString.length() - 1).toString());
            taskEntry.put("preTaskCollection", collection);
        }
    }

    public static void checkDataInsight(BeforeImportDataEventArgs e, Map<String, DynamicObject> number2DataInsightMap) {
        JSONObject row = (JSONObject)e.getSourceData();
        JSONArray childBillEntity = row.getJSONArray("childbillentryentity");
        for (int i = 0; i < childBillEntity.size(); ++i) {
            JSONObject dataInsight = childBillEntity.getJSONObject(i).getJSONObject("datainsightschema");
            if (dataInsight == null || StringUtils.isEmpty((CharSequence)dataInsight.getString("number"))) continue;
            ArrayList<Long> collection = new ArrayList<Long>();
            for (String number : dataInsight.getString("number").split(",")) {
                DynamicObject dataInsightObj = number2DataInsightMap.get(number);
                if (dataInsightObj == null) {
                    e.setCancel(true);
                    e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(-1), String.format(ResManager.loadKDString((String)"%s\uff1a\u6570\u636e\u6d1e\u5bdf\u65b9\u6848\u4e0d\u5b58\u5728", (String)"TaskRule4ImptEditHelper_16", (String)"ssc-task-business", (Object[])new Object[0]), number));
                    continue;
                }
                if (!dataInsightObj.getBoolean("enable")) {
                    e.setCancel(true);
                    e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(-1), String.format(ResManager.loadKDString((String)"%s\uff1a\u6570\u636e\u6d1e\u5bdf\u65b9\u6848\u5df2\u7981\u7528", (String)"TaskRule4ImptEditHelper_17", (String)"ssc-task-business", (Object[])new Object[0]), number));
                    continue;
                }
                collection.add(dataInsightObj.getLong("id"));
            }
            childBillEntity.getJSONObject(i).put("insightSchemaCollection", collection);
        }
    }

    public static void checkFieldEntity(BeforeImportDataEventArgs e) {
        JSONObject row = (JSONObject)e.getSourceData();
        JSONArray fieldEntity = row.getJSONArray("entryentityfield");
        if (fieldEntity == null) {
            e.setCancel(true);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5b57\u6bb5\u6620\u5c04\u5206\u5f55", (String)"TaskRule4ImptEditHelper_23", (String)"ssc-task-business", (Object[])new Object[0]));
            return;
        }
        boolean org = false;
        boolean applier = false;
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < fieldEntity.size(); ++i) {
            String fieldConfiguration = fieldEntity.getJSONObject(i).getString("fieldconfiguration");
            if (TaskFieldConfigEnum.ORG.getFieldKey().equals(fieldConfiguration)) {
                org = true;
            } else if (TaskFieldConfigEnum.APPLIER.getFieldKey().equals(fieldConfiguration)) {
                applier = true;
            }
            if (set.contains(fieldConfiguration)) {
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), String.format(ResManager.loadKDString((String)"%s\uff1a\u5b57\u6bb5\u6620\u5c04\u5206\u5f55\u5b58\u5728\u91cd\u590d\u5b57\u6bb5", (String)"TaskRule4ImptEditHelper_24", (String)"ssc-task-business", (Object[])new Object[0]), fieldConfiguration));
                return;
            }
            set.add(fieldConfiguration);
        }
        if (!org) {
            e.setCancel(true);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), ResManager.loadKDString((String)"\u7f3a\u5c11\u5b57\u6bb5\u6620\u5c04\u5206\u5f55\uff0c\u5373\u4efb\u52a1\u6c60\u663e\u793a\u5b57\u6bb5\u4e3a[\u7ec4\u7ec7]\u7684\u5206\u5f55", (String)"TaskRule4ImptEditHelper_25", (String)"ssc-task-business", (Object[])new Object[0]));
            return;
        }
        if (!applier) {
            e.setCancel(true);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), ResManager.loadKDString((String)"\u7f3a\u5c11\u5b57\u6bb5\u6620\u5c04\u5206\u5f55\uff0c\u5373\u4efb\u52a1\u6c60\u663e\u793a\u5b57\u6bb5\u4e3a[\u7533\u8bf7\u4eba]\u7684\u5206\u5f55", (String)"TaskRule4ImptEditHelper_26", (String)"ssc-task-business", (Object[])new Object[0]));
            return;
        }
        if (row.getJSONObject("bindbill").getString("id") == null) {
            return;
        }
        String bindBill = row.getJSONObject("bindbill").getString("number");
        HashMap<String, Property> proName2Property = TaskRule4ImptEditHelper.createPropertyMap(bindBill);
        if (proName2Property == null) {
            e.setCancel(true);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), String.format(ResManager.loadKDString((String)"%s\uff1a\u89e3\u6790\u6765\u6e90\u5355\u636e\u5c5e\u6027\u65f6\u62a5\u9519\uff0c\u8bf7\u6821\u9a8c\u5355\u636e\u9875\u9762\u662f\u5426\u6b63\u5e38", (String)"TaskRule4ImptEditHelper_27", (String)"ssc-task-business", (Object[])new Object[0]), bindBill));
            return;
        }
        for (int i = 0; i < fieldEntity.size(); ++i) {
            JSONObject entry = fieldEntity.getJSONObject(i);
            String sourceFieldName = entry.getString("sourcefieldname");
            String sourceFieldNumber = entry.getString("sourcefieldnumber");
            Property property = StringUtils.isNotBlank((CharSequence)sourceFieldNumber) ? proName2Property.get(sourceFieldNumber) : proName2Property.get(sourceFieldName);
            if (property == null) {
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(-1), String.format(ResManager.loadKDString((String)"\u5355\u636e\u5b57\u6bb5\u540d\u79f0\u6216\u7f16\u7801[%s]\u4e0d\u5b58\u5728\u4e8e\u6e90\u5355\u636e\u4e2d", (String)"TaskRule4ImptEditHelper_28", (String)"ssc-task-business", (Object[])new Object[0]), StringUtils.isNotBlank((CharSequence)sourceFieldNumber) ? sourceFieldNumber : sourceFieldName));
                return;
            }
            if ("80".equals(entry.getString("fieldconfiguration")) && !property.isBaseData()) {
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(-1), String.format(ResManager.loadKDString((String)"\u5355\u636e\u5b57\u6bb5\u540d\u79f0[%s]\u4e0d\u7b26\u5408\u4efb\u52a1\u91cf\u7cfb\u6570\u7684\u8981\u6c42", (String)"TaskRule4ImptEditHelper_29", (String)"ssc-task-business", (Object[])new Object[0]), sourceFieldName));
                return;
            }
            entry.put("sourcefieldnumber", (Object)property.getNumber());
            entry.put("sourcefieldname", (Object)property.getName());
        }
    }

    public static void checkCheckPoint(long sscId, BeforeImportDataEventArgs e, IFormView view) {
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Map<String, DynamicObject> number2CheckPoint = (Map<String, DynamicObject>)formShowParameter.getCustomParam("checkPointMap");
        if (number2CheckPoint == null) {
            DynamicObject[] checkPoints = BusinessDataServiceHelper.load((String)"task_checkpoint", (String)"id,number,enable", (QFilter[])new QFilter("createorg", "=", (Object)sscId).toArray());
            number2CheckPoint = Arrays.stream(checkPoints).collect(Collectors.toMap(k -> k.getString("number"), v -> v));
            formShowParameter.setCustomParam("checkPointMap", number2CheckPoint);
        }
        JSONObject row = (JSONObject)e.getSourceData();
        JSONArray childBillEntity = row.getJSONArray("childbillentryentity");
        for (int i = 0; i < childBillEntity.size(); ++i) {
            JSONObject checkPoint = childBillEntity.getJSONObject(i).getJSONObject("articheckpointconfig");
            if (checkPoint == null || StringUtils.isEmpty((CharSequence)checkPoint.getString("number"))) continue;
            ArrayList<Long> collection = new ArrayList<Long>();
            StringBuilder idString = new StringBuilder();
            for (String number : checkPoint.getString("number").split(",")) {
                DynamicObject checkPointObj = number2CheckPoint.get(number);
                if (checkPointObj == null) {
                    e.setCancel(true);
                    e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(-1), String.format(ResManager.loadKDString((String)"%s\uff1a\u4eba\u5de5\u68c0\u67e5\u9879\u4e0d\u5b58\u5728", (String)"TaskRule4ImptEditHelper_18", (String)"ssc-task-business", (Object[])new Object[0]), number));
                    return;
                }
                if (!checkPointObj.getBoolean("enable")) {
                    e.setCancel(true);
                    e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(-1), String.format(ResManager.loadKDString((String)"%s\uff1a\u4eba\u5de5\u68c0\u67e5\u9879\u5df2\u7981\u7528", (String)"TaskRule4ImptEditHelper_19", (String)"ssc-task-business", (Object[])new Object[0]), number));
                    return;
                }
                idString.append(checkPointObj.getLong("id")).append(",");
                collection.add(checkPointObj.getLong("id"));
            }
            checkPoint.put("importprop", (Object)"id");
            checkPoint.put("id", (Object)idString.deleteCharAt(idString.length() - 1).toString());
            childBillEntity.getJSONObject(i).put("checkPointCollection", collection);
        }
    }

    public static void checkBizSystem(BeforeImportDataEventArgs e, IFormView view) {
        JSONObject extSystem;
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Map<String, DynamicObject> number2ExtSystem = (Map<String, DynamicObject>)formShowParameter.getCustomParam("extSystemMap");
        if (number2ExtSystem == null) {
            DynamicObjectCollection checkPoints = QueryServiceHelper.query((String)"bas_extenderp", (String)"id,number,enable", null);
            number2ExtSystem = checkPoints.stream().collect(Collectors.toMap(k -> k.getString("number"), v -> v));
            formShowParameter.setCustomParam("extSystemMap", number2ExtSystem);
        }
        if ((extSystem = ((JSONObject)e.getSourceData()).getJSONObject("externalerp")) == null || StringUtils.isEmpty((CharSequence)extSystem.getString("number"))) {
            e.setCancel(true);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6240\u5c5e\u7cfb\u7edf", (String)"TaskRule4ImptEditHelper_20", (String)"ssc-task-business", (Object[])new Object[0]));
            return;
        }
        DynamicObject extSystemObj = number2ExtSystem.get(extSystem.getString("number"));
        if (extSystemObj == null) {
            e.setCancel(true);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), String.format(ResManager.loadKDString((String)"%s\uff1a\u6240\u5c5e\u7cfb\u7edf\u4e0d\u5b58\u5728", (String)"TaskRule4ImptEditHelper_21", (String)"ssc-task-business", (Object[])new Object[0]), extSystem.getString("number")));
        } else if (!extSystemObj.getBoolean("enable")) {
            e.setCancel(true);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), String.format(ResManager.loadKDString((String)"%s\uff1a\u6240\u5c5e\u7cfb\u7edf\u5df2\u7981\u7528", (String)"TaskRule4ImptEditHelper_22", (String)"ssc-task-business", (Object[])new Object[0]), extSystem.getString("number")));
        } else {
            extSystem.put("id", (Object)extSystemObj.getLong("id"));
        }
    }

    public static HashMap<String, Property> createPropertyMap(String billNumber) {
        try {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)billNumber);
            HashMap<String, Property> proName2Property = new HashMap<String, Property>();
            for (Map.Entry type : entityType.getAllEntities().entrySet()) {
                for (IDataEntityProperty prop : ((EntityType)type.getValue()).getProperties()) {
                    if (prop instanceof DynamicLocaleProperty || prop instanceof PKFieldProp || prop instanceof EntryProp || prop instanceof FlexProp) continue;
                    if (prop instanceof BasedataProp) {
                        proName2Property.put(prop.getDisplayName().toString(), new Property(prop.getName(), prop.getDisplayName().toString(), true));
                        proName2Property.put(prop.getName(), new Property(prop.getName(), prop.getDisplayName().toString(), true));
                        TaskRule4ImptEditHelper.putSubPropertyIntoMap(proName2Property, prop);
                        continue;
                    }
                    proName2Property.put(prop.getDisplayName().toString(), new Property(prop.getName(), prop.getDisplayName().toString(), false));
                    proName2Property.put(prop.getName(), new Property(prop.getName(), prop.getDisplayName().toString(), false));
                }
            }
            return proName2Property;
        }
        catch (Exception e) {
            log.error("Error on parsing property of metadata " + billNumber, (Throwable)e);
            return null;
        }
    }

    public static void putSubPropertyIntoMap(HashMap<String, Property> proName2Property, IDataEntityProperty property) {
        try {
            String namePrefix = property.getDisplayName().toString() + '.';
            String numberPrefix = property.getName() + '.';
            String name = ((DynamicComplexProperty)property).getComplexType().getName();
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)name);
            for (Map.Entry type : entityType.getAllEntities().entrySet()) {
                for (IDataEntityProperty prop : ((EntityType)type.getValue()).getProperties()) {
                    if (prop instanceof DynamicLocaleProperty || prop instanceof PKFieldProp) continue;
                    proName2Property.put(namePrefix + prop.getDisplayName().toString(), new Property(numberPrefix + prop.getName(), prop.getDisplayName().toString(), false));
                    proName2Property.put(numberPrefix + prop.getName(), new Property(numberPrefix + prop.getName(), prop.getDisplayName().toString(), false));
                }
            }
        }
        catch (Exception e) {
            log.error("Error on parsing sub property of metadata", (Throwable)e);
        }
    }

    public static void checkTaskBillClassify(BeforeImportDataEventArgs e, Map<String, DynamicObject> taskBillClassifyMap) {
        JSONObject row = (JSONObject)e.getSourceData();
        String classifyNum = row.getJSONObject("group").getString("number");
        DynamicObject classifyDyo = taskBillClassifyMap.get(classifyNum);
        if (classifyDyo == null) {
            e.setCancel(true);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), String.format(ResManager.loadKDString((String)"\u5171\u4eab\u4e2d\u5fc3[%1$s]\u4e0b\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%2$s\u7684\u4e1a\u52a1\u5355\u636e\u5206\u7c7b", (String)"TaskRule4ImptEditHelper_35", (String)"ssc-task-business", (Object[])new Object[0]), row.getJSONObject("ssccenter").getString("number"), classifyNum));
        } else if (!classifyDyo.getBoolean("isleaf")) {
            e.setCancel(true);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), String.format(ResManager.loadKDString((String)"\u53ea\u80fd\u5728\u53f6\u5b50\u8282\u70b9\u5206\u7c7b\u4e0b\u65b0\u589e\u4e1a\u52a1\u5355\u636e", (String)"TaskRule4ImptEditHelper_41", (String)"ssc-task-business", (Object[])new Object[0]), new Object[0]));
        } else {
            row.getJSONObject("group").put("id", (Object)classifyDyo.getLong("id"));
        }
    }

    public static void checkTaskPool(BeforeImportDataEventArgs e, Map<String, DynamicObject> bindBillMap, Map<String, DynamicObject> taskPoolMap) {
        JSONObject row = (JSONObject)e.getSourceData();
        JSONObject taskPoolJson = row.getJSONObject("taskpool");
        if (taskPoolJson == null) {
            return;
        }
        String taskPoolNum = taskPoolJson.getString("number");
        DynamicObject taskPoolDyo = taskPoolMap.get(taskPoolNum);
        if (taskPoolDyo == null) {
            e.setCancel(true);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%s\u7684\u81ea\u5b9a\u4e49\u4efb\u52a1\u6c60", (String)"TaskRule4ImptEditHelper_36", (String)"ssc-task-business", (Object[])new Object[0]), taskPoolNum));
            return;
        }
        row.getJSONObject("taskpool").put("id", (Object)taskPoolDyo.getLong("id"));
        String bindBillNum = row.getJSONObject("bindbill").getString("number");
        DynamicObject bindBillDyo = bindBillMap.get(bindBillNum);
        if (bindBillDyo == null) {
            return;
        }
        if (!bindBillNum.equals(taskPoolDyo.getString("bill.number"))) {
            e.setCancel(true);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%1$s\u7684\u81ea\u5b9a\u4e49\u4efb\u52a1\u6c60\u4e0d\u5c5e\u4e8e\u5b9e\u4f53[%2$s]", (String)"TaskRule4ImptEditHelper_39", (String)"ssc-task-business", (Object[])new Object[0]), taskPoolNum, bindBillDyo.getString("name")));
            return;
        }
    }

    public static void checkApplyCond(BeforeImportDataEventArgs e, Map<String, DynamicObject> applyCondMap) {
        String createTaskModel;
        JSONObject row = (JSONObject)e.getSourceData();
        JSONObject applyCondJson = row.getJSONObject("applycond");
        if (applyCondJson == null) {
            return;
        }
        String applyCondNum = applyCondJson.getString("number");
        DynamicObject dyo = applyCondMap.get(applyCondNum);
        if (dyo == null) {
            e.setCancel(true);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%s\u7684\u9002\u7528\u6761\u4ef6", (String)"TaskRule4ImptEditHelper_37", (String)"ssc-task-business", (Object[])new Object[0]), applyCondNum));
            return;
        }
        if ("0".equals(dyo.getString("enable"))) {
            e.setCancel(true);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u9002\u7528\u6761\u4ef6\u5df2\u88ab\u7981\u7528", (String)"TaskRule4ImptEditHelper_38", (String)"ssc-task-business", (Object[])new Object[0]), applyCondNum));
        }
        if ("1".equals(createTaskModel = row.getString("createtaskmodel"))) {
            row.getJSONObject("applycond").put("id", (Object)dyo.getLong("id"));
        } else {
            e.setCancel(true);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), String.format(ResManager.loadKDString((String)"\u53ea\u6709\u591a\u7ea7\u4efb\u52a1\u521b\u5efa\u6a21\u5f0f\u4e3a\u5de5\u4f5c\u6d41\u521b\u5efa\u4efb\u52a1\u65f6\u624d\u5141\u8bb8\u5f15\u5165\u9002\u7528\u6761\u4ef6", (String)"TaskRule4ImptEditHelper_40", (String)"ssc-task-business", (Object[])new Object[0]), new Object[0]));
        }
    }

    public static void checkImage(BeforeImportDataEventArgs e) {
        JSONObject row = (JSONObject)e.getSourceData();
        boolean isUseImage = row.getBoolean("isuseimage");
        boolean isNeedImage = row.getBoolean("isneedimage");
        if (!isUseImage && isNeedImage) {
            e.setCancel(true);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), String.format(ResManager.loadKDString((String)"\u672a\u542f\u7528\u5f71\u50cf\u65f6\uff0c\u9700\u8981\u5f71\u50cf\u4e0a\u4f20\u53ea\u80fd\u586b\u5426", (String)"TaskRule4ImptEditHelper_42", (String)"ssc-task-business", (Object[])new Object[0]), new Object[0]));
        }
    }

    private static class Property {
        String number;
        String name;
        boolean isBaseData;

        public Property(String number, boolean isBaseData) {
            this.number = number;
            this.isBaseData = isBaseData;
        }

        public Property(String number, String name, boolean isBaseData) {
            this.number = number;
            this.name = name;
            this.isBaseData = isBaseData;
        }

        public String getNumber() {
            return this.number;
        }

        public String getName() {
            return this.name;
        }

        public boolean isBaseData() {
            return this.isBaseData;
        }
    }
}

