/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.workbill;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.isv.ISVService;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.service.VersionService;
import kd.bos.portal.service.bo.Version;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ssc.task.business.workbill.ExtAppUtil;

public class WorkBillCommonHelper {
    protected static final String SYSTEM_TYPE = "ssc-task-business";
    protected static final String CS_VERSION = "csVersion";
    protected static final String CSS_VERSION = "cssVersion";

    protected static String removeLastVersion(String version) {
        String[] split;
        if (StringUtils.isNotEmpty((CharSequence)version) && (split = version.split("\\.")).length == 4) {
            version = String.join((CharSequence)".", Arrays.copyOf(split, split.length - 1));
        }
        return version;
    }

    public static String getIsvPrefix() {
        String isvInfo = ISVService.getISVInfo().getId().toLowerCase();
        return isvInfo + "_";
    }

    protected static String getExtBizAppId() {
        QFilter numberFilter = new QFilter("number", "=", (Object)"ssc");
        DynamicObject metaInfo = BusinessDataServiceHelper.loadSingle((String)"bos_devportal_bizapp", (String)"fid,bizcloud,number", (QFilter[])new QFilter[]{numberFilter});
        String bizCloudId = metaInfo.getString("bizcloud");
        String bizAppId = metaInfo.getString("id");
        return ExtAppUtil.getExtApp(bizCloudId, bizAppId);
    }

    protected static Map<String, String> queryVersionInfo() {
        List versions = VersionService.getVersionInfos();
        HashMap<String, String> versionMap = new HashMap<String, String>();
        for (Version version : versions) {
            if ("cosmic_bos".equals(version.getProductNumber())) {
                versionMap.put(CS_VERSION, WorkBillCommonHelper.removeLastVersion(version.getVersion()));
                continue;
            }
            if (!version.getProductNumber().startsWith("constellation_")) continue;
            versionMap.put(CSS_VERSION, WorkBillCommonHelper.removeLastVersion(version.getVersion()));
        }
        return versionMap;
    }

    protected static String amendNumber(String original, String isvPrefix) {
        String result = original.replace(" ", "").toLowerCase(Locale.ENGLISH);
        if (!result.startsWith(isvPrefix)) {
            result = isvPrefix + result;
        }
        return result;
    }
}

