/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.workbill;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.task.business.workbill.ExtAppUtil;
import kd.ssc.task.business.workbill.WorkBillConfigDTO;
import kd.ssc.task.business.workbill.builder.BillFormModelBuilder;
import kd.ssc.task.business.workbill.builder.WorkBillConfigDTOBuilder;

public class WorkBillSavePlugin
extends AbstractOperationServicePlugIn {
    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        List successPkIds = this.getOperationResult().getSuccessPkIds();
        List validateResults = this.operationResult.getValidateResult().getValidateErrors();
        String bizAppId = this.getExtBizAppId();
        if (StringUtils.isEmpty((String)bizAppId)) {
            ValidationErrorInfo info = new ValidationErrorInfo("", null, 0, 0, "errorcode_001", "", ResManager.loadKDString((String)"\u521b\u5efa\u6269\u5c55\u5e94\u7528\u9519\u8bef", (String)"WorkBillSavePlugin_0", (String)"ssc-task-business", (Object[])new Object[0]), ErrorLevel.Error);
            ValidateResult validateResult = new ValidateResult();
            validateResult.addErrorInfo((OperateErrorInfo)info);
            validateResults.add(validateResult);
            return;
        }
        for (DynamicObject workBill : dataEntities) {
            if (!successPkIds.contains(workBill.getPkValue())) continue;
            WorkBillConfigDTO workBillConfigDTO = WorkBillConfigDTOBuilder.createWorkBillConfigDTO(bizAppId, workBill);
            BillFormModelBuilder billModelBuilder = new BillFormModelBuilder(workBillConfigDTO);
            billModelBuilder.createBillFormModel();
        }
    }

    private String getExtBizAppId() {
        QFilter numberFilter = new QFilter("number", "=", (Object)"ssc");
        DynamicObject metaInfo = BusinessDataServiceHelper.loadSingle((String)"bos_devportal_bizapp", (String)"fid,fbizcloudid,fnumber", (QFilter[])new QFilter[]{numberFilter});
        String bizCloudId = metaInfo.getString("bizCloudId");
        String bizAppId = metaInfo.getString("id");
        return ExtAppUtil.getExtApp(bizCloudId, bizAppId);
    }
}

