/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.workbill.excel;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.ssc.task.business.workbill.excel.WorkBillExcelInfo;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class WorkBillImportExcelUtil {
    private static final int DEFAULT_SHEET_NO = 0;
    private static final int START_ROW_INDEX = 6;
    private static final int FIELD_NUM_CELL_INDEX = 4;

    public static List<WorkBillExcelInfo> readExcelOfList(InputStream inputStream) throws IOException {
        ArrayList resultMapList = new ArrayList(8);
        XSSFWorkbook workbook = new XSSFWorkbook(inputStream);
        Sheet sheet = workbook.getSheetAt(0);
        int lastRowIndex = sheet.getLastRowNum();
        for (int i = 6; i <= lastRowIndex; ++i) {
            Row row = sheet.getRow(i);
            HashMap<String, Object> resultMap = new HashMap<String, Object>(8);
            for (int j = 0; j < row.getLastCellNum(); ++j) {
                Cell cell = sheet.getRow(4).getCell(j);
                if (ObjectUtils.isEmpty((Object)cell)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u52ff\u4fee\u6539\u8868\u5934\u7684\u5185\u5bb9\u548c\u884c\u4f4d\u7f6e\uff0c\u5426\u5219\u5c06\u9020\u6210\u6570\u636e\u89e3\u6790\u5f02\u5e38\u3002", (String)"WorkBillFieldInfoEnum_10", (String)"ssc-task-business", (Object[])new Object[0]));
                }
                resultMap.put(cell.getStringCellValue(), WorkBillImportExcelUtil.getStringValue(row.getCell(j)));
            }
            resultMap.put("rowNum", i + 1);
            resultMapList.add(resultMap);
        }
        return JSON.parseArray((String)JSON.toJSONString(resultMapList), WorkBillExcelInfo.class);
    }

    private static String getStringValue(Cell cell) {
        if (cell == null) {
            return "";
        }
        cell.setCellType(CellType.STRING);
        String value = cell.getStringCellValue();
        return value.trim();
    }
}

