/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.workbill.file;

import com.alibaba.fastjson.JSON;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.utils.DynamicObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.ssc.task.business.workbill.WorkBillCommonHelper;
import kd.ssc.task.business.workbill.pojo.WorkBillVersionInfo;
import kd.ssc.workbill.util.MetaDataFileUtil;

public class WorkBillImportHelper
extends WorkBillCommonHelper {
    private static final Log log = LogFactory.getLog(WorkBillImportHelper.class);

    public static List<String> importZipFile(String attachmentUrl, Long useOrgId) {
        HashMap<String, DynamicObject> entityMap = new HashMap<String, DynamicObject>(8);
        HashSet<String> metaDataNames = new HashSet<String>();
        WorkBillVersionInfo versionInfo = WorkBillImportHelper.getImportFileInfo(attachmentUrl, entityMap, metaDataNames);
        WorkBillImportHelper.checkFileValid(entityMap.keySet(), metaDataNames, versionInfo);
        HashMap<String, DynamicObject> existDynObjMap = new HashMap<String, DynamicObject>(8);
        Map<String, String> entityErrorMsgMap = WorkBillImportHelper.loopImportEntity(entityMap, existDynObjMap, useOrgId);
        Map<String, String> metaDataImportResultMap = WorkBillImportHelper.loopImportMetaData(attachmentUrl, entityErrorMsgMap);
        List<String> metaDataErrorMsgList = WorkBillImportHelper.checkResultMap(metaDataImportResultMap, existDynObjMap);
        metaDataErrorMsgList.addAll(entityErrorMsgMap.values());
        return metaDataErrorMsgList;
    }

    private static Map<String, String> loopImportEntity(Map<String, DynamicObject> entityMap, Map<String, DynamicObject> existDynObjMap, Long useOrgId) {
        HashMap<String, String> errMsgMap = new HashMap<String, String>();
        for (Map.Entry<String, DynamicObject> entry : entityMap.entrySet()) {
            String importWorkBillNum = entry.getKey();
            Long workBillId = WorkBillImportHelper.queryExistWorkBillId(importWorkBillNum);
            if (workBillId == 0L) {
                Map<String, String> insertErrorMsgMap = WorkBillImportHelper.insertWorkBillDynObj(entry, useOrgId);
                errMsgMap.putAll(insertErrorMsgMap);
                continue;
            }
            Map<String, String> updateErrorMsgMap = WorkBillImportHelper.updateWorkBillDynObj(entry, workBillId, existDynObjMap, useOrgId);
            errMsgMap.putAll(updateErrorMsgMap);
        }
        return errMsgMap;
    }

    private static Map<String, String> updateWorkBillDynObj(Map.Entry<String, DynamicObject> entry, Long workBillId, Map<String, DynamicObject> existDynObjMap, Long useOrgId) {
        HashMap<String, String> errMsgMap = new HashMap<String, String>();
        String importWorkBillNum = entry.getKey();
        DynamicObject importWorkBillDynObj = entry.getValue();
        DynamicObject localDynObj = BusinessDataServiceHelper.loadSingle((Object)workBillId, (String)"ssc_billmanger");
        CloneUtils cloneUtils = new CloneUtils(false, true);
        DynamicObject existDynObjBackup = (DynamicObject)cloneUtils.clone((IDataEntityBase)localDynObj);
        try {
            HashSet<String> ignores = new HashSet<String>(8);
            ignores.add("id");
            ignores.add("ctrlstrategy");
            DynamicObjectUtils.copy((DynamicObject)importWorkBillDynObj, (DynamicObject)localDynObj, ignores);
            WorkBillImportHelper.checkGroupIsExist(localDynObj, importWorkBillNum);
            WorkBillImportHelper.setCreatorAndModifier(localDynObj);
            WorkBillImportHelper.setUserOrg(localDynObj, useOrgId);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{localDynObj});
        }
        catch (Exception e) {
            errMsgMap.put(importWorkBillNum, e.getMessage());
            return errMsgMap;
        }
        existDynObjMap.put(importWorkBillNum, existDynObjBackup);
        return errMsgMap;
    }

    private static void rollBackWorkBillDynObj(DynamicObject dynObjBackUp, String workBillNum) {
        Long workBillId = WorkBillImportHelper.queryExistWorkBillId(workBillNum);
        DynamicObject existDynObj = BusinessDataServiceHelper.loadSingle((Object)workBillId, (String)"ssc_billmanger");
        HashSet<String> ignores = new HashSet<String>(8);
        ignores.add("id");
        ignores.add("ctrlstrategy");
        DynamicObjectUtils.copy((DynamicObject)dynObjBackUp, (DynamicObject)existDynObj, ignores);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{existDynObj});
    }

    private static Long queryExistWorkBillId(String workBillNum) {
        QFilter qFilter = new QFilter("number", "=", (Object)workBillNum);
        String selectFields = "id";
        DynamicObject existDynObj = QueryServiceHelper.queryOne((String)"ssc_billmanger", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        if (existDynObj == null) {
            return 0L;
        }
        return existDynObj.getLong(selectFields);
    }

    private static Map<String, String> insertWorkBillDynObj(Map.Entry<String, DynamicObject> entry, Long userOrgId) {
        HashMap<String, String> errMsgMap = new HashMap<String, String>();
        String importWorkBillNum = entry.getKey();
        try {
            DynamicObject importWorkBillDynObj = entry.getValue();
            DynamicObject newData = BusinessDataServiceHelper.newDynamicObject((String)"ssc_billmanger");
            DynamicObjectUtils.copy((DynamicObject)importWorkBillDynObj, (DynamicObject)newData);
            WorkBillImportHelper.checkGroupIsExist(newData, importWorkBillNum);
            WorkBillImportHelper.setCreatorAndModifier(newData);
            WorkBillImportHelper.setUserOrg(newData, userOrgId);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newData});
        }
        catch (Exception e) {
            errMsgMap.put(importWorkBillNum, e.getMessage());
        }
        return errMsgMap;
    }

    private static void setUserOrg(DynamicObject newData, Long useOrgId) {
        String userOrgNum = newData.getString("useorg.number");
        QFilter qFilter = new QFilter("number", "=", (Object)userOrgNum);
        String selectFields = "id";
        DynamicObject localUserOrg = QueryServiceHelper.queryOne((String)"bos_org", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        if (localUserOrg == null) {
            DynamicObject filterUserOrgDyn = BusinessDataServiceHelper.loadSingle((Object)useOrgId, (String)"bos_org");
            newData.set("useorg", (Object)filterUserOrgDyn);
            newData.set("org", (Object)filterUserOrgDyn);
            newData.set("createorg", (Object)filterUserOrgDyn);
            return;
        }
        DynamicObject localUserOrgDyn = BusinessDataServiceHelper.loadSingle((Object)localUserOrg.getLong(selectFields), (String)"bos_org");
        newData.set("useorg", (Object)localUserOrgDyn);
        newData.set("org", (Object)localUserOrgDyn);
        newData.set("createorg", (Object)localUserOrgDyn);
    }

    private static void setCreatorAndModifier(DynamicObject newData) {
        long currUserId = RequestContext.get().getCurrUserId();
        DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)currUserId, (String)"bos_user");
        newData.set("creator", (Object)user);
        newData.set("modifier", (Object)user);
    }

    private static List<String> checkResultMap(Map<String, String> metaDataImportResultMap, Map<String, DynamicObject> existDynObjMap) {
        ArrayList<String> errorList = new ArrayList<String>();
        for (Map.Entry<String, String> entry : metaDataImportResultMap.entrySet()) {
            String workBillNum = entry.getKey();
            String importResult = entry.getValue();
            Map resultMap = (Map)JSON.parseObject((String)importResult, Map.class);
            if (resultMap.get("ERROR") != null || resultMap.get("RUNTIMEERROR") != null) {
                DynamicObject dynObjBackUp = existDynObjMap.get(workBillNum);
                WorkBillImportHelper.rollBackWorkBillDynObj(dynObjBackUp, workBillNum);
                String errorMsg = resultMap.get("ERROR") != null ? resultMap.get("ERROR").toString() : resultMap.get("RUNTIMEERROR").toString();
                errorList.add(errorMsg);
                continue;
            }
            MetaDataFileUtil.updateTable((String)workBillNum);
        }
        return errorList;
    }

    private static Map<String, String> loopImportMetaData(String attachmentUrl, Map<String, String> entityImportErrorMap) {
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        String extBizAppId = WorkBillImportHelper.getExtBizAppId();
        Set<String> errNums = entityImportErrorMap.keySet();
        HashMap<String, String> importReultMap = new HashMap<String, String>();
        try (ZipInputStream zipFile = new ZipInputStream(tempFileCache.getInputStream(attachmentUrl), StandardCharsets.UTF_8);){
            ZipEntry nextEntry;
            while ((nextEntry = zipFile.getNextEntry()) != null) {
                String workBillNum;
                String fileName = nextEntry.getName();
                if (!fileName.endsWith(".zip") || errNums.contains(workBillNum = fileName.substring(0, fileName.lastIndexOf(".")))) continue;
                String importResult = WorkBillImportHelper.importSingleMetaData(zipFile, fileName, extBizAppId);
                importReultMap.put(workBillNum, importResult);
            }
        }
        catch (Exception e) {
            log.error("import metadata error:", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u5143\u6570\u636e\u5bfc\u5165\u53d1\u751f\u5f02\u5e38\u3002", (String)"WorkBillImportHelper_0", (String)"ssc-task-common", (Object[])new Object[0]));
        }
        return importReultMap;
    }

    private static WorkBillVersionInfo getImportFileInfo(String attachmentUrl, Map<String, DynamicObject> entityMap, Set<String> metaDataNames) {
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        WorkBillVersionInfo versionInfo = null;
        try (ZipInputStream zipFile = new ZipInputStream(tempFileCache.getInputStream(attachmentUrl), StandardCharsets.UTF_8);){
            ZipEntry nextEntry;
            while ((nextEntry = zipFile.getNextEntry()) != null) {
                String fileName = nextEntry.getName();
                if (fileName.endsWith(".xml")) {
                    versionInfo = WorkBillImportHelper.getVersionInfoByImportFile(zipFile, fileName);
                    continue;
                }
                if (fileName.endsWith(".zip")) {
                    metaDataNames.add(fileName.substring(0, fileName.lastIndexOf(".")));
                    continue;
                }
                if (fileName.endsWith(".dts")) {
                    DynamicObject workBill = WorkBillImportHelper.getEntityInfoByImportFile(zipFile, fileName);
                    entityMap.put(workBill.getString("number"), workBill);
                    continue;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u5bfc\u5165\u5f02\u5e38\uff0c\u8bf7\u4f7f\u7528\u6807\u51c6\u5bfc\u51fa\u6a21\u677f\u5bfc\u5165\u3002", (String)"WorkBillImportHelper_1", (String)"ssc-task-common", (Object[])new Object[0]));
            }
        }
        catch (KDBizException ex) {
            log.error("import workbill file error:", (Throwable)ex);
            throw ex;
        }
        catch (Exception e) {
            log.error("import workbill file error:", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff0c\u6570\u636e\u89e3\u6790\u5f02\u5e38\u3002", (String)"WorkBillImportHelper_2", (String)"ssc-task-common", (Object[])new Object[0]));
        }
        return versionInfo;
    }

    private static void checkFileValid(Set<String> entityNames, Set<String> metaDataNames, WorkBillVersionInfo versionInfo) {
        if (versionInfo == null) {
            log.error("version.xml missing");
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u5185\u5bb9\u7f3a\u5931\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u5185\u5bb9\u540e\u518d\u91cd\u65b0\u5bfc\u5165\u3002", (String)"WorkBillImportHelper_3", (String)"ssc-task-business", (Object[])new Object[0]));
        }
        WorkBillImportHelper.checkVersionInfo(versionInfo);
        if (CollectionUtils.isEmpty(entityNames)) {
            log.error("entity missing");
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u5185\u5bb9\u7f3a\u5931\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u5185\u5bb9\u540e\u518d\u91cd\u65b0\u5bfc\u5165\u3002", (String)"WorkBillImportHelper_3", (String)"ssc-task-business", (Object[])new Object[0]));
        }
        if (CollectionUtils.isEmpty(metaDataNames)) {
            log.error("metadata missing");
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u5185\u5bb9\u7f3a\u5931\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u5185\u5bb9\u540e\u518d\u91cd\u65b0\u5bfc\u5165\u3002", (String)"WorkBillImportHelper_3", (String)"ssc-task-business", (Object[])new Object[0]));
        }
        if (entityNames.size() != metaDataNames.size()) {
            log.error("entity or metadata missing");
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u5185\u5bb9\u7f3a\u5931\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u5185\u5bb9\u540e\u518d\u91cd\u65b0\u5bfc\u5165\u3002", (String)"WorkBillImportHelper_3", (String)"ssc-task-business", (Object[])new Object[0]));
        }
        HashSet<String> mixedSet = new HashSet<String>(entityNames);
        mixedSet.removeAll(metaDataNames);
        if (!CollectionUtils.isEmpty(mixedSet)) {
            log.error("entity and metadata does not match");
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u5185\u5bb9\u7f3a\u5931\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u5185\u5bb9\u540e\u518d\u91cd\u65b0\u5bfc\u5165\u3002", (String)"WorkBillImportHelper_3", (String)"ssc-task-business", (Object[])new Object[0]));
        }
    }

    private static void checkVersionInfo(WorkBillVersionInfo versionInfo) {
        Map<String, String> versionMap = WorkBillImportHelper.queryVersionInfo();
        if (!StringUtils.equals((CharSequence)WorkBillImportHelper.getIsvPrefix(), (CharSequence)versionInfo.getPrefix())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u6587\u4ef6\u6240\u4f7f\u7528\u7684\u5f00\u53d1\u5546\u524d\u7f00\u4e0e\u5f53\u524d\u73af\u5883\u4e0d\u4e00\u81f4\u3002", (String)"WorkBillImportHelper_4", (String)"ssc-task-business", (Object[])new Object[0]));
        }
        if (!StringUtils.equals((CharSequence)versionMap.get("csVersion"), (CharSequence)versionInfo.getCsVersion())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u6587\u4ef6\u6240\u4f7f\u7528\u7684\u91d1\u8776\u4e91\u00b7\u82cd\u7a79\u7248\u672c\u4e0e\u5f53\u524d\u73af\u5883\u4e0d\u4e00\u81f4\u3002", (String)"WorkBillImportHelper_5", (String)"ssc-task-business", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)versionMap.get("cssVersion"))) {
            return;
        }
        if (!StringUtils.equals((CharSequence)versionMap.get("cssVersion"), (CharSequence)versionInfo.getCcsVersion())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u6587\u4ef6\u6240\u4f7f\u7528\u7684\u661f\u7ff0\u7248\u672c\u4e0e\u5f53\u524d\u73af\u5883\u4e0d\u4e00\u81f4\u3002", (String)"WorkBillImportHelper_6", (String)"ssc-task-business", (Object[])new Object[0]));
        }
    }

    /*
     * Exception decompiling
     */
    private static WorkBillVersionInfo getVersionInfoByImportFile(ZipInputStream zipFile, String fileName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static DynamicObject getEntityInfoByImportFile(ZipInputStream zipFile, String fileName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static String importSingleMetaData(ZipInputStream zipFile, String fileName, String extBizAppId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void checkGroupIsExist(DynamicObject importWorkBillDynObj, String importWorkBillNum) {
        String groupNum = importWorkBillDynObj.getString("group.number");
        QFilter qFilter = new QFilter("number", "=", (Object)groupNum);
        DynamicObject group = QueryServiceHelper.queryOne((String)"ssc_billmangerclassify", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (group == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\uff1a%2$s\u5206\u7ec4\u4e0d\u5b58\u5728\u3002", (String)"WorkBillImportHelper_9", (String)"ssc-task-common", (Object[])new Object[0]), importWorkBillNum, groupNum));
        }
        DynamicObject groupObj = BusinessDataServiceHelper.loadSingle((Object)group.getLong("id"), (String)"ssc_billmangerclassify");
        importWorkBillDynObj.set("group", (Object)groupObj);
    }
}

