/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.business.workbill.isc;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class WorkBillIscDefineHelper {
    private static final String TARGET_SCHEMA = "target_schema";
    private static final String ISC_DATA_COPY = "isc_data_copy";
    private static final String ISC_METADATA_SCHEMA = "isc_metadata_schema";

    public static List<Long> queryIscDataCopy(Long iscObjId) {
        QFilter filter = new QFilter(TARGET_SCHEMA, "=", (Object)iscObjId);
        DynamicObjectCollection col = QueryServiceHelper.query((String)ISC_DATA_COPY, (String)"id", (QFilter[])filter.toArray());
        return col.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
    }

    public static Long newIscDataCopy(Long targetId, Long sourceId) {
        DynamicObject targetObj = BusinessDataServiceHelper.loadSingle((Object)targetId, (String)ISC_METADATA_SCHEMA);
        DynamicObject sourceObj = BusinessDataServiceHelper.loadSingle((Object)sourceId, (String)ISC_METADATA_SCHEMA);
        DynamicObject newIscDataCopy = BusinessDataServiceHelper.newDynamicObject((String)ISC_DATA_COPY);
        newIscDataCopy.set("source_schema", (Object)sourceObj);
        newIscDataCopy.set(TARGET_SCHEMA, (Object)targetObj);
        newIscDataCopy.set("data_source", (Object)sourceObj.getDynamicObject("group"));
        newIscDataCopy.set("data_target", (Object)targetObj.getDynamicObject("group"));
        String name = WorkBillIscDefineHelper.splitJointName(sourceObj.getString("name"), targetObj.getString("name"));
        newIscDataCopy.set("name", (Object)name);
        String number = WorkBillIscDefineHelper.splitJointNumber(sourceObj.getString("number"), targetObj.getString("number"));
        newIscDataCopy.set("number", (Object)number);
        newIscDataCopy.set("mode", (Object)"BreakOnError");
        long currUserId = RequestContext.get().getCurrUserId();
        DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)currUserId, (String)"bos_user");
        newIscDataCopy.set("creator", (Object)user);
        newIscDataCopy.set("status", (Object)Character.valueOf('C'));
        newIscDataCopy.set("enable", (Object)Character.valueOf('1'));
        newIscDataCopy.set("protect_level", (Object)"DEFAULT");
        Object[] objects = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newIscDataCopy});
        return ((DynamicObject)objects[0]).getLong("id");
    }

    private static String splitJointName(String sourceObjName, String targetObjName) {
        String newName = StringUtils.join((Object[])new String[]{sourceObjName, "-", targetObjName});
        return newName.length() > 50 ? newName.substring(0, 50) : newName;
    }

    private static String splitJointNumber(String sourceObjNum, String targetObjNum) {
        String number = StringUtils.join((Object[])new String[]{sourceObjNum, "-", targetObjNum});
        number = number.length() > 57 ? number.substring(0, 57) : number;
        QFilter filter = new QFilter("number", "=", (Object)number);
        boolean exists = QueryServiceHelper.exists((String)ISC_DATA_COPY, (QFilter[])filter.toArray());
        int i = 1;
        String num = number;
        while (exists) {
            num = StringUtils.join((Object[])new Serializable[]{number, Integer.valueOf(i++)});
            QFilter numFilter = new QFilter("number", "=", (Object)num);
            exists = QueryServiceHelper.exists((String)ISC_DATA_COPY, (QFilter[])numFilter.toArray());
        }
        return num;
    }

    public static boolean existIscDataCopy(Long targetId, Long sourceId) {
        if (0L == sourceId) {
            return Boolean.FALSE;
        }
        QFilter targetFilter = new QFilter(TARGET_SCHEMA, "=", (Object)targetId);
        QFilter sourceFilter = new QFilter("source_schema", "=", (Object)sourceId);
        return QueryServiceHelper.exists((String)ISC_DATA_COPY, (QFilter[])targetFilter.and(sourceFilter).toArray());
    }
}

