/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.common;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.ssc.task.common.DateRangeEnum;
import kd.ssc.task.formplugin.pojo.DateRange;
import kd.ssc.task.util.DateUtil;

public class DateRangeUtil {
    private static final Log log = LogFactory.getLog(DateRangeUtil.class);
    private static Date today;
    private static Date firstDayOfWeek;
    private static Date lastDayOfWeek;
    private static Date firstDayOfMonth;
    private static Date lastDayOfMonth;
    private static Date firstDayOfLastMonth;
    private static Date lastDayOfLastMonth;
    private static Date firstDayOfLast3Month;
    private static Date lastDayOfLast3Month;

    public static DateRangeEnum getDateRangeEnum(Date beginDate, Date endDate) {
        if (beginDate != null && endDate != null) {
            DateRangeUtil.initialization();
            if (DateRangeUtil.isSameDay(beginDate, today) && DateRangeUtil.isSameDay(DateUtil.addDay((Date)beginDate, (long)1L), endDate)) {
                return DateRangeEnum.TODAY;
            }
            if (DateRangeUtil.isSameDay(beginDate, firstDayOfWeek) && DateRangeUtil.isSameDay(endDate, lastDayOfWeek)) {
                return DateRangeEnum.THIS_WEEK;
            }
            if (DateRangeUtil.isSameDay(beginDate, firstDayOfLastMonth) && DateRangeUtil.isSameDay(endDate, lastDayOfLastMonth)) {
                return DateRangeEnum.LAST_MONTH;
            }
            if (DateRangeUtil.isSameDay(beginDate, firstDayOfMonth) && DateRangeUtil.isSameDay(endDate, lastDayOfMonth)) {
                return DateRangeEnum.THIS_MONTH;
            }
            if (DateRangeUtil.isSameDay(beginDate, firstDayOfLast3Month) && DateRangeUtil.isSameDay(endDate, lastDayOfLast3Month)) {
                return DateRangeEnum.LAST_THREE_MONTH;
            }
            return null;
        }
        return null;
    }

    private static boolean isSameDay(Date oneDay, Date otherDay) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        return df.format(oneDay).equals(df.format(otherDay));
    }

    public static DateRange getDateRange(DateRangeEnum dateRangeType) {
        DateRange dateRange = new DateRange();
        DateRangeUtil.initialization();
        int type = dateRangeType.getValue();
        Date tomorrow = DateUtil.addDay((Date)today, (long)1L);
        if (type == DateRangeEnum.TODAY.getValue()) {
            dateRange.setStartDate(today);
            dateRange.setEndDate(tomorrow);
        } else if (type == DateRangeEnum.THIS_WEEK.getValue()) {
            dateRange.setStartDate(firstDayOfWeek);
            dateRange.setEndDate(tomorrow);
        } else if (type == DateRangeEnum.LAST_MONTH.getValue()) {
            dateRange.setStartDate(firstDayOfLastMonth);
            dateRange.setEndDate(firstDayOfMonth);
        } else if (type == DateRangeEnum.THIS_MONTH.getValue()) {
            dateRange.setStartDate(firstDayOfMonth);
            dateRange.setEndDate(tomorrow);
        } else if (type == DateRangeEnum.LAST_THREE_MONTH.getValue()) {
            dateRange.setStartDate(firstDayOfLast3Month);
            dateRange.setEndDate(tomorrow);
        }
        return dateRange;
    }

    private static void initialization() {
        try {
            today = DateUtil.getCurDateForm((Date)new Date(), (boolean)true);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(today);
            calendar.set(7, 1);
            firstDayOfWeek = calendar.getTime();
            calendar.set(7, 7);
            calendar.add(5, 1);
            lastDayOfWeek = calendar.getTime();
            calendar.setTime(today);
            calendar.set(5, calendar.getActualMinimum(5));
            lastDayOfLastMonth = firstDayOfMonth = calendar.getTime();
            calendar.add(2, 1);
            calendar.set(5, calendar.getActualMinimum(5));
            lastDayOfMonth = calendar.getTime();
            calendar.setTime(today);
            calendar.add(2, -1);
            calendar.set(5, calendar.getActualMinimum(5));
            firstDayOfLastMonth = calendar.getTime();
            calendar.setTime(today);
            calendar.add(2, -3);
            firstDayOfLast3Month = calendar.getTime();
            lastDayOfLast3Month = DateUtil.addDay((Date)today, (long)1L);
        }
        catch (ParseException e) {
            log.error("DateRangeUtil.initialization \u65e5\u671f\u521d\u59cb\u5316\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
    }
}

