/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class DisRuleDataSyncHelper {
    private static final int BATCH_COUNT = 100000;

    public void keepDataSync(DynamicObject disRuleObj) {
        if (disRuleObj == null) {
            return;
        }
        Long disruleID = (Long)disRuleObj.getPkValue();
        QFilter delFilter = new QFilter("task_disrule", "=", (Object)disruleID);
        DeleteServiceHelper.delete((String)"task_disrule_query", (QFilter[])new QFilter[]{delFilter});
        Long sscid = disRuleObj.getLong("ssccenter.id");
        int priority = disRuleObj.getInt("priority");
        Long tasktype = disRuleObj.getLong("tasktype.id");
        DynamicObjectCollection billOranges = disRuleObj.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection usergroup_orgs = disRuleObj.getDynamicObjectCollection("entryentity1");
        HashMap<Long, Set<Long>> groupUserMap = new HashMap<Long, Set<Long>>();
        if (!CollectionUtils.isEmpty((Collection)usergroup_orgs)) {
            for (DynamicObject ugroup_org : usergroup_orgs) {
                Long ugID = ugroup_org.getLong("usergroup.id");
                groupUserMap.put(ugID, this.getUserByUserGroupID(ugID));
            }
        }
        ArrayList<DynamicObject> dynaObjList = new ArrayList<DynamicObject>();
        for (DynamicObject billOrange : billOranges) {
            Long taskbillID = billOrange.getLong("billtype.id");
            String filterrule = billOrange.getString("filterrule");
            String rule_json_b = billOrange.getString("filterrulejson_tag");
            String rule_json_c = billOrange.getString("applycreditleveljoson_tag");
            for (DynamicObject ugroup_org : usergroup_orgs) {
                Long ugID = ugroup_org.getLong("usergroup.id");
                Set users = (Set)groupUserMap.get(ugID);
                DynamicObjectCollection orgranges = ugroup_org.getDynamicObjectCollection("orgrange");
                for (Long userid : users) {
                    for (DynamicObject orgrange : orgranges) {
                        DynamicObject org = orgrange.getDynamicObject("fbasedataid");
                        if (org == null) continue;
                        Long orgid = (Long)org.getPkValue();
                        DynamicObject dynaObj = BusinessDataServiceHelper.newDynamicObject((String)"task_disrule_query");
                        dynaObj.set("ssccenter", (Object)sscid);
                        dynaObj.set("task_disrule", (Object)disruleID);
                        dynaObj.set("priority", (Object)priority);
                        dynaObj.set("taskbill", (Object)taskbillID);
                        dynaObj.set("tasktype", (Object)tasktype);
                        dynaObj.set("filterrule", (Object)filterrule);
                        dynaObj.set("rule_json_b", (Object)rule_json_b);
                        dynaObj.set("rule_json_c", (Object)rule_json_c);
                        dynaObj.set("usergroup", (Object)ugID);
                        dynaObj.set("orgfield", (Object)orgid);
                        dynaObj.set("userfield", (Object)userid);
                        dynaObj.set("createtime", (Object)new Date());
                        dynaObjList.add(dynaObj);
                    }
                }
            }
        }
        this.batchSaveDoList(dynaObjList);
    }

    private void batchSaveDoList(List<DynamicObject> dynaObjList) {
        int totalCount = dynaObjList.size();
        if (totalCount <= 100000) {
            SaveServiceHelper.save((DynamicObject[])dynaObjList.toArray(new DynamicObject[0]));
        } else {
            int times = totalCount / 100000 + 1;
            for (int seq = 0; seq < times; ++seq) {
                List<DynamicObject> currDoList = this.getCurrTaskDisRuleQueryDoList(dynaObjList, totalCount, 100000, seq);
                if (CollectionUtils.isEmpty(currDoList)) continue;
                SaveServiceHelper.save((DynamicObject[])currDoList.toArray(new DynamicObject[0]));
            }
        }
    }

    private List<DynamicObject> getCurrTaskDisRuleQueryDoList(List<DynamicObject> dynaObjList, int totalCount, int batchCount, int seq) {
        ArrayList<DynamicObject> currDoList = new ArrayList<DynamicObject>();
        int begin = seq * batchCount;
        int end = begin + batchCount;
        for (int i = begin; i < end && i < totalCount; ++i) {
            currDoList.add(dynaObjList.get(i));
        }
        return currDoList;
    }

    private void keepDataSync(DynamicObject[] disRuleObjs) {
        for (DynamicObject disRuleObj : disRuleObjs) {
            this.keepDataSync(disRuleObj);
        }
    }

    public void keepDataSync(QFilter disRuleFilter) {
        String entityName = "task_disrule";
        String selectProperties = "id,number,name,ssccenter,priority,tasktype,entryentity.billtype,entryentity.filterrule,entryentity.filterrulejson_tag,entryentity.applycreditleveljoson_tag,entryentity1.usergroup,entryentity1.orgrange";
        DynamicObject[] disRuleObjs = disRuleFilter == null ? BusinessDataServiceHelper.load((String)entityName, (String)selectProperties, null) : BusinessDataServiceHelper.load((String)entityName, (String)selectProperties, (QFilter[])new QFilter[]{disRuleFilter});
        if (disRuleObjs != null) {
            this.keepDataSync(disRuleObjs);
        }
    }

    private Set<Long> getUserByUserGroupID(Long ugID) {
        HashSet<Long> userSet = new HashSet<Long>();
        String entityName = "task_usergroup";
        String selectFields = "id,entryentity.userfield as userid";
        QFilter idFilter = new QFilter("id", "=", (Object)ugID);
        DynamicObjectCollection dynObjCol = QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])new QFilter[]{idFilter});
        for (DynamicObject obj : dynObjCol) {
            Long userid = obj.getLong("userid");
            userSet.add(userid);
        }
        return userSet;
    }

    public void keepDataSyncByGroup(DynamicObject disRuleObj, Long userGroupId) {
        if (disRuleObj == null) {
            return;
        }
        Long disRuleId = (Long)disRuleObj.getPkValue();
        QFilter delFilter = new QFilter("task_disrule", "=", (Object)disRuleId);
        QFilter userGroupFilter = new QFilter("usergroup", "=", (Object)userGroupId);
        DeleteServiceHelper.delete((String)"task_disrule_query", (QFilter[])new QFilter[]{delFilter, userGroupFilter});
        Long sscid = disRuleObj.getLong("ssccenter.id");
        int priority = disRuleObj.getInt("priority");
        Long tasktype = disRuleObj.getLong("tasktype.id");
        DynamicObjectCollection billOrangeDos = disRuleObj.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection usergroupOrgDos = disRuleObj.getDynamicObjectCollection("entryentity1");
        Set<Long> userSet = this.getUserByUserGroupID(userGroupId);
        ArrayList<DynamicObject> dynaObjList = new ArrayList<DynamicObject>();
        for (DynamicObject billOrange : billOrangeDos) {
            Long taskBilliD = billOrange.getLong("billtype.id");
            String filterrule = billOrange.getString("filterrule");
            String ruleJsonB = billOrange.getString("filterrulejson_tag");
            String ruleJsonC = billOrange.getString("applycreditleveljoson_tag");
            for (DynamicObject ugroupOrg : usergroupOrgDos) {
                Long ugId = ugroupOrg.getLong("usergroup.id");
                if (!userGroupId.equals(ugId)) continue;
                DynamicObjectCollection orgranges = ugroupOrg.getDynamicObjectCollection("orgrange");
                for (Long userid : userSet) {
                    for (DynamicObject orgrange : orgranges) {
                        DynamicObject org = orgrange.getDynamicObject("fbasedataid");
                        if (org == null) continue;
                        Long orgid = (Long)org.getPkValue();
                        DynamicObject dynaObj = BusinessDataServiceHelper.newDynamicObject((String)"task_disrule_query");
                        dynaObj.set("ssccenter", (Object)sscid);
                        dynaObj.set("task_disrule", (Object)disRuleId);
                        dynaObj.set("priority", (Object)priority);
                        dynaObj.set("taskbill", (Object)taskBilliD);
                        dynaObj.set("tasktype", (Object)tasktype);
                        dynaObj.set("filterrule", (Object)filterrule);
                        dynaObj.set("rule_json_b", (Object)ruleJsonB);
                        dynaObj.set("rule_json_c", (Object)ruleJsonC);
                        dynaObj.set("usergroup", (Object)ugId);
                        dynaObj.set("orgfield", (Object)orgid);
                        dynaObj.set("userfield", (Object)userid);
                        dynaObj.set("createtime", (Object)new Date());
                        dynaObjList.add(dynaObj);
                    }
                }
            }
        }
        this.batchSaveDoList(dynaObjList);
    }
}

