/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.common;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.task.business.quality.credit.CreditFilterCondition;
import kd.ssc.task.business.quality.credit.QualityCheckCreditHelper;
import kd.ssc.task.common.QualityCheckSchemeUtil;
import kd.ssc.task.common.quality.QualityFilterPojo;
import kd.ssc.task.util.RandomUtil;
import kd.ssc.task.util.TaskDateUtil;

public class MultQualityCheckSchemeUtil {
    private static Log log = LogFactory.getLog(MultQualityCheckSchemeUtil.class);
    private static final int RUNPAGESIZE = 5000;
    private static final String selectEntityFields = "id,billid,billnumber,sysbillid,bizdata_tag,subject,billtype,orgid,sscid,tasktypeid,innermsg,apprevalmessage,tasklevelid,imageok,flagmsg,imageuploadtime,coefficient,multistate,resttime,level,extenderp,source,auditor,assignid,procinstid,oldtaskstate,recyclestate,unpassreasonid,info,consignerid,flowbackstgid,waittime,pausewaittime,rescanwaittime,costwaittime,allocatecount,islastaudit,hasallocated,createruleid,imagenumber,reverseoprt,oprt,orglongnumber,unpassreasondesc,iscalculated,qualityresult,creator,personid,autoprocess,sourcetaskid,billlongid";
    private static final int TASK_ID_PAGE = 25000;
    private static final String TASK_DATA_SET_FIELD = "id,billid,billtype,bizdata_tag,completetime";
    private static final String NUMBER_NEXT_BASEXTENDERP = "KDCC";

    public static int excuteQualityCheckTask(DynamicObject checkScheme, DynamicObject[] entities) {
        int executeSum = 0;
        String taskConditionJson = checkScheme.getString("taskbillcondiontionjson");
        FilterObject taskfilterObject = null;
        if (!StringUtils.isBlank((CharSequence)taskConditionJson)) {
            FilterCondition taskfilterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)taskConditionJson, FilterCondition.class);
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"task_task");
            FilterBuilder filterBuilder = new FilterBuilder(entityType, taskfilterCondition);
            filterBuilder.buildFilter(false);
            taskfilterObject = filterBuilder.getFilterObject();
        }
        ArrayList<Object> billTypeIdList = new ArrayList<Object>(16);
        DynamicObjectCollection taskbillentry = checkScheme.getDynamicObjectCollection("taskbillentry");
        HashMap<Object, DynamicObject> billFilterMap = new HashMap<Object, DynamicObject>(16);
        for (DynamicObject taskbillItem : taskbillentry) {
            DynamicObject mulTaskBill = (DynamicObject)taskbillItem.get("multaskbill");
            if (mulTaskBill == null) {
                log.info("\u8d28\u68c0\u65b9\u6848\u591a\u9009\u5355\u636e\uff1a\u4e1a\u52a1\u5355\u636e\u4e0d\u5b58\u5728");
                continue;
            }
            billTypeIdList.add(mulTaskBill.getPkValue());
            billFilterMap.put(mulTaskBill.getPkValue(), taskbillItem);
        }
        Long checkSchemeId = (Long)checkScheme.getPkValue();
        DynamicObject dySSCCenter = checkScheme.getDynamicObject("ssccenter");
        ArrayList<Long> sscIdList = new ArrayList<Long>();
        sscIdList.add(dySSCCenter.getLong("id"));
        DynamicObject taskType = checkScheme.get("tasktype") == null ? null : (DynamicObject)checkScheme.get("tasktype");
        Object taskTypeId = taskType == null ? null : taskType.getPkValue();
        String timeRangeType = checkScheme.getString("timeframe");
        Date startdate = checkScheme.getDate("startdate");
        Date enddate = checkScheme.getDate("enddate");
        Map times = TaskDateUtil.getQueryTimeParams((String)timeRangeType, (Date)startdate, (Date)enddate);
        DynamicObjectCollection orgDyc = checkScheme.get("selectedorg") == null ? null : (DynamicObjectCollection)checkScheme.get("selectedorg");
        ArrayList<Object> orgList = new ArrayList<Object>();
        if (orgDyc != null && orgDyc.size() > 0) {
            for (DynamicObject item : orgDyc) {
                DynamicObject org = item.getDynamicObject(1);
                orgList.add(org.getPkValue());
            }
        }
        String isautoprocess = checkScheme.getString("isautoprocess");
        boolean isrepeatsample = checkScheme.getBoolean("isrepeatsample");
        QFilter filterPreTask = MultQualityCheckSchemeUtil.getPreTaskFilter(checkSchemeId, billTypeIdList, taskTypeId, orgList, sscIdList, times, isautoprocess, isrepeatsample);
        log.info("\u8d28\u68c0\u65b9\u6848\u591a\u9009\u5355\u636e: \u524d\u7f6e\u8fc7\u6ee4\uff1a " + filterPreTask);
        if (taskfilterObject != null) {
            filterPreTask.and(taskfilterObject.getQFilter());
            log.info("\u8d28\u68c0\u65b9\u6848\u591a\u9009\u5355\u636e: \u4efb\u52a1\u8fc7\u6ee4\uff1a " + taskfilterObject.getQFilter());
        }
        ORM orm = ORM.create();
        int start = 0;
        int pageIndex = 0;
        boolean oneCount = false;
        DataSet preTaskDataSet = orm.queryDataSet("kd.ssc.task.common.QualityCheckSchemeNewUtil.excuteQualityCheckTask", "task_taskhistory", TASK_DATA_SET_FIELD, filterPreTask.toArray(), "id", start, 25000);
        int samplingmethod = checkScheme.getInt("samplingmethod");
        int loopTotalTimes = 0;
        if (1 == samplingmethod) {
            int taskCount = orm.queryDataSet("kd.ssc.task.common.QualityCheckSchemeNewUtil.excuteQualityCheckTask.getCount", "task_taskhistory", "id", filterPreTask.toArray()).count("id", false);
            loopTotalTimes = (int)Math.ceil((double)taskCount * 1.0 / 25000.0);
            log.info("\u8d28\u68c0\u65b9\u6848\u591a\u9009\u5355\u636e: \u4efb\u52a1\u8fc7\u6ee4\u83b7\u53d6\u6761\u6570\uff1a" + taskCount);
        }
        List<DynamicObject> taskSet = null;
        HashMap<Object, List<Long>> validBillIds = new HashMap<Object, List<Long>>(16);
        HashMap<Object, Integer> validBillTaskIndex = new HashMap<Object, Integer>(16);
        HashMap<Object, DynamicObject> taskBillMap = new HashMap<Object, DynamicObject>(billTypeIdList.size());
        boolean isNumberSampling = 1 == samplingmethod;
        boolean latest = checkScheme.getBoolean("islatest");
        Set<Long> extractedIds = QualityCheckSchemeUtil.getExtractedTaskByOtherSchemes(isrepeatsample ? checkSchemeId : null);
        while (preTaskDataSet != null && preTaskDataSet.hasNext()) {
            for (Object billTypeId : billTypeIdList) {
                DataSet dataSetCopy = preTaskDataSet.copy();
                DataSet dataSet = dataSetCopy.where("billtype = " + billTypeId);
                DynamicObjectCollection taskDys = ORMUtil.toDynamicObjectCollection((DataSet)dataSet, (String)"task_taskhistory");
                DynamicObject dyTaskBill = taskBillMap.computeIfAbsent(billTypeId, QualityCheckSchemeUtil::getTaskBill);
                boolean isNext = false;
                String erpNumber = "";
                String formId = "";
                String formNumber = "";
                if (dyTaskBill != null) {
                    Object erpId = dyTaskBill.get("externalerp.id");
                    formId = dyTaskBill.getString("bindbill.id");
                    DynamicObject dyExtendErp = QualityCheckSchemeUtil.getExtendErp(erpId);
                    formNumber = QualityCheckSchemeUtil.getBillIDNumber(formId);
                    if (dyExtendErp != null) {
                        erpNumber = dyExtendErp.getString("number");
                    }
                }
                if (NUMBER_NEXT_BASEXTENDERP.equalsIgnoreCase(erpNumber)) {
                    isNext = true;
                }
                DynamicObject billDynamicObject = billFilterMap.get(billTypeId);
                QualityFilterPojo qualityFilterPojo = MultQualityCheckSchemeUtil.getFilterObject(billTypeId, billDynamicObject, formNumber);
                if (isNext) {
                    List<DynamicObject> validTaskSet = QualityCheckSchemeUtil.getNextValidTaskSet(taskDys, qualityFilterPojo.getBillFilterObject(), formNumber);
                    taskSet = QualityCheckCreditHelper.getNextValidTaskSet(validTaskSet, (String)qualityFilterPojo.getCreditFilterJson(), (String)formNumber, (String)qualityFilterPojo.getAppObj());
                } else {
                    taskSet = QualityCheckSchemeUtil.getEasValidTaskSet(taskDys, qualityFilterPojo.getBillFilterObject(), formNumber);
                }
                taskSet = QualityCheckSchemeUtil.getLatestTask(taskSet, latest);
                taskSet = MultQualityCheckSchemeUtil.removeRepeat(taskSet, extractedIds);
                int sampleNum = billDynamicObject.getInt("samplenum");
                List ids = validBillIds.computeIfAbsent(billTypeId, k -> {
                    int initSize = sampleNum > 0 ? sampleNum : 256;
                    return new ArrayList(initSize);
                });
                int taskIndex = validBillTaskIndex.computeIfAbsent(billTypeId, k -> 0);
                taskIndex = MultQualityCheckSchemeUtil.reservoirSampling(taskSet, sampleNum, isNumberSampling, ids, taskIndex);
                log.info("\u5f53\u524d\u8d28\u68c0\u7c7b\u578b\u4e3a{}\u7c7b\u578b\uff0c\u5355\u636e\u7c7b\u578b{}\uff0c\u5f53\u524d\u6279\u6b21\u7b26\u5408\u6761\u4ef6\u7684\u6837\u672c\u6570\uff1a{}\uff0c\u7ed3\u675f\u540e\u5f53\u524d\u6837\u672c\u96c6\u5408\u6570\uff1a{}", new Object[]{isNumberSampling ? "\u6837\u672c\u6570" : "\u6bd4\u4f8b", billTypeId, taskSet.size(), ids.size()});
                validBillTaskIndex.put(billTypeId, taskIndex);
            }
            start = 25000 * ++pageIndex;
            preTaskDataSet = orm.queryDataSet("kd.ssc.task.common.QualityCheckSchemeNewUtil.excuteQualityCheckTask", "task_taskhistory", TASK_DATA_SET_FIELD, filterPreTask.toArray(), "id", start, 25000);
        }
        if (preTaskDataSet != null) {
            preTaskDataSet.close();
        }
        executeSum = MultQualityCheckSchemeUtil.doExecute(billTypeIdList, billFilterMap, validBillIds, checkScheme, entities, isNumberSampling);
        return executeSum;
    }

    private static QualityFilterPojo getFilterObject(Object billTypeId, DynamicObject billDynamicObject, String formNumber) {
        QualityFilterPojo qualityFilterPojo = new QualityFilterPojo();
        String billConditionjson = billDynamicObject.getString("conditionjson");
        String creditFilterJson = billDynamicObject.getString("creditjson_tag");
        if (StringUtils.isEmpty((CharSequence)billConditionjson) && StringUtils.isEmpty((CharSequence)creditFilterJson)) {
            return qualityFilterPojo;
        }
        if (StringUtils.isNotBlank((CharSequence)billConditionjson)) {
            FilterCondition billfilterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)billConditionjson, FilterCondition.class);
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)formNumber);
            FilterBuilder filterBuilder = new FilterBuilder(entityType, billfilterCondition);
            filterBuilder.buildFilter(false);
            FilterObject billFilterObject = filterBuilder.getFilterObject();
            qualityFilterPojo.setBillFilterObject(billFilterObject);
            log.info("\u8d28\u68c0\u65b9\u6848\u591a\u9009\u5355\u636e: " + billTypeId + "\uff0c\u62bd\u68c0\u53c2\u6570\u6761\u4ef6\uff1a" + billFilterObject.getFilter());
        }
        if (StringUtils.isNotBlank((CharSequence)creditFilterJson)) {
            CreditFilterCondition creditFilterCondition = (CreditFilterCondition)SerializationUtils.fromJsonString((String)creditFilterJson, CreditFilterCondition.class);
            qualityFilterPojo.setAppObj(creditFilterCondition.getAppObj());
            qualityFilterPojo.setCreditFilterJson(creditFilterJson);
            log.info("\u8d28\u68c0\u65b9\u6848\u591a\u9009\u5355\u636e: " + billTypeId + "\uff0c\u4fe1\u7528\u53c2\u6570\u6761\u4ef6\uff1a" + creditFilterJson + "\uff0c\u4fe1\u7528\u5e94\u7528\u5bf9\u8c61\uff1a" + creditFilterCondition.getAppObj());
        }
        return qualityFilterPojo;
    }

    private static List<DynamicObject> removeRepeat(List<DynamicObject> taskSet, Set<Long> extractedIds) {
        if (!extractedIds.isEmpty()) {
            taskSet.removeIf(next -> extractedIds.contains(next.getLong("id")));
        }
        return taskSet;
    }

    private static List<Long> randomSampling(int sampleScale, boolean isNumberSampling, List<Long> ids) {
        List<Long> result = ids;
        if (!isNumberSampling) {
            int sampleCount = (int)Math.ceil((double)ids.size() * ((double)sampleScale / 100.0));
            Set sampleRandom = RandomUtil.generateRandom((int)0, (int)ids.size(), (int)sampleCount);
            ArrayList<Long> actualIds = new ArrayList<Long>(sampleCount);
            Iterator iterator = sampleRandom.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                actualIds.add(ids.get(index));
            }
            result = actualIds;
        }
        return result;
    }

    private static int reservoirSampling(List<DynamicObject> taskSet, int sampleNum, boolean isNumberSampling, List<Long> ids, int taskIndex) {
        for (DynamicObject task : taskSet) {
            long id = task.getLong("id");
            if (isNumberSampling && ids.size() == sampleNum) {
                int index = RandomUtil.nextInt((int)(taskIndex + 1));
                if (index < sampleNum) {
                    ids.set(index, id);
                }
            } else {
                ids.add(id);
            }
            ++taskIndex;
        }
        return taskIndex;
    }

    private static int doExecute(ArrayList<Object> billTypeIdList, HashMap<Object, DynamicObject> billFilterMap, Map<Object, List<Long>> validBillIds, DynamicObject checkScheme, DynamicObject[] entities, boolean isNumberSampling) {
        int executeSum = 0;
        for (Object billTypeId : billTypeIdList) {
            List<Long> ids = validBillIds.get(billTypeId);
            if (ids == null || ids.isEmpty()) {
                log.info("\u8d28\u68c0\u65b9\u6848\u591a\u9009\u5355\u636e{}: \u672a\u8d28\u68c0\u5230\u7b26\u5408\u8981\u6c42\u7684\u4efb\u52a1\uff01", billTypeId);
                continue;
            }
            DynamicObject billDynamicObject = billFilterMap.get(billTypeId);
            int scale = billDynamicObject.getInt("scale");
            ids = MultQualityCheckSchemeUtil.randomSampling(scale, isNumberSampling, ids);
            int begin = 0;
            while (begin < ids.size()) {
                int end = begin + 5000;
                end = Math.min(end, ids.size());
                List<Long> batchIds = ids.subList(begin, end);
                QFilter inIds = new QFilter("id", "in", (Object)batchIds.toArray(new Long[0]));
                DynamicObjectCollection tasks = QueryServiceHelper.query((String)"task_taskhistory", (String)selectEntityFields, (QFilter[])new QFilter[]{inIds});
                int executeCount = QualityCheckSchemeUtil.createQualityCheckTask(entities, checkScheme, (List<DynamicObject>)tasks);
                executeSum += executeCount;
                QualityCheckSchemeUtil.handleDispatcherTask(checkScheme, entities);
                begin = end;
            }
            ids.clear();
            validBillIds.remove(billTypeId);
        }
        return executeSum;
    }

    private static QFilter getPreTaskFilter(Long checkSchemeId, ArrayList<Object> billTypeIdList, Object taskTypeId, List orgList, List sscCentrIDList, Map times, String isautoprocess, boolean isrepeatsample) {
        QFilter filterPoolType = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.COMPLETE.getValue());
        QFilter filterQualityLibId = new QFilter("qualitysamplelibrary", "=", (Object)0);
        QFilter filterState = new QFilter("state", "=", (Object)TaskStateEnum.AUDIT_PASSED.getValue());
        QFilter filterBillTypeID = new QFilter("billtype", "in", billTypeIdList);
        QFilter filterTaskTypeID = new QFilter("tasktypeid", "=", taskTypeId);
        QFilter filterOrgID = new QFilter("orgid", "in", (Object)orgList);
        QFilter filterSSCID = new QFilter("sscid", "in", (Object)sscCentrIDList);
        QFilter filterisautoprocess = null;
        if ("0".equals(isautoprocess)) {
            filterisautoprocess = new QFilter("autoprocess", "=", (Object)Character.valueOf('0'));
        } else if ("1".equals(isautoprocess)) {
            filterisautoprocess = new QFilter("autoprocess", "=", (Object)Character.valueOf('1'));
        }
        QFilter filter = filterPoolType.and(filterQualityLibId).and(filterState).and(filterBillTypeID).and(filterTaskTypeID).and(filterOrgID).and(filterSSCID).and(filterisautoprocess);
        if (filterisautoprocess != null) {
            filter.and(filterisautoprocess);
        }
        Object startDate = times.get("startdate");
        Object endDate = times.get("enddate");
        if (startDate != null && endDate != null) {
            QFilter filterCompleteTimeBegin = QFilter.of((String)"completetime >= ? AND completetime <= ?", (Object[])new Object[]{startDate, endDate});
            filter.and(filterCompleteTimeBegin);
        } else {
            QFilter filterCompleteTimeNotNull = new QFilter("completetime", "is not null", null);
            filter.and(filterCompleteTimeNotNull);
        }
        return filter;
    }
}

