/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.mservice.form.FormService;
import kd.bos.orm.ORM;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.sysint.servicehelper.SysIntegrationServiceHelper;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.eventSend.core.SscEventDistributor;
import kd.ssc.eventSend.entity.DataChangeTypeEnum;
import kd.ssc.exception.ExceptionPlatformUtil;
import kd.ssc.exception.ExceptionUtil;
import kd.ssc.exception.TaskErrorCodeEnum;
import kd.ssc.exception.TaskKDExcetptionUtil;
import kd.ssc.task.ErpFactory;
import kd.ssc.task.bill.TaskBillChildUtil;
import kd.ssc.task.business.helper.TaskCreditHelper;
import kd.ssc.task.business.helper.WorkFlowCreditHelper;
import kd.ssc.task.common.AutoProcessResultEnum;
import kd.ssc.task.common.smartscheme.SmartSchemePredictMessage;
import kd.ssc.task.common.workcalendar.CalRemainingTime;
import kd.ssc.task.creditupdate.TaskAutoApproveResultHelper;
import kd.ssc.task.face.TaskFacade;
import kd.ssc.task.formplugin.TaskApprevalHelper;
import kd.ssc.task.formplugin.util.ArtiCheckPointUtil;
import kd.ssc.task.formplugin.util.WithdrawalSelectorUtil;
import kd.ssc.task.partask.ParTaskMessage;
import kd.ssc.task.partask.factory.PublisherFactory;
import kd.ssc.task.partask.service.impl.ParTaskNodeServiceImpl;
import kd.ssc.task.service.approve.ApproveService;
import kd.ssc.task.util.SSCBosUtil;
import kd.ssc.task.workflow.dto.CreditPointDTO;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class TaskApprevalUtil {
    private static final Log log = LogFactory.getLog(TaskApprevalUtil.class);
    private static final String TRUE_STR = "true";
    private static final String BAR_PASS = "bar_pass";
    private static final String BAR_NOT_PASS = "bd_nopass";
    private static final String BAR_REPULSE = "bar_repulse";
    private static final String SYNC_RESULT = "sscsyncresult";
    private static final String PUBLIC_SYNC_RESULT = "publicsyncresult";

    public static void doApproveOperation(String key, DynamicObject billData, Map<String, String> map, IFormView view, IDataModel model, IFormView subView, boolean flag) {
        String erpNumber;
        String extUserID;
        String decisionValue;
        ApproveService approveService = TaskApprevalUtil.getApproveService();
        if (approveService != null) {
            approveService.beforeApproveOperation(key, billData, map, view, model, subView, flag);
        }
        String taskID = map.get("taskID");
        String billTypeID = map.get("billtypeid");
        Long taskid = NumberUtils.toLong((String)taskID, (long)0L);
        String billTypeKey = map.get("billTypeKey");
        boolean isTaskadministor = BooleanUtils.toBoolean((String)map.get("isTaskadministor"));
        boolean isPass = BAR_PASS.equals(key);
        int decision = BAR_NOT_PASS.equalsIgnoreCase(key) ? 2 : (BAR_REPULSE.equalsIgnoreCase(key) ? 3 : 1);
        String message = map.get("opinion");
        if (isPass) {
            decisionValue = map.getOrDefault("passDecisionValue", "Consent");
            if (map.containsKey("passDecisionValue")) {
                log.info("Extended passDecisionValue[{}] exists", (Object)decisionValue);
            }
        } else {
            decisionValue = TaskApprevalUtil.getDecisionValue(NumberUtils.toLong((String)map.get("decisionitemid")));
            if (StringUtils.isEmpty((CharSequence)decisionValue)) {
                decisionValue = "Reject";
                log.info("Using default because no pass decision[{}] not exists", (Object)map.get("decisionitemid"));
            }
        }
        if ((extUserID = TaskApprevalUtil.getExtUserID(view, erpNumber = TaskApprevalUtil.getErpNumber(map))).equals("errorUserID")) {
            return;
        }
        TaskFacade taskFacade = ErpFactory.getTaskFacade((String)erpNumber);
        String json = "";
        if (!TRUE_STR.equalsIgnoreCase(map.get("isEmbed"))) {
            String taskTypeId;
            boolean success;
            json = TaskApprevalUtil.buildExtKDCCBillData(billData, erpNumber);
            if ("KDCC".equalsIgnoreCase(erpNumber) && !(success = TaskApprevalUtil.saveKDCCBillData(view, subView, billData, billTypeID, taskTypeId = map.get("tasktypeid"), billTypeKey, false))) {
                return;
            }
        }
        long hisTaskId = 0L;
        try {
            TaskApprevalUtil.creditSetWfVariable(key, map, taskid);
            TaskApprevalUtil.sysAudit(map, billData, view, subView, taskid, isTaskadministor, isPass, message, decision, decisionValue, extUserID, taskFacade);
        }
        catch (Exception e) {
            ErrorCode code;
            view.getPageCache().put("submitResult", "false");
            String errorInfo = ResManager.loadKDString((String)"\u5ba1\u6838\u51fa\u9519[1]", (String)"TaskApprevalUtil_14", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            log.error(errorInfo, (Throwable)e);
            String errorMsg = e.getMessage();
            if (e instanceof KDException && (code = ((KDException)e).getErrorCode()).getCode() != null && code.getCode().startsWith("approve_partask") && code.getMessage() != null && !code.getMessage().isEmpty()) {
                errorMsg = code.getMessage();
            }
            view.showMessage(errorInfo, errorMsg, MessageTypes.Default);
            TaskApprevalUtil.saveExceptionInfo2DB(e, "taskId = " + taskID);
            TaskApprevalUtil.deleteUnPassResion(Long.parseLong(taskID));
            return;
        }
        try (TXHandle h = TX.requiresNew((String)"kd.ssc.task.common.TaskApprevalUtil.doApproveOperation");){
            try {
                TaskApprevalUtil.calCompletedTime(Collections.singletonList(taskid));
                hisTaskId = TaskApprevalUtil.updateStateAndRecord(model, key, taskid, json, map);
                if (view.getPageCache().get("dealSuccess") == null) {
                    view.showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"TaskApprevalUtil_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    view.getPageCache().put("dealSuccess", "yes");
                }
            }
            catch (Exception e) {
                h.markRollback();
                view.getPageCache().put("submitResult", "false");
                String errorInfo = ResManager.loadKDString((String)"\u5ba1\u6838\u51fa\u9519[2]", (String)"TaskApprevalUtil_15", (String)"ssc-task-formplugin", (Object[])new Object[0]);
                log.error(errorInfo, (Throwable)e);
                view.showMessage(errorInfo, e.getMessage(), MessageTypes.Default);
                TaskApprevalUtil.saveExceptionInfo2DB(e, "taskId = " + taskID);
                if (h != null) {
                    if (errorInfo != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable) {
                            errorInfo.addSuppressed(throwable);
                        }
                    } else {
                        h.close();
                    }
                }
                return;
            }
        }
        if (decision == 1) {
            TaskApprevalUtil.sendParTaskMessageIfNecessary(hisTaskId);
        }
        TaskApprevalUtil.predictMQ(hisTaskId, map.get("billTypeKey"));
        String isNext = view.getPageCache().get("isNext");
        if (TRUE_STR.equals(isNext)) {
            try {
                TaskApprevalUtil.switchNextTask(view);
            }
            catch (Exception e) {
                log.error("\u4efb\u52a1\u5ba1\u6279\u5b8c\u6210\uff0c\u63d0\u4ea4\u5e76\u4e0b\u4e00\u6761\u62a5\u9519", (Throwable)e);
                view.close();
                return;
            }
        }
        TaskApprevalUtil.doSyncResultOperation(billTypeKey, billData, subView);
        if (model != null && !flag) {
            view.close();
        }
        TaskApprevalUtil.plusCreditPoints(taskid, erpNumber, map);
        if (approveService != null) {
            approveService.afterApproveOperation(key, billData, map, view, model, subView, flag, hisTaskId);
        }
    }

    private static void creditSetWfVariable(String key, Map<String, String> map, Long taskId) {
        DynamicObject taskInfo = TaskCreditHelper.getTaskInfo((long)taskId);
        Boolean openCreditControl = WorkFlowCreditHelper.isOpenCreditControlByTaskId((DynamicObject)taskInfo);
        if (openCreditControl == null || !openCreditControl.booleanValue()) {
            return;
        }
        TaskCreditHelper.updateWfVariableByTaskId((String)key, map, (DynamicObject)taskInfo);
    }

    public static void doSyncResultOperation(String billTypeKey, DynamicObject billData, IFormView subView) {
        List dataEntityOperate = EntityMetadataCache.getDataEntityOperate((String)billTypeKey);
        block8: for (Map operate : dataEntityOperate) {
            String operateKey;
            switch (operateKey = (String)operate.get("key")) {
                case "sscsyncresult": {
                    TaskApprevalUtil.workBillSyncResult(billTypeKey, billData, subView);
                    continue block8;
                }
                case "publicsyncresult": {
                    TaskApprevalUtil.workBillSyncResultNew(billData);
                    continue block8;
                }
            }
        }
    }

    public static void doSyncResultOperation(String billTypeKey, DynamicObject billData) {
        List dataEntityOperate = EntityMetadataCache.getDataEntityOperate((String)billTypeKey);
        block8: for (Map operate : dataEntityOperate) {
            String operateKey;
            switch (operateKey = (String)operate.get("key")) {
                case "sscsyncresult": {
                    TaskApprevalUtil.workBillSyncResult(billTypeKey, billData, null);
                    continue block8;
                }
                case "publicsyncresult": {
                    TaskApprevalUtil.workBillSyncResultNew(billData);
                    continue block8;
                }
            }
        }
    }

    private static void workBillSyncResultNew(DynamicObject billData) {
        try {
            String flowNum = billData.getString("flownumber");
            Long id = billData.getLong("id");
            if (StringUtils.isEmpty((CharSequence)flowNum)) {
                log.error("flowNum is empty,billId:" + id);
                return;
            }
            ArrayList<Long> inputs = new ArrayList<Long>(1);
            inputs.add(id);
            DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscFlowService", (String)"start", (Object[])new Object[]{flowNum, inputs});
        }
        catch (Exception e) {
            log.error("sync result error", (Throwable)e);
        }
    }

    private static void workBillSyncResult(String billTypeKey, DynamicObject billData, IFormView subView) {
        if (subView == null) {
            OperationServiceHelper.executeOperate((String)SYNC_RESULT, (String)billTypeKey, (DynamicObject[])new DynamicObject[]{billData}, null);
        } else {
            subView.invokeOperation(SYNC_RESULT);
        }
    }

    public static void plusCreditPoints(long taskId, String erpNumber, Map<String, String> map) {
        if ("KDCC".equalsIgnoreCase(erpNumber)) {
            return;
        }
        if (map.isEmpty()) {
            return;
        }
        String subScoreRuleIdsJson = map.get("subscorerule");
        if (StringUtils.isNotBlank((CharSequence)subScoreRuleIdsJson)) {
            return;
        }
        QFilter filter = new QFilter("id", "in", (Object)taskId);
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((String)"task_task", (String)"billtype,billid,creator,billnumber", (QFilter[])filter.toArray());
        DynamicObject billType = dy.getDynamicObject("billtype");
        String number = billType.getString("externalerp.number");
        String billNumber = billType.getString("bindbill.number");
        String billId = dy.getString("billid");
        long userId = dy.getLong("creator.id");
        String billNo = dy.getString("billnumber");
        if (StringUtils.equals((CharSequence)"KDCC", (CharSequence)number)) {
            return;
        }
        CreditPointDTO dto = new CreditPointDTO(billId, billNumber, billNo, userId);
        try {
            Long userIdByAppObj = (Long)DispatchServiceHelper.invokeBizService((String)"fi", (String)"fircm", (String)"ICreditService", (String)"getCreditArgAppObj", (Object[])new Object[]{dto.getBillNumber(), dto.getBillId()});
            Optional.ofNullable(userIdByAppObj).ifPresent(id -> dto.setUserId(id.longValue()));
            if (dto.getUserId() == -1L) {
                log.error(String.format("plusCreditPoints error, billType:{%s}, billNo:{%s}", dto.getBillNumber(), dto.getBillNo()));
                return;
            }
            log.info("start to call ICreditService#directCreditPoints, param:" + dto);
            String creditPointDTOStr = SerializationUtils.toJsonString((Object)dto);
            DispatchServiceHelper.invokeBizService((String)"fi", (String)"fircm", (String)"ICreditService", (String)"directCreditPoints", (Object[])new Object[]{creditPointDTOStr});
        }
        catch (Exception e) {
            log.error(String.format("deductCreditPoints error, msg:%s", ExceptionUtil.getStackTrace((Throwable)e)));
            ExceptionPlatformUtil.saveErrorInfo((String)TaskApprevalUtil.class.getName(), (String)"plusCreditPoints", (String)dto.toString(), (Throwable)e);
        }
    }

    public static void switchNextTask(IFormView view) {
        String taskId = view.getPageCache().get("taskid");
        String poolType = view.getPageCache().get("pooltype");
        String poolTask = view.getPageCache().get("pooltype-mytask");
        String sourcePageId = view.getPageCache().get("sourcePageId");
        DynamicObject curtask = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(taskId), (String)"task_task");
        if (curtask == null) {
            QFilter idFilter = new QFilter("sourcetaskid", "=", (Object)Long.valueOf(taskId));
            curtask = BusinessDataServiceHelper.loadSingleFromCache((String)"task_taskhistory", (QFilter[])new QFilter[]{idFilter});
        }
        TaskApprevalHelper.getNextTask(curtask, view, poolType, poolTask, sourcePageId);
    }

    private static DynamicObject getTaskHisObj(Long taskid, Map<String, Object> params) {
        QFilter filter = new QFilter("sourcetaskid", "=", (Object)taskid);
        DynamicObject[] taskObjCol = BusinessDataServiceHelper.load((String)"task_taskhistory", (String)"billnumber,orgid.id", (QFilter[])filter.toArray());
        if (taskObjCol == null || taskObjCol.length == 0) {
            return null;
        }
        DynamicObject taskObj = taskObjCol[0];
        return taskObj;
    }

    private static boolean sysAudit(Map<String, String> map, DynamicObject billData, IFormView view, IFormView subView, Long taskid, boolean isTaskadministor, boolean isPass, String isPassmessage, int decision, String decisionValue, String extUserID, TaskFacade taskFacade) throws Exception {
        String info = String.format("kd.ssc.task.common.TaskApprevalUtil.sysAudit# entityName: %s, billid: %s, taskid: %s, extUserID: %s, isPass: %s, isPassmessage: %s, decision: %s, decisionValue: %s, isTaskadministor: %s", billData != null ? billData.getDataEntityType().getName() : "isEmbed", billData != null ? billData.getPkValue() : "isEmbed", taskid, extUserID, isPass, isPassmessage, decision, decisionValue, isTaskadministor);
        log.info(info);
        if (TRUE_STR.equalsIgnoreCase(map.get("isEmbed"))) {
            return TaskApprevalUtil.embedBizAudit(billData, view, subView, taskid, isTaskadministor, isPass, isPassmessage, decision, decisionValue, extUserID, taskFacade);
        }
        return TaskApprevalUtil.notEmbedBizAudit(billData, view, subView, taskid, isTaskadministor, isPass, isPassmessage, decision, decisionValue, extUserID, taskFacade);
    }

    public static boolean embedBizAudit(DynamicObject billData, IFormView view, IFormView subView, Long taskid, boolean isTaskadministor, boolean isPass, String isPassmessage, int decision, String decisionValue, String extUserID, TaskFacade taskFacade) throws Exception {
        boolean remoteInvoke = taskFacade.embedApprove(taskid.longValue(), extUserID, isPass, isPassmessage == null ? "" : isPassmessage, billData, decision, decisionValue, isTaskadministor, subView);
        log.info("kd.ssc.task.common.TaskApprevalUtil.embedBizAudit end");
        if (!remoteInvoke) {
            ErrorCode errorCode = new ErrorCode("embedBizAudit_0", "invoke embedBizAudit() fail! remoteInvoke = false ");
            throw new KDException(errorCode, new Object[]{ResManager.loadKDString((String)"\u5d4c\u5165\u5f0f\u5355\u636e\u5904\u7406\u51fa\u9519\u3002", (String)"TaskApprevalUtil_9", (String)"ssc-task-formplugin", (Object[])new Object[0])});
        }
        return remoteInvoke;
    }

    private static boolean notEmbedBizAudit(DynamicObject billData, IFormView view, IFormView subView, Long taskid, boolean isTaskadministor, boolean isPass, String isPassmessage, int decision, String decisionValue, String extUserID, TaskFacade taskFacade) throws Exception {
        HashMap<String, String> paramMap = new HashMap<String, String>(8);
        String itemId = view.getPageCache().get("nodeItemId");
        paramMap.put("itemId", itemId);
        boolean remoteInvoke = taskFacade.approve(taskid.longValue(), extUserID, isPass, isPassmessage == null ? "" : isPassmessage, billData, decision, decisionValue, isTaskadministor, subView, paramMap);
        log.info("kd.ssc.task.common.TaskApprevalUtil.notEmbedBizAudit end");
        if (!remoteInvoke) {
            ErrorCode errorCode = new ErrorCode("notEmbedBizAudit_0", "invoke notEmbedBizAudit() fail! remoteInvoke = false ");
            throw new KDException(errorCode, new Object[]{ResManager.loadKDString((String)"\u975e\u5d4c\u5165\u5f0f\u5355\u636e\u5904\u7406\u51fa\u9519\u3002", (String)"TaskApprevalUtil_10", (String)"ssc-task-formplugin", (Object[])new Object[0])});
        }
        return remoteInvoke;
    }

    private static void calCompletedTime(List<Long> taskIds) {
        CalRemainingTime cal = new CalRemainingTime();
        cal.calCompletedTimeOfTaskApprove(taskIds);
    }

    public static void reCalcCompletedTime(List<Long> hisTaskIds) {
        CalRemainingTime cal = new CalRemainingTime();
        cal.reCalcCompletedTime(hisTaskIds);
    }

    public static String buildExtKDCCBillData(DynamicObject billData, String erpNumber) {
        String json = null;
        if (!"KDCC".equalsIgnoreCase(erpNumber)) {
            DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(billData.getDynamicObjectType());
            binder.setIgnoreCase(true);
            DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
            jser.setIsLocaleValueFull(true);
            binder.setOnlyDbProperty(false);
            json = jser.serializeToString((Object)billData, null);
        }
        return json;
    }

    @Deprecated
    public static boolean saveKDCCBillData(IFormView view, IFormView subView, DynamicObject billData, String taskBillId, String taskTypeId, String bindBillNumber, boolean showOpResultMsg) {
        if (subView == null) {
            return true;
        }
        long taskBill = Long.parseLong(taskBillId);
        long taskType = Long.parseLong(taskTypeId);
        String operation = view.getPageCache().get("operation");
        boolean isSave = TRUE_STR.equals(view.getPageCache().get("isSave"));
        String operationKey = TaskApprevalUtil.getOriginBillOp(taskBill, taskType, operation, isSave);
        view.getPageCache().remove("operation");
        view.getPageCache().remove("isSave");
        if (StringUtils.isEmpty((CharSequence)operationKey)) {
            log.info("\u672a\u8bfb\u53d6\u5230\u5ba1\u6279\u64cd\u4f5c\u914d\u7f6e\uff0c\u4e0d\u6267\u884c\u539f\u5355\u64cd\u4f5c");
            if (showOpResultMsg) {
                view.showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"TaskApprevalPlugin_26", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            }
            return true;
        }
        log.info("\u8bfb\u53d6\u5230\u5ba1\u6279\u64cd\u4f5c\u914d\u7f6e\uff1a" + operationKey);
        boolean returnResult = false;
        String subPageId = subView.getPageId();
        String appId = subView.getServiceAppId(subPageId);
        try {
            HashMap<String, String> variable = new HashMap<String, String>(1);
            variable.put("ishasright", String.valueOf(true));
            Map resultMap = (Map)DispatchServiceHelper.invokeBOSService((String)appId, (String)FormService.class.getSimpleName(), (String)"invokeOperationFromService", (Object[])new Object[]{subPageId, operationKey, variable});
            String opResultStr = (String)resultMap.get("operationResult");
            Object opResultObj = DataEntitySerializer.deSerializerFromString((String)opResultStr, (IDataEntityType)OrmUtils.getDataEntityType(OperationResult.class));
            OperationResult opResult = (OperationResult)opResultObj;
            if (!opResult.isSuccess()) {
                subView.showOperationResult(opResult);
                view.sendFormAction(subView);
            } else if (showOpResultMsg) {
                view.showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"TaskApprevalPlugin_26", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            }
            returnResult = opResult.isSuccess();
        }
        catch (Exception e) {
            log.error("Error on invoking \"{}\" operation", (Object)operationKey, (Object)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u5ba1\u6279\u8c03\u7528\u64cd\u4f5c\u62a5\u9519\uff0c\u8bf7\u68c0\u67e5\u4e1a\u52a1\u5355\u636e\u914d\u7f6e", (String)"TaskApprevalUtil_16", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
        return returnResult;
    }

    public static String getOriginBillOp(Long taskBill, Long taskType, String operationType, boolean isSave) {
        log.info("\u5f53\u524d\u5171\u4eab\u64cd\u4f5c\u7c7b\u578b operationType = " + operationType + "\uff0c\u662f\u5426\u4e3a\u4fdd\u5b58\u64cd\u4f5c\uff1a" + isSave);
        String operationKey = null;
        if (isSave) {
            operationType = "7";
        }
        DynamicObjectCollection billOpConfigCollection = new TaskBillChildUtil().query(taskBill.longValue(), taskType.longValue(), "entryentitybillop.ssc_auditop,entryentitybillop.srcoperation_key");
        for (DynamicObject billOpConfig : billOpConfigCollection) {
            String sscOperation = billOpConfig.getString("entryentitybillop.ssc_auditop");
            if (sscOperation == null || !sscOperation.equals(operationType)) continue;
            operationKey = billOpConfig.getString("entryentitybillop.srcoperation_key");
            break;
        }
        return operationKey;
    }

    private static String getExtUserID(IFormView view, String erpNumber) {
        RequestContext requestContext = RequestContext.get();
        Long currentUserId = Long.valueOf(requestContext.getUserId());
        String id = "";
        if (!"KDCC".equalsIgnoreCase(erpNumber)) {
            try {
                Map userMap = SysIntegrationServiceHelper.getExternalData((Long)1L, (String)"bos_user", (String)currentUserId.toString(), null, null);
                id = (String)userMap.get("id");
            }
            catch (Exception e) {
                log.error("Error on get external data", (Throwable)e);
            }
            if (StringUtils.isEmpty((CharSequence)id)) {
                view.showMessage(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237%s\u6ca1\u6709\u7ef4\u62a4\u4e0e\u5916\u90e8\u7cfb\u7edf\u6620\u5c04\u5173\u7cfb\uff0c\u8bf7\u5728\u57fa\u7840\u670d\u52a1\u8bbe\u7f6e\uff01", (String)"TaskApprevalUtil_3", (String)"ssc-task-formplugin", (Object[])new Object[0]), requestContext.getUserName()));
                return "errorUserID";
            }
        }
        return id;
    }

    public static void autoDoApproveOperation(String key, DynamicObject billData, Map<String, String> map) {
        Long sscId = Long.valueOf(map.get("sscId"));
        String taskID = map.get("taskID");
        boolean isTaskadministor = false;
        String isTaskAdminStr = map.get("isTaskadministor");
        if (isTaskAdminStr != null) {
            isTaskadministor = Boolean.parseBoolean(isTaskAdminStr);
        }
        String isPassmessage = map.get("opinion");
        String erpNumber = TaskApprevalUtil.getErpNumber(map);
        TaskFacade taskFacade = ErpFactory.getTaskFacade((String)erpNumber);
        String robotId = map.get("personID");
        String id = "";
        if (!"KDCC".equalsIgnoreCase(erpNumber)) {
            try {
                Map userMap = SysIntegrationServiceHelper.getExternalData((Long)1L, (String)"bos_user", (String)robotId, null, null);
                id = (String)userMap.get("id");
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
            if (StringUtils.isEmpty((CharSequence)id)) {
                log.error("\u8d22\u52a1\u673a\u5668\u4eba\u7528\u6237\u6ca1\u6709\u7ef4\u62a4\u4e0e\u5916\u90e8\u7cfb\u7edf\u6620\u5c04\u5173\u7cfb\uff0c\u8bf7\u5728\u57fa\u7840\u670d\u52a1\u8bbe\u7f6e\uff01");
                return;
            }
        }
        String json = null;
        if (!"KDCC".equalsIgnoreCase(erpNumber)) {
            DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(billData.getDynamicObjectType());
            binder.setIgnoreCase(true);
            DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
            jser.setIsLocaleValueFull(true);
            binder.setOnlyDbProperty(false);
            json = jser.serializeToString((Object)billData, null);
        } else {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{billData});
        }
        try {
            log.info("kd.ssc.task.common.TaskApprevalUtil.autoDoApproveOperation task:" + taskID + ";id:" + id + ";isPassmessage:" + isPassmessage + "; billData:" + billData + "; isTaskadministor:" + isTaskadministor);
            TaskApprevalUtil.creditSetWfVariable(key, map, Long.parseLong(taskID));
            taskFacade.approve(Long.parseLong(taskID), id, true, isPassmessage == null ? "" : isPassmessage, billData, 1, null, isTaskadministor, null);
            log.info("kd.ssc.task.common.TaskApprevalUtil.autoDoApproveOperation end");
        }
        catch (Exception e) {
            log.error("\u81ea\u52a8\u5ba1\u6279\uff1a\u4e1a\u52a1\u7cfb\u7edf\u5355\u636e\u5904\u7406\u51fa\u9519\uff0c\u8bf7\u67e5\u770b\u4e1a\u52a1\u7cfb\u7edf\u65e5\u5fd7\uff01", (Throwable)e);
            TaskApprevalUtil.saveExceptionInfo2DB(e, "taskId= " + taskID);
            return;
        }
        Long taskid = Long.valueOf(taskID);
        TaskApprevalUtil.calCompletedTime(Collections.singletonList(taskid));
        TaskAutoApproveResultHelper approveResultHelper = new TaskAutoApproveResultHelper();
        approveResultHelper.saveAutoApproveResult(taskid, AutoProcessResultEnum.PASS.getValue());
        long hisId = TaskApprevalUtil.updateStateAndRecord(null, key, taskid, json, map);
        if (taskid != 0L && hisId != 0L) {
            SscEventDistributor.taskSyncData((String)"task_task", (DataChangeTypeEnum)DataChangeTypeEnum.DELETE, (Long)sscId, (Long)taskid);
            SscEventDistributor.taskSyncData((String)"task_taskhistory", (DataChangeTypeEnum)DataChangeTypeEnum.INSERT, (Long)sscId, (Long)hisId);
        }
        TaskApprevalUtil.sendParTaskMessageIfNecessary(hisId);
        TaskApprevalUtil.predictMQ(hisId, map.get("billTypeKey"));
        TaskApprevalUtil.plusCreditPoints(taskid, erpNumber, map);
        String billTypeKey = map.get("billTypeKey");
        TaskApprevalUtil.doSyncResultOperation(billTypeKey, billData, null);
    }

    public static String getErpNumber(Map<String, String> map) {
        String erpNumber = map.get("erpNumber");
        if (!StringUtils.isEmpty((CharSequence)erpNumber)) {
            return erpNumber;
        }
        String billtypeidStr = map.get("billtypeid");
        long billtypeid = Long.parseLong(billtypeidStr);
        ORM orm = ORM.create();
        DynamicObject billType = orm.queryOne("task_taskbill", "id,externalerp.id,externalerp.number", new QFilter[]{new QFilter("id", "=", (Object)billtypeid)});
        erpNumber = (String)billType.get("externalerp.number");
        return erpNumber;
    }

    public static void updateStateAndRecord(String key, DynamicObject billData, Map<String, String> map, IFormView view, IDataModel model, IFormView subView) {
        String erpNumber = TaskApprevalUtil.getErpNumber(map);
        Long taskid = Long.valueOf(map.get("taskID"));
        String json = null;
        if (!"KDCC".equalsIgnoreCase(erpNumber)) {
            DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(billData.getDynamicObjectType());
            DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
            jser.setIsLocaleValueFull(true);
            binder.setOnlyDbProperty(false);
            json = jser.serializeToString((Object)billData, null);
        }
        QFilter hisJobFilter = new QFilter("sourcetaskid", "=", (Object)taskid);
        DynamicObject[] hisObjs = BusinessDataServiceHelper.load((String)"task_taskhistory", (String)"id", (QFilter[])new QFilter[]{hisJobFilter});
        long hisTaskId = 0L;
        if (hisObjs.length > 0) {
            hisTaskId = hisObjs[0].getLong("id");
        }
        QFilter hisStateJobFilter = new QFilter("jobid", "=", (Object)hisTaskId);
        DeleteServiceHelper.delete((String)"task_statechangehis", (QFilter[])new QFilter[]{hisStateJobFilter});
        DeleteServiceHelper.delete((String)"task_taskhistory", (QFilter[])new QFilter[]{hisJobFilter});
        long hisId = TaskApprevalUtil.updateStateAndRecord(model, key, taskid, json, map);
        TaskApprevalUtil.predictMQ(hisId, map.get("billTypeKey"));
    }

    private static long updateStateAndRecord(IDataModel model, String key, Long taskid, String json, Map<String, String> map) {
        long billtype = Long.parseLong(map.get("billtypeid"));
        long oldState = Long.parseLong(map.get("state"));
        long tasktypeid = Long.parseLong(map.get("tasktypeid"));
        RequestContext requestContext = RequestContext.get();
        Long personid = Long.valueOf(requestContext.getUserId());
        if (TRUE_STR.equals(map.get("fixdata")) || TRUE_STR.equals(map.get("autoappreval"))) {
            personid = Long.valueOf(map.get("personid"));
        }
        DynamicObject task = TaskApprevalUtil.updateTaskStatus(key, json, taskid, model, map);
        boolean deleteTask = true;
        if (TRUE_STR.equals(map.get("fixdata"))) {
            deleteTask = false;
            TaskApprevalUtil.markSameJobHandled(taskid);
        }
        DynamicObject taskHis = TaskApprevalUtil.insertDataToHistoryTask(taskid, task, deleteTask, key, map);
        try {
            TaskApprevalUtil.insertWFTask(taskHis);
        }
        catch (Exception e) {
            log.error("\u8bb0\u5f55\u6d41\u7a0b\u4efb\u52a1\u5173\u7cfb\u8868\u5931\u8d25\uff1a{}" + e.getMessage());
        }
        long hisID = taskHis.getLong("ID");
        DynamicObject auditStateChange = TaskApprevalUtil.createAuditStateChange(model, key, taskid, map, billtype, oldState, tasktypeid, personid);
        TaskApprevalUtil.insertDataToHistoryState(taskid, hisID, auditStateChange, deleteTask);
        TaskApprevalUtil.insertTaskHistExtParam(taskid, hisID);
        ArtiCheckPointUtil.saveArtiCheckPointInfo(key, String.valueOf(taskid), model, hisID, map.get("origin") != null, billtype, String.valueOf(tasktypeid));
        TaskApprevalUtil.creditSubScore(key, hisID, map);
        TaskApprevalUtil.updatePredictResult(taskHis, map);
        return hisID;
    }

    private static void updatePredictResult(DynamicObject taskHis, Map<String, String> map) {
        try {
            DynamicObject approvalRes = BusinessDataServiceHelper.loadSingle((String)"task_approval_result", (String)"billnumber,subject,realpass,realbreakrule,realoperation,realwithdrawal,predictpass,breakrule,operation,withdrawal,realpredictresult,breakrulepredictresult,operationpredictresult,withdrawalpredictresult,newrealbreakrule,newrealwithdrawal", (QFilter[])new QFilter("taskid", "=", (Object)taskHis.getLong("sourcetaskid")).toArray());
            approvalRes.set("billnumber", (Object)taskHis.getString("billnumber"));
            approvalRes.set("subject", (Object)taskHis.getString("subject"));
            String state = taskHis.getString("state");
            if (TaskStateEnum.AUDIT_PASSED.getValue().equals(state)) {
                approvalRes.set("realpass", (Object)"1");
                approvalRes.set("realpredictresult", (Object)("1".equals(approvalRes.getString("predictpass")) ? "1" : "0"));
                String breakRule = map.getOrDefault("subscorerule", " ");
                if (StringUtils.isBlank((CharSequence)breakRule)) {
                    approvalRes.set("breakrulepredictresult", (Object)"1");
                } else {
                    String breakRulePredictRes = "0";
                    JSONArray array = JSON.parseArray((String)breakRule);
                    for (Object id : array) {
                        if (!approvalRes.getString("breakrule").contains("\"" + id + "\"")) continue;
                        breakRulePredictRes = "1";
                        break;
                    }
                    TaskApprevalUtil.putMulDynamicObject(approvalRes, "newrealbreakrule", (Collection<Object>)array);
                    approvalRes.set("breakrulepredictresult", (Object)breakRulePredictRes);
                }
                if (breakRule.length() > 1000) {
                    breakRule = breakRule.substring(0, 1000);
                    breakRule = breakRule.substring(0, breakRule.lastIndexOf(44)) + ']';
                }
                approvalRes.set("realbreakrule", (Object)breakRule);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{approvalRes});
                return;
            }
            if (TaskStateEnum.AUDIT_NOTPASSED.getValue().equals(state)) {
                approvalRes.set("realpass", (Object)"0");
                approvalRes.set("realpredictresult", (Object)("0".equals(approvalRes.getString("predictpass")) ? "1" : "0"));
                String withdrawalIds = map.getOrDefault("withdrawalids", " ");
                if (StringUtils.isBlank((CharSequence)withdrawalIds)) {
                    approvalRes.set("withdrawalpredictresult", (Object)"1");
                } else {
                    String withdrawalPredictRes = "0";
                    JSONArray array = JSON.parseArray((String)withdrawalIds);
                    for (Object id : array) {
                        if (!approvalRes.getString("withdrawal").contains("\"" + id + "\"")) continue;
                        withdrawalPredictRes = "1";
                        break;
                    }
                    TaskApprevalUtil.putMulDynamicObject(approvalRes, "newrealwithdrawal", (Collection<Object>)array);
                    approvalRes.set("withdrawalpredictresult", (Object)withdrawalPredictRes);
                }
                if (withdrawalIds.length() > 1000) {
                    withdrawalIds = withdrawalIds.substring(0, 1000);
                    withdrawalIds = withdrawalIds.substring(0, withdrawalIds.lastIndexOf(44)) + ']';
                }
                approvalRes.set("realwithdrawal", (Object)withdrawalIds);
                String operation = map.getOrDefault("decisionitem", " ");
                approvalRes.set("realoperation", (Object)operation);
                if (StringUtils.isBlank((CharSequence)operation) || approvalRes.getString("operation").contains("\"" + operation + "\"")) {
                    approvalRes.set("operationpredictresult", (Object)"1");
                } else {
                    approvalRes.set("operationpredictresult", (Object)"0");
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{approvalRes});
            }
        }
        catch (Exception e) {
            log.error("Error on saving approval info to t_tk_approval_result", (Throwable)e);
        }
    }

    private static void putMulDynamicObject(DynamicObject approvalRes, String property, Collection<Object> collection) {
        DynamicObjectCollection newrealwithdrawal = approvalRes.getDynamicObjectCollection(property);
        for (Object o : collection) {
            DynamicObject dynamicObject = newrealwithdrawal.addNew();
            dynamicObject.set("fbasedataid", approvalRes.get("id"));
            dynamicObject.set("fbasedataid_id", o);
        }
        approvalRes.set(property, (Object)newrealwithdrawal);
    }

    private static void creditSubScore(String key, long historyTaskId, Map<String, String> map) {
        Boolean openCreditControl;
        if (StringUtils.equals((CharSequence)BAR_PASS, (CharSequence)key)) {
            TaskCreditHelper.saveBreakRuleRecord((Long)historyTaskId, map);
        }
        if ((openCreditControl = WorkFlowCreditHelper.isOpenCreditControlByHisTask((long)historyTaskId)) == null) {
            TaskApprevalUtil.deductCreditScore(key, historyTaskId, map);
        }
    }

    private static void deductCreditScore(String key, long historyTaskId, Map<String, String> map) {
        switch (key) {
            case "bar_pass": {
                TaskCreditHelper.passedButFlawed(map, (long)historyTaskId);
                break;
            }
            case "bd_nopass": {
                TaskCreditHelper.approvalFailed(map, (long)historyTaskId);
                break;
            }
        }
    }

    private static DynamicObject createAuditStateChange(IDataModel model, String key, Long taskid, Map<String, String> map, long billtype, long oldState, long tasktypeid, Long personid) {
        ORM orm = ORM.create();
        DynamicObject obj = orm.newDynamicObject("task_statechange");
        if (BAR_NOT_PASS.equals(key) || BAR_REPULSE.equals(key) || "bar_repulse_mytask".equals(key)) {
            obj.set("newjobstate", (Object)TaskStateEnum.AUDIT_NOTPASSED.getValue());
            obj.set("operation", (Object)"2");
        } else if (BAR_PASS.equals(key)) {
            obj.set("newjobstate", (Object)TaskStateEnum.AUDIT_PASSED.getValue());
            obj.set("operation", (Object)"1");
        }
        obj.set("oldjobstate", (Object)oldState);
        obj.set("changetime", (Object)new Date());
        obj.set("operatorid", (Object)personid);
        obj.set("tasktype", (Object)tasktypeid);
        obj.set("billtype", (Object)billtype);
        if (model != null) {
            obj.set("message", model.getValue("opinion"));
            obj.set("innermsg", model.getValue("innermsg"));
        } else {
            obj.set("message", (Object)map.get("opinion"));
            obj.set("innermsg", (Object)map.get("innermsg"));
        }
        obj.set("jobid", (Object)taskid);
        return obj;
    }

    public static DynamicObject createStateChange4ReturnSsc(DynamicObject task, DynamicObject taskHistory) {
        ORM orm = ORM.create();
        DynamicObject obj = orm.newDynamicObject("task_statechange");
        obj.set("jobid", (Object)task.getLong("id"));
        obj.set("newjobstate", (Object)TaskStateEnum.AUDIT_NOTPASSED.getValue());
        obj.set("operation", (Object)"2");
        obj.set("oldjobstate", task.get("state"));
        obj.set("changetime", (Object)new Date());
        obj.set("operatorid", taskHistory.get("personid"));
        obj.set("tasktype", taskHistory.get("tasktypeid"));
        obj.set("billtype", taskHistory.get("billtype"));
        obj.set("message", taskHistory.get("apprevalmessage"));
        obj.set("innermsg", taskHistory.get("innermsg"));
        return obj;
    }

    public static void insertTaskHistExtParam(Long taskid, long hisID) {
        QFilter extParamFilter = new QFilter("taskid", "=", (Object)taskid);
        DynamicObject extParam = BusinessDataServiceHelper.loadSingle((String)"task_ext_param", (String)"creator,createdate,taskid,extparam,extparam_tag,isstoredindb", (QFilter[])new QFilter[]{extParamFilter});
        if (extParam != null) {
            ORM orm = ORM.create();
            DynamicObject hisTaskExtParam = orm.newDynamicObject("taskhis_ext_param");
            hisTaskExtParam.set("taskid", (Object)hisID);
            hisTaskExtParam.set("createdate", extParam.get("createdate"));
            hisTaskExtParam.set("creator", extParam.get("creator"));
            hisTaskExtParam.set("extparam_tag", extParam.get("extparam_tag"));
            hisTaskExtParam.set("isstoredindb", extParam.get("isstoredindb"));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{hisTaskExtParam});
        }
    }

    public static void markSameJobHandled(Long taskid) {
        DynamicObject taskData = BusinessDataServiceHelper.loadSingle((Object)taskid, (String)"task_task", (String)"tasktypeid,billtype,billid");
        Long taskTypeID = taskData.getLong("tasktypeid.id");
        Long billTypeID = taskData.getLong("billtype.id");
        String billID = taskData.getString("billid");
        QFilter taskTypeFilter = new QFilter("tasktypeid", "=", (Object)taskTypeID);
        QFilter billTypeFilter = new QFilter("billtype", "=", (Object)billTypeID);
        QFilter billIDFilter = new QFilter("billid", "=", (Object)billID);
        QFilter ishandledFilter = new QFilter("ishandled", "=", (Object)"0");
        DynamicObject[] taskHisDatas = BusinessDataServiceHelper.load((String)"task_taskhistory", (String)"id,ishandled", (QFilter[])new QFilter[]{taskTypeFilter, billTypeFilter, billIDFilter, ishandledFilter});
        if (taskHisDatas.length > 0) {
            for (DynamicObject taskhis : taskHisDatas) {
                taskhis.set("ishandled", (Object)"1");
            }
            SaveServiceHelper.save((DynamicObject[])taskHisDatas);
        }
    }

    public static void insertDataToHistoryState(long taskid, long hisID, DynamicObject auditStateChange, boolean deleteTask) {
        ORM orm = ORM.create();
        QFilter filter = new QFilter("jobid", "=", (Object)taskid);
        DynamicObjectCollection col = orm.query("task_statechange", filter.toArray());
        col.add((Object)auditStateChange);
        ArrayList<DynamicObject> hisTaskStateList = new ArrayList<DynamicObject>(10);
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject historyTaskState = orm.newDynamicObject("task_statechangehis");
            historyTaskState.set("newjobstate", ((DynamicObject)col.get(i)).get("newjobstate"));
            historyTaskState.set("operation", ((DynamicObject)col.get(i)).get("operation"));
            historyTaskState.set("oldjobstate", ((DynamicObject)col.get(i)).get("oldjobstate"));
            historyTaskState.set("changetime", ((DynamicObject)col.get(i)).get("changetime"));
            historyTaskState.set("operatorid", ((DynamicObject)col.get(i)).get("operatorid"));
            historyTaskState.set("allocatedpersonid", ((DynamicObject)col.get(i)).get("allocatedpersonid"));
            historyTaskState.set("tasktype", ((DynamicObject)col.get(i)).get("tasktype"));
            historyTaskState.set("billtype", ((DynamicObject)col.get(i)).get("billtype"));
            historyTaskState.set("message", ((DynamicObject)col.get(i)).get("message"));
            historyTaskState.set("innermsg", ((DynamicObject)col.get(i)).get("innermsg"));
            historyTaskState.set("jobid", (Object)hisID);
            hisTaskStateList.add(historyTaskState);
        }
        if (!hisTaskStateList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])hisTaskStateList.toArray(new DynamicObject[0]));
        }
        if (deleteTask) {
            DeleteServiceHelper.delete((String)"task_statechange", (QFilter[])filter.toArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DynamicObjectCollection getDataTasklist(long taskid) {
        ORM orm = ORM.create();
        QFilter filter = new QFilter("id", "=", (Object)taskid);
        QFilter[] filters = new QFilter[]{filter};
        try (DataSet dataset = orm.queryDataSet("tasklist", "task_task", "id,billtype,oprt,billid,pooltype,state,subject,tasktypeid,personid", filters);){
            DynamicObjectCollection collection;
            DynamicObjectCollection dynamicObjectCollection = collection = ORMUtil.toDynamicObjectCollection((DataSet)dataset, (String)"task_task");
            return dynamicObjectCollection;
        }
    }

    private static DynamicObject updateTaskStatus(String key, String bizdata, Long taskid, IDataModel model, Map<String, String> map) {
        DynamicObject[] taskObjs;
        ArrayList<Long> taskIDS = new ArrayList<Long>();
        taskIDS.add(taskid);
        QFilter toDisfilter = new QFilter("id", "in", taskIDS);
        String innermsg = "";
        String apprevalmessage = "";
        if (model != null) {
            innermsg = model.getDataEntity().get("innermsg") == null ? "" : model.getDataEntity().get("innermsg").toString();
            apprevalmessage = model.getDataEntity().get("opinion") == null ? "" : model.getDataEntity().get("opinion").toString();
        } else {
            innermsg = map.get("innermsg");
            apprevalmessage = map.get("opinion");
        }
        String decisionitem = map.get("decisionitem");
        String selectFields = "id,resttime,billnumber,orgid,costwaittime,billtype,tasktypeid,sscid,creator,usergroup,subject,state,innermsg,apprevalmessage,taskcreatetime,imageuploadtime,receivetime,completetime,personid,tasklevelid,imageok,flagmsg,autoprocess,pooltype,expirestate,bizdata_tag,billid,assignid,procinstid,coefficient,unpassreasondesc,imagenumber,applytime,createtime,entryentity.voucherid,entryentity.vouchernumber,billinfoentry.costdept,billinfoentry.expenseitem,billinfoentry.expenseamount,billinfoentry.supplier,orglongnumber,matchrule,autoprocessresult,firstcostwaittime,firstreceivetime,billlongid";
        for (DynamicObject task : taskObjs = BusinessDataServiceHelper.load((String)"task_task", (String)selectFields, (QFilter[])new QFilter[]{toDisfilter})) {
            task.set("pooltype", (Object)TaskPoolTypeEnum.COMPLETE.getValue());
            if (BAR_NOT_PASS.equals(key) || BAR_REPULSE.equals(key)) {
                task.set("state", (Object)TaskStateEnum.AUDIT_NOTPASSED.getValue());
            } else if (BAR_PASS.equals(key)) {
                task.set("state", (Object)TaskStateEnum.AUDIT_PASSED.getValue());
            }
            if ("1".equals(decisionitem) || "2".equals(decisionitem) || "4".equals(decisionitem)) {
                task.set("state", (Object)TaskStateEnum.AUDIT_NOTPASSED.getValue());
            }
            task.set("completetime", (Object)new Date());
            task.set("innermsg", (Object)innermsg);
            task.set("apprevalmessage", (Object)(apprevalmessage.length() > 2000 ? apprevalmessage.substring(0, 2000) : apprevalmessage));
            task.set("bizdata_tag", (Object)bizdata);
        }
        return taskObjs[0];
    }

    private static DynamicObject insertDataToHistoryTask(Long taskid, DynamicObject taskData, boolean deleteTask, String key, Map<String, String> map) {
        ORM orm = ORM.create();
        DynamicObject historyTask = orm.newDynamicObject("task_taskhistory");
        historyTask.set("sourcetaskid", (Object)taskid);
        historyTask.set("decisionitem", (Object)map.get("decisionitem"));
        historyTask.set("decisionitemnew", (Object)NumberUtils.toLong((String)map.get("decisionitemid")));
        String itemId = map.get("itemId");
        historyTask.set("itemid", (Object)itemId);
        historyTask.set("subject", taskData.get("subject"));
        historyTask.set("state", taskData.get("state"));
        historyTask.set("innermsg", taskData.get("innermsg"));
        historyTask.set("billnumber", taskData.get("billnumber"));
        historyTask.set("apprevalmessage", taskData.get("apprevalmessage"));
        long personid = taskData.getLong("personid.id");
        if (personid == 0L) {
            RequestContext requestContext = RequestContext.get();
            Long currentUserId = Long.valueOf(requestContext.getUserId());
            historyTask.set("receivetime", (Object)new Date());
            historyTask.set("completetime", (Object)new Date());
            historyTask.set("personid", (Object)currentUserId);
        } else {
            historyTask.set("receivetime", taskData.get("receivetime"));
            historyTask.set("completetime", taskData.get("completetime"));
            historyTask.set("personid", taskData.get("personid"));
        }
        historyTask.set("tasklevelid", taskData.get("tasklevelid"));
        historyTask.set("usergroup", taskData.get("usergroup"));
        historyTask.set("imageok", taskData.get("imageok"));
        historyTask.set("flagmsg", taskData.get("flagmsg"));
        historyTask.set("autoprocess", taskData.get("autoprocess"));
        historyTask.set("pooltype", taskData.get("pooltype"));
        historyTask.set("expirestate", taskData.get("expirestate"));
        historyTask.set("creator", taskData.get("creator"));
        historyTask.set("sscid", taskData.get("sscid"));
        historyTask.set("tasktypeid", taskData.get("tasktypeid"));
        historyTask.set("billtype", taskData.get("billtype"));
        historyTask.set("orgid", taskData.get("orgid"));
        historyTask.set("applytime", taskData.get("applytime"));
        historyTask.set("createtime", taskData.get("createtime"));
        historyTask.set("taskcreatetime", taskData.get("taskcreatetime"));
        historyTask.set("imageuploadtime", taskData.get("imageuploadtime"));
        historyTask.set("costwaittime", taskData.get("costwaittime"));
        historyTask.set("resttime", taskData.get("resttime"));
        historyTask.set("waittime", (Object)new BigDecimal(0));
        historyTask.set("firstreceivetime", taskData.get("firstreceivetime"));
        historyTask.set("firstcostwaittime", taskData.get("firstcostwaittime"));
        historyTask.set("bizdata_tag", taskData.get("bizdata_tag"));
        historyTask.set("billid", taskData.get("billid"));
        historyTask.set("billlongid", taskData.get("billlongid"));
        historyTask.set("assignid", taskData.get("assignid"));
        historyTask.set("procinstid", taskData.get("procinstid"));
        historyTask.set("coefficient", taskData.get("coefficient"));
        String state = taskData.getString("state");
        if (!TaskStateEnum.AUDIT_PASSED.getValue().equalsIgnoreCase(state)) {
            historyTask.set("unpassreasondesc", taskData.get("unpassreasondesc"));
        }
        historyTask.set("imagenumber", taskData.get("imagenumber"));
        historyTask.set("iscalculated", (Object)"0");
        historyTask.set("orglongnumber", taskData.get("orglongnumber"));
        if (StringUtils.isNotEmpty((CharSequence)map.get("innermsg"))) {
            historyTask.set("innermsg", (Object)map.get("innermsg"));
        }
        if (StringUtils.isNotEmpty((CharSequence)map.get("opinion"))) {
            String opinion = map.get("opinion");
            historyTask.set("apprevalmessage", (Object)(opinion.length() > 2000 ? opinion.substring(0, 2000) : opinion));
        }
        if (!TaskStateEnum.AUDIT_PASSED.getValue().equalsIgnoreCase(state) && StringUtils.isNotEmpty((CharSequence)map.get("withdrawal"))) {
            historyTask.set("unpassreasondesc", (Object)map.get("withdrawal"));
        }
        historyTask.set("matchrule", taskData.get("matchrule"));
        historyTask.set("autoprocessresult", taskData.get("autoprocessresult"));
        TaskApprevalUtil.setBillInfoEntry(taskData, historyTask);
        DynamicObject[] hisTasks = new DynamicObject[]{historyTask};
        SaveServiceHelper.save((DynamicObject[])hisTasks);
        historyTask = hisTasks[0];
        if (deleteTask) {
            QFilter taskIDQfilter = new QFilter("id", "=", (Object)taskid);
            DeleteServiceHelper.delete((String)"task_task", (QFilter[])new QFilter[]{taskIDQfilter});
        }
        return historyTask;
    }

    public static boolean isSend() {
        boolean isSend = true;
        String entityName = "task_paramcontrol";
        String selectProp = "paramname,paramvalue";
        QFilter nameFilter = new QFilter("paramname", "=", (Object)"isSendTaskDataToPA");
        DynamicObject paramObj = BusinessDataServiceHelper.loadSingle((String)entityName, (String)selectProp, (QFilter[])new QFilter[]{nameFilter});
        if (paramObj == null) {
            log.error("\u5171\u4eab\u7cfb\u7edf\u63a7\u5236\u53c2\u6570isSendTaskDataToPA\u4e22\u5931\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406\u3002");
            return isSend;
        }
        String paramVal = paramObj.getString("paramvalue");
        if (StringUtils.isNotEmpty((CharSequence)paramVal) && "false".equals(paramVal)) {
            isSend = false;
        }
        return isSend;
    }

    private static void setBillInfoEntry(DynamicObject taskData, DynamicObject historyTask) {
        DynamicObjectCollection billInfoEntry = taskData.getDynamicObjectCollection("billinfoentry");
        DynamicObjectCollection hisBillInfoEntry = historyTask.getDynamicObjectCollection("billinfoentry");
        for (DynamicObject dynObj : billInfoEntry) {
            DynamicObject hisDynObj = hisBillInfoEntry.addNew();
            hisDynObj.set("costdept", dynObj.get("costdept"));
            hisDynObj.set("expenseitem", dynObj.get("expenseitem"));
            hisDynObj.set("expenseamount", dynObj.get("expenseamount"));
            hisDynObj.set("supplier", dynObj.get("supplier"));
        }
    }

    private static void predictMQ(Long taskId, String billTypeKey) {
        if (taskId == 0L) {
            log.info("\u4efb\u52a1\u98ce\u9669\u9884\u6d4b\u5931\u8d25, taskId = 0");
            return;
        }
        boolean predic = TaskApprevalUtil.getSscSettingInfo("taskpredict");
        if (predic && (billTypeKey.equals("er_tripreqbill") || billTypeKey.equals("er_dailyloanbill") || billTypeKey.equals("er_dailyreimbursebill") || billTypeKey.equals("er_tripreimbursebill"))) {
            try (MessagePublisher pub = MQFactory.get().createSimplePublisher("ssc", "kd.ssc.task.ssc_smartscheme_queue");){
                pub.publish((Object)new SmartSchemePredictMessage(Collections.singletonList(taskId), Collections.singletonList(billTypeKey)));
            }
        }
    }

    private static boolean getSscSettingInfo(String key) {
        Object params = SSCBosUtil.getSscSettingInfo((String)key, (boolean)false);
        if (params == null || !(params instanceof Boolean)) {
            log.info("\u4efb\u52a1\u98ce\u9669\u9884\u6d4b-\u83b7\u53d6\u914d\u7f6e\uff1a\u83b7\u53d6 " + key + "\u8bbe\u7f6e\u53c2\u6570\u4e3a\u7a7a");
            return false;
        }
        return (Boolean)params;
    }

    private static void saveExceptionInfo2DB(Exception e, String keyInfo) {
        try (TXHandle tx = TX.requiresNew((String)"ssc_taskApproval_saveExcInfo");){
            try {
                ExceptionPlatformUtil.saveErrorInfo((String)TaskApprevalUtil.class.getName(), (String)"doApproveOperation/autoDoApproveOperation", (String)keyInfo, (Throwable)e);
            }
            catch (Exception e_) {
                log.warn("kd.ssc.exception.ExceptionPlatformUtil.saveErrorInfo() excute failed! ", (Throwable)e_);
            }
        }
    }

    private static void deleteUnPassResion(Long taskid) {
        WithdrawalSelectorUtil utils = new WithdrawalSelectorUtil();
        try (TXHandle th = TX.requiresNew();){
            try {
                utils.deleteTaskWithdrawalUnpassById(taskid);
                utils.deleteTaskUnpass(" ", taskid);
            }
            catch (Exception excption) {
                th.markRollback();
            }
        }
    }

    public static void insertWFTask(DynamicObject taskHis) {
        long taskId = taskHis.getLong("id");
        long assignId = taskHis.getLong("assignid");
        Date completeTime = taskHis.getDate("completetime");
        DynamicObject wfTask = QueryServiceHelper.queryOne((String)"wf_hitaskinst", (String)"processdefinitionid, processinstanceid, taskdefinitionkey", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)assignId)});
        if (wfTask != null) {
            long processdefinitionid = wfTask.getLong("processdefinitionid");
            long processinstanceid = wfTask.getLong("processinstanceid");
            String taskdefinitionkey = wfTask.getString("taskdefinitionkey");
            DynamicObject taskWFtask = BusinessDataServiceHelper.newDynamicObject((String)"task_wftask");
            taskWFtask.set("taskhistoryid", (Object)taskId);
            taskWFtask.set("assignid", (Object)assignId);
            taskWFtask.set("processdefinitionid", (Object)processdefinitionid);
            taskWFtask.set("processinstanceid", (Object)processinstanceid);
            taskWFtask.set("taskdefinitionkey", (Object)taskdefinitionkey);
            taskWFtask.set("completetime", (Object)completeTime);
            log.info("\u8bb0\u5f55\u4efb\u52a1\u5de5\u4f5c\u6d41\u5173\u7cfb\u8868\uff0ctaskWFtask\uff1a{}", (Object)taskWFtask);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskWFtask});
        } else {
            log.info("\u8bb0\u5f55\u4efb\u52a1\u5de5\u4f5c\u6d41\u5173\u7cfb\u8868\uff0c\u67e5\u8be2\u5de5\u4f5c\u6d41\u4efb\u52a1\u4e3a\u7a7aassignid\uff1a{}", (Object)assignId);
        }
    }

    private static String getDecisionValue(long decisionItemId) {
        if (decisionItemId == 0L) {
            return null;
        }
        DynamicObject decisionItem = BusinessDataServiceHelper.loadSingleFromCache((String)"task_decisionitem", (String)"decisionvalue", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)decisionItemId)});
        return decisionItem.getString("decisionvalue");
    }

    public static ApproveService getApproveService() {
        QFilter qFilter1 = new QFilter("enable", "=", (Object)"1");
        QFilter qFilter2 = new QFilter("interfacename", "=", (Object)"ApproveService");
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"task_interfaceconfig", (String)"implementname", (QFilter[])new QFilter[]{qFilter1, qFilter2});
        if (collection.isEmpty()) {
            return null;
        }
        try {
            String value = (String)((DynamicObject)collection.get(0)).get("implementname");
            Class<?> aClass = Class.forName(value);
            return (ApproveService)aClass.newInstance();
        }
        catch (Exception e) {
            log.error("Error on instantiating ApproveService", (Throwable)e);
            throw TaskKDExcetptionUtil.createKDException((Throwable)e, (String)TaskErrorCodeEnum.C_REFLECT_EXCEPTION.getCode(), (String)ResManager.loadKDString((String)"\u53cd\u5c04ApproveService\u5b9e\u73b0\u7c7b\u5f02\u5e38\u3002", (String)"ExceptionTaskReflect_1", (String)"ssc-task-common", (Object[])new Object[0]), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendParTaskMessageIfNecessary(long hisTaskId) {
        DynamicObject hisTask = QueryServiceHelper.queryOne((String)"task_taskhistory", (String)"sourcetaskid,assignid", (QFilter[])new QFilter("id", "=", (Object)hisTaskId).toArray());
        try (MessagePublisher parTaskPub = PublisherFactory.getParTaskPub();){
            List msgList = new ParTaskNodeServiceImpl().getNextNodeMsg(hisTask.getLong("sourcetaskid"), hisTask.getLong("assignid"));
            if (msgList != null) {
                for (ParTaskMessage msg : msgList) {
                    parTaskPub.publish((Object)msg);
                }
            }
        }
    }
}

