/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.common.quality;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.task.business.task.TaskQcPendingRecordHelper;

public class QualityTaskHelper {
    public static Object saveQualityHistoryTask(long taskId) {
        Object newTaskId = QualityTaskHelper.insertQualityTaskHistory(taskId);
        if (newTaskId == null) {
            return null;
        }
        HashMap<String, Object> changeData = new HashMap<String, Object>();
        changeData.put("newtaskid", newTaskId);
        QualityTaskHelper.updateMessageRecord(taskId, changeData);
        QualityTaskHelper.updateAttachmentsRecord(taskId, changeData);
        TaskQcPendingRecordHelper.updatePendingRecordToHistory((Long)taskId, (Long)((Long)newTaskId));
        QualityTaskHelper.deleteCompleteTask(taskId);
        return newTaskId;
    }

    public static Object insertQualityTaskHistory(long taskId) {
        QFilter fiterTaskId = new QFilter("id", "=", (Object)taskId);
        QFilter fiterPoolType = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.COMPLETE.getValue());
        String selectFields = "id,billno,resttime,billnumber,orgid,usergroup,costwaittime,billtype,tasktypeid,sscid,creator,subject,state,innermsg,apprevalmessage,taskcreatetime,imageuploadtime,receivetime,completetime,personid,tasklevelid,imageok,flagmsg,autoprocess,pooltype,expirestate,bizdata_tag,billid,procinstid,coefficient,unpassreasondesc,qualitysamplelibrary,qualitystate,orignalperson,reformperson,qualityresult,qualitychecktime,sysbillid,multistate,level,extenderp,source,auditor,assignid,oldtaskstate,recyclestate,unpassreasonid,info,consignerid,flowbackstgid,waittime,pausewaittime,rescanwaittime,allocatecount,islastaudit,hasallocated,createruleid,imagenumber,reverseoprt,oprt,orglongnumber,sourcetaskid,autoprocessforcheck,matchrule,firstreceivetime,firstcostwaittime,billlongid";
        DynamicObject taskData = BusinessDataServiceHelper.loadSingle((String)"task_task", (String)selectFields, (QFilter[])new QFilter[]{fiterTaskId, fiterPoolType});
        DynamicObject historyTask = BusinessDataServiceHelper.newDynamicObject((String)"task_taskhistory");
        historyTask.set("sourcetaskid", taskData.get("sourcetaskid"));
        historyTask.set("subject", taskData.get("subject"));
        historyTask.set("billno", taskData.get("billno"));
        historyTask.set("state", taskData.get("state"));
        historyTask.set("innermsg", taskData.get("innermsg"));
        historyTask.set("billnumber", taskData.get("billnumber"));
        historyTask.set("apprevalmessage", taskData.get("apprevalmessage"));
        historyTask.set("completetime", (Object)new Date());
        historyTask.set("receivetime", taskData.get("receivetime"));
        historyTask.set("firstreceivetime", taskData.get("firstreceivetime"));
        historyTask.set("personid", taskData.get("personid"));
        historyTask.set("usergroup", taskData.get("usergroup"));
        historyTask.set("tasklevelid", taskData.get("tasklevelid"));
        historyTask.set("imageok", taskData.get("imageok"));
        historyTask.set("flagmsg", taskData.get("flagmsg"));
        historyTask.set("autoprocess", taskData.get("autoprocess"));
        historyTask.set("pooltype", taskData.get("pooltype"));
        historyTask.set("expirestate", taskData.get("expirestate"));
        historyTask.set("creator", taskData.get("creator"));
        historyTask.set("sscid", taskData.get("sscid"));
        historyTask.set("tasktypeid", taskData.get("tasktypeid"));
        historyTask.set("billtype", taskData.get("billtype"));
        historyTask.set("orgid", taskData.get("orgid"));
        historyTask.set("createtime", taskData.get("taskcreatetime"));
        historyTask.set("taskcreatetime", taskData.get("taskcreatetime"));
        historyTask.set("imageuploadtime", taskData.get("imageuploadtime"));
        historyTask.set("costwaittime", taskData.get("costwaittime"));
        historyTask.set("firstcostwaittime", taskData.get("firstcostwaittime"));
        historyTask.set("resttime", taskData.get("resttime"));
        historyTask.set("bizdata_tag", taskData.get("bizdata_tag"));
        historyTask.set("billid", taskData.get("billid"));
        historyTask.set("billlongid", taskData.get("billlongid"));
        historyTask.set("procinstid", taskData.get("procinstid"));
        historyTask.set("coefficient", taskData.get("coefficient"));
        historyTask.set("unpassreasondesc", taskData.get("unpassreasondesc"));
        historyTask.set("qualitystate", taskData.get("qualitystate"));
        historyTask.set("qualitysamplelibrary", taskData.get("qualitysamplelibrary.id"));
        historyTask.set("orignalperson", taskData.get("orignalperson.id"));
        historyTask.set("reformperson", taskData.get("reformperson.id"));
        historyTask.set("qualityresult", taskData.get("qualityresult"));
        historyTask.set("qualitychecktime", taskData.get("qualitychecktime"));
        historyTask.set("sysbillid", taskData.get("sysbillid"));
        historyTask.set("multistate", taskData.get("multistate"));
        historyTask.set("level", taskData.get("level"));
        historyTask.set("extenderp", taskData.get("extenderp"));
        historyTask.set("source", taskData.get("source"));
        historyTask.set("auditor", taskData.get("auditor"));
        historyTask.set("assignid", taskData.get("assignid"));
        historyTask.set("oldtaskstate", taskData.get("oldtaskstate"));
        historyTask.set("recyclestate", taskData.get("recyclestate"));
        historyTask.set("unpassreasonid", taskData.get("unpassreasonid"));
        historyTask.set("info", taskData.get("info"));
        historyTask.set("consignerid", taskData.get("consignerid"));
        historyTask.set("flowbackstgid", taskData.get("flowbackstgid"));
        historyTask.set("waittime", taskData.get("waittime"));
        historyTask.set("pausewaittime", (Object)taskData.getDate("pausewaittime"));
        historyTask.set("rescanwaittime", (Object)taskData.getDate("rescanwaittime"));
        historyTask.set("allocatecount", taskData.get("allocatecount"));
        historyTask.set("islastaudit", taskData.get("islastaudit"));
        historyTask.set("hasallocated", taskData.get("hasallocated"));
        historyTask.set("createruleid", taskData.get("createruleid"));
        historyTask.set("imagenumber", taskData.get("imagenumber"));
        historyTask.set("reverseoprt", taskData.get("reverseoprt"));
        historyTask.set("oprt", taskData.get("oprt"));
        historyTask.set("orglongnumber", taskData.get("orglongnumber"));
        historyTask.set("autoprocessforcheck", taskData.get("autoprocessforcheck"));
        historyTask.set("matchrule", taskData.get("matchrule"));
        Object[] ret = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{historyTask});
        if (ret != null && ret.length > 0) {
            DynamicObject newTask = (DynamicObject)ret[0];
            return newTask.getPkValue();
        }
        return null;
    }

    public static boolean updateMessageRecord(long taskId, Map<String, Object> changeData) {
        DynamicObject[] checkRecords;
        if (changeData == null) {
            return false;
        }
        Object newTaskId = changeData.get("newtaskid");
        QFilter filterTaskId = new QFilter("qualitycheck", "=", (Object)taskId);
        for (DynamicObject item : checkRecords = BusinessDataServiceHelper.load((String)"task_qualitymessagerecord", (String)"point,qualitycheck, entryentity.message,entryentity.datetime,entryentity.messagetype,entryentity.usercheck", (QFilter[])new QFilter[]{filterTaskId})) {
            item.set("qualitycheck", newTaskId);
        }
        Object[] ret = SaveServiceHelper.save((DynamicObject[])checkRecords);
        return ret != null && ret.length > 0;
    }

    public static boolean updateAttachmentsRecord(long taskId, Map<String, Object> changeData) {
        DynamicObject[] attachements;
        if (changeData == null) {
            return false;
        }
        Object newTaskId = changeData.get("newtaskid");
        QFilter filterTaskId = new QFilter("taskid", "=", (Object)taskId);
        for (DynamicObject item : attachements = BusinessDataServiceHelper.load((String)"task_qcattachment", (String)"id,taskid,pointid", (QFilter[])new QFilter[]{filterTaskId})) {
            item.set("taskid", newTaskId);
        }
        Object[] ret = SaveServiceHelper.save((DynamicObject[])attachements);
        return ret != null && ret.length > 0;
    }

    public static boolean deleteCompleteTask(long taskId) {
        QFilter fiterTaskId = new QFilter("id", "=", (Object)taskId);
        QFilter fiterPoolType = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.COMPLETE.getValue());
        int ret = DeleteServiceHelper.delete((String)"task_task", (QFilter[])new QFilter[]{fiterTaskId, fiterPoolType});
        return ret > 0;
    }
}

