/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.common.smartscheme;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.task.common.TaskFilterEnum;
import kd.ssc.task.common.smartscheme.TaskAITrainDTO;

public class TrainDataUtil {
    private static final Log logger = LogFactory.getLog(TrainDataUtil.class);
    private static final long bizSys = 427215148743160832L;
    private static final String taskhistory = "task_taskhistory";
    private static final String tripreqbill = "er_tripreqbill";
    private static final String dailyloanbill = "er_dailyloanbill";
    private static final String dailyreimbursebill = "er_dailyreimbursebill";
    private static final String tripreimbursebill = "er_tripreimbursebill";
    private static final String marketaccountbill = "market_account_bill";
    private static final String channelaccountbill = "channel_account_bill";
    private static final String paymentbill = "task_paymentbill";
    private static final Set<String> validBills = new LinkedHashSet<String>(Arrays.asList("er_tripreqbill", "er_dailyloanbill", "er_dailyreimbursebill", "er_tripreimbursebill", "market_account_bill", "channel_account_bill"));

    public static List<TaskAITrainDTO> getData() {
        Calendar endTime = Calendar.getInstance();
        endTime.add(5, 1);
        endTime.set(11, 0);
        endTime.set(12, 0);
        endTime.set(13, 0);
        Calendar startTime = Calendar.getInstance();
        startTime.add(5, -2);
        startTime.set(11, 0);
        startTime.set(12, 0);
        startTime.set(13, 0);
        String selectQualityTask = "id,sourcetaskid,autoprocess,taskcreatetime,tasktypeid,billtype,billid,billnumber,creator,personid,sscid,reformperson,qualityresult";
        String orderByQualityTask = "completetime desc";
        QFilter qFilterQualityTask = new QFilter("qualitysamplelibrary", "!=", (Object)TaskFilterEnum.NOTQUACHECKTASK);
        qFilterQualityTask.and(new QFilter("completetime", ">", (Object)startTime.getTime()));
        qFilterQualityTask.and(new QFilter("completetime", "<", (Object)endTime.getTime()));
        qFilterQualityTask.and(new QFilter("billtype.externalerp", "=", (Object)427215148743160832L));
        qFilterQualityTask.and(new QFilter("state", "=", (Object)TaskStateEnum.QUA_CHECK_COMPLETED.getValue()));
        DynamicObject[] qualityTasks = BusinessDataServiceHelper.load((String)taskhistory, (String)selectQualityTask, (QFilter[])qFilterQualityTask.toArray(), (String)orderByQualityTask, (int)10000);
        if (qualityTasks == null || qualityTasks.length == 0) {
            return null;
        }
        logger.info("\u63a8\u9001\u667a\u80fd\u8d28\u68c0\u8bad\u7ec3\u6570\u636e\uff0c\u5171\u63a8\u9001\u8d28\u68c0\u4efb\u52a1\u6570:" + qualityTasks.length);
        HashMap sTaskDtos = new HashMap(10);
        HashSet sourceTaskIds = new HashSet(10);
        HashMap<String, List> allBills = new HashMap<String, List>(16);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMM");
        Arrays.stream(qualityTasks).forEach(qTask -> {
            String billNumber = qTask.getString("billtype.bindbill.number");
            ArrayList<Long> billIds = (ArrayList<Long>)allBills.get(billNumber);
            if (billIds == null) {
                billIds = new ArrayList<Long>(10);
                allBills.put(billNumber, billIds);
            }
            Long billId = qTask.getLong("billid");
            billIds.add(billId);
            TaskAITrainDTO dto = TaskAITrainDTO.builder().id(qTask.getPkValue() + "").record_num(qTask.getString("billnumber")).record_type(qTask.getString("billtype.bindbill.name")).billNumber(qTask.getString("billtype.bindbill.number")).billId(qTask.getString("billid")).create_month(Integer.parseInt(formatter.format(qTask.get("taskcreatetime")))).label("1".equals(qTask.get("qualityresult")) ? "true" : "false").project("").sum("").nums("").organization("").job("").department("").credit_score("").build();
            Object sourcetaskId = qTask.get("sourcetaskid");
            sourceTaskIds.add(sourcetaskId);
            ArrayList<TaskAITrainDTO> trainDtos = (ArrayList<TaskAITrainDTO>)sTaskDtos.get(sourcetaskId);
            if (trainDtos == null) {
                trainDtos = new ArrayList<TaskAITrainDTO>(10);
                sTaskDtos.put(sourcetaskId, trainDtos);
            }
            trainDtos.add(dto);
        });
        QFilter ifReturnFilter = new QFilter("jobid", "in", sourceTaskIds);
        ifReturnFilter.and("newjobstate", "=", (Object)TaskStateEnum.PAUSE.getValue());
        DataSet isRepulseDs = QueryServiceHelper.queryDataSet((String)"TrainDataUtil.getData#ifReturn", (String)"task_statechangehis", (String)"id,newjobstate,jobid", (QFilter[])new QFilter[]{ifReturnFilter}, null).groupBy(new String[]{"jobid"}).count("repulse").finish();
        HashMap<Object, String> ifReturn = new HashMap<Object, String>(16);
        for (Row row : isRepulseDs) {
            ifReturn.put(row.get("jobid"), row.getInteger("repulse") > 0 ? "true" : "false");
        }
        DynamicObject[] sourceTasks = BusinessDataServiceHelper.load((Object[])sourceTaskIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)taskhistory));
        HashMap<String, List> creatorPersonDtos = new HashMap<String, List>(16);
        HashSet<Long> creatorIds = new HashSet<Long>(10);
        HashSet<Object> personIds = new HashSet<Object>(10);
        Arrays.stream(sourceTasks).forEach(sTask -> {
            List dtosOfSourceTask = (List)sTaskDtos.get(sTask.getPkValue());
            String department = "";
            String job = "";
            DynamicObjectCollection creator = sTask.getDynamicObjectCollection("creator.entryentity");
            for (DynamicObject entity : creator) {
                if (entity.getBoolean("ispartjob")) continue;
                department = entity.get("dpt") != null ? entity.get("dpt.name") + "" : "";
                job = entity.get("position") != null ? entity.get("position") + "" : "";
                break;
            }
            for (TaskAITrainDTO dto : dtosOfSourceTask) {
                dto.setDepartment(department);
                dto.setJob(job);
                dto.setUser(sTask.get("usergroup") != null ? sTask.get("usergroup.name") + "" : "");
                dto.setIf_exemption(sTask.getString("autoprocess"));
                dto.setTask_type(sTask.getString("tasktypeid.name"));
                dto.setIf_return(ifReturn.get(sTask.getPkValue()) != null ? (String)ifReturn.get(sTask.getPkValue()) : "false");
            }
            creatorIds.add(sTask.getLong("creator.id"));
            personIds.add(sTask.get("personid.id"));
            String key = sTask.getString("creator.id") + "#" + sTask.get("sscid.id") + "#" + sTask.get("personid.id");
            ArrayList dtosOf = (ArrayList)creatorPersonDtos.get(key);
            if (dtosOf == null) {
                dtosOf = new ArrayList(10);
                creatorPersonDtos.put(key, dtosOf);
            }
            dtosOf.addAll(dtosOfSourceTask);
        });
        sTaskDtos.clear();
        List creatorOrgIds = UserServiceHelper.getUserMainOrgIds(new ArrayList(creatorIds));
        DataSet orgDs = QueryServiceHelper.queryDataSet((String)"TrainDataUtil.getData#organization2", (String)"bos_org", (String)"id,orgpattern.name orgpattern", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)creatorOrgIds)}, null);
        QFilter creatorFilter = new QFilter("id", "in", creatorIds);
        creatorFilter.and(new QFilter("entryentity.ispartjob", "=", (Object)Boolean.FALSE));
        DataSet creatorDs = QueryServiceHelper.queryDataSet((String)"TrainDataUtil.getData#organization", (String)"bos_user", (String)"id,entryentity.dpt as dptid", (QFilter[])new QFilter[]{creatorFilter}, null);
        DataSet orgResultDs = creatorDs.join(orgDs).on("dptid", "id").select(new String[]{"id", "dptid"}, new String[]{"orgpattern"}).finish();
        HashMap<String, String> orgPatternMap = new HashMap<String, String>(16);
        for (Row row : orgResultDs) {
            orgPatternMap.put(row.getString("id"), row.getString("orgpattern"));
        }
        orgResultDs.close();
        DynamicObjectCollection creditValOfCreator = TrainDataUtil.getCreditValOfCreator(creatorIds);
        Map<String, Integer> extractNumMap = TrainDataUtil.getExtractNumMap(creatorIds);
        Map<String, Integer> shareNumMap = TrainDataUtil.getShareNumMap(personIds);
        Map<Object, String> accuracyPersons = TrainDataUtil.getAccuracyPersons(personIds);
        HashMap billDtos = new HashMap(16);
        creatorPersonDtos.forEach((key, dtosOf) -> {
            String creatorId = key.split("#")[0];
            String personId = key.split("#")[2];
            dtosOf.forEach(dto -> dto.setOrganization((String)orgPatternMap.get(creatorId)));
            for (DynamicObject val : creditValOfCreator) {
                String keyLike = val.getString("user") + "#";
                if (!key.contains(keyLike)) continue;
                dtosOf.forEach(dto -> dto.setCredit_score(val.get("creditvalue") != null ? val.getString("creditvalue") : ""));
                break;
            }
            dtosOf.forEach(dto -> dto.setExtract_num((Integer)extractNumMap.get(creatorId)));
            dtosOf.forEach(dto -> dto.setShare_num((Integer)shareNumMap.get(personId)));
            for (Map.Entry entry : accuracyPersons.entrySet()) {
                String checkNum = (String)entry.getValue();
                String keyLike = "#" + entry.getKey();
                BigDecimal accuracy = new BigDecimal(checkNum.split("#")[1]).divide(new BigDecimal(checkNum.split("#")[0]), 2, 4);
                if (!key.contains(keyLike)) continue;
                dtosOf.forEach(dto -> {
                    dto.setAccuracy(accuracy);
                    String billDtoKey = dto.getBillNumber() + "#" + dto.getBillId();
                    ArrayList<TaskAITrainDTO> dtosOfBill = (ArrayList<TaskAITrainDTO>)billDtos.get(billDtoKey);
                    if (dtosOfBill == null) {
                        dtosOfBill = new ArrayList<TaskAITrainDTO>(10);
                        billDtos.put(billDtoKey, dtosOfBill);
                    }
                    dtosOfBill.add((TaskAITrainDTO)dto);
                });
                break;
            }
        });
        creatorPersonDtos.clear();
        shareNumMap.clear();
        orgPatternMap.clear();
        extractNumMap.clear();
        ArrayList<TaskAITrainDTO> dtos = new ArrayList<TaskAITrainDTO>(10);
        allBills.forEach((billNumber, billIds) -> {
            if (validBills.contains(billNumber)) {
                DynamicObject[] bills = BusinessDataServiceHelper.load((Object[])billIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)billNumber));
                Arrays.stream(bills).forEach(bill -> {
                    String key = billNumber + "#" + bill.getPkValue();
                    List dtosOf = (List)billDtos.get(key);
                    if (dtosOf != null) {
                        billDtos.remove(key);
                        int nums = 0;
                        double sums = 0.0;
                        switch (billNumber) {
                            case "er_tripreqbill": {
                                DynamicObjectCollection entry = bill.getDynamicObjectCollection("caspayentry");
                                nums += bill.getDynamicObjectCollection("tripentry").size();
                                nums += bill.getDynamicObjectCollection("accountentry").size();
                                nums += entry.size();
                                if (entry.size() <= 0) break;
                                sums = entry.stream().mapToDouble(item -> item.get("dpamt") != null ? item.getBigDecimal("dpamt").doubleValue() : 0.0).sum();
                                break;
                            }
                            case "er_dailyloanbill": {
                                DynamicObjectCollection entry = bill.getDynamicObjectCollection("expenseentryentity");
                                nums += entry.size();
                                nums += bill.getDynamicObjectCollection("accountentry").size();
                                nums += bill.getDynamicObjectCollection("caspayentry").size();
                                if (entry.size() <= 0) break;
                                sums = entry.stream().mapToDouble(item -> item.get("expenseamount") != null ? item.getBigDecimal("expenseamount").doubleValue() : 0.0).sum();
                                break;
                            }
                            case "er_dailyreimbursebill": {
                                DynamicObjectCollection entry = bill.getDynamicObjectCollection("expenseentryentity");
                                nums += entry.size();
                                nums += bill.getDynamicObjectCollection("invoiceentry").size();
                                nums += bill.getDynamicObjectCollection("writeoffmoney").size();
                                nums += bill.getDynamicObjectCollection("writeoffapply").size();
                                nums += bill.getDynamicObjectCollection("accountentry").size();
                                nums += bill.getDynamicObjectCollection("caspayentry").size();
                                nums += bill.getDynamicObjectCollection("invoiceitementry").size();
                                if (entry.size() <= 0) break;
                                sums = entry.stream().mapToDouble(item -> item.get("expenseamount") != null ? item.getBigDecimal("expenseamount").doubleValue() : 0.0).sum();
                                break;
                            }
                            case "er_tripreimbursebill": {
                                nums += bill.getDynamicObjectCollection("tripentry").size();
                                nums += bill.getDynamicObjectCollection("invoiceentry").size();
                                nums += bill.getDynamicObjectCollection("clearloanentry").size();
                                nums += bill.getDynamicObjectCollection("accountentry").size();
                                nums += bill.getDynamicObjectCollection("caspayentry").size();
                                DynamicObjectCollection entry = bill.getDynamicObjectCollection("invoiceitementry");
                                nums += entry.size();
                                if (entry.size() <= 0) break;
                                sums = entry.stream().mapToDouble(item -> item.get("excludeamount") != null ? item.getBigDecimal("excludeamount").doubleValue() : 0.0).sum();
                                break;
                            }
                            case "market_account_bill": {
                                nums += bill.getDynamicObjectCollection("invoiceentity").size();
                                nums += bill.getDynamicObjectCollection("entryentity").size();
                                nums += bill.getDynamicObjectCollection("paymentdetail").size();
                                DynamicObjectCollection entry = bill.getDynamicObjectCollection("amountdetail");
                                nums += entry.size();
                                if (entry.size() <= 0) break;
                                sums = entry.stream().mapToDouble(item -> item.get("amount") != null ? item.getBigDecimal("amount").doubleValue() : 0.0).sum();
                                break;
                            }
                            case "channel_account_bill": {
                                nums += bill.getDynamicObjectCollection("invoiceentity").size();
                                nums += bill.getDynamicObjectCollection("paymentdetail").size();
                                DynamicObjectCollection entry = bill.getDynamicObjectCollection("amountdetail");
                                nums += entry.size();
                                if (entry.size() <= 0) break;
                                sums = entry.stream().mapToDouble(item -> item.get("amount") != null ? item.getBigDecimal("amount").doubleValue() : 0.0).sum();
                                break;
                            }
                            case "task_paymentbill": {
                                DynamicObjectCollection entry = bill.getDynamicObjectCollection("entries");
                                nums += entry.size();
                                if (entry.size() <= 0) break;
                                sums = entry.stream().mapToDouble(item -> item.get("accountmoney") != null ? item.getBigDecimal("accountmoney").doubleValue() : 0.0).sum();
                                break;
                            }
                        }
                        if (nums > 0 || sums > 0.0) {
                            int finalNums = nums;
                            double finalSum = sums;
                            dtosOf.forEach(dto -> {
                                if (finalNums > 0) {
                                    dto.setNums(finalNums + "");
                                }
                                if (finalSum > 0.0) {
                                    dto.setSum(finalSum + "");
                                }
                            });
                        }
                        billDtos.put(key, dtosOf);
                    }
                });
            }
        });
        billDtos.values().forEach(value -> value.forEach(dto -> {
            dto.setBillId(null);
            dto.setBillNumber(null);
            dtos.add((TaskAITrainDTO)dto);
        }));
        logger.info("\u63a8\u9001\u667a\u80fd\u8d28\u68c0\u8bad\u7ec3\u6570\u636e\uff0c\u5b9e\u9645\u63a8\u9001\u6570\u636e\u6570 :" + dtos.size());
        return dtos;
    }

    public static Map<Object, String> getAccuracyPersons(Set<Object> personIds) {
        QFilter filterAccuracy = new QFilter("personid", "in", personIds);
        filterAccuracy.and(new QFilter("qualitysamplelibrary", "!=", (Object)TaskFilterEnum.NOTQUACHECKTASK));
        DynamicObjectCollection accuracyBaseData = QueryServiceHelper.query((String)taskhistory, (String)"id,personid,qualitystate,state,reformperson,qualityresult", (QFilter[])filterAccuracy.toArray(), (String)"completetime desc", (int)50);
        HashMap<Object, String> accuracyPersons = new HashMap<Object, String>(16);
        accuracyBaseData.forEach(qTask -> {
            Object personId = qTask.get("personid");
            String checkNum = (String)accuracyPersons.get(personId);
            if (checkNum == null) {
                checkNum = "0#0";
            }
            int sum = Integer.parseInt(checkNum.split("#")[0]) + 1;
            int num = Integer.parseInt(checkNum.split("#")[1]);
            String state = qTask.getString("state");
            if (qTask.get("qualityresult").equals("1") && state.equals(TaskStateEnum.QUA_CHECK_COMPLETED.getValue())) {
                ++num;
            }
            checkNum = sum + "#" + num;
            accuracyPersons.put(personId, checkNum);
        });
        accuracyBaseData.clear();
        return accuracyPersons;
    }

    public static Map<String, Integer> getShareNumMap(Set<Object> personIds) {
        QFilter filterShareNum = new QFilter("personid", "in", personIds);
        filterShareNum.and(new QFilter("qualitysamplelibrary", "=", (Object)TaskFilterEnum.NOTQUACHECKTASK));
        DataSet shareNumDs = QueryServiceHelper.queryDataSet((String)"TrainDataUtil.getData#extractNum", (String)taskhistory, (String)"id,personid", (QFilter[])filterShareNum.toArray(), null).groupBy(new String[]{"personid"}).count("sharenum").finish();
        HashMap<String, Integer> shareNumMap = new HashMap<String, Integer>(16);
        for (Row row : shareNumDs) {
            shareNumMap.put(row.getString("personid"), row.getInteger("sharenum"));
        }
        shareNumDs.close();
        return shareNumMap;
    }

    public static Map<String, Integer> getExtractNumMap(Set<Long> creatorIds) {
        QFilter filterExtractNum = new QFilter("creator", "in", creatorIds);
        filterExtractNum.and(new QFilter("qualitysamplelibrary", "=", (Object)TaskFilterEnum.NOTQUACHECKTASK));
        DataSet extractNumDs = QueryServiceHelper.queryDataSet((String)"TrainDataUtil.getData#extractNum", (String)taskhistory, (String)"id,creator", (QFilter[])filterExtractNum.toArray(), null).groupBy(new String[]{"creator"}).count("extractnum").finish();
        HashMap<String, Integer> extractNumMap = new HashMap<String, Integer>(16);
        for (Row row : extractNumDs) {
            extractNumMap.put(row.getString("creator"), row.getInteger("extractnum"));
        }
        extractNumDs.close();
        return extractNumMap;
    }

    public static DynamicObjectCollection getCreditValOfCreator(Set<Long> creatorIds) {
        String selectCreditVal = "id,user,creditvalue";
        QFilter filterCreditVal = new QFilter("user", "in", creatorIds);
        return QueryServiceHelper.query((String)"task_creditfiles", (String)selectCreditVal, (QFilter[])filterCreditVal.toArray());
    }
}

