/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.common.workcalendar;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.task.common.workcalendar.WorkCalendarTaskUtil;
import kd.ssc.task.formplugin.pojo.workcalendar.DailyWorkPeriod;
import kd.ssc.task.util.DateUtil;
import kd.ssc.task.util.ObjectCloneUtil;
import kd.ssc.task.workcalendar.pojo.SimpleJob;

public class CalWorkDateUtil {
    private static final Log log = LogFactory.getLog(CalWorkDateUtil.class);
    private Map<String, List<DailyWorkPeriod>> userDailyWorkPeriodMap;
    Map<Long, String> timeZoneNumberCache = new HashMap<Long, String>();

    public static CalWorkDateUtil getInstance(long shareCenterId, Date startDate, Date endDate, String type) {
        return new CalWorkDateUtil(shareCenterId, startDate, endDate, type);
    }

    public CalWorkDateUtil(long shareCenterId, Date startDate, Date endDate, String type) {
        this.iniCalendar(shareCenterId, startDate, endDate, type);
    }

    private void iniCalendar(long centerId, Date startDate, Date endDate, String type) {
        QFilter filter = new QFilter("monthofyear", "in", WorkCalendarTaskUtil.getMonthOfYear(startDate, endDate));
        filter.and(new QFilter("sscId", "=", (Object)centerId));
        if (type.equals("user")) {
            filter.and(new QFilter("user", ">", (Object)0));
            filter.and(new QFilter("usergroup", ">", (Object)0));
        } else if (type.equals("group")) {
            filter.and(new QFilter("user", "=", (Object)0));
            filter.and(new QFilter("usergroup", ">", (Object)0));
        } else if (type.equals("ssc")) {
            filter.and(new QFilter("user", "=", (Object)0));
            filter.and(new QFilter("usergroup", "=", (Object)0));
        }
        DynamicObjectCollection monthlyWorkPeriods = QueryServiceHelper.query((String)"ssc_userworkperiod", (String)"id,sscid,usergroup,user,monthofyear,monthlyworkperiod_tag", (QFilter[])filter.toArray(), (String)"monthofyear asc");
        Collection sortedDistinctWorkPeriods = monthlyWorkPeriods.stream().collect(Collectors.toMap(k -> k.getString("sscid") + k.getLong("monthofyear"), v -> v, (e1, e2) -> e1.getLong("id") > e2.getLong("id") ? e1 : e2)).values().stream().sorted(Comparator.comparingLong(a -> a.getLong("monthofyear"))).collect(Collectors.toList());
        this.userDailyWorkPeriodMap = new HashMap<String, List<DailyWorkPeriod>>(16);
        StringBuilder sBuilder = new StringBuilder();
        sortedDistinctWorkPeriods.forEach(monthlyPeriod -> {
            long sscId = monthlyPeriod.getLong("sscid");
            long userGroup = monthlyPeriod.getLong("usergroup");
            long userId = monthlyPeriod.getLong("user");
            Long monthOfYear = monthlyPeriod.getLong("monthofyear");
            List monthlyWorkPeriod = SerializationUtils.fromJsonStringToList((String)monthlyPeriod.getString("monthlyworkperiod_tag"), DailyWorkPeriod.class);
            sBuilder.append(sscId);
            if (userGroup > 0L) {
                sBuilder.append('-').append(userGroup);
            }
            if (userId > 0L) {
                sBuilder.append('-').append(userId);
            }
            String mapKey = sBuilder.toString();
            sBuilder.setLength(0);
            if (!this.userDailyWorkPeriodMap.containsKey(mapKey)) {
                this.userDailyWorkPeriodMap.put(mapKey, new ArrayList(10));
            }
            monthlyWorkPeriod.forEach(dailyPeriod -> {
                int day = dailyPeriod.getDay();
                sBuilder.append(monthOfYear);
                if (dailyPeriod.getDay() < 10) {
                    sBuilder.append('0');
                }
                sBuilder.append(day);
                day = Integer.parseInt(sBuilder.toString());
                dailyPeriod.setDay(day);
                this.userDailyWorkPeriodMap.get(mapKey).add((DailyWorkPeriod)dailyPeriod);
                sBuilder.setLength(0);
            });
        });
    }

    public long calWorkTime(SimpleJob simpleJob, Date receiveTime, Date now) {
        if (receiveTime == null || now == null || receiveTime.after(now)) {
            log.error("\u65f6\u95f4\u4e0d\u7b26\u5408");
            return 0L;
        }
        List<DailyWorkPeriod> dailyWorkPeriods = this.getDailyWorkPeriods(simpleJob);
        if (dailyWorkPeriods == null || dailyWorkPeriods.isEmpty()) {
            log.info("\u6ca1\u6709\u53d6\u5230\u5de5\u4f5c\u65e5\u5386");
            return 0L;
        }
        long shareCenterId = simpleJob.getShareCenterId();
        String timeZoneNumber = this.timeZoneNumberCache.get(shareCenterId);
        if (timeZoneNumber == null) {
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bos_org", (String)"timezone.number as timezone_number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)shareCenterId)});
            timeZoneNumber = dynamicObject.getString("timezone_number");
            if (timeZoneNumber == null) {
                timeZoneNumber = "";
            }
            this.timeZoneNumberCache.put(shareCenterId, timeZoneNumber);
        }
        if (StringUtils.isBlank((CharSequence)timeZoneNumber)) {
            log.info(String.format("\u5f53\u524d\u5171\u4eab\u4e2d\u5fc3\uff08%s\uff09\u672a\u8bbe\u7f6e\u65f6\u533a\u3002\u4f7f\u7528\u7cfb\u7edf\u65f6\u533a\u3002", shareCenterId));
        }
        receiveTime = DateUtil.changeTimeZone((Date)receiveTime, (String)timeZoneNumber);
        now = DateUtil.changeTimeZone((Date)now, (String)timeZoneNumber);
        String startDate = DateUtil.format((Object)receiveTime, (String)"yyyyMMdd HHmm");
        int startDay = Integer.parseInt(startDate.split(" ")[0]);
        int startTime = Integer.parseInt(startDate.split(" ")[1]);
        String endDate = DateUtil.format((Object)now, (String)"yyyyMMdd HHmm");
        int endDay = Integer.parseInt(endDate.split(" ")[0]);
        int endTime = Integer.parseInt(endDate.split(" ")[1]);
        long totalWorkMinutes = 0L;
        for (DailyWorkPeriod dailyWorkPeriod : dailyWorkPeriods) {
            List<Map<String, Integer>> workPeriodsBak;
            int day = dailyWorkPeriod.getDay();
            if (startDay > day || day > endDay || (workPeriodsBak = this.clonePeriod(dailyWorkPeriod.getWorkPeriods())).isEmpty()) continue;
            if (day == startDay) {
                workPeriodsBak = this.getStartDayWorkPeriod(startTime, workPeriodsBak);
            }
            if (workPeriodsBak != null && day == endDay) {
                workPeriodsBak = this.getEndDayWorkPeriod(endTime, workPeriodsBak);
            }
            if (workPeriodsBak == null) continue;
            totalWorkMinutes += (long)workPeriodsBak.stream().mapToInt(period -> WorkCalendarTaskUtil.getMinutes(period.get("start") + "", period.get("end") + "")).sum();
        }
        return totalWorkMinutes;
    }

    public List<DailyWorkPeriod> getDailyWorkPeriods(SimpleJob simpleJob) {
        StringBuilder sBuilder = new StringBuilder();
        long sscId = simpleJob.getShareCenterId();
        long userGroup = simpleJob.getUserGroupId();
        long userId = simpleJob.getPersonId();
        sBuilder.append(sscId);
        if (userGroup > 0L) {
            sBuilder.append('-').append(userGroup);
        }
        if (userId > 0L) {
            sBuilder.append('-').append(userId);
        }
        return this.userDailyWorkPeriodMap.get(sBuilder.toString());
    }

    public List<Map<String, Integer>> getStartDayWorkPeriod(int startTime, List<Map<String, Integer>> workPeriods) {
        Collections.sort(workPeriods, new Comparator<Map<String, Integer>>(){

            @Override
            public int compare(Map<String, Integer> o1, Map<String, Integer> o2) {
                return o1.get("start").compareTo(o2.get("start"));
            }
        });
        Map<String, Integer> firstPeriodsOfDay = workPeriods.get(0);
        Map<String, Integer> lastPeriodsOfDay = workPeriods.get(workPeriods.size() - 1);
        if (startTime > lastPeriodsOfDay.get("end")) {
            return null;
        }
        if (startTime >= firstPeriodsOfDay.get("start")) {
            int len = workPeriods.size();
            for (int i = 0; i < len; ++i) {
                Map<String, Integer> period = workPeriods.get(i);
                int start = period.get("start");
                int end = period.get("end");
                if (startTime > end) {
                    workPeriods.remove(period);
                    --i;
                    len = workPeriods.size();
                    continue;
                }
                if (startTime < start) continue;
                workPeriods.get(i).put("start", startTime);
            }
        }
        return workPeriods;
    }

    private List<Map<String, Integer>> getEndDayWorkPeriod(int endTime, List<Map<String, Integer>> workPeriods) {
        Collections.sort(workPeriods, new Comparator<Map<String, Integer>>(){

            @Override
            public int compare(Map<String, Integer> o1, Map<String, Integer> o2) {
                return o1.get("start").compareTo(o2.get("start"));
            }
        });
        Map<String, Integer> firstPeriodsOfDay = workPeriods.get(0);
        Map<String, Integer> lastPeriodsOfDay = workPeriods.get(workPeriods.size() - 1);
        if (endTime < firstPeriodsOfDay.get("start")) {
            return null;
        }
        if (endTime <= lastPeriodsOfDay.get("end")) {
            int len = workPeriods.size();
            for (int i = 0; i < len; ++i) {
                Map<String, Integer> period = workPeriods.get(i);
                int start = period.get("start");
                int end = period.get("end");
                if (endTime < start) {
                    workPeriods.remove(period);
                    --i;
                    len = workPeriods.size();
                    continue;
                }
                if (endTime > end) continue;
                workPeriods.get(i).put("end", endTime);
            }
        }
        return workPeriods;
    }

    public int getWorkMinutesOfSomeDay(List<DailyWorkPeriod> dailyWorkPeriods, Date startTime, int dayNum) {
        int totalWorkMinutes = 0;
        if (dailyWorkPeriods != null && !dailyWorkPeriods.isEmpty()) {
            String startDate = DateUtil.format((Object)startTime, (String)"yyyyMMdd HHmm");
            int day = Integer.parseInt(startDate.split(" ")[0]);
            int time = Integer.parseInt(startDate.split(" ")[1]);
            int size = dailyWorkPeriods.size();
            if (size > dayNum) {
                size = dayNum;
            }
            for (DailyWorkPeriod dailyWorkPeriod : dailyWorkPeriods) {
                int theDay = dailyWorkPeriod.getDay();
                if (day > theDay || size < 1) continue;
                --size;
                List<Map<String, Integer>> workPeriodsBak = this.clonePeriod(dailyWorkPeriod.getWorkPeriods());
                if (day == theDay) {
                    workPeriodsBak = this.getStartDayWorkPeriod(time, workPeriodsBak);
                }
                if (workPeriodsBak == null) continue;
                totalWorkMinutes += workPeriodsBak.stream().mapToInt(period -> WorkCalendarTaskUtil.getMinutes(period.get("start") + "", period.get("end") + "")).sum();
            }
        }
        return totalWorkMinutes;
    }

    public Date getNextWorkTime(List<DailyWorkPeriod> dailyWorkPeriods, Date startDate, int waitMin) {
        if (dailyWorkPeriods == null || dailyWorkPeriods.isEmpty()) {
            return startDate;
        }
        int totalWorkMinutes = 0;
        String date = DateUtil.format((Object)startDate, (String)"yyyyMMdd HHmm");
        int startDay = Integer.parseInt(date.split(" ")[0]);
        int startTime = Integer.parseInt(date.split(" ")[1]);
        String theDay = "";
        Map<Object, Object> thePeriod = new HashMap(2);
        boolean flag = true;
        block2: for (DailyWorkPeriod dailyWorkPeriod : dailyWorkPeriods) {
            if (!flag) break;
            int day = dailyWorkPeriod.getDay();
            if (day < startDay) continue;
            List<Map<String, Integer>> workPeriodsBak = this.clonePeriod(dailyWorkPeriod.getWorkPeriods());
            if (day == startDay) {
                workPeriodsBak = this.getStartDayWorkPeriod(startTime, workPeriodsBak);
            }
            if (workPeriodsBak == null) continue;
            for (Map<String, Integer> period : workPeriodsBak) {
                if ((totalWorkMinutes += WorkCalendarTaskUtil.getMinutes(period.get("start") + "", period.get("end") + "")) <= waitMin) continue;
                theDay = day + "";
                thePeriod = period;
                flag = false;
                continue block2;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)theDay)) {
            int overMin = totalWorkMinutes - waitMin;
            String time = WorkCalendarTaskUtil.getTimes(thePeriod.get("end") + "", overMin, "down") + "";
            while (time.length() < 4) {
                time = "0" + time;
            }
            theDay = theDay + time;
            try {
                return DateUtil.parse((String)theDay, (String)"yyyyMMddHHmm");
            }
            catch (ParseException e) {
                log.error("kd.ssc.task.common.workcalendar.CalWorkDateUtil.getNextWorkTime,\u65f6\u95f4\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            }
        }
        return startDate;
    }

    private List<Map<String, Integer>> clonePeriod(List<Map<String, Integer>> workPeriods) {
        ArrayList<Map<String, Integer>> workPeriodsBak = new ArrayList<Map<String, Integer>>(10);
        workPeriods.forEach(period -> workPeriodsBak.add((Map)ObjectCloneUtil.cloneObject((Object)period)));
        return workPeriodsBak;
    }
}

