/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.common.workcalendar;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.ssc.enums.workcalendar.SscDateType;
import kd.ssc.enums.workcalendar.SscLevelType;
import kd.ssc.enums.workcalendar.SscTimeType;
import kd.ssc.exception.ExceptionPlatformUtil;
import kd.ssc.task.formplugin.pojo.PersonInfo;
import kd.ssc.task.formplugin.pojo.workcalendar.DailyWorkPeriod;
import kd.ssc.task.formplugin.util.SscWorkCalendarLoadService;
import kd.ssc.task.formplugin.util.SscWorkCalendarUtil;
import kd.ssc.task.util.DateUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class SscWorkCalendarApi {
    private static final Log log = LogFactory.getLog(SscWorkCalendarApi.class);

    public static List<PersonInfo> getPersonWorkList(String orgId, String groupId) {
        List<PersonInfo> list = SscWorkCalendarLoadService.getUserListByGroupId(groupId);
        String timeZoneNumber = "";
        if (CollectionUtils.isNotEmpty(list)) {
            timeZoneNumber = list.get(0).getTimeZoneNumber();
        }
        Map<Long, Boolean> map = SscWorkCalendarApi.isPersonsWork(orgId, groupId, timeZoneNumber);
        if (list != null && list.size() > 0 && map != null && map.size() > 0) {
            for (PersonInfo p : list) {
                Boolean aBoolean = map.get(p.getUid());
                if (aBoolean == null) {
                    aBoolean = false;
                }
                p.setWorkStatus(aBoolean);
            }
        }
        return list;
    }

    @Deprecated
    public static Map<Long, Boolean> isPersonsWork(String orgId, String groupId) {
        return SscWorkCalendarApi.isPersonsWork(orgId, groupId, null);
    }

    public static Map<Long, Boolean> isPersonsWork(String orgId, String groupId, String timeZoneNumber) {
        SimpleDateFormat SDFTIME = new SimpleDateFormat("HH:mm");
        SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd");
        Calendar now = Calendar.getInstance();
        Date date = now.getTime();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{timeZoneNumber})) {
            now.setTimeZone(TimeZone.getTimeZone(timeZoneNumber));
            date = DateUtil.changeTimeZone((Date)date, (String)timeZoneNumber);
        }
        int hour = now.get(11);
        int minute = now.get(12);
        Date nowDate = null;
        Date nowTime = null;
        HashMap<Long, Boolean> map = null;
        List<Long> userIdList = null;
        try {
            userIdList = SscWorkCalendarLoadService.getUserIdList(groupId);
            if (userIdList == null || userIdList.size() == 0) {
                return map;
            }
            map = new HashMap<Long, Boolean>(16);
            nowDate = SDF.parse(SDF.format(date));
            nowTime = SDFTIME.parse(SscWorkCalendarUtil.getTimeShow(hour * 60 * 60 + minute * 60));
            DynamicObjectCollection sscCols = SscWorkCalendarApi.getData(orgId, null, nowDate, null);
            DynamicObjectCollection groupCols = SscWorkCalendarApi.getData(orgId, groupId, nowDate, null);
            DynamicObjectCollection userCols = SscWorkCalendarApi.getData(orgId, groupId, nowDate, userIdList);
            if (userCols != null && userCols.size() > 0) {
                Long userid;
                HashMap tempMap = new HashMap(16);
                ArrayList<DynamicObject> sublist = null;
                for (DynamicObject obj : userCols) {
                    userid = obj.getLong("dateentry.user");
                    if (tempMap.get(userid) != null) {
                        ((List)tempMap.get(userid)).add(obj);
                        continue;
                    }
                    sublist = new ArrayList<DynamicObject>(16);
                    sublist.add(obj);
                    tempMap.put(userid, sublist);
                }
                for (Map.Entry entry : tempMap.entrySet()) {
                    userid = (Long)entry.getKey();
                    List list = (List)entry.getValue();
                    Collections.sort(list, new Comparator<DynamicObject>(){

                        @Override
                        public int compare(DynamicObject o1, DynamicObject o2) {
                            return Long.compare(o1.getLong("dateentry.timeentry.id"), o2.getLong("dateentry.timeentry.id")) == 1 ? -1 : 0;
                        }
                    });
                    boolean isWork = false;
                    boolean belong = false;
                    for (DynamicObject obj : list) {
                        Date overTimeEnd;
                        Date overTimeStart;
                        if (belong) break;
                        int status = SscWorkCalendarApi.isWorkToGroupkOrSsc(nowTime, sscCols, groupCols);
                        if (status == 1) {
                            isWork = true;
                        }
                        String timeType = obj.getString("dateentry.timeentry.timetype");
                        if (SscTimeType.WORKTIME.getValue().equals(timeType)) {
                            Date amStart = SDFTIME.parse(obj.getString("dateentry.timeentry.begintimeam"));
                            Date amEnd = SDFTIME.parse(obj.getString("dateentry.timeentry.endtimeam"));
                            Date pmStart = SDFTIME.parse(obj.getString("dateentry.timeentry.begintimepm"));
                            Date pmEnd = SDFTIME.parse(obj.getString("dateentry.timeentry.endtimepm"));
                            boolean amf = SscWorkCalendarApi.belongTime(amStart, amEnd, nowTime);
                            boolean pmf = SscWorkCalendarApi.belongTime(pmStart, pmEnd, nowTime);
                            if (amf && pmf) {
                                isWork = true;
                                continue;
                            }
                            isWork = false;
                            continue;
                        }
                        if (SscTimeType.OFFTIME.getValue().equals(timeType)) {
                            Date offtimeEnd;
                            Date offtimeStart = SDFTIME.parse(obj.getString("dateentry.timeentry.begintimeam"));
                            belong = SscWorkCalendarApi.belongTime(offtimeStart, offtimeEnd = SDFTIME.parse(obj.getString("dateentry.timeentry.endtimeam")), nowTime);
                            if (!belong) continue;
                            isWork = false;
                            continue;
                        }
                        if (!SscTimeType.OVERTIME.getValue().equals(timeType) || !(belong = SscWorkCalendarApi.belongTime(overTimeStart = SDFTIME.parse(obj.getString("dateentry.timeentry.begintimeam")), overTimeEnd = SDFTIME.parse(obj.getString("dateentry.timeentry.endtimeam")), nowTime))) continue;
                        isWork = true;
                    }
                    map.put(userid, isWork);
                }
                if (tempMap.size() < userIdList.size()) {
                    ArrayList<Long> groupInit = new ArrayList<Long>(16);
                    if (map.size() > 0) {
                        for (Long user : userIdList) {
                            if (map.containsKey(user)) continue;
                            groupInit.add(user);
                        }
                    }
                    SscWorkCalendarApi.fillWorkMap(nowTime, map, groupInit, sscCols, groupCols);
                }
            } else {
                SscWorkCalendarApi.fillWorkMap(nowTime, map, userIdList, sscCols, groupCols);
            }
        }
        catch (Exception e) {
            log.error("Error on call isPersonsWork({}, {})", new Object[]{orgId, groupId, e});
            ExceptionPlatformUtil.saveErrorInfo((String)SscWorkCalendarApi.class.getName(), (String)"isPersonsWork", (String)String.format("orgId: %s, groupId: %s", orgId, groupId), (Throwable)e);
        }
        return map;
    }

    public static void fillWorkMap(Date nowTime, Map<Long, Boolean> map, List<Long> userIdList, DynamicObjectCollection sscCols, DynamicObjectCollection groupCols) throws ParseException {
        int status = SscWorkCalendarApi.isWorkToGroupkOrSsc(nowTime, sscCols, groupCols);
        if (status == -1) {
            return;
        }
        boolean isWork = false;
        if (status == 1) {
            isWork = true;
        }
        for (Long uid : userIdList) {
            map.put(uid, isWork);
        }
    }

    public static int isWorkToGroupkOrSsc(Date nowTime, DynamicObjectCollection sscCols, DynamicObjectCollection groupCols) throws ParseException {
        if (groupCols != null && groupCols.size() > 0) {
            return SscWorkCalendarApi.getIsWork(nowTime, groupCols);
        }
        if (sscCols == null || sscCols.size() <= 0) {
            return -1;
        }
        return SscWorkCalendarApi.getIsWork(nowTime, sscCols);
    }

    private static int getIsWork(Date nowTime, DynamicObjectCollection cols) throws ParseException {
        int isWork = 0;
        String datetype = ((DynamicObject)cols.get(0)).getString("dateentry.datetype");
        SimpleDateFormat SDFTIME = new SimpleDateFormat("HH:mm");
        for (DynamicObject obj : cols) {
            Date pmEnd;
            if (SscDateType.WORKDATE.getValue().equals(datetype)) {
                Date amStart = SDFTIME.parse(obj.getString("dateentry.timeentry.begintimeam"));
                Date amEnd = SDFTIME.parse(obj.getString("dateentry.timeentry.endtimeam"));
                Date pmStart = SDFTIME.parse(obj.getString("dateentry.timeentry.begintimepm"));
                Date pmEnd2 = SDFTIME.parse(obj.getString("dateentry.timeentry.endtimepm"));
                boolean amf = SscWorkCalendarApi.belongTime(amStart, amEnd, nowTime);
                boolean pmf = SscWorkCalendarApi.belongTime(pmStart, pmEnd2, nowTime);
                if (!amf && !pmf) break;
                isWork = 1;
                break;
            }
            if (SscDateType.HALFWORKDATEAM.getValue().equals(datetype)) {
                Date amEnd;
                Date amStart = SDFTIME.parse(obj.getString("dateentry.timeentry.begintimeam"));
                boolean amf = SscWorkCalendarApi.belongTime(amStart, amEnd = SDFTIME.parse(obj.getString("dateentry.timeentry.endtimeam")), nowTime);
                if (!amf) break;
                isWork = 1;
                break;
            }
            if (!SscDateType.HALFWORKDATEPM.getValue().equals(datetype)) continue;
            Date pmStart = SDFTIME.parse(obj.getString("dateentry.timeentry.begintimepm"));
            boolean pmf = SscWorkCalendarApi.belongTime(pmStart, pmEnd = SDFTIME.parse(obj.getString("dateentry.timeentry.endtimepm")), nowTime);
            if (!pmf) break;
            isWork = 1;
            break;
        }
        return isWork;
    }

    public static boolean belongTime(Date beginTime, Date endTime, Date nowTime) {
        Calendar date = Calendar.getInstance();
        date.setTime(nowTime);
        Calendar begin = Calendar.getInstance();
        begin.setTime(beginTime);
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        return date.compareTo(begin) >= 0 && date.compareTo(end) <= 0;
    }

    public static DynamicObjectCollection getData(String orgId, String groupId, Date nowDate, List<Long> userIdList) {
        QFilter filters = new QFilter("ssccenter", "=", (Object)NumberUtils.toLong((String)orgId, (long)-1L));
        if (groupId != null && (userIdList == null || userIdList.size() == 0)) {
            filters.and(new QFilter("dateentry.usergroup", "=", (Object)NumberUtils.toLong((String)groupId, (long)-1L)));
            filters.and(new QFilter("dateentry.level", "=", (Object)SscLevelType.GROUP.getValue()));
        } else if (groupId != null && userIdList != null && userIdList.size() > 0) {
            filters.and(new QFilter("dateentry.user", "in", userIdList));
            filters.and(new QFilter("dateentry.usergroup", "=", (Object)NumberUtils.toLong((String)groupId, (long)-1L)));
            filters.and(new QFilter("dateentry.level", "=", (Object)SscLevelType.EMPLOYEE.getValue()));
        } else {
            filters.and(new QFilter("dateentry.level", "=", (Object)SscLevelType.SSCCENTER.getValue()));
        }
        filters.and(new QFilter("dateentry.date", "=", (Object)nowDate));
        return QueryServiceHelper.query((String)"ssc_workcalendarsetting", (String)"id,dateentry.id,dateentry.level,dateentry.ssc,dateentry.usergroup,dateentry.datetype,dateentry.user,dateentry.timeentry.*", (QFilter[])new QFilter[]{filters});
    }

    @Deprecated
    public static Map<Long, Set<Long>> queryUserOnWork(Set<Long> userGroupIds) {
        return SscWorkCalendarApi.queryUserOnWork(userGroupIds, new Date());
    }

    public static Map<Long, Set<Long>> queryUserOnWork(Set<Long> userGroupIds, Date date) {
        if (CollectionUtils.isEmpty(userGroupIds)) {
            log.info("params exception: userGroupIds is empty.");
            return Collections.emptyMap();
        }
        HashMap<Long, Set<Long>> resultMap = new HashMap<Long, Set<Long>>(userGroupIds.size());
        Map.Entry dateEntryMap = DateUtil.convertInteger((Date)date);
        int yyyyMM = (Integer)dateEntryMap.getKey() / 100;
        int dd = (Integer)dateEntryMap.getKey() % 100;
        int hhMM = (Integer)dateEntryMap.getValue() / 100;
        QFilter ugidFilter = new QFilter("usergroup", "in", userGroupIds);
        QFilter uidFilter = new QFilter("user", ">", (Object)0);
        QFilter dateFilter = new QFilter("monthofyear", "=", (Object)yyyyMM);
        DynamicObjectCollection monthlyWorkPeriods = QueryServiceHelper.query((String)"ssc_userworkperiod", (String)"id,usergroup,user,monthlyworkperiod_tag", (QFilter[])new QFilter[]{ugidFilter, uidFilter, dateFilter});
        for (DynamicObject monthlyPeriod : monthlyWorkPeriods) {
            List<Map<String, Integer>> oneDayWorkPeriods;
            Optional<Map> optionalMap;
            Long ugid = monthlyPeriod.getLong("usergroup");
            Long uid = monthlyPeriod.getLong("user");
            List dailyWorkPeriods = SerializationUtils.fromJsonStringToList((String)monthlyPeriod.getString("monthlyworkperiod_tag"), DailyWorkPeriod.class);
            Optional<DailyWorkPeriod> optionalDwp = dailyWorkPeriods.stream().filter(p -> dd == p.getDay()).findFirst();
            if (!optionalDwp.isPresent() || !(optionalMap = (oneDayWorkPeriods = optionalDwp.get().getWorkPeriods()).stream().filter(m -> (Integer)m.get("start") <= hhMM && hhMM <= (Integer)m.get("end")).findFirst()).isPresent()) continue;
            resultMap.computeIfAbsent(ugid, p -> new HashSet()).add(uid);
        }
        return resultMap;
    }
}

