/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.common.workcalendar;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.enums.workcalendar.SscLevelType;
import kd.ssc.enums.workcalendar.SscTimeOp;
import kd.ssc.task.formplugin.pojo.workcalendar.WorkCalendarTaskMessage;
import kd.ssc.task.formplugin.util.SscWorkCalendarUtil;

public class WorkCalendarServiceHelper {
    private static final Log log = LogFactory.getLog(WorkCalendarServiceHelper.class);

    public static void updateUserWorkTime(Long sscid, Long userGroupId, Long userId, Date startDate, Date endDate, SscTimeOp timeOp, List<String> timeIntervals) {
        if (WorkCalendarServiceHelper.saveDb(sscid, userGroupId, userId, startDate, endDate, timeOp, timeIntervals)) {
            return;
        }
        WorkCalendarServiceHelper.sendMq(sscid, userGroupId, userId, startDate, endDate);
    }

    public static boolean saveDb(Long sscid, Long userGroupId, Long userId, Date startDate, Date endDate, SscTimeOp timeOp, List<String> timeIntervals) {
        try {
            String timeIntervalJson = CollectionUtils.isEmpty(timeIntervals) ? "" : JSONObject.toJSONString(timeIntervals);
            log.info("\u4fdd\u5b58\u5de5\u4f5c\u65e5\u5386\u5c55\u793a\u6570\u636e-\u6279\u91cf\u8bbe\u7f6estart: sscid = {}, userGroupId = {}, userId = {}, startDate = {}, endDate = {}, timeOp = {}, timeIntervals = {}", new Object[]{sscid, userGroupId, userId, startDate, endDate, timeOp, timeIntervalJson});
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u5de5\u4f5c\u65e5\u5386\u5c55\u793a\u6570\u636e-\u6279\u91cf\u8bbe\u7f6e\uff0c\u53c2\u6570\u65e5\u5fd7\u6253\u5370\u5f02\u5e38", (Throwable)e);
        }
        DynamicObject[] workCalenObjs = WorkCalendarServiceHelper.loadWorkCalendarDynObjs(sscid, startDate, endDate);
        HashMap<Date, DynamicObject> sscDateEntries = new HashMap<Date, DynamicObject>(8);
        HashMap<Date, DynamicObject> groupDateEntries = new HashMap<Date, DynamicObject>(8);
        HashMap<Date, DynamicObject> userDateEntries = new HashMap<Date, DynamicObject>(8);
        WorkCalendarServiceHelper.groupByLevel(workCalenObjs, sscDateEntries, groupDateEntries, userDateEntries, sscid, userGroupId, userId);
        if (sscDateEntries.isEmpty()) {
            log.info(String.format("sscDateEntries.size = %s, groupDateEntries.size = %s, userDateEntries.size = %s", sscDateEntries.size(), groupDateEntries.size(), userDateEntries.size()));
            return true;
        }
        for (DynamicObject workCalenObj : workCalenObjs) {
            DynamicObjectCollection dateEntries = workCalenObj.getDynamicObjectCollection("dateentry");
            int size = dateEntries.size();
            for (int i = 0; i < size; ++i) {
                Date day;
                DynamicObject dateEntry = (DynamicObject)dateEntries.get(i);
                if (!SscLevelType.SSCCENTER.getValue().equals(dateEntry.getString("level")) || (day = dateEntry.getDate("date")).before(startDate) || day.after(endDate)) continue;
                DynamicObject userDateEntry = (DynamicObject)userDateEntries.get(day);
                if (userDateEntry == null) {
                    if (SscTimeOp.CANCLELEAVE == timeOp || SscTimeOp.CANCLEOVERTIME == timeOp) {
                        log.info("\u65e5\u671f\uff1a" + day + "\uff0c\u8be5\u7528\u6237\u6ca1\u6709\u8bf7\u5047\u6216\u52a0\u73ed\u6570\u636e\uff0c\u6240\u4ee5\u65e0\u9700\u9500\u5047\u6216\u53d6\u6d88\u52a0\u73ed");
                        continue;
                    }
                    String dateType = dateEntry.getString("datetype");
                    if (groupDateEntries.get(day) != null) {
                        dateType = ((DynamicObject)groupDateEntries.get(day)).getString("datetype");
                    }
                    userDateEntry = WorkCalendarServiceHelper.addNewDateEntry(dateEntries, sscid, userGroupId, userId, dateType, day, timeOp.getTimeType(), timeIntervals);
                    userDateEntries.put(day, userDateEntry);
                    continue;
                }
                WorkCalendarServiceHelper.updateDateEntry(userDateEntry, timeOp, timeIntervals);
            }
        }
        SaveServiceHelper.save((DynamicObject[])workCalenObjs);
        log.info("\u4fdd\u5b58\u5de5\u4f5c\u65e5\u5386\u5c55\u793a\u6570\u636e-\u6279\u91cf\u8bbe\u7f6eend: workCalenObjs size() = {}", workCalenObjs == null ? null : Integer.valueOf(workCalenObjs.length));
        return false;
    }

    public static void sendMq(Long sscid, Long userGroupId, Long userId, Date startDate, Date endDate) {
        try (MessagePublisher pub = MQFactory.get().createSimplePublisher("ssc", "kd.ssc.task.ssc_workcalendar_queue");){
            pub.publish((Object)new WorkCalendarTaskMessage(String.valueOf(sscid), String.valueOf(userGroupId), Collections.singletonList(userId), startDate, endDate, "user"));
        }
    }

    private static DynamicObject[] loadWorkCalendarDynObjs(Long sscid, Date startDate, Date endDate) {
        QFilter[] filters = new QFilter[]{new QFilter("dateentry.ssc", "=", (Object)sscid), new QFilter("dateentry.level", "=", (Object)SscLevelType.SSCCENTER.getValue()), new QFilter("dateentry.date", ">=", (Object)startDate), new QFilter("dateentry.date", "<=", (Object)endDate)};
        List workCalendarIds = QueryServiceHelper.queryPrimaryKeys((String)"ssc_workcalendarsetting", (QFilter[])filters, null, (int)-1);
        return BusinessDataServiceHelper.load((Object[])workCalendarIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ssc_workcalendarsetting"));
    }

    private static void groupByLevel(DynamicObject[] workCalenObjs, Map<Date, DynamicObject> sscDateEntries, Map<Date, DynamicObject> userGroupDateEntries, Map<Date, DynamicObject> userDateEntries, Long sscid, Long userGroupId, Long userId) {
        for (DynamicObject workCalenObj : workCalenObjs) {
            DynamicObjectCollection dateEntries = workCalenObj.getDynamicObjectCollection("dateentry");
            for (DynamicObject dateEntry : dateEntries) {
                String level = dateEntry.getString("level");
                switch (SscLevelType.getSscLevelType((String)level)) {
                    case SSCCENTER: {
                        if (sscid.longValue() != dateEntry.getLong("ssc.id")) break;
                        sscDateEntries.put(dateEntry.getDate("date"), dateEntry);
                        break;
                    }
                    case GROUP: {
                        if (userGroupId.longValue() != dateEntry.getLong("usergroup.id")) break;
                        userGroupDateEntries.put(dateEntry.getDate("date"), dateEntry);
                        break;
                    }
                    case EMPLOYEE: {
                        if (userGroupId.longValue() != dateEntry.getLong("usergroup.id") || userId.longValue() != dateEntry.getLong("user.id")) break;
                        userDateEntries.put(dateEntry.getDate("date"), dateEntry);
                        break;
                    }
                }
            }
        }
    }

    private static DynamicObject addNewDateEntry(DynamicObjectCollection dateEntries, Long sscid, Long userGroupId, Long userId, String dateType, Date day, String timeType, List<String> timeIntervals) {
        DynamicObject newDateEntry = dateEntries.addNew();
        newDateEntry.set("ssc", (Object)sscid);
        newDateEntry.set("usergroup", (Object)userGroupId);
        newDateEntry.set("user", (Object)userId);
        newDateEntry.set("level", (Object)SscLevelType.EMPLOYEE.getValue());
        newDateEntry.set("date", (Object)day);
        newDateEntry.set("datetype", (Object)dateType);
        List<Integer> minutes = WorkCalendarServiceHelper.getMinutes(timeIntervals);
        int min = Math.abs(minutes.stream().min(Comparator.comparingInt(Math::abs)).get());
        int[] array01 = WorkCalendarServiceHelper.convertArray01(minutes);
        List<String> newTimeIntervals = WorkCalendarServiceHelper.buildNewTimeIntervals(array01, min);
        DynamicObjectCollection timeEnties = newDateEntry.getDynamicObjectCollection("timeentry");
        WorkCalendarServiceHelper.addNewTimeEntry(timeEnties, timeType, newTimeIntervals);
        return newDateEntry;
    }

    private static void addNewTimeEntry(DynamicObjectCollection timeEnties, String timeType, List<String> timeIntervals) {
        for (String timeInterval : timeIntervals) {
            DynamicObject newTimeEntry = timeEnties.addNew();
            newTimeEntry.set("timetype", (Object)timeType);
            String[] timeArr = timeInterval.split("-");
            newTimeEntry.set("begintimeam", (Object)timeArr[0]);
            newTimeEntry.set("endtimeam", (Object)timeArr[1]);
        }
    }

    private static void updateDateEntry(DynamicObject dateEntry, SscTimeOp timeOpType, List<String> timeIntervals) {
        DynamicObjectCollection timeEnties = dateEntry.getDynamicObjectCollection("timeentry");
        List<DynamicObject> oldData = timeEnties.stream().filter(p -> timeOpType.getTimeType().equals(p.getString("timetype"))).collect(Collectors.toList());
        List<Integer> minutes = WorkCalendarServiceHelper.getMinutes(oldData, timeOpType, timeIntervals);
        int min = Math.abs(minutes.stream().min(Comparator.comparingInt(Math::abs)).get());
        int[] array01 = WorkCalendarServiceHelper.convertArray01(minutes);
        List<String> newTimeIntervals = WorkCalendarServiceHelper.buildNewTimeIntervals(array01, min);
        timeEnties.removeAll(oldData);
        WorkCalendarServiceHelper.addNewTimeEntry(timeEnties, timeOpType.getTimeType(), newTimeIntervals);
    }

    private static List<Integer> getMinutes(List<String> timeIntervals) {
        ArrayList<Integer> minutes = new ArrayList<Integer>(timeIntervals.size() * 2);
        for (String timeInterval : timeIntervals) {
            String[] timeArr = timeInterval.split("-");
            String[] beginArr_ = timeArr[0].split(":");
            String[] endArr_ = timeArr[1].split(":");
            minutes.add(Integer.parseInt(beginArr_[0]) * 60 + Integer.parseInt(beginArr_[1]));
            minutes.add(Integer.parseInt(endArr_[0]) * 60 + Integer.parseInt(endArr_[1]));
        }
        return minutes;
    }

    private static List<Integer> getMinutes(List<DynamicObject> oldData, SscTimeOp timeOpType, List<String> timeIntervals) {
        ArrayList<Integer> minutes = new ArrayList<Integer>(oldData.size() * 2 + timeIntervals.size() * 2);
        for (DynamicObject data : oldData) {
            String[] beginArr = data.getString("begintimeam").split(":");
            String[] endArr = data.getString("endtimeam").split(":");
            minutes.add(Integer.parseInt(beginArr[0]) * 60 + Integer.parseInt(beginArr[1]));
            minutes.add(Integer.parseInt(endArr[0]) * 60 + Integer.parseInt(endArr[1]));
        }
        int sign = SscTimeOp.ASKFORLEAVE == timeOpType || SscTimeOp.OVERTIME == timeOpType ? 1 : -1;
        for (String timeInterval : timeIntervals) {
            String[] timeArr = timeInterval.split("-");
            String[] beginArr_ = timeArr[0].split(":");
            String[] endArr_ = timeArr[1].split(":");
            minutes.add((Integer.parseInt(beginArr_[0]) * 60 + Integer.parseInt(beginArr_[1])) * sign);
            minutes.add((Integer.parseInt(endArr_[0]) * 60 + Integer.parseInt(endArr_[1])) * sign);
        }
        return minutes;
    }

    private static int[] convertArray01(List<Integer> minutes) {
        int min = Math.abs(minutes.stream().min(Comparator.comparingInt(Math::abs)).get());
        int max = Math.abs(minutes.stream().max(Comparator.comparingInt(Math::abs)).get());
        int[] array01 = new int[max - min + 1];
        int size = minutes.size();
        for (int i = 0; i < size; i += 2) {
            int begin = minutes.get(i);
            int end = minutes.get(i + 1);
            int flag = begin >= 0 && end >= 0 ? 1 : 0;
            Arrays.fill(array01, Math.abs(begin) - min, Math.abs(end) - min + 1, flag);
        }
        return array01;
    }

    private static List<String> buildNewTimeIntervals(int[] array01, int min) {
        ArrayList<String> newTimeIntervals = new ArrayList<String>(8);
        int fromIndex = -1;
        int toIndex = -1;
        int len = array01.length;
        for (int i = 0; i < len; ++i) {
            if (array01[i] < 1) {
                if (fromIndex <= -1 || toIndex <= -1) continue;
                String beginTime = SscWorkCalendarUtil.getTimeShow((fromIndex + min) * 60);
                String endTime = SscWorkCalendarUtil.getTimeShow((toIndex + min) * 60);
                newTimeIntervals.add(beginTime + '-' + endTime);
                fromIndex = -1;
                toIndex = -1;
                continue;
            }
            if (fromIndex < 0) {
                fromIndex = i;
                continue;
            }
            toIndex = i;
        }
        if (fromIndex > -1 && toIndex > -1) {
            String beginTime = SscWorkCalendarUtil.getTimeShow((fromIndex + min) * 60);
            String endTime = SscWorkCalendarUtil.getTimeShow((toIndex + min) * 60);
            newTimeIntervals.add(beginTime + '-' + endTime);
        }
        return newTimeIntervals;
    }

    public static List<Long> queryUserGroupIdByUseId(String userId, String sscId, String userGroupId) {
        QFilter userFilter;
        QFilter enableFilter;
        String selectFields = "id";
        QFilter idFilter = new QFilter("id", "!=", (Object)Long.parseLong(userGroupId));
        QFilter sscIdFilter = new QFilter("orgfield", "=", (Object)Long.parseLong(sscId));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"task_usergroup", (String)selectFields, (QFilter[])new QFilter[]{sscIdFilter, enableFilter = new QFilter("enable", "=", (Object)Character.valueOf('1')), userFilter = new QFilter("entryentity.userfield", "=", (Object)Long.parseLong(userId)), idFilter});
        if (dynamicObjects == null || dynamicObjects.isEmpty()) {
            return new ArrayList<Long>();
        }
        return dynamicObjects.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
    }

    public static Map<Long, List<Long>> batchQueryUserGroupIdByUseId(List<Long> userIds, Long sscId) {
        QFilter userFilter;
        String selectFields = "entryentity.userfield,id";
        QFilter sscIdFilter = new QFilter("orgfield", "=", (Object)sscId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"task_usergroup", (String)selectFields, (QFilter[])new QFilter[]{sscIdFilter, enableFilter, userFilter = new QFilter("entryentity.userfield", "in", userIds)});
        if (dynamicObjects == null || dynamicObjects.isEmpty()) {
            return new HashMap<Long, List<Long>>();
        }
        HashMap<Long, List<Long>> userIdMap = new HashMap<Long, List<Long>>();
        for (DynamicObject dynObj : dynamicObjects) {
            long userId = dynObj.getLong("entryentity.userfield");
            long userGroupId = dynObj.getLong("id");
            userIdMap.computeIfAbsent(userId, p -> new ArrayList(8)).add(userGroupId);
        }
        return userIdMap;
    }

    public static Map<Long, DynamicObject> batchQueryUserGroupInfoByGroupId(List<Long> userGroupIds) {
        DynamicObject[] userGroupDyns = BusinessDataServiceHelper.load((Object[])userGroupIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"task_usergroup"));
        HashMap<Long, DynamicObject> userGroupMap = new HashMap<Long, DynamicObject>(8);
        for (DynamicObject dynObj : userGroupDyns) {
            long userGroupId = dynObj.getLong("id");
            userGroupMap.put(userGroupId, dynObj);
        }
        return userGroupMap;
    }
}

