/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.dis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.param.AppParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.ssc.task.common.CommonFilterUtil;
import kd.ssc.task.dis.HisTaskDisRule;

public class RobortRepulseRule {
    private static final Log log = LogFactory.getLog(RobortRepulseRule.class);
    private static final String TASK_USERGROUPMETA = "task_usergroup";
    private HashSet<Long> rebortSet = new HashSet(16);
    private HashMap<Long, HashSet<Long>> rebortGroupSet = new HashMap(16);
    private HisTaskDisRule hisTaskDisRule = null;
    private boolean printLog;
    private HashMap<Long, Long> robotGroup2Ssc;
    private HashMap<Long, Boolean> robotsDistriOnDuty;

    public void prepareData() {
        this.rebortSet = this.buildRobotGroupInfo();
        this.buildDistriOnDutyParam();
    }

    public RobortRepulseRule(HisTaskDisRule hisTaskDisRule) {
        this.hisTaskDisRule = hisTaskDisRule;
    }

    private HashSet<Long> buildRobotGroupInfo() {
        DynamicObject[] userGroups;
        HashSet<Long> resultSet = new HashSet<Long>();
        this.robotGroup2Ssc = new HashMap();
        QFilter enableUserFilter = CommonFilterUtil.getEnableMetaQFilterByMetaName("entryentity.userfield");
        QFilter robotFilter = new QFilter("isrobots", "=", (Object)true);
        for (DynamicObject userGroup : userGroups = BusinessDataServiceHelper.load((String)TASK_USERGROUPMETA, (String)"id,number,entryentity.userfield,createorg", (QFilter[])new QFilter[]{enableUserFilter, robotFilter})) {
            Long groupId = userGroup.getLong("id");
            DynamicObjectCollection groupUserCollection = userGroup.getDynamicObjectCollection("entryentity");
            HashSet<Long> groupUserSet = this.rebortGroupSet.get(groupId);
            if (groupUserSet == null) {
                groupUserSet = new HashSet();
            }
            for (DynamicObject user : groupUserCollection) {
                Long userId = user.getLong("userfield.id");
                groupUserSet.add(userId);
                resultSet.add(userId);
            }
            this.rebortGroupSet.put(groupId, groupUserSet);
            Long sscId = userGroup.getDynamicObject("createorg").getLong("id");
            this.robotGroup2Ssc.put(groupId, sscId);
        }
        return resultSet;
    }

    public boolean match(DynamicObject task) {
        long person;
        boolean result = false;
        if (this.hisTaskDisRule.matched(task) && this.isRobort(person = this.hisTaskDisRule.getMatchPerson())) {
            result = true;
        }
        return result;
    }

    public boolean isRobort(long person) {
        boolean result = false;
        result = this.rebortSet.contains(person);
        this.logInfo("currTask dealUser: " + person);
        this.logInfo("matchResult: " + result);
        return result;
    }

    private void buildDistriOnDutyParam() {
        this.robotsDistriOnDuty = new HashMap();
        AppParam param = new AppParam("83bfebc8000020ac", "12", Long.valueOf(0L), Long.valueOf(0L));
        Map map = SystemParamServiceHelper.loadBatchAppParameterByOrgFromCache((AppParam)param, new ArrayList<Long>(this.robotGroup2Ssc.values()));
        for (Map.Entry entry : map.entrySet()) {
            try {
                this.robotsDistriOnDuty.put(Long.valueOf((String)entry.getKey()), Boolean.valueOf(((Object)((Map)entry.getValue()).getOrDefault("robotsdistrionduty", Boolean.FALSE)).toString()));
            }
            catch (Exception e) {
                log.error("Error on get system param [robotsdistrionduty] for org {}", entry.getKey());
            }
        }
    }

    public boolean isRobortGroup(long group) {
        return this.rebortGroupSet.containsKey(group);
    }

    long getOneRobort(long userGroupId) {
        HashSet<Long> hashSet = this.rebortGroupSet.get(userGroupId);
        return hashSet.iterator().next();
    }

    private void logInfo(String msg) {
        if (this.printLog) {
            log.error(msg);
        }
    }

    public void setPrintLog(boolean printLog) {
        this.printLog = printLog;
    }

    public boolean isRobotsDistriOnDuty(long groupId) {
        if (!this.robotGroup2Ssc.containsKey(groupId)) {
            return false;
        }
        return this.robotsDistriOnDuty.getOrDefault(this.robotGroup2Ssc.get(groupId), Boolean.FALSE);
    }
}

